/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sql;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntrySQL
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySQL.class;
    private String sql = null;
    private DatabaseMeta connection = null;
    private boolean useVariableSubstitution = false;
    private boolean sqlfromfile = false;
    private String sqlfilename;
    private boolean sendOneStatement = false;

    public JobEntrySQL(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntrySQL() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySQL je = (JobEntrySQL)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("      ").append(XMLHandler.addTagValue((String)"useVariableSubstitution", (String)(this.useVariableSubstitution ? "T" : "F")));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sqlfromfile", (String)(this.sqlfromfile ? "T" : "F")));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sqlfilename", (String)this.sqlfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sendOneStatement", (String)(this.sendOneStatement ? "T" : "F")));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.sql = XMLHandler.getTagValue((Node)entrynode, (String)"sql");
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            String sSubs = XMLHandler.getTagValue((Node)entrynode, (String)"useVariableSubstitution");
            if (sSubs != null && sSubs.equalsIgnoreCase("T")) {
                this.useVariableSubstitution = true;
            }
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            String ssql = XMLHandler.getTagValue((Node)entrynode, (String)"sqlfromfile");
            if (ssql != null && ssql.equalsIgnoreCase("T")) {
                this.sqlfromfile = true;
            }
            this.sqlfilename = XMLHandler.getTagValue((Node)entrynode, (String)"sqlfilename");
            String sOneStatement = XMLHandler.getTagValue((Node)entrynode, (String)"sendOneStatement");
            if (sOneStatement != null && sOneStatement.equalsIgnoreCase("T")) {
                this.sendOneStatement = true;
            }
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'sql' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            String ssendOneStatement;
            String ssql;
            this.sql = rep.getJobEntryAttributeString(id_jobentry, "sql");
            String sSubs = rep.getJobEntryAttributeString(id_jobentry, "useVariableSubstitution");
            if (sSubs != null && sSubs.equalsIgnoreCase("T")) {
                this.useVariableSubstitution = true;
            }
            if ((ssql = rep.getJobEntryAttributeString(id_jobentry, "sqlfromfile")) != null && ssql.equalsIgnoreCase("T")) {
                this.sqlfromfile = true;
            }
            if ((ssendOneStatement = rep.getJobEntryAttributeString(id_jobentry, "sendOneStatement")) != null && ssendOneStatement.equalsIgnoreCase("T")) {
                this.sendOneStatement = true;
            }
            this.sqlfilename = rep.getJobEntryAttributeString(id_jobentry, "sqlfilename");
            this.connection = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", "id_database", databases);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'sql' from the repository with id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), "connection", "id_database", this.connection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sql", this.sql);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "useVariableSubstitution", this.useVariableSubstitution ? "T" : "F");
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sqlfromfile", this.sqlfromfile ? "T" : "F");
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sqlfilename", this.sqlfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sendOneStatement", this.sendOneStatement ? "T" : "F");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'sql' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    public String getSQLFilename() {
        return this.sqlfilename;
    }

    public void setSQLFilename(String sqlfilename) {
        this.sqlfilename = sqlfilename;
    }

    public boolean getUseVariableSubstitution() {
        return this.useVariableSubstitution;
    }

    public void setUseVariableSubstitution(boolean subs) {
        this.useVariableSubstitution = subs;
    }

    public void setSQLFromFile(boolean sqlfromfilein) {
        this.sqlfromfile = sqlfromfilein;
    }

    public boolean getSQLFromFile() {
        return this.sqlfromfile;
    }

    public boolean isSendOneStatement() {
        return this.sendOneStatement;
    }

    public void setSendOneStatement(boolean sendOneStatementin) {
        this.sendOneStatement = sendOneStatementin;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        result = previousResult;
        if (this.connection != null) {
            db = new Database((LoggingObjectInterface)this, this.connection);
            SQLfile = null;
            db.shareVariablesWith((VariableSpace)this);
            try {
                block30: {
                    mySQL = null;
                    db.connect(this.parentJob.getTransactionId(), null);
                    if (this.sqlfromfile) {
                        if (this.sqlfilename == null) {
                            throw new KettleDatabaseException(BaseMessages.getString(JobEntrySQL.PKG, (String)"JobSQL.NoSQLFileSpecified", (String[])new String[0]));
                        }
                        try {
                            realfilename = this.environmentSubstitute(this.sqlfilename);
                            SQLfile = KettleVFS.getFileObject((String)realfilename, (VariableSpace)this);
                            if (!SQLfile.exists()) {
                                this.logError(BaseMessages.getString(JobEntrySQL.PKG, (String)"JobSQL.SQLFileNotExist", (String[])new String[]{realfilename}));
                                throw new KettleDatabaseException(BaseMessages.getString(JobEntrySQL.PKG, (String)"JobSQL.SQLFileNotExist", (String[])new String[]{realfilename}));
                            }
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(JobEntrySQL.PKG, (String)"JobSQL.SQLFileExists", (String[])new String[]{realfilename}));
                            }
                            IS = KettleVFS.getInputStream((FileObject)SQLfile);
                            try {
                                BIS = new InputStreamReader(new BufferedInputStream(IS, 500));
                                lineStringBuffer = new StringBuffer(256);
                                lineStringBuffer.setLength(0);
                                buff = new BufferedReader(BIS);
                                sLine = null;
                                mySQL = Const.CR;
                                while ((sLine = buff.readLine()) != null) {
                                    if (Const.isEmpty((String)sLine)) {
                                        mySQL = mySQL + Const.CR;
                                        continue;
                                    }
                                    mySQL = mySQL + Const.CR + sLine;
                                }
                                break block30;
                            }
                            finally {
                                IS.close();
                            }
                        }
                        catch (Exception e) {
                            throw new KettleDatabaseException(BaseMessages.getString(JobEntrySQL.PKG, (String)"JobSQL.ErrorRunningSQLfromFile", (String[])new String[0]), (Throwable)e);
                        }
                    }
                    mySQL = this.sql;
                }
                if (Const.isEmpty((String)mySQL)) ** GOTO lbl68
                if (this.useVariableSubstitution) {
                    mySQL = this.environmentSubstitute(mySQL);
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(JobEntrySQL.PKG, (String)"JobSQL.Log.SQlStatement", (String[])new String[]{mySQL}));
                }
                if (this.sendOneStatement) {
                    db.execStatement(mySQL);
                }
                db.execStatements(mySQL);
            }
            catch (KettleDatabaseException je) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(JobEntrySQL.PKG, (String)"JobSQL.ErrorRunJobEntry", (String[])new String[]{je.getMessage()}));
            }
            finally {
                db.disconnect();
                if (SQLfile != null) {
                    try {
                        SQLfile.close();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(JobEntrySQL.PKG, (String)"JobSQL.NoDatabaseConnection", (String[])new String[0]));
        }
lbl68:
        // 5 sources

        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "SQL", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

