/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ssh2get;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ssh2get.FTPUtils;
import org.pentaho.di.job.entries.ssh2get.SimpleVerifier;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntrySSH2GET
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySSH2GET.class;
    private String serverName = null;
    private String userName;
    private String password;
    private String serverPort = "22";
    private String ftpDirectory;
    private String localDirectory;
    private String wildcard;
    private boolean onlyGettingNewFiles;
    private boolean usehttpproxy = false;
    private String httpProxyHost = null;
    private String httpproxyport = null;
    private String httpproxyusername = null;
    private String httpProxyPassword = null;
    private boolean publicpublickey = false;
    private String keyFilename = null;
    private String keyFilePass = null;
    private boolean useBasicAuthentication = false;
    private String afterFtpPut = "do_nothing";
    private String destinationfolder = null;
    private boolean createdestinationfolder = false;
    private boolean cachehostkey = false;
    private int timeout = 0;
    boolean createtargetfolder = false;
    boolean includeSubFolders = false;
    static KnownHosts database = new KnownHosts();
    int nbfilestoget = 0;
    int nbgot = 0;
    int nbrerror = 0;

    public JobEntrySSH2GET(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntrySSH2GET() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySSH2GET je = (JobEntrySSH2GET)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ftpdirectory", (String)this.ftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"localdirectory", (String)this.localDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_new", (boolean)this.onlyGettingNewFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usehttpproxy", (boolean)this.usehttpproxy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxyhost", (String)this.httpProxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxyport", (String)this.httpproxyport));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxyusername", (String)this.httpproxyusername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxypassword", (String)this.httpProxyPassword));
        retval.append("      ").append(XMLHandler.addTagValue((String)"publicpublickey", (boolean)this.publicpublickey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilename", (String)this.keyFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilepass", (String)this.keyFilePass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usebasicauthentication", (boolean)this.useBasicAuthentication));
        retval.append("      ").append(XMLHandler.addTagValue((String)"afterftpput", (String)this.afterFtpPut));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationfolder", (String)this.destinationfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createdestinationfolder", (boolean)this.createdestinationfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cachehostkey", (boolean)this.cachehostkey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createtargetfolder", (boolean)this.createtargetfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"includeSubFolders", (boolean)this.includeSubFolders));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.ftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"ftpdirectory");
            this.localDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"localdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.onlyGettingNewFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.usehttpproxy = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usehttpproxy"));
            this.httpProxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxyhost");
            this.httpproxyport = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxyport");
            this.httpproxyusername = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxyusername");
            this.httpProxyPassword = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxypassword");
            this.publicpublickey = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"publicpublickey"));
            this.keyFilename = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyFilePass = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilepass");
            this.useBasicAuthentication = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usebasicauthentication"));
            this.afterFtpPut = XMLHandler.getTagValue((Node)entrynode, (String)"afterftpput");
            this.destinationfolder = XMLHandler.getTagValue((Node)entrynode, (String)"destinationfolder");
            this.createdestinationfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createdestinationfolder"));
            this.cachehostkey = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"cachehostkey"));
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)0);
            this.createtargetfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createtargetfolder"));
            this.includeSubFolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"includeSubFolders"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.UnableLoadXML", (String[])new String[]{xe.getMessage()}));
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            this.ftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "ftpdirectory");
            this.localDirectory = rep.getJobEntryAttributeString(id_jobentry, "localdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.onlyGettingNewFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "only_new");
            this.usehttpproxy = rep.getJobEntryAttributeBoolean(id_jobentry, "usehttpproxy");
            this.httpProxyHost = rep.getJobEntryAttributeString(id_jobentry, "httpproxyhost");
            this.httpproxyusername = rep.getJobEntryAttributeString(id_jobentry, "httpproxyusername");
            this.httpProxyPassword = rep.getJobEntryAttributeString(id_jobentry, "httpproxypassword");
            this.publicpublickey = rep.getJobEntryAttributeBoolean(id_jobentry, "publicpublickey");
            this.keyFilename = rep.getJobEntryAttributeString(id_jobentry, "keyfilename");
            this.keyFilePass = rep.getJobEntryAttributeString(id_jobentry, "keyfilepass");
            this.useBasicAuthentication = rep.getJobEntryAttributeBoolean(id_jobentry, "usebasicauthentication");
            this.afterFtpPut = rep.getJobEntryAttributeString(id_jobentry, "afterftpput");
            this.destinationfolder = rep.getJobEntryAttributeString(id_jobentry, "destinationfolder");
            this.createdestinationfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createdestinationfolder");
            this.cachehostkey = rep.getJobEntryAttributeBoolean(id_jobentry, "cachehostkey");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.createtargetfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createtargetfolder");
            this.includeSubFolders = rep.getJobEntryAttributeBoolean(id_jobentry, "includeSubFolders");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.UnableLoadRep", (String[])new String[]{"" + id_jobentry, dbe.getMessage()}));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ftpdirectory", this.ftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "localdirectory", this.localDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "only_new", this.onlyGettingNewFiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "usehttpproxy", this.usehttpproxy);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "httpproxyhost", this.httpProxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "httpproxyport", this.httpproxyport);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "httpproxyusername", this.httpproxyusername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "httpproxypassword", this.httpProxyPassword);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "publicpublickey", this.publicpublickey);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilename", this.keyFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilepass", this.keyFilePass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "usebasicauthentication", this.useBasicAuthentication);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "afterftpput", this.afterFtpPut);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destinationfolder", this.destinationfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createdestinationfolder", this.createdestinationfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "cachehostkey", this.cachehostkey);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createtargetfolder", this.createtargetfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "includeSubFolders", this.includeSubFolders);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.UnableSaveRep", (String[])new String[]{"" + id_job, dbe.getMessage()}));
        }
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public void setFtpDirectory(String directory) {
        this.ftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAfterFTPPut() {
        return this.afterFtpPut;
    }

    public void setAfterFTPPut(String afterFtpPut) {
        this.afterFtpPut = afterFtpPut;
    }

    public void setHTTPProxyPassword(String proxyPassword) {
        this.httpProxyPassword = proxyPassword;
    }

    public String getHTTPProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setKeyFilePass(String keyFilePass) {
        this.keyFilePass = keyFilePass;
    }

    public String getKeyFilePass() {
        return this.keyFilePass;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setHTTPProxyHost(String proxyhost) {
        this.httpProxyHost = proxyhost;
    }

    public String getHTTPProxyHost() {
        return this.httpProxyHost;
    }

    public void setKeyFilename(String keyfilename) {
        this.keyFilename = keyfilename;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setHTTPProxyUsername(String proxyusername) {
        this.httpproxyusername = proxyusername;
    }

    public String getHTTPProxyUsername() {
        return this.httpproxyusername;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getlocalDirectory() {
        return this.localDirectory;
    }

    public void setlocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public boolean isOnlyGettingNewFiles() {
        return this.onlyGettingNewFiles;
    }

    public void setOnlyGettingNewFiles(boolean onlyGettingNewFiles) {
        this.onlyGettingNewFiles = onlyGettingNewFiles;
    }

    public void setCacheHostKey(boolean cachehostkeyin) {
        this.cachehostkey = cachehostkeyin;
    }

    public boolean isCacheHostKey() {
        return this.cachehostkey;
    }

    public void setUseHTTPProxy(boolean httpproxy) {
        this.usehttpproxy = httpproxy;
    }

    public boolean isUseHTTPProxy() {
        return this.usehttpproxy;
    }

    public boolean isUseBasicAuthentication() {
        return this.useBasicAuthentication;
    }

    public void setUseBasicAuthentication(boolean useBasicAuthentication) {
        this.useBasicAuthentication = useBasicAuthentication;
    }

    public void setIncludeSubFolders(boolean includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setCreateDestinationFolder(boolean createdestinationfolderin) {
        this.createdestinationfolder = createdestinationfolderin;
    }

    public boolean isCreateDestinationFolder() {
        return this.createdestinationfolder;
    }

    public boolean isCreateTargetFolder() {
        return this.createtargetfolder;
    }

    public void setCreateTargetFolder(boolean createtargetfolderin) {
        this.createtargetfolder = createtargetfolderin;
    }

    public void setUsePublicKey(boolean publickey) {
        this.publicpublickey = publickey;
    }

    public boolean isUsePublicKey() {
        return this.publicpublickey;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void setHTTPProxyPort(String proxyport) {
        this.httpproxyport = proxyport;
    }

    public String getHTTPProxyPort() {
        return this.httpproxyport;
    }

    public void setDestinationFolder(String destinationfolderin) {
        this.destinationfolder = destinationfolderin;
    }

    public String getDestinationFolder() {
        return this.destinationfolder;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.GettingFieldsValue", (String[])new String[0]));
        }
        String realServerName = this.environmentSubstitute(this.serverName);
        int realServerPort = Const.toInt((String)this.environmentSubstitute(this.serverPort), (int)22);
        String realUserName = this.environmentSubstitute(this.userName);
        String realServerPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
        String realProxyHost = this.environmentSubstitute(this.httpProxyHost);
        int realProxyPort = Const.toInt((String)this.environmentSubstitute(this.httpproxyport), (int)22);
        String realproxyUserName = this.environmentSubstitute(this.httpproxyusername);
        String realProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.httpProxyPassword));
        String realKeyFilename = this.environmentSubstitute(this.keyFilename);
        String relKeyFilepass = this.environmentSubstitute(this.keyFilePass);
        String realLocalDirectory = this.environmentSubstitute(this.localDirectory);
        String realwildcard = this.environmentSubstitute(this.wildcard);
        String realftpDirectory = this.environmentSubstitute(this.ftpDirectory);
        String realDestinationFolder = this.environmentSubstitute(this.destinationfolder);
        try {
            realftpDirectory = FTPUtils.normalizePath(realftpDirectory);
            realDestinationFolder = FTPUtils.normalizePath(realDestinationFolder);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.CanNotNormalizePath", (String[])new String[]{e.getMessage()}));
            result.setNrErrors(1L);
            return result;
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.CheckingMandatoryFields", (String[])new String[0]));
        }
        boolean mandatoryok = true;
        if (Const.isEmpty((String)realServerName)) {
            mandatoryok = false;
            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.ServernameMissing", (String[])new String[0]));
        }
        if (this.usehttpproxy && Const.isEmpty((String)realProxyHost)) {
            mandatoryok = false;
            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.HttpProxyhostMissing", (String[])new String[0]));
        }
        if (this.publicpublickey) {
            if (Const.isEmpty((String)realKeyFilename)) {
                mandatoryok = false;
                this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.KeyFileMissing", (String[])new String[0]));
            } else if (!new File(realKeyFilename).exists()) {
                mandatoryok = false;
                this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.KeyFileNotExist", (String[])new String[0]));
            }
        }
        if (Const.isEmpty((String)realLocalDirectory)) {
            mandatoryok = false;
            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.LocalFolderMissing", (String[])new String[0]));
        } else if (!new File(realLocalDirectory).exists()) {
            if (this.createtargetfolder) {
                if (!this.CreateFolder(realLocalDirectory)) {
                    mandatoryok = false;
                }
            } else {
                mandatoryok = false;
                this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.LocalFolderNotExists", (String[])new String[]{realLocalDirectory}));
            }
        } else if (!new File(realLocalDirectory).isDirectory()) {
            mandatoryok = false;
            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.LocalFolderNotFolder", (String[])new String[]{realLocalDirectory}));
        }
        if (this.afterFtpPut.equals("move_file") && Const.isEmpty((String)realDestinationFolder)) {
            mandatoryok = false;
            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.DestinatFolderMissing", (String[])new String[0]));
        }
        if (mandatoryok) {
            Connection conn = null;
            SFTPv3Client client = null;
            boolean good = true;
            try {
                conn = this.getConnection(realServerName, realServerPort, realProxyHost, realProxyPort, realproxyUserName, realProxyPassword);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.ConnectionInstanceCreated", (String[])new String[0]));
                }
                if (this.timeout > 0) {
                    if (this.cachehostkey) {
                        conn.connect((ServerHostKeyVerifier)new SimpleVerifier(database), 0, this.timeout * 1000);
                    } else {
                        conn.connect(null, 0, this.timeout * 1000);
                    }
                } else if (this.cachehostkey) {
                    conn.connect((ServerHostKeyVerifier)new SimpleVerifier(database));
                } else {
                    conn.connect();
                }
                boolean isAuthenticated = false;
                isAuthenticated = this.publicpublickey ? conn.authenticateWithPublicKey(realUserName, new File(realKeyFilename), relKeyFilepass) : conn.authenticateWithPassword(realUserName, realServerPassword);
                if (!isAuthenticated) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.AuthenticationFailed", (String[])new String[0]));
                } else {
                    if (this.log.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Connected", (String[])new String[]{this.serverName, this.userName}));
                    }
                    client = new SFTPv3Client(conn);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.ProtocolVersion", (String[])new String[]{"" + client.getProtocolVersion()}));
                    }
                    if (!Const.isEmpty((String)realftpDirectory)) {
                        if (!this.sshDirectoryExists(client, realftpDirectory)) {
                            good = false;
                            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.RemoteDirectoryNotExist", (String[])new String[]{realftpDirectory}));
                        } else if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.RemoteDirectoryExist", (String[])new String[]{realftpDirectory}));
                        }
                    }
                    if (realDestinationFolder != null && !this.sshDirectoryExists(client, realDestinationFolder)) {
                        if (this.createdestinationfolder) {
                            if (!this.CreateRemoteFolder(client, realDestinationFolder)) {
                                good = false;
                            }
                        } else {
                            good = false;
                            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.DestinatFolderNotExist", (String[])new String[]{realDestinationFolder}));
                        }
                    }
                    if (good) {
                        Pattern pattern = null;
                        if (!Const.isEmpty((String)realwildcard)) {
                            pattern = Pattern.compile(realwildcard);
                        }
                        if (this.includeSubFolders) {
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.RecursiveModeOn", (String[])new String[0]));
                            }
                            this.copyRecursive(realftpDirectory, realLocalDirectory, client, pattern, this.parentJob);
                        } else {
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.RecursiveModeOff", (String[])new String[0]));
                            }
                            this.GetFiles(realftpDirectory, realLocalDirectory, client, pattern, this.parentJob);
                        }
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Result.JobEntryEnd1", (String[])new String[0]));
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Result.TotalFiles", (String[])new String[]{"" + this.nbfilestoget}));
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Result.TotalFilesPut", (String[])new String[]{"" + this.nbgot}));
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Result.TotalFilesError", (String[])new String[]{"" + this.nbrerror}));
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Result.JobEntryEnd2", (String[])new String[0]));
                        }
                        if (this.nbrerror == 0) {
                            result.setResult(true);
                        }
                    }
                }
            }
            catch (Exception e) {
                result.setNrErrors((long)this.nbrerror);
                this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Error.ErrorFTP", (String[])new String[]{e.getMessage()}));
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
                if (client != null) {
                    client.close();
                }
            }
        }
        return result;
    }

    private Connection getConnection(String servername, int serverport, String proxyhost, int proxyport, String proxyusername, String proxypassword) {
        Connection conn = new Connection(servername, serverport);
        if (this.usehttpproxy) {
            conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport));
            if (this.useBasicAuthentication) {
                conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport, proxyusername, proxypassword));
            }
        }
        return conn;
    }

    public boolean sshFileExists(SFTPv3Client sftpClient, String filename) {
        try {
            SFTPv3FileAttributes attributes = sftpClient.stat(filename);
            if (attributes != null) {
                return attributes.isRegularFile();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean FileExists(String filename) {
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject((String)filename, (VariableSpace)this);
            if (!file.exists()) {
                return false;
            }
            return file.getType() == FileType.FILE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDirectory(SFTPv3Client sftpClient, String filename) {
        try {
            return sftpClient.stat(filename).isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean sshDirectoryExists(SFTPv3Client sftpClient, String directory) {
        try {
            SFTPv3FileAttributes attributes = sftpClient.stat(directory);
            if (attributes != null) {
                return attributes.isDirectory();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getFileSize(SFTPv3Client sftpClient, String filename) throws Exception {
        return sftpClient.stat((String)filename).size;
    }

    private boolean getFileWildcard(String selectedfile, Pattern pattern) {
        boolean getIt = true;
        if (pattern != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    private boolean deleteOrMoveFiles(SFTPv3Client sftpClient, String filename, String destinationFolder) {
        boolean retval = false;
        if (this.afterFtpPut.equals("delete_file")) {
            try {
                sftpClient.rm(filename);
                retval = true;
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.DeletedFile", (String[])new String[]{filename}));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Error.CanNotDeleteRemoteFile", (String[])new String[]{filename}), e);
            }
        } else if (this.afterFtpPut.equals("move_file")) {
            String DestinationFullFilename = destinationFolder + Const.FILE_SEPARATOR + filename;
            try {
                sftpClient.mv(filename, DestinationFullFilename);
                retval = true;
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.DeletedFile", (String[])new String[]{filename}));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Error.MovedFile", (String[])new String[]{filename, destinationFolder}), e);
            }
        }
        return retval;
    }

    private void GetFiles(String sourceLocation, String targetLocation, SFTPv3Client sftpClient, Pattern pattern, Job parentJob) throws Exception {
        String sourceFolder = ".";
        sourceFolder = !Const.isEmpty((String)sourceLocation) ? sourceLocation + FTPUtils.FILE_SEPARATOR : sourceFolder + FTPUtils.FILE_SEPARATOR;
        Vector filelist = sftpClient.ls(sourceFolder);
        if (filelist != null) {
            Iterator iterator = filelist.iterator();
            while (iterator.hasNext() && !parentJob.isStopped()) {
                SFTPv3DirectoryEntry dirEntry = (SFTPv3DirectoryEntry)iterator.next();
                if (dirEntry == null || dirEntry.filename.equals(".") || dirEntry.filename.equals("..") || this.isDirectory(sftpClient, sourceFolder + dirEntry.filename) || !this.getFileWildcard(dirEntry.filename, pattern)) continue;
                this.copyFile(sourceFolder + dirEntry.filename, targetLocation + FTPUtils.FILE_SEPARATOR + dirEntry.filename, sftpClient);
            }
        }
    }

    private void copyRecursive(String sourceLocation, String targetLocation, SFTPv3Client sftpClient, Pattern pattern, Job parentJob) throws Exception {
        String sourceFolder = "." + FTPUtils.FILE_SEPARATOR;
        if (sourceLocation != null) {
            sourceFolder = sourceLocation;
        }
        if (this.isDirectory(sftpClient, sourceFolder)) {
            Vector filelist = sftpClient.ls(sourceFolder);
            for (SFTPv3DirectoryEntry dirEntry : filelist) {
                if (dirEntry == null || dirEntry.filename.equals(".") || dirEntry.filename.equals("..")) continue;
                this.copyRecursive(sourceFolder + FTPUtils.FILE_SEPARATOR + dirEntry.filename, targetLocation + Const.FILE_SEPARATOR + dirEntry.filename, sftpClient, pattern, parentJob);
            }
        } else if (this.isFile(sftpClient, sourceFolder) && this.getFileWildcard(sourceFolder, pattern)) {
            this.copyFile(sourceFolder, targetLocation, sftpClient);
        }
    }

    public boolean isFile(SFTPv3Client sftpClient, String filename) {
        try {
            return sftpClient.stat(filename).isRegularFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void copyFile(String sourceLocation, String targetLocation, SFTPv3Client sftpClient) {
        block27: {
            File transferFile;
            FileOutputStream fos;
            SFTPv3FileHandle sftpFileHandle;
            block26: {
                sftpFileHandle = null;
                fos = null;
                transferFile = null;
                long remoteFileSize = -1L;
                boolean filecopied = true;
                transferFile = new File(targetLocation);
                if (!this.onlyGettingNewFiles || this.onlyGettingNewFiles && !this.FileExists(transferFile.getAbsolutePath())) {
                    int len;
                    new File(transferFile.getParent()).mkdirs();
                    remoteFileSize = this.getFileSize(sftpClient, sourceLocation);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.ReceivingFile", (String[])new String[]{sourceLocation, transferFile.getAbsolutePath(), "" + remoteFileSize}));
                    }
                    sftpFileHandle = sftpClient.openFileRO(sourceLocation);
                    fos = null;
                    long offset = 0L;
                    fos = new FileOutputStream(transferFile);
                    byte[] buffer = new byte[2048];
                    while ((len = sftpClient.read(sftpFileHandle, offset, buffer, 0, buffer.length)) > 0) {
                        fos.write(buffer, 0, len);
                        offset += (long)len;
                    }
                    fos.flush();
                    fos.close();
                    fos = null;
                    ++this.nbfilestoget;
                    if (remoteFileSize > 0L && remoteFileSize != transferFile.length()) {
                        filecopied = false;
                        ++this.nbrerror;
                        this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Error.RemoteFileLocalDifferent", (String[])new String[]{"" + remoteFileSize, transferFile.length() + "", "" + offset}));
                    } else {
                        ++this.nbgot;
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.RemoteFileLocalCopied", (String[])new String[]{sourceLocation, transferFile + ""}));
                        }
                    }
                }
                if (!filecopied || this.afterFtpPut.equals("do_nothing")) break block26;
                this.deleteOrMoveFiles(sftpClient, sourceLocation, this.environmentSubstitute(this.destinationfolder));
            }
            try {
                if (sftpFileHandle != null) {
                    sftpClient.closeFile(sftpFileHandle);
                    sftpFileHandle = null;
                }
                if (fos == null) break block27;
                try {
                    fos.close();
                    fos = null;
                    break block27;
                }
                catch (Exception ex) {
                }
            }
            catch (Exception e) {}
            break block27;
            catch (Exception e) {
                try {
                    ++this.nbrerror;
                    this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Error.WritingFile", (String[])new String[]{transferFile.getAbsolutePath(), e.getMessage()}));
                }
                catch (Throwable throwable) {
                    try {
                        if (sftpFileHandle != null) {
                            sftpClient.closeFile(sftpFileHandle);
                            sftpFileHandle = null;
                        }
                        if (fos != null) {
                            try {
                                fos.close();
                                fos = null;
                            }
                            catch (Exception ex) {}
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (sftpFileHandle != null) {
                        sftpClient.closeFile(sftpFileHandle);
                        sftpFileHandle = null;
                    }
                    if (fos == null) break block27;
                    try {
                        fos.close();
                        fos = null;
                    }
                    catch (Exception ex) {
                    }
                }
                catch (Exception e3) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CreateFolder(String filefolder) {
        FileObject folder = null;
        try {
            folder = KettleVFS.getFileObject((String)filefolder, (VariableSpace)this);
            if (!folder.exists()) {
                if (this.createtargetfolder) {
                    folder.createFolder();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.FolderCreated", (String[])new String[]{folder.toString()}));
                    }
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.CanNotCreateFolder", (String[])new String[]{folder.toString()}), e);
        }
        finally {
            if (folder != null) {
                try {
                    folder.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private boolean CreateRemoteFolder(SFTPv3Client sftpClient, String foldername) {
        boolean retval = false;
        if (!this.sshDirectoryExists(sftpClient, foldername)) {
            try {
                sftpClient.mkdir(foldername, 448);
                retval = true;
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.RemoteFolderCreated", (String[])new String[]{foldername}));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobSSH2GET.Log.Error.CreatingRemoteFolder", (String[])new String[]{foldername}), e);
            }
        }
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "localDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

