/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.syslog;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.syslog.SyslogDefs;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogIF;
import org.w3c.dom.Node;

public class JobEntrySyslog
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySyslog.class;
    private String serverName = null;
    private String port = String.valueOf(514);
    private String message = null;
    private String facility = SyslogDefs.FACILITYS[0];
    private String priority = SyslogDefs.PRIORITYS[0];
    private String datePattern = "MMM dd HH:mm:ss";
    private boolean addTimestamp = true;
    private boolean addHostname = true;

    public JobEntrySyslog(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntrySyslog() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySyslog je = (JobEntrySyslog)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"facility", (String)this.facility));
        retval.append("      ").append(XMLHandler.addTagValue((String)"priority", (String)this.priority));
        retval.append("      ").append(XMLHandler.addTagValue((String)"message", (String)this.message));
        retval.append("      ").append(XMLHandler.addTagValue((String)"datePattern", (String)this.datePattern));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addTimestamp", (boolean)this.addTimestamp));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addHostname", (boolean)this.addHostname));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.facility = XMLHandler.getTagValue((Node)entrynode, (String)"facility");
            this.priority = XMLHandler.getTagValue((Node)entrynode, (String)"priority");
            this.message = XMLHandler.getTagValue((Node)entrynode, (String)"message");
            this.datePattern = XMLHandler.getTagValue((Node)entrynode, (String)"datePattern");
            this.addTimestamp = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addTimestamp"));
            this.addHostname = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addHostname"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'Syslog' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.facility = rep.getJobEntryAttributeString(id_jobentry, "facility");
            this.priority = rep.getJobEntryAttributeString(id_jobentry, "priority");
            this.message = rep.getJobEntryAttributeString(id_jobentry, "message");
            this.datePattern = rep.getJobEntryAttributeString(id_jobentry, "datePattern");
            this.addTimestamp = rep.getJobEntryAttributeBoolean(id_jobentry, "addTimestamp");
            this.addHostname = rep.getJobEntryAttributeBoolean(id_jobentry, "addHostname");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'Syslog' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "facility", this.facility);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "priority", this.priority);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "message", this.message);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "datePattern", this.datePattern);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addTimestamp", this.addTimestamp);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addHostname", this.addHostname);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'Syslog' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void addTimestamp(boolean value) {
        this.addTimestamp = value;
    }

    public boolean isAddHostName() {
        return this.addHostname;
    }

    public void addHostName(boolean value) {
        this.addHostname = value;
    }

    public boolean isAddTimestamp() {
        return this.addTimestamp;
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        String messageString;
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String servername = this.environmentSubstitute(this.getServerName());
        if (Const.isEmpty((String)servername)) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntrySyslog.MissingServerName", (String[])new String[0]));
        }
        if (Const.isEmpty((String)(messageString = this.environmentSubstitute(this.getMessage())))) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntrySyslog.MissingMessage", (String[])new String[0]));
        }
        int nrPort = Const.toInt((String)this.environmentSubstitute(this.getPort()), (int)514);
        SyslogIF syslog = null;
        try {
            String pattern = null;
            if (this.isAddTimestamp() && Const.isEmpty((String)(pattern = this.environmentSubstitute(this.getDatePattern())))) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySyslog.DatePatternEmpty", (String[])new String[0]));
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntrySyslog.DatePatternEmpty", (String[])new String[0]));
            }
            syslog = Syslog.getInstance((String)"udp");
            syslog.getConfig().setHost(servername);
            syslog.getConfig().setPort(nrPort);
            syslog.getConfig().setFacility(this.getFacility());
            syslog.getConfig().setSendLocalName(false);
            syslog.getConfig().setSendLocalTimestamp(false);
            SyslogDefs.sendMessage(syslog, SyslogDefs.getPriority(this.getPriority()), messageString, this.isAddTimestamp(), pattern, this.isAddHostName());
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntrySyslog.ErrorSendingMessage", (String[])new String[]{e.toString()}));
        }
        finally {
            if (syslog != null) {
                syslog.shutdown();
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
    }
}

