/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.telnet;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryTelnet
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryTelnet.class;
    private String hostname = null;
    private String port = String.valueOf(23);
    private String timeout = String.valueOf(3000);
    public static final int DEFAULT_TIME_OUT = 3000;
    public static final int DEFAULT_PORT = 23;

    public JobEntryTelnet(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryTelnet() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryTelnet je = (JobEntryTelnet)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.hostname = XMLHandler.getTagValue((Node)entrynode, (String)"hostname");
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.timeout = XMLHandler.getTagValue((Node)entrynode, (String)"timeout");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'Telnet' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.hostname = rep.getJobEntryAttributeString(id_jobentry, "hostname");
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.timeout = rep.getJobEntryAttributeString(id_jobentry, "timeout");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'Telnet' exists from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hostname", this.hostname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'Telnet' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getPort() {
        return this.port;
    }

    public String getRealPort() {
        return this.environmentSubstitute(this.getPort());
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRealHostname() {
        return this.environmentSubstitute(this.getHostname());
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public String getRealTimeOut() {
        return this.environmentSubstitute(this.getTimeOut());
    }

    public void setTimeOut(String timeout) {
        this.timeout = timeout;
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String hostname = this.getRealHostname();
        int port = Const.toInt((String)this.getRealPort(), (int)23);
        int timeoutInt = Const.toInt((String)this.getRealTimeOut(), (int)-1);
        if (Const.isEmpty((String)hostname)) {
            this.logError(BaseMessages.getString(PKG, (String)"JobTelnet.SpecifyHost.Label", (String[])new String[0]));
            return result;
        }
        try {
            JobEntryTelnet.telnetHost(hostname, port, timeoutInt);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobTelnet.OK.Label", (Object[])new Object[]{hostname, port}));
            }
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(PKG, (String)"JobTelnet.NOK.Label", (String[])new String[]{hostname, String.valueOf(port)}));
            this.logError(BaseMessages.getString(PKG, (String)"JobTelnet.Error.Label", (String[])new String[0]) + ex.getMessage());
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    private static void telnetHost(String host, int port, int timeout) throws KettleException {
        Socket socket = new Socket();
        try {
            InetSocketAddress is = new InetSocketAddress(host, port);
            if (timeout < 0) {
                socket.connect(is);
            } else {
                socket.connect(is, timeout);
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.hostname)) {
            String realServername = jobMeta.environmentSubstitute(this.hostname);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "hostname", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

