/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.webserviceavailable;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryWebServiceAvailable
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryWebServiceAvailable.class;
    private String url = null;
    private String connectTimeOut = "0";
    private String readTimeOut = "0";

    public JobEntryWebServiceAvailable(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryWebServiceAvailable() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryWebServiceAvailable je = (JobEntryWebServiceAvailable)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"url", (String)this.url));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connectTimeOut", (String)this.connectTimeOut));
        retval.append("      ").append(XMLHandler.addTagValue((String)"readTimeOut", (String)this.readTimeOut));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.url = XMLHandler.getTagValue((Node)entrynode, (String)"url");
            this.connectTimeOut = XMLHandler.getTagValue((Node)entrynode, (String)"connectTimeOut");
            this.readTimeOut = XMLHandler.getTagValue((Node)entrynode, (String)"readTimeOut");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryWebServiceAvailable.ERROR_0001_Cannot_Load_Job_Entry_From_Xml_Node", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.url = rep.getJobEntryAttributeString(id_jobentry, "url");
            this.connectTimeOut = rep.getJobEntryAttributeString(id_jobentry, "connectTimeOut");
            this.readTimeOut = rep.getJobEntryAttributeString(id_jobentry, "readTimeOut");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryWebServiceAvailable.ERROR_0002_Cannot_Load_Job_From_Repository", (String[])new String[]{"" + id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "url", this.url);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "connectTimeOut", this.connectTimeOut);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "readTimeOut", this.readTimeOut);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryWebServiceAvailable.ERROR_0003_Cannot_Save_Job_Entry", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public void setConnectTimeOut(String timeout) {
        this.connectTimeOut = timeout;
    }

    public String getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setReadTimeOut(String timeout) {
        this.readTimeOut = timeout;
    }

    public String getReadTimeOut() {
        return this.readTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        String realURL = this.environmentSubstitute(this.getURL());
        if (!Const.isEmpty((String)realURL)) {
            int connectTimeOut = Const.toInt((String)this.environmentSubstitute(this.getConnectTimeOut()), (int)0);
            int readTimeOut = Const.toInt((String)this.environmentSubstitute(this.getReadTimeOut()), (int)0);
            InputStream in = null;
            try {
                URLConnection conn = new URL(realURL).openConnection();
                conn.setConnectTimeout(connectTimeOut);
                conn.setReadTimeout(readTimeOut);
                in = conn.getInputStream();
                result.setResult(true);
            }
            catch (Exception e) {
                result.setNrErrors(1L);
                String message = BaseMessages.getString(PKG, (String)"JobEntryWebServiceAvailable.ERROR_0004_Exception", (String[])new String[]{realURL, e.toString()});
                this.logError(message);
                result.setLogText(message);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            result.setNrErrors(1L);
            String message = BaseMessages.getString(PKG, (String)"JobEntryWebServiceAvailable.ERROR_0005_No_URL_Defined", (String[])new String[0]);
            this.logError(message);
            result.setLogText(message);
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }
}

