/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.kitchen;

import com.google.gdata.util.common.base.Pair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.FileLoggingEventListener;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.di.version.BuildVersion;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.stores.delegate.DelegatingMetaStore;

public class Kitchen {
    private static Class<?> PKG = Kitchen.class;
    public static final String STRING_KITCHEN = "Kitchen";
    private static FileLoggingEventListener fileAppender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] a) throws Exception {
        Repository repository;
        JobMeta jobMeta;
        Date start;
        Calendar cal;
        SimpleDateFormat df;
        LogChannel log;
        StringBuffer optionExport;
        StringBuffer optionListParam;
        StringBuffer optionListrep;
        StringBuffer optionListjobs;
        StringBuffer optionListdir;
        NamedParamsDefault customOptions;
        NamedParamsDefault optionParams;
        Job job;
        DelegatingMetaStore metaStore;
        ArrayList<String> args;
        block68: {
            Pair<KettlePluginException, Future<KettleException>> repositoryRegisterResults;
            KettlePluginException repositoryRegisterException;
            final ExecutorService executor = ExecutorUtil.getExecutor();
            final RepositoryPluginType repositoryPluginType = RepositoryPluginType.getInstance();
            Future<Pair<KettlePluginException, Future<KettleException>>> repositoryRegisterFuture = executor.submit(new Callable<Pair<KettlePluginException, Future<KettleException>>>(){

                @Override
                public Pair<KettlePluginException, Future<KettleException>> call() throws Exception {
                    PluginRegistry.addPluginType((PluginTypeInterface)repositoryPluginType);
                    try {
                        KettleClientEnvironment.init();
                    }
                    catch (KettlePluginException e) {
                        return Pair.of((Object)((Object)e), null);
                    }
                    Future<KettleException> kettleEnvironmentInitFuture = executor.submit(new Callable<KettleException>(){

                        @Override
                        public KettleException call() throws Exception {
                            try {
                                KettleEnvironment.init();
                                KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.KITCHEN);
                            }
                            catch (KettleException e) {
                                return e;
                            }
                            return null;
                        }
                    });
                    return Pair.of(null, kettleEnvironmentInitFuture);
                }
            });
            args = new ArrayList<String>();
            for (int i = 0; i < a.length; ++i) {
                if (a[i].length() <= 0) continue;
                args.add(a[i]);
            }
            metaStore = new DelegatingMetaStore();
            metaStore.addMetaStore(MetaStoreConst.openLocalPentahoMetaStore());
            metaStore.setActiveMetaStoreName(metaStore.getName());
            RepositoryMeta repositoryMeta = null;
            job = null;
            optionParams = new NamedParamsDefault();
            customOptions = new NamedParamsDefault();
            CommandLineOption maxLogLinesOption = new CommandLineOption("maxloglines", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.MaxLogLines", (String[])new String[0]), new StringBuffer());
            CommandLineOption maxLogTimeoutOption = new CommandLineOption("maxlogtimeout", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.MaxLogTimeout", (String[])new String[0]), new StringBuffer());
            CommandLineOption[] commandLineOptionArray = new CommandLineOption[20];
            StringBuffer optionRepname = new StringBuffer();
            commandLineOptionArray[0] = new CommandLineOption("rep", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepName", (String[])new String[0]), optionRepname);
            StringBuffer optionUsername = new StringBuffer();
            commandLineOptionArray[1] = new CommandLineOption("user", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepUsername", (String[])new String[0]), optionUsername);
            StringBuffer optionPassword = new StringBuffer();
            commandLineOptionArray[2] = new CommandLineOption("pass", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepPassword", (String[])new String[0]), optionPassword);
            StringBuffer optionJobname = new StringBuffer();
            commandLineOptionArray[3] = new CommandLineOption("job", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepJobName", (String[])new String[0]), optionJobname);
            StringBuffer optionDirname = new StringBuffer();
            commandLineOptionArray[4] = new CommandLineOption("dir", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepDir", (String[])new String[0]), optionDirname);
            StringBuffer optionFilename = new StringBuffer();
            commandLineOptionArray[5] = new CommandLineOption("file", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.XMLJob", (String[])new String[0]), optionFilename);
            StringBuffer optionLoglevel = new StringBuffer();
            commandLineOptionArray[6] = new CommandLineOption("level", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.LogLevel", (String[])new String[0]), optionLoglevel);
            StringBuffer optionLogfile = new StringBuffer();
            commandLineOptionArray[7] = new CommandLineOption("logfile", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.LogFile", (String[])new String[0]), optionLogfile);
            StringBuffer optionLogfileOld = new StringBuffer();
            commandLineOptionArray[8] = new CommandLineOption("log", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.LogFileOld", (String[])new String[0]), optionLogfileOld, false, true);
            optionListdir = new StringBuffer();
            commandLineOptionArray[9] = new CommandLineOption("listdir", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.ListDir", (String[])new String[0]), optionListdir, true, false);
            optionListjobs = new StringBuffer();
            commandLineOptionArray[10] = new CommandLineOption("listjobs", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.ListJobsDir", (String[])new String[0]), optionListjobs, true, false);
            optionListrep = new StringBuffer();
            commandLineOptionArray[11] = new CommandLineOption("listrep", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.ListAvailableReps", (String[])new String[0]), optionListrep, true, false);
            StringBuffer optionNorep = new StringBuffer();
            commandLineOptionArray[12] = new CommandLineOption("norep", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.NoRep", (String[])new String[0]), optionNorep, true, false);
            StringBuffer optionVersion = new StringBuffer();
            commandLineOptionArray[13] = new CommandLineOption("version", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.Version", (String[])new String[0]), optionVersion, true, false);
            commandLineOptionArray[14] = new CommandLineOption("param", BaseMessages.getString(PKG, (String)"Kitchen.ComdLine.Param", (String[])new String[0]), (NamedParams)optionParams, false);
            optionListParam = new StringBuffer();
            commandLineOptionArray[15] = new CommandLineOption("listparam", BaseMessages.getString(PKG, (String)"Kitchen.ComdLine.ListParam", (String[])new String[0]), optionListParam, true, false);
            optionExport = new StringBuffer();
            commandLineOptionArray[16] = new CommandLineOption("export", BaseMessages.getString(PKG, (String)"Kitchen.ComdLine.Export", (String[])new String[0]), optionExport, true, false);
            commandLineOptionArray[17] = new CommandLineOption("custom", BaseMessages.getString(PKG, (String)"Kitchen.ComdLine.Custom", (String[])new String[0]), (NamedParams)customOptions, false);
            commandLineOptionArray[18] = maxLogLinesOption;
            commandLineOptionArray[19] = maxLogTimeoutOption;
            CommandLineOption[] options = commandLineOptionArray;
            if (args.size() == 0) {
                CommandLineOption.printUsage(options);
                Kitchen.exitJVM(9);
            }
            log = new LogChannel((Object)STRING_KITCHEN);
            CommandLineOption.parseArguments(args, options, (LogChannelInterface)log);
            Kitchen.configureLogging(maxLogLinesOption, maxLogTimeoutOption);
            String kettleRepname = Const.getEnvironmentVariable((String)"KETTLE_REPOSITORY", null);
            String kettleUsername = Const.getEnvironmentVariable((String)"KETTLE_USER", null);
            String kettlePassword = Const.getEnvironmentVariable((String)"KETTLE_PASSWORD", null);
            if (!Const.isEmpty((String)kettleRepname)) {
                optionRepname = new StringBuffer(kettleRepname);
            }
            if (!Const.isEmpty((String)kettleUsername)) {
                optionUsername = new StringBuffer(kettleUsername);
            }
            if (!Const.isEmpty((String)kettlePassword)) {
                optionPassword = new StringBuffer(kettlePassword);
            }
            if (Const.isEmpty((StringBuffer)optionLogfile) && !Const.isEmpty((StringBuffer)optionLogfileOld)) {
                optionLogfile = optionLogfileOld;
            }
            if ((repositoryRegisterException = (KettlePluginException)((Object)(repositoryRegisterResults = repositoryRegisterFuture.get()).getFirst())) != null) {
                throw repositoryRegisterException;
            }
            Future kettleInitFuture = (Future)repositoryRegisterResults.getSecond();
            if (!Const.isEmpty((StringBuffer)optionLogfile)) {
                fileAppender = new FileLoggingEventListener(optionLogfile.toString(), true);
                KettleLogStore.getAppender().addLoggingEventListener((KettleLoggingEventListener)fileAppender);
            } else {
                fileAppender = null;
            }
            if (!Const.isEmpty((StringBuffer)optionLoglevel)) {
                log.setLogLevel(LogLevel.getLogLevelForCode((String)optionLoglevel.toString()));
                log.logMinimal(BaseMessages.getString(PKG, (String)"Kitchen.Log.LogLevel", (String[])new String[]{log.getLogLevel().getDescription()}));
            }
            if (!Const.isEmpty((StringBuffer)optionVersion)) {
                BuildVersion buildVersion = BuildVersion.getInstance();
                log.logBasic(BaseMessages.getString(PKG, (String)"Kitchen.Log.KettleVersion", (String[])new String[]{buildVersion.getVersion(), buildVersion.getRevision(), buildVersion.getBuildDate()}));
                if (a.length == 1) {
                    Kitchen.exitJVM(6);
                }
            }
            if (!Const.isEmpty((StringBuffer)optionRepname) && !Const.isEmpty((StringBuffer)optionUsername) && log.isDetailed()) {
                log.logDetailed(BaseMessages.getString(PKG, (String)"Kitchen.Log.RepUsernameSupplied", (String[])new String[0]));
            }
            log.logMinimal(BaseMessages.getString(PKG, (String)"Kitchen.Log.Starting", (String[])new String[0]));
            df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            cal = Calendar.getInstance();
            start = cal.getTime();
            if (log.isDebug()) {
                log.logDebug(BaseMessages.getString(PKG, (String)"Kitchen.Log.AllocateNewJob", (String[])new String[0]));
            }
            jobMeta = new JobMeta();
            repository = null;
            try {
                if (!Const.isEmpty((StringBuffer)optionRepname) || !Const.isEmpty((StringBuffer)optionFilename)) {
                    if (log.isDebug()) {
                        log.logDebug(BaseMessages.getString(PKG, (String)"Kitchen.Log.ParsingCommandLine", (String[])new String[0]));
                    }
                    if (!Const.isEmpty((StringBuffer)optionRepname) && !"Y".equalsIgnoreCase(optionNorep.toString())) {
                        if (log.isDebug()) {
                            log.logDebug(BaseMessages.getString(PKG, (String)"Kitchen.Log.LoadingRep", (String[])new String[0]));
                        }
                        RepositoriesMeta repsinfo = new RepositoriesMeta();
                        try {
                            repsinfo.readData();
                        }
                        catch (Exception e) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Kitchen.Error.NoRepDefinied", (String[])new String[0]), (Throwable)e);
                        }
                        if (log.isDebug()) {
                            log.logDebug(BaseMessages.getString(PKG, (String)"Kitchen.Log.FindingRep", (String[])new String[]{"" + optionRepname}));
                        }
                        if ((repositoryMeta = repsinfo.findRepository(optionRepname.toString())) != null) {
                            if (log.isDebug()) {
                                log.logDebug(BaseMessages.getString(PKG, (String)"Kitchen.Log.Alocate&ConnectRep", (String[])new String[0]));
                            }
                            repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
                            repository.init(repositoryMeta);
                            repository.connect(optionUsername != null ? optionUsername.toString() : null, optionPassword != null ? optionPassword.toString() : null);
                            RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree();
                            if (repository.getMetaStore() != null) {
                                metaStore.addMetaStore(repository.getMetaStore());
                            }
                            if (!Const.isEmpty((StringBuffer)optionDirname)) {
                                directory = directory.findDirectory(optionDirname.toString());
                            }
                            if (directory != null) {
                                int i;
                                if (log.isDebug()) {
                                    log.logDebug(BaseMessages.getString(PKG, (String)"Kitchen.Log.CheckUserPass", (String[])new String[0]));
                                }
                                if (!Const.isEmpty((StringBuffer)optionJobname)) {
                                    if (log.isDebug()) {
                                        log.logDebug(BaseMessages.getString(PKG, (String)"Kitchen.Log.LoadingJobInfo", (String[])new String[0]));
                                    }
                                    Kitchen.blockAndThrow(kettleInitFuture);
                                    jobMeta = repository.loadJob(optionJobname.toString(), directory, null, null);
                                    if (log.isDebug()) {
                                        log.logDebug(BaseMessages.getString(PKG, (String)"Kitchen.Log.AllocateJob", (String[])new String[0]));
                                    }
                                    job = new Job(repository, jobMeta);
                                } else if ("Y".equalsIgnoreCase(optionListjobs.toString())) {
                                    if (log.isDebug()) {
                                        log.logDebug(BaseMessages.getString(PKG, (String)"Kitchen.Log.GettingLostJobsInDirectory", (String[])new String[]{"" + directory}));
                                    }
                                    String[] jobnames = repository.getJobNames(directory.getObjectId(), false);
                                    for (i = 0; i < jobnames.length; ++i) {
                                        System.out.println(jobnames[i]);
                                    }
                                } else if ("Y".equalsIgnoreCase(optionListdir.toString())) {
                                    String[] dirnames = repository.getDirectoryNames(directory.getObjectId());
                                    for (i = 0; i < dirnames.length; ++i) {
                                        System.out.println(dirnames[i]);
                                    }
                                }
                            } else {
                                System.out.println(BaseMessages.getString(PKG, (String)"Kitchen.Error.CanNotFindSuppliedDirectory", (String[])new String[]{optionDirname + ""}));
                                repositoryMeta = null;
                            }
                        } else {
                            System.out.println(BaseMessages.getString(PKG, (String)"Kitchen.Error.NoRepProvided", (String[])new String[0]));
                        }
                    }
                    if (!Const.isEmpty((StringBuffer)optionFilename) && job == null) {
                        Kitchen.blockAndThrow(kettleInitFuture);
                        jobMeta = new JobMeta(optionFilename.toString(), null, null);
                        job = new Job(null, jobMeta);
                    }
                    break block68;
                }
                if ("Y".equalsIgnoreCase(optionListrep.toString())) {
                    RepositoriesMeta ri = new RepositoriesMeta();
                    ri.readData();
                    System.out.println(BaseMessages.getString(PKG, (String)"Kitchen.Log.ListRep", (String[])new String[0]));
                    for (int i = 0; i < ri.nrRepositories(); ++i) {
                        RepositoryMeta rinfo = ri.getRepository(i);
                        System.out.println("#" + (i + 1) + " : " + rinfo.getName() + " [" + rinfo.getDescription() + "]  id=" + rinfo.getId());
                    }
                }
            }
            catch (KettleException e) {
                job = null;
                jobMeta = null;
                System.out.println(BaseMessages.getString(PKG, (String)"Kitchen.Error.StopProcess", (String[])new String[]{e.getMessage()}));
            }
        }
        if (job == null) {
            if (!("Y".equalsIgnoreCase(optionListjobs.toString()) || "Y".equalsIgnoreCase(optionListdir.toString()) || "Y".equalsIgnoreCase(optionListrep.toString()))) {
                System.out.println(BaseMessages.getString(PKG, (String)"Kitchen.Error.canNotLoadJob", (String[])new String[0]));
            }
            Kitchen.exitJVM(7);
        }
        if (!Const.isEmpty((String)optionExport.toString())) {
            try {
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(optionExport.toString(), job.getJobMeta(), job, repository, (IMetaStore)metaStore);
                String launchFile = topLevelResource.getResourceName();
                String message = ResourceUtil.getExplanation(optionExport.toString(), launchFile, job.getJobMeta());
                System.out.println();
                System.out.println(message);
                optionListParam = new StringBuffer("Y");
            }
            catch (Exception e) {
                System.out.println(Const.getStackTracker((Throwable)e));
                Kitchen.exitJVM(2);
            }
        }
        Result result = null;
        int returnCode = 0;
        try {
            String value;
            String[] jobParams;
            if (args.size() == 0) {
                job.setArguments(null);
            } else {
                job.setArguments(args.toArray(new String[args.size()]));
            }
            job.initializeVariablesFrom(null);
            job.setLogLevel(log.getLogLevel());
            job.getJobMeta().setInternalKettleVariables(job);
            for (String param : jobParams = jobMeta.listParameters()) {
                value = optionParams.getParameterValue(param);
                if (value == null) continue;
                job.getJobMeta().setParameterValue(param, value);
            }
            job.copyParametersFrom(job.getJobMeta());
            job.activateParameters();
            for (String optionName : customOptions.listParameters()) {
                String optionValue = customOptions.getParameterValue(optionName);
                if (optionName == null || optionValue == null) continue;
                job.getExtensionDataMap().put(optionName, optionValue);
            }
            if ("Y".equalsIgnoreCase(optionListParam.toString())) {
                for (String parameterName : job.listParameters()) {
                    value = job.getParameterValue(parameterName);
                    String deflt = job.getParameterDefault(parameterName);
                    String descr = job.getParameterDescription(parameterName);
                    if (deflt != null) {
                        System.out.println("Parameter: " + parameterName + "=" + Const.NVL((String)value, (String)"") + ", default=" + deflt + " : " + Const.NVL((String)descr, (String)""));
                        continue;
                    }
                    System.out.println("Parameter: " + parameterName + "=" + Const.NVL((String)value, (String)"") + " : " + Const.NVL((String)descr, (String)""));
                }
                Kitchen.exitJVM(7);
            }
            job.start();
            job.waitUntilFinished();
            result = job.getResult();
        }
        finally {
            if (repository != null) {
                repository.disconnect();
            }
        }
        log.logMinimal(BaseMessages.getString(PKG, (String)"Kitchen.Log.Finished", (String[])new String[0]));
        if (result != null && result.getNrErrors() != 0L) {
            log.logError(BaseMessages.getString(PKG, (String)"Kitchen.Error.FinishedWithErrors", (String[])new String[0]));
            returnCode = 1;
        }
        cal = Calendar.getInstance();
        Date stop = cal.getTime();
        String begin = df.format(start).toString();
        String end = df.format(stop).toString();
        log.logMinimal(BaseMessages.getString(PKG, (String)"Kitchen.Log.StartStop", (String[])new String[]{begin, end}));
        long seconds = (stop.getTime() - start.getTime()) / 1000L;
        if (seconds <= 60L) {
            log.logMinimal(BaseMessages.getString(PKG, (String)"Kitchen.Log.ProcessEndAfter", (String[])new String[]{String.valueOf(seconds)}));
        } else if (seconds <= 3600L) {
            int min = (int)(seconds / 60L);
            int rem = (int)(seconds % 60L);
            log.logMinimal(BaseMessages.getString(PKG, (String)"Kitchen.Log.ProcessEndAfterLong", (String[])new String[]{String.valueOf(min), String.valueOf(rem), String.valueOf(seconds)}));
        } else if (seconds <= 86400L) {
            int hour = (int)(seconds / 3600L);
            int rem = (int)(seconds % 3600L);
            int min = rem / 60;
            log.logMinimal(BaseMessages.getString(PKG, (String)"Kitchen.Log.ProcessEndAfterLonger", (String[])new String[]{String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
        } else {
            int days = (int)(seconds / 86400L);
            int rem = (int)(seconds % 86400L);
            int hour = rem / 3600;
            int min = (rem %= 3600) / 60;
            log.logMinimal(BaseMessages.getString(PKG, (String)"Kitchen.Log.ProcessEndAfterLongest", (String[])new String[]{String.valueOf(days), String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
        }
        if (fileAppender != null) {
            fileAppender.close();
            KettleLogStore.getAppender().removeLoggingEventListener((KettleLoggingEventListener)fileAppender);
        }
        Kitchen.exitJVM(returnCode);
    }

    private static <T extends Throwable> void blockAndThrow(Future<T> future) throws T {
        try {
            Throwable e = (Throwable)future.get();
            if (e != null) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void configureLogging(CommandLineOption maxLogLinesOption, CommandLineOption maxLogTimeoutOption) throws KettleException {
        int maxLogLines = Kitchen.parseIntArgument(maxLogLinesOption, 0);
        if (Const.isEmpty((StringBuffer)maxLogLinesOption.getArgument())) {
            maxLogLines = Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_MAX_LOG_SIZE_IN_LINES"), (int)5000);
        }
        int maxLogTimeout = Kitchen.parseIntArgument(maxLogTimeoutOption, 0);
        if (Const.isEmpty((StringBuffer)maxLogTimeoutOption.getArgument())) {
            maxLogTimeout = Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_MAX_LOG_TIMEOUT_IN_MINUTES"), (int)1440);
        }
        KettleLogStore.init((int)maxLogLines, (int)maxLogTimeout);
    }

    protected static int parseIntArgument(CommandLineOption option, int def) throws KettleException {
        if (!Const.isEmpty((StringBuffer)option.getArgument())) {
            try {
                return Integer.parseInt(option.getArgument().toString());
            }
            catch (NumberFormatException ex) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Kitchen.Error.InvalidNumberArgument", (Object[])new Object[]{option.getOption(), option.getArgument()}));
            }
        }
        return def;
    }

    private static final void exitJVM(int status) {
        System.exit(status);
    }
}

