/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pan;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.FileLoggingEventListener;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.kitchen.Kitchen;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.version.BuildVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Pan {
    private static Class<?> PKG = Pan.class;
    private static final String STRING_PAN = "Pan";
    private static FileLoggingEventListener fileLoggingEventListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] a) throws KettleException {
        Repository rep;
        Date start;
        Calendar cal;
        SimpleDateFormat df;
        LogChannel log;
        StringBuffer optionMetrics;
        StringBuffer optionListParam;
        StringBuffer optionSafemode;
        StringBuffer optionExprep;
        StringBuffer optionListrep;
        StringBuffer optionListtrans;
        StringBuffer optionListdir;
        NamedParamsDefault optionParams;
        Trans trans;
        ArrayList<String> args;
        block92: {
            KettleEnvironment.init();
            KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.PAN);
            args = new ArrayList<String>();
            for (int i = 0; i < a.length; ++i) {
                if (a[i].length() <= 0) continue;
                args.add(a[i]);
            }
            RepositoryMeta repositoryMeta = null;
            trans = null;
            optionParams = new NamedParamsDefault();
            CommandLineOption maxLogLinesOption = new CommandLineOption("maxloglines", BaseMessages.getString(PKG, (String)"Pan.CmdLine.MaxLogLines", (String[])new String[0]), new StringBuffer());
            CommandLineOption maxLogTimeoutOption = new CommandLineOption("maxlogtimeout", BaseMessages.getString(PKG, (String)"Pan.CmdLine.MaxLogTimeout", (String[])new String[0]), new StringBuffer());
            CommandLineOption[] commandLineOptionArray = new CommandLineOption[22];
            StringBuffer optionRepname = new StringBuffer();
            commandLineOptionArray[0] = new CommandLineOption("rep", BaseMessages.getString(PKG, (String)"Pan.ComdLine.RepName", (String[])new String[0]), optionRepname);
            StringBuffer optionUsername = new StringBuffer();
            commandLineOptionArray[1] = new CommandLineOption("user", BaseMessages.getString(PKG, (String)"Pan.ComdLine.RepUsername", (String[])new String[0]), optionUsername);
            StringBuffer optionPassword = new StringBuffer();
            commandLineOptionArray[2] = new CommandLineOption("pass", BaseMessages.getString(PKG, (String)"Pan.ComdLine.RepPassword", (String[])new String[0]), optionPassword);
            StringBuffer optionTransname = new StringBuffer();
            commandLineOptionArray[3] = new CommandLineOption("trans", BaseMessages.getString(PKG, (String)"Pan.ComdLine.TransName", (String[])new String[0]), optionTransname);
            StringBuffer optionDirname = new StringBuffer();
            commandLineOptionArray[4] = new CommandLineOption("dir", BaseMessages.getString(PKG, (String)"Pan.ComdLine.RepDir", (String[])new String[0]), optionDirname);
            StringBuffer optionFilename = new StringBuffer();
            commandLineOptionArray[5] = new CommandLineOption("file", BaseMessages.getString(PKG, (String)"Pan.ComdLine.XMLTransFile", (String[])new String[0]), optionFilename);
            StringBuffer optionLoglevel = new StringBuffer();
            commandLineOptionArray[6] = new CommandLineOption("level", BaseMessages.getString(PKG, (String)"Pan.ComdLine.LogLevel", (String[])new String[0]), optionLoglevel);
            StringBuffer optionLogfile = new StringBuffer();
            commandLineOptionArray[7] = new CommandLineOption("logfile", BaseMessages.getString(PKG, (String)"Pan.ComdLine.LogFile", (String[])new String[0]), optionLogfile);
            StringBuffer optionLogfileOld = new StringBuffer();
            commandLineOptionArray[8] = new CommandLineOption("log", BaseMessages.getString(PKG, (String)"Pan.ComdLine.LogOldFile", (String[])new String[0]), optionLogfileOld, false, true);
            optionListdir = new StringBuffer();
            commandLineOptionArray[9] = new CommandLineOption("listdir", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ListDirRep", (String[])new String[0]), optionListdir, true, false);
            optionListtrans = new StringBuffer();
            commandLineOptionArray[10] = new CommandLineOption("listtrans", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ListTransDir", (String[])new String[0]), optionListtrans, true, false);
            optionListrep = new StringBuffer();
            commandLineOptionArray[11] = new CommandLineOption("listrep", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ListReps", (String[])new String[0]), optionListrep, true, false);
            optionExprep = new StringBuffer();
            commandLineOptionArray[12] = new CommandLineOption("exprep", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ExpObjectsXML", (String[])new String[0]), optionExprep, true, false);
            StringBuffer optionNorep = new StringBuffer();
            commandLineOptionArray[13] = new CommandLineOption("norep", BaseMessages.getString(PKG, (String)"Pan.ComdLine.NoRep", (String[])new String[0]), optionNorep, true, false);
            optionSafemode = new StringBuffer();
            commandLineOptionArray[14] = new CommandLineOption("safemode", BaseMessages.getString(PKG, (String)"Pan.ComdLine.SafeMode", (String[])new String[0]), optionSafemode, true, false);
            StringBuffer optionVersion = new StringBuffer();
            commandLineOptionArray[15] = new CommandLineOption("version", BaseMessages.getString(PKG, (String)"Pan.ComdLine.Version", (String[])new String[0]), optionVersion, true, false);
            StringBuffer optionJarFilename = new StringBuffer();
            commandLineOptionArray[16] = new CommandLineOption("jarfile", BaseMessages.getString(PKG, (String)"Pan.ComdLine.JarFile", (String[])new String[0]), optionJarFilename, false, true);
            commandLineOptionArray[17] = new CommandLineOption("param", BaseMessages.getString(PKG, (String)"Pan.ComdLine.Param", (String[])new String[0]), (NamedParams)optionParams, false);
            optionListParam = new StringBuffer();
            commandLineOptionArray[18] = new CommandLineOption("listparam", BaseMessages.getString(PKG, (String)"Pan.ComdLine.ListParam", (String[])new String[0]), optionListParam, true, false);
            optionMetrics = new StringBuffer();
            commandLineOptionArray[19] = new CommandLineOption("metrics", BaseMessages.getString(PKG, (String)"Pan.ComdLine.Metrics", (String[])new String[0]), optionMetrics, true, false);
            commandLineOptionArray[20] = maxLogLinesOption;
            commandLineOptionArray[21] = maxLogTimeoutOption;
            CommandLineOption[] options = commandLineOptionArray;
            if (args.size() == 0) {
                CommandLineOption.printUsage(options);
                Pan.exitJVM(9);
            }
            if (!CommandLineOption.parseArguments(args, options, (LogChannelInterface)(log = new LogChannel((Object)STRING_PAN)))) {
                log.logError(BaseMessages.getString(PKG, (String)"Pan.Error.CommandLineError", (String[])new String[0]));
                Pan.exitJVM(8);
            }
            Kitchen.configureLogging(maxLogLinesOption, maxLogTimeoutOption);
            String kettleRepname = Const.getEnvironmentVariable((String)"KETTLE_REPOSITORY", null);
            String kettleUsername = Const.getEnvironmentVariable((String)"KETTLE_USER", null);
            String kettlePassword = Const.getEnvironmentVariable((String)"KETTLE_PASSWORD", null);
            if (kettleRepname != null && kettleRepname.length() > 0) {
                optionRepname = new StringBuffer(kettleRepname);
            }
            if (kettleUsername != null && kettleUsername.length() > 0) {
                optionUsername = new StringBuffer(kettleUsername);
            }
            if (kettlePassword != null && kettlePassword.length() > 0) {
                optionPassword = new StringBuffer(kettlePassword);
            }
            if (Const.isEmpty((StringBuffer)optionLogfile) && !Const.isEmpty((StringBuffer)optionLogfileOld)) {
                optionLogfile = optionLogfileOld;
            }
            if (!Const.isEmpty((StringBuffer)optionLogfile)) {
                fileLoggingEventListener = new FileLoggingEventListener(optionLogfile.toString(), true);
                KettleLogStore.getAppender().addLoggingEventListener((KettleLoggingEventListener)fileLoggingEventListener);
            } else {
                fileLoggingEventListener = null;
            }
            if (!Const.isEmpty((StringBuffer)optionLoglevel)) {
                log.setLogLevel(LogLevel.getLogLevelForCode((String)optionLoglevel.toString()));
                log.logMinimal(BaseMessages.getString(PKG, (String)"Pan.Log.Loglevel", (String[])new String[]{log.getLogLevel().getDescription()}));
            }
            if (!Const.isEmpty((StringBuffer)optionVersion)) {
                BuildVersion buildVersion = BuildVersion.getInstance();
                if (log.isBasic()) {
                    log.logBasic(BaseMessages.getString(PKG, (String)"Pan.Log.KettleVersion", (String[])new String[]{buildVersion.getVersion(), buildVersion.getRevision(), buildVersion.getBuildDate()}));
                }
                if (a.length == 1) {
                    Pan.exitJVM(6);
                }
            }
            if (log.isDebug()) {
                System.out.println("Arguments:");
                for (int i = 0; i < options.length; ++i) {
                    System.out.println(Const.rightPad((String)options[i].getOption(), (int)12) + " : " + options[i].getArgument());
                }
                System.out.println("");
            }
            log.logMinimal(BaseMessages.getString(PKG, (String)"Pan.Log.StartingToRun", (String[])new String[0]));
            df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            cal = Calendar.getInstance();
            start = cal.getTime();
            if (log.isDebug()) {
                log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.AllocatteNewTrans", (String[])new String[0]));
            }
            TransMeta transMeta = new TransMeta();
            rep = null;
            try {
                if (log.isDebug()) {
                    log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.StartingToLookOptions", (String[])new String[0]));
                }
                if (!(Const.isEmpty((StringBuffer)optionRepname) && Const.isEmpty((StringBuffer)optionFilename) && Const.isEmpty((StringBuffer)optionJarFilename))) {
                    if (log.isDebug()) {
                        log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.ParsingCommandline", (String[])new String[0]));
                    }
                    if (!Const.isEmpty((StringBuffer)optionRepname) && !"Y".equalsIgnoreCase(optionNorep.toString())) {
                        if (log.isDebug()) {
                            log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.LoadingAvailableRep", (String[])new String[0]));
                        }
                        RepositoriesMeta repsinfo = new RepositoriesMeta();
                        try {
                            repsinfo.readData();
                        }
                        catch (Exception e) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Pan.Error.NoRepsDefined", (String[])new String[0]), (Throwable)e);
                        }
                        if (log.isDebug()) {
                            log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.FindingRep", (String[])new String[]{"" + optionRepname}));
                        }
                        if ((repositoryMeta = repsinfo.findRepository(optionRepname.toString())) != null) {
                            if (log.isDebug()) {
                                log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.Allocate&ConnectRep", (String[])new String[0]));
                            }
                            rep = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
                            rep.init(repositoryMeta);
                            rep.connect(optionUsername != null ? optionUsername.toString() : null, optionPassword != null ? optionPassword.toString() : null);
                            RepositoryDirectoryInterface directory = rep.loadRepositoryDirectoryTree();
                            if (!Const.isEmpty((StringBuffer)optionDirname)) {
                                directory = directory.findDirectory(optionDirname.toString());
                            }
                            if (directory != null) {
                                int i;
                                if (log.isDebug()) {
                                    log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.CheckSuppliedUserPass", (String[])new String[0]));
                                }
                                if (!Const.isEmpty((StringBuffer)optionTransname)) {
                                    if (log.isDebug()) {
                                        log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.LoadTransInfo", (String[])new String[0]));
                                    }
                                    transMeta = rep.loadTransformation(optionTransname.toString(), directory, null, true, null);
                                    if (log.isDebug()) {
                                        log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.AllocateTrans", (String[])new String[0]));
                                    }
                                    trans = new Trans(transMeta);
                                    trans.setRepository(rep);
                                } else if ("Y".equalsIgnoreCase(optionListtrans.toString())) {
                                    if (log.isDebug()) {
                                        log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.GettingListTransDirectory", (String[])new String[]{"" + directory}));
                                    }
                                    String[] transnames = rep.getTransformationNames(directory.getObjectId(), false);
                                    for (i = 0; i < transnames.length; ++i) {
                                        System.out.println(transnames[i]);
                                    }
                                } else if ("Y".equalsIgnoreCase(optionListdir.toString())) {
                                    String[] dirnames = rep.getDirectoryNames(directory.getObjectId());
                                    for (i = 0; i < dirnames.length; ++i) {
                                        System.out.println(dirnames[i]);
                                    }
                                } else if (!Const.isEmpty((StringBuffer)optionExprep)) {
                                    System.out.println(BaseMessages.getString(PKG, (String)"Pan.Log.ExportingObjectsRepToFile", (String[])new String[]{"" + optionExprep}));
                                    rep.getExporter().exportAllObjects(null, optionExprep.toString(), directory, "all");
                                    System.out.println(BaseMessages.getString(PKG, (String)"Pan.Log.FinishedExportObjectsRepToFile", (String[])new String[]{"" + optionExprep}));
                                } else {
                                    System.out.println(BaseMessages.getString(PKG, (String)"Pan.Error.NoTransNameSupplied", (String[])new String[0]));
                                }
                            } else {
                                System.out.println(BaseMessages.getString(PKG, (String)"Pan.Error.CanNotFindSpecifiedDirectory", (String[])new String[]{"" + optionDirname}));
                                repositoryMeta = null;
                            }
                        } else {
                            System.out.println(BaseMessages.getString(PKG, (String)"Pan.Error.NoRepProvided", (String[])new String[0]));
                        }
                    }
                    if (trans == null && !Const.isEmpty((StringBuffer)optionFilename)) {
                        if (log.isDetailed()) {
                            log.logDetailed(BaseMessages.getString(PKG, (String)"Pan.Log.LoadingTransXML", (String[])new String[]{"" + optionFilename}));
                        }
                        transMeta = new TransMeta(optionFilename.toString());
                        trans = new Trans(transMeta);
                    }
                    if (trans == null && !Const.isEmpty((StringBuffer)optionJarFilename)) {
                        try {
                            int c;
                            if (log.isDetailed()) {
                                log.logDetailed(BaseMessages.getString(PKG, (String)"Pan.Log.LoadingTransJar", (String[])new String[]{"" + optionJarFilename}));
                            }
                            InputStream inputStream = Pan.class.getResourceAsStream(optionJarFilename.toString());
                            StringBuffer xml = new StringBuffer();
                            while ((c = inputStream.read()) != -1) {
                                xml.append((char)c);
                            }
                            inputStream.close();
                            Document document = XMLHandler.loadXMLString((String)xml.toString());
                            transMeta = new TransMeta(XMLHandler.getSubNode((Node)document, (String)"transformation"), null);
                            trans = new Trans(transMeta);
                        }
                        catch (Exception e) {
                            System.out.println(BaseMessages.getString(PKG, (String)"Pan.Error.ReadingJar", (String[])new String[]{e.toString()}));
                            System.out.println(Const.getStackTracker((Throwable)e));
                            throw e;
                        }
                    }
                }
                if (!"Y".equalsIgnoreCase(optionListrep.toString())) break block92;
                if (log.isDebug()) {
                    log.logDebug(BaseMessages.getString(PKG, (String)"Pan.Log.GettingListReps", (String[])new String[0]));
                }
                RepositoriesMeta ri = new RepositoriesMeta();
                try {
                    ri.readData();
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Pan.Error.UnableReadXML", (String[])new String[0]), (Throwable)e);
                }
                System.out.println(BaseMessages.getString(PKG, (String)"Pan.Log.ListReps", (String[])new String[0]));
                for (int i = 0; i < ri.nrRepositories(); ++i) {
                    RepositoryMeta rinfo = ri.getRepository(i);
                    System.out.println(BaseMessages.getString(PKG, (String)"Pan.Log.RepNameDesc", (String[])new String[]{"" + (i + 1), rinfo.getName(), rinfo.getDescription()}));
                }
            }
            catch (Exception e) {
                trans = null;
                transMeta = null;
                if (rep != null) {
                    rep.disconnect();
                }
                System.out.println(BaseMessages.getString(PKG, (String)"Pan.Error.ProcessStopError", (String[])new String[]{e.getMessage()}));
                e.printStackTrace();
                Pan.exitJVM(1);
            }
        }
        if (trans == null) {
            if (rep != null) {
                rep.disconnect();
            }
            if (!"Y".equalsIgnoreCase(optionListtrans.toString()) && !"Y".equalsIgnoreCase(optionListdir.toString()) && !"Y".equalsIgnoreCase(optionListrep.toString()) && Const.isEmpty((StringBuffer)optionExprep)) {
                System.out.println(BaseMessages.getString(PKG, (String)"Pan.Error.CanNotLoadTrans", (String[])new String[0]));
                Pan.exitJVM(7);
            } else {
                Pan.exitJVM(0);
            }
        }
        try {
            String value;
            String[] transParams;
            trans.initializeVariablesFrom(null);
            trans.getTransMeta().setInternalKettleVariables(trans);
            trans.setLogLevel(log.getLogLevel());
            for (String param : transParams = trans.listParameters()) {
                value = optionParams.getParameterValue(param);
                if (value == null) continue;
                trans.setParameterValue(param, value);
            }
            trans.activateParameters();
            if ("Y".equalsIgnoreCase(optionSafemode.toString())) {
                trans.setSafeModeEnabled(true);
            }
            if ("Y".equalsIgnoreCase(optionMetrics.toString())) {
                trans.setGatheringMetrics(true);
            }
            if ("Y".equalsIgnoreCase(optionListParam.toString())) {
                for (String parameterName : trans.listParameters()) {
                    value = trans.getParameterValue(parameterName);
                    String deflt = trans.getParameterDefault(parameterName);
                    String descr = trans.getParameterDescription(parameterName);
                    if (deflt != null) {
                        System.out.println("Parameter: " + parameterName + "=" + Const.NVL((String)value, (String)"") + ", default=" + deflt + " : " + Const.NVL((String)descr, (String)""));
                        continue;
                    }
                    System.out.println("Parameter: " + parameterName + "=" + Const.NVL((String)value, (String)"") + " : " + Const.NVL((String)descr, (String)""));
                }
                Pan.exitJVM(7);
            }
            try {
                trans.execute(args.toArray(new String[args.size()]));
            }
            catch (KettleException e) {
                System.out.println(BaseMessages.getString(PKG, (String)"Pan.Error.UnablePrepareInitTrans", (String[])new String[0]));
                Pan.exitJVM(3);
            }
            trans.waitUntilFinished();
            for (int i = 0; i < 100 && trans.isRunning(); ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (trans.isRunning()) {
                log.logError(BaseMessages.getString(PKG, (String)"Pan.Log.NotStopping", (String[])new String[0]));
            }
            log.logMinimal(BaseMessages.getString(PKG, (String)"Pan.Log.Finished", (String[])new String[0]));
            cal = Calendar.getInstance();
            Date stop = cal.getTime();
            String begin = df.format(start).toString();
            String end = df.format(stop).toString();
            log.logMinimal(BaseMessages.getString(PKG, (String)"Pan.Log.StartStop", (String[])new String[]{begin, end}));
            long millis = stop.getTime() - start.getTime();
            int seconds = (int)(millis / 1000L);
            if (seconds <= 60) {
                log.logMinimal(BaseMessages.getString(PKG, (String)"Pan.Log.ProcessingEndAfter", (String[])new String[]{String.valueOf(seconds)}));
            } else if (seconds <= 3600) {
                int min = seconds / 60;
                int rem = seconds % 60;
                log.logMinimal(BaseMessages.getString(PKG, (String)"Pan.Log.ProcessingEndAfterLong", (String[])new String[]{String.valueOf(min), String.valueOf(rem), String.valueOf(seconds)}));
            } else if (seconds <= 86400) {
                int hour = seconds / 3600;
                int rem = seconds % 3600;
                int min = rem / 60;
                log.logMinimal(BaseMessages.getString(PKG, (String)"Pan.Log.ProcessingEndAfterLonger", (String[])new String[]{String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
            } else {
                int days = seconds / 86400;
                int rem = seconds % 86400;
                int hour = rem / 3600;
                int min = (rem %= 3600) / 60;
                log.logMinimal(BaseMessages.getString(PKG, (String)"Pan.Log.ProcessingEndAfterLongest", (String[])new String[]{String.valueOf(days), String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
            }
            if (trans.getResult().getNrErrors() == 0L) {
                trans.printStats(seconds);
                Pan.exitJVM(0);
            } else {
                String transJVMExitCode = trans.getVariable("KETTLE_TRANS_PAN_JVM_EXIT_CODE");
                if (!Const.isEmpty((String)transJVMExitCode)) {
                    try {
                        Pan.exitJVM(Integer.valueOf(transJVMExitCode));
                    }
                    catch (NumberFormatException nfe) {
                        log.logError(BaseMessages.getString(PKG, (String)"Pan.Error.TransJVMExitCodeInvalid", (String[])new String[]{"KETTLE_TRANS_PAN_JVM_EXIT_CODE", transJVMExitCode}));
                        log.logError(BaseMessages.getString(PKG, (String)"Pan.Log.JVMExitCode", (String[])new String[]{"1"}));
                        Pan.exitJVM(1);
                    }
                } else {
                    Pan.exitJVM(1);
                }
            }
        }
        catch (KettleException ke) {
            System.out.println(BaseMessages.getString(PKG, (String)"Pan.Log.ErrorOccurred", (String[])new String[]{"" + ke.getMessage()}));
            log.logError(BaseMessages.getString(PKG, (String)"Pan.Log.UnexpectedErrorOccurred", (String[])new String[]{"" + ke.getMessage()}));
            Pan.exitJVM(2);
        }
        finally {
            if (rep != null) {
                rep.disconnect();
            }
        }
    }

    private static final void exitJVM(int status) {
        if (fileLoggingEventListener != null) {
            try {
                fileLoggingEventListener.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                status = 1;
            }
            KettleLogStore.getAppender().removeLoggingEventListener((KettleLoggingEventListener)fileLoggingEventListener);
        }
        System.exit(status);
    }
}

