/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.IRepositoryImporter;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryExportSaxParser;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.pentaho.di.repository.RepositoryImportLocation;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class RepositoryImporter
implements IRepositoryImporter {
    private static Class<?> PKG = RepositoryImporter.class;
    private Repository rep;
    private LogChannelInterface log = new LogChannel((Object)"Repository import");
    private SharedObjects sharedObjects;
    private RepositoryDirectoryInterface baseDirectory;
    private RepositoryDirectoryInterface root;
    private boolean overwrite;
    private boolean askOverwrite = true;
    private String versionComment;
    private boolean continueOnError;
    private String transDirOverride = null;
    private String jobDirOverride = null;
    private ImportRules importRules;
    private List<String> limitDirs;
    private List<RepositoryObject> referencingObjects;
    private List<Exception> exceptions;
    private int transformationNumber = 1;
    private int jobNumber = 1;

    public RepositoryImporter(Repository repository) {
        this(repository, new ImportRules(), new ArrayList<String>());
    }

    public RepositoryImporter(Repository repository, ImportRules importRules, List<String> limitDirs) {
        this.rep = repository;
        this.importRules = importRules;
        this.limitDirs = limitDirs;
        this.exceptions = new ArrayList<Exception>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void importAll(RepositoryImportFeedbackInterface feedback, String fileDirectory, String[] filenames, RepositoryDirectoryInterface baseDirectory, boolean overwrite, boolean continueOnError, String versionComment) {
        this.baseDirectory = baseDirectory;
        this.overwrite = overwrite;
        this.continueOnError = continueOnError;
        this.versionComment = versionComment;
        this.referencingObjects = new ArrayList<RepositoryObject>();
        feedback.setLabel(BaseMessages.getString(PKG, (String)"RepositoryImporter.ImportXML.Label", (String[])new String[0]));
        try {
            this.loadSharedObjects();
            RepositoryImportLocation.setRepositoryImportLocation(baseDirectory);
            for (int ii = 0; ii < filenames.length; ++ii) {
                String filename;
                String string = filename = !Const.isEmpty((String)fileDirectory) ? fileDirectory + Const.FILE_SEPARATOR + filenames[ii] : filenames[ii];
                if (this.log.isBasic()) {
                    this.log.logBasic("Import objects from XML file [" + filename + "]");
                }
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.WhichFile.Log", (String[])new String[]{filename}));
                feedback.setLabel(BaseMessages.getString(PKG, (String)"RepositoryImporter.WhichDir.Label", (String[])new String[0]));
                try {
                    RepositoryExportSaxParser parser = new RepositoryExportSaxParser(filename, feedback);
                    parser.parse(this);
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    this.addException(fnfe);
                    feedback.showError(BaseMessages.getString(PKG, (String)"PurRepositoryImporter.ErrorGeneral.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PurRepositoryImporter.FileNotFound.Message", (String[])new String[]{filename}), fnfe);
                    continue;
                }
                catch (SAXParseException spe) {
                    this.addException(spe);
                    feedback.showError(BaseMessages.getString(PKG, (String)"PurRepositoryImporter.ErrorGeneral.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PurRepositoryImporter.ParseError.Message", (String[])new String[]{filename}), spe);
                    continue;
                }
                catch (Exception e) {
                    feedback.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorGeneral.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorGeneral.Message", (String[])new String[0]), e);
                }
            }
            for (RepositoryObject ro : this.referencingObjects) {
                if (ro.getObjectType() == RepositoryObjectType.TRANSFORMATION) {
                    TransMeta transMeta = this.rep.loadTransformation(ro.getObjectId(), null);
                    try {
                        transMeta.lookupRepositoryReferences(this.rep);
                    }
                    catch (KettleException e) {
                        feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.LookupRepoRefsError.Log", (String[])new String[]{transMeta.getName()}));
                    }
                    this.rep.save(transMeta, "import object reference specification", null);
                }
                if (ro.getObjectType() != RepositoryObjectType.JOB) continue;
                JobMeta jobMeta = this.rep.loadJob(ro.getObjectId(), null);
                try {
                    jobMeta.lookupRepositoryReferences(this.rep);
                }
                catch (KettleException e) {
                    feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.LookupRepoRefsError.Log", (String[])new String[]{jobMeta.getName()}));
                }
                this.rep.save(jobMeta, "import object reference specification", null);
            }
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.ImportFinished.Log", (String[])new String[0]));
        }
        catch (KettleException e) {
            feedback.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorGeneral.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorGeneral.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        finally {
            RepositoryImportLocation.setRepositoryImportLocation(null);
        }
    }

    private void loadSharedObjects() throws KettleException {
        this.sharedObjects = new SharedObjects();
        for (ObjectId id : this.rep.getDatabaseIDs(false)) {
            DatabaseMeta databaseMeta = this.rep.loadDatabaseMeta(id, null);
            RepositoryImporter.validateImportedElement(this.importRules, databaseMeta);
            this.sharedObjects.storeObject((SharedObjectInterface)databaseMeta);
        }
        ArrayList<SlaveServer> slaveServers = new ArrayList<SlaveServer>();
        for (ObjectId id : this.rep.getSlaveIDs(false)) {
            SlaveServer slaveServer = this.rep.loadSlaveServer(id, null);
            RepositoryImporter.validateImportedElement(this.importRules, slaveServer);
            this.sharedObjects.storeObject(slaveServer);
            slaveServers.add(slaveServer);
        }
        for (ObjectId id : this.rep.getClusterIDs(false)) {
            ClusterSchema clusterSchema = this.rep.loadClusterSchema(id, slaveServers, null);
            RepositoryImporter.validateImportedElement(this.importRules, clusterSchema);
            this.sharedObjects.storeObject(clusterSchema);
        }
        for (ObjectId id : this.rep.getPartitionSchemaIDs(false)) {
            PartitionSchema partitionSchema = this.rep.loadPartitionSchema(id, null);
            RepositoryImporter.validateImportedElement(this.importRules, partitionSchema);
            this.sharedObjects.storeObject(partitionSchema);
        }
    }

    public static void validateImportedElement(ImportRules importRules, Object subject) throws KettleException {
        List<ImportValidationFeedback> feedback = importRules.verifyRules(subject);
        List<ImportValidationFeedback> errors = ImportValidationFeedback.getErrors(feedback);
        if (!errors.isEmpty()) {
            StringBuffer message = new StringBuffer(BaseMessages.getString(PKG, (String)"RepositoryImporter.ValidationFailed.Message", (String[])new String[]{subject.toString()}));
            message.append(Const.CR);
            for (ImportValidationFeedback error : errors) {
                message.append(" - ");
                message.append(error.toString());
                message.append(Const.CR);
            }
            throw new KettleException(message.toString());
        }
    }

    @Override
    public void addLog(String line) {
        this.log.logBasic(line);
    }

    @Override
    public void setLabel(String labelText) {
        this.log.logBasic(labelText);
    }

    @Override
    public boolean transOverwritePrompt(TransMeta transMeta) {
        return this.overwrite;
    }

    @Override
    public boolean jobOverwritePrompt(JobMeta jobMeta) {
        return this.overwrite;
    }

    @Override
    public void updateDisplay() {
    }

    @Override
    public void showError(String title, String message, Exception e) {
        this.log.logError(message, (Throwable)e);
    }

    private void replaceSharedObjects(TransMeta transMeta) {
        for (SharedObjectInterface sharedObject : this.sharedObjects.getObjectsMap().values()) {
            Object imported;
            int index;
            if (sharedObject instanceof DatabaseMeta) {
                DatabaseMeta databaseMeta = (DatabaseMeta)sharedObject;
                index = transMeta.indexOfDatabase(databaseMeta);
                if (index < 0) {
                    transMeta.addDatabase(databaseMeta);
                } else {
                    imported = transMeta.getDatabase(index);
                    if (this.overwrite) {
                        imported.setObjectId(databaseMeta.getObjectId());
                        imported.setChanged();
                    } else {
                        imported.replaceMeta(databaseMeta);
                        imported.setChanged(false);
                    }
                }
            }
            if (sharedObject instanceof SlaveServer) {
                SlaveServer slaveServer = (SlaveServer)sharedObject;
                index = transMeta.getSlaveServers().indexOf(slaveServer);
                if (index < 0) {
                    transMeta.getSlaveServers().add(slaveServer);
                } else {
                    imported = transMeta.getSlaveServers().get(index);
                    if (this.overwrite) {
                        ((SlaveServer)imported).setObjectId(slaveServer.getObjectId());
                        ((ChangedFlag)imported).setChanged();
                    } else {
                        ((SlaveServer)imported).replaceMeta(slaveServer);
                        ((ChangedFlag)imported).setChanged(false);
                    }
                }
            }
            if (sharedObject instanceof ClusterSchema) {
                ClusterSchema clusterSchema = (ClusterSchema)sharedObject;
                index = transMeta.getClusterSchemas().indexOf(clusterSchema);
                if (index < 0) {
                    transMeta.getClusterSchemas().add(clusterSchema);
                } else {
                    imported = transMeta.getClusterSchemas().get(index);
                    if (this.overwrite) {
                        ((ClusterSchema)imported).setObjectId(clusterSchema.getObjectId());
                        ((ChangedFlag)imported).setChanged();
                    } else {
                        ((ClusterSchema)imported).replaceMeta(clusterSchema);
                        ((ChangedFlag)imported).setChanged(false);
                    }
                }
            }
            if (!(sharedObject instanceof PartitionSchema)) continue;
            PartitionSchema partitionSchema = (PartitionSchema)sharedObject;
            index = transMeta.getPartitionSchemas().indexOf(partitionSchema);
            if (index < 0) {
                transMeta.getPartitionSchemas().add(partitionSchema);
                continue;
            }
            imported = transMeta.getPartitionSchemas().get(index);
            if (this.overwrite) {
                ((PartitionSchema)imported).setObjectId(partitionSchema.getObjectId());
                ((ChangedFlag)imported).setChanged();
                continue;
            }
            ((PartitionSchema)imported).replaceMeta(partitionSchema);
            ((ChangedFlag)imported).setChanged(false);
        }
    }

    private void replaceSharedObjects(JobMeta transMeta) {
        for (SharedObjectInterface sharedObject : this.sharedObjects.getObjectsMap().values()) {
            Object imported;
            int index;
            if (sharedObject instanceof DatabaseMeta) {
                DatabaseMeta databaseMeta = (DatabaseMeta)sharedObject;
                index = transMeta.indexOfDatabase(databaseMeta);
                if (index < 0) {
                    transMeta.addDatabase(databaseMeta);
                } else {
                    imported = transMeta.getDatabase(index);
                    if (this.overwrite) {
                        imported.setObjectId(databaseMeta.getObjectId());
                        imported.setChanged();
                    } else {
                        imported.replaceMeta(databaseMeta);
                        imported.setChanged(false);
                    }
                }
            }
            if (!(sharedObject instanceof SlaveServer)) continue;
            SlaveServer slaveServer = (SlaveServer)sharedObject;
            index = transMeta.getSlaveServers().indexOf(slaveServer);
            if (index < 0) {
                transMeta.getSlaveServers().add(slaveServer);
                continue;
            }
            imported = transMeta.getSlaveServers().get(index);
            if (this.overwrite) {
                ((SlaveServer)imported).setObjectId(slaveServer.getObjectId());
                ((ChangedFlag)imported).setChanged();
                continue;
            }
            ((SlaveServer)imported).replaceMeta(slaveServer);
            ((ChangedFlag)imported).setChanged(false);
        }
    }

    private void patchMappingSteps(TransMeta transMeta) {
        for (StepMeta stepMeta : transMeta.getSteps()) {
            MappingMeta mappingMeta;
            if (!stepMeta.isMapping() || (mappingMeta = (MappingMeta)stepMeta.getStepMetaInterface()).getSpecificationMethod() != ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) continue;
            if (this.transDirOverride != null) {
                mappingMeta.setDirectoryPath(this.transDirOverride);
                continue;
            }
            String newPath = this.baseDirectory.getPath();
            String extraPath = mappingMeta.getDirectoryPath();
            if (newPath.endsWith("/") && extraPath.startsWith("/")) {
                newPath = newPath.substring(0, newPath.length() - 1);
            } else if (!newPath.endsWith("/") && !extraPath.startsWith("/")) {
                newPath = newPath + "/";
            } else if (extraPath.equals("/")) {
                extraPath = "";
            }
            mappingMeta.setDirectoryPath(newPath + extraPath);
        }
    }

    private void patchJobEntries(JobMeta jobMeta) {
        for (JobEntryCopy copy : jobMeta.getJobCopies()) {
            String extraPath;
            String newPath;
            JobEntryBase entry;
            if (copy.isTransformation() && ((JobEntryTrans)(entry = (JobEntryTrans)copy.getEntry())).getSpecificationMethod() == ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) {
                if (this.transDirOverride != null) {
                    ((JobEntryTrans)entry).setDirectory(this.transDirOverride);
                    continue;
                }
                newPath = this.baseDirectory.getPath();
                extraPath = Const.NVL((String)((JobEntryTrans)entry).getDirectory(), (String)"/");
                if (newPath.endsWith("/") && extraPath.startsWith("/")) {
                    newPath = newPath.substring(0, newPath.length() - 1);
                } else if (!newPath.endsWith("/") && !extraPath.startsWith("/")) {
                    newPath = newPath + "/";
                } else if (extraPath.equals("/")) {
                    extraPath = "";
                }
                ((JobEntryTrans)entry).setDirectory(newPath + extraPath);
            }
            if (!copy.isJob() || ((JobEntryJob)(entry = (JobEntryJob)copy.getEntry())).getSpecificationMethod() != ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) continue;
            if (this.jobDirOverride != null) {
                ((JobEntryJob)entry).setDirectory(this.jobDirOverride);
                continue;
            }
            newPath = this.baseDirectory.getPath();
            extraPath = Const.NVL((String)((JobEntryJob)entry).getDirectory(), (String)"/");
            if (newPath.endsWith("/") && extraPath.startsWith("/")) {
                newPath = newPath.substring(0, newPath.length() - 1);
            } else if (!newPath.endsWith("/") && !extraPath.startsWith("/")) {
                newPath = newPath + "/";
            } else if (extraPath.equals("/")) {
                extraPath = "";
            }
            ((JobEntryJob)entry).setDirectory(newPath + extraPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean importTransformation(Node transnode, RepositoryImportFeedbackInterface feedback) throws KettleException {
        TransMeta transMeta = new TransMeta(transnode, null);
        this.replaceSharedObjects(transMeta);
        feedback.setLabel(BaseMessages.getString(PKG, (String)"RepositoryImporter.ImportTrans.Label", (String[])new String[]{Integer.toString(this.transformationNumber), transMeta.getName()}));
        RepositoryImporter.validateImportedElement(this.importRules, transMeta);
        String directoryPath = XMLHandler.getTagValue((Node)transnode, (String)"info", (String)"directory");
        if (this.transDirOverride != null) {
            directoryPath = this.transDirOverride;
        }
        if (directoryPath.startsWith("/")) {
            directoryPath = directoryPath.substring(1);
        }
        if (this.limitDirs.size() > 0 && Const.indexOfString((String)directoryPath, this.limitDirs) < 0) {
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.SkippedTransformationNotPartOfLimitingDirectories.Log", (String[])new String[]{transMeta.getName()}));
            return true;
        }
        RepositoryDirectoryInterface targetDirectory = this.getTargetDirectory(directoryPath, this.transDirOverride, feedback);
        ObjectId existingId = this.rep.getTransformationID(transMeta.getName(), targetDirectory);
        if (existingId != null && this.askOverwrite) {
            this.overwrite = feedback.transOverwritePrompt(transMeta);
            this.askOverwrite = feedback.isAskingOverwriteConfirmation();
        } else {
            this.updateDisplay();
        }
        if (existingId == null || this.overwrite) {
            transMeta.setObjectId(existingId);
            transMeta.setRepositoryDirectory(targetDirectory);
            this.patchMappingSteps(transMeta);
            try {
                if (transMeta.getCreatedUser() == null || transMeta.getCreatedUser().equals("-")) {
                    transMeta.setCreatedDate(new Date());
                    if (this.rep.getUserInfo() != null) {
                        transMeta.setCreatedUser(this.rep.getUserInfo().getLogin());
                    } else {
                        transMeta.setCreatedUser(null);
                    }
                }
                this.rep.save(transMeta, this.versionComment, this, this.overwrite);
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.TransSaved.Log", (String[])new String[]{Integer.toString(this.transformationNumber), transMeta.getName()}));
                if (!transMeta.hasRepositoryReferences()) return true;
                this.referencingObjects.add(new RepositoryObject(transMeta.getObjectId(), transMeta.getName(), transMeta.getRepositoryDirectory(), null, null, RepositoryObjectType.TRANSFORMATION, null, false));
                return true;
            }
            catch (Exception e) {
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorSavingTrans.Log", (String[])new String[]{Integer.toString(this.transformationNumber), transMeta.getName(), Const.getStackTracker((Throwable)e)}));
                if (feedback.askContinueOnErrorQuestion(BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Message", (String[])new String[0]))) return true;
                return false;
            }
        } else {
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.SkippedExistingTransformation.Log", (String[])new String[]{transMeta.getName()}));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean importJob(Node jobnode, RepositoryImportFeedbackInterface feedback) throws KettleException {
        JobMeta jobMeta = new JobMeta(jobnode, this.rep, false, (OverwritePrompter)SpoonFactory.getInstance());
        this.replaceSharedObjects(jobMeta);
        feedback.setLabel(BaseMessages.getString(PKG, (String)"RepositoryImporter.ImportJob.Label", (String[])new String[]{Integer.toString(this.jobNumber), jobMeta.getName()}));
        RepositoryImporter.validateImportedElement(this.importRules, jobMeta);
        String directoryPath = Const.NVL((String)XMLHandler.getTagValue((Node)jobnode, (String)"directory"), (String)Const.FILE_SEPARATOR);
        if (this.jobDirOverride != null) {
            directoryPath = this.jobDirOverride;
        }
        if (directoryPath.startsWith("/")) {
            directoryPath = directoryPath.substring(1);
        }
        if (this.limitDirs.size() > 0 && Const.indexOfString((String)directoryPath, this.limitDirs) < 0) {
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.SkippedJobNotPartOfLimitingDirectories.Log", (String[])new String[]{jobMeta.getName()}));
            return true;
        }
        RepositoryDirectoryInterface targetDirectory = this.getTargetDirectory(directoryPath, this.jobDirOverride, feedback);
        ObjectId existintId = this.rep.getJobId(jobMeta.getName(), targetDirectory);
        if (existintId != null && this.askOverwrite) {
            this.overwrite = feedback.jobOverwritePrompt(jobMeta);
            this.askOverwrite = feedback.isAskingOverwriteConfirmation();
        } else {
            this.updateDisplay();
        }
        if (existintId == null || this.overwrite) {
            jobMeta.setRepositoryDirectory(targetDirectory);
            jobMeta.setObjectId(existintId);
            this.patchJobEntries(jobMeta);
            try {
                if (jobMeta.getCreatedUser() == null || jobMeta.getCreatedUser().equals("-")) {
                    jobMeta.setCreatedDate(new Date());
                    if (this.rep.getUserInfo() != null) {
                        jobMeta.setCreatedUser(this.rep.getUserInfo().getLogin());
                    } else {
                        jobMeta.setCreatedUser(null);
                    }
                }
                this.rep.save(jobMeta, this.versionComment, null, this.overwrite);
                if (jobMeta.hasRepositoryReferences()) {
                    this.referencingObjects.add(new RepositoryObject(jobMeta.getObjectId(), jobMeta.getName(), jobMeta.getRepositoryDirectory(), null, null, RepositoryObjectType.JOB, null, false));
                }
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.JobSaved.Log", (String[])new String[]{Integer.toString(this.jobNumber), jobMeta.getName()}));
                return true;
            }
            catch (Exception e) {
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorSavingJob.Log", (String[])new String[]{Integer.toString(this.jobNumber), jobMeta.getName(), Const.getStackTracker((Throwable)e)}));
                if (feedback.askContinueOnErrorQuestion(BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Message", (String[])new String[0]))) return true;
                return false;
            }
        } else {
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.SkippedExistingJob.Log", (String[])new String[]{jobMeta.getName()}));
        }
        return true;
    }

    @Override
    public boolean transformationElementRead(String xml, RepositoryImportFeedbackInterface feedback) {
        block3: {
            try {
                Document doc = XMLHandler.loadXMLString((String)xml);
                Node transformationNode = XMLHandler.getSubNode((Node)doc, (String)"transformation");
                if (!this.importTransformation(transformationNode, feedback)) {
                    return false;
                }
                ++this.transformationNumber;
            }
            catch (Exception e) {
                feedback.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.UnexpectedErrorDuringTransformationImport.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.UnexpectedErrorDuringTransformationImport.Message", (String[])new String[0]), e);
                if (feedback.askContinueOnErrorQuestion(BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Message", (String[])new String[0]))) break block3;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean jobElementRead(String xml, RepositoryImportFeedbackInterface feedback) {
        block3: {
            try {
                Document doc = XMLHandler.loadXMLString((String)xml);
                Node jobNode = XMLHandler.getSubNode((Node)doc, (String)"job");
                if (!this.importJob(jobNode, feedback)) {
                    return false;
                }
                ++this.jobNumber;
            }
            catch (Exception e) {
                this.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.UnexpectedErrorDuringJobImport.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.UnexpectedErrorDuringJobImport.Message", (String[])new String[0]), e);
                if (feedback.askContinueOnErrorQuestion(BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Message", (String[])new String[0]))) break block3;
                return false;
            }
        }
        return true;
    }

    private RepositoryDirectoryInterface getTargetDirectory(String directoryPath, String dirOverride, RepositoryImportFeedbackInterface feedback) throws KettleException {
        RepositoryDirectoryInterface targetDirectory = null;
        if (dirOverride != null) {
            targetDirectory = this.rep.findDirectory(directoryPath);
            if (targetDirectory == null) {
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.CreateDir.Log", (String[])new String[]{directoryPath, this.getRepositoryRoot().toString()}));
                targetDirectory = this.rep.createRepositoryDirectory(this.getRepositoryRoot(), directoryPath);
            }
        } else {
            targetDirectory = this.baseDirectory.findDirectory(directoryPath);
            if (targetDirectory == null) {
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.CreateDir.Log", (String[])new String[]{directoryPath, this.baseDirectory.toString()}));
                targetDirectory = this.rep.createRepositoryDirectory(this.baseDirectory, directoryPath);
            }
        }
        return targetDirectory;
    }

    private RepositoryDirectoryInterface getRepositoryRoot() throws KettleException {
        if (this.root == null) {
            this.root = this.rep.loadRepositoryDirectoryTree();
        }
        return this.root;
    }

    @Override
    public void fatalXmlErrorEncountered(SAXParseException e) {
        this.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorInvalidXML.Message", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorInvalidXML.Title", (String[])new String[0]), e);
    }

    @Override
    public boolean askContinueOnErrorQuestion(String title, String message) {
        return this.continueOnError;
    }

    public void beginTask(String message, int nrWorks) {
        this.addLog(message);
    }

    public void done() {
    }

    public boolean isCanceled() {
        return false;
    }

    public void setTaskName(String taskName) {
        this.addLog(taskName);
    }

    public void subTask(String message) {
        this.addLog(message);
    }

    public void worked(int nrWorks) {
    }

    public String getTransDirOverride() {
        return this.transDirOverride;
    }

    @Override
    public void setTransDirOverride(String transDirOverride) {
        this.transDirOverride = transDirOverride;
    }

    public String getJobDirOverride() {
        return this.jobDirOverride;
    }

    @Override
    public void setJobDirOverride(String jobDirOverride) {
        this.jobDirOverride = jobDirOverride;
    }

    @Override
    public void setImportRules(ImportRules importRules) {
        this.importRules = importRules;
    }

    public ImportRules getImportRules() {
        return this.importRules;
    }

    @Override
    public boolean isAskingOverwriteConfirmation() {
        return this.askOverwrite;
    }

    private void addException(Exception exception) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<Exception>();
        }
        this.exceptions.add(exception);
    }

    @Override
    public List<Exception> getExceptions() {
        return this.exceptions;
    }
}

