/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;

public class KettleDatabaseRepositoryCreationHelper {
    private KettleDatabaseRepository repository;
    private LogChannelInterface log;
    private DatabaseMeta databaseMeta;
    private Database database;
    private PluginRegistry pluginRegistry;

    public KettleDatabaseRepositoryCreationHelper(KettleDatabaseRepository repository) {
        this.repository = repository;
        this.databaseMeta = this.repository.getDatabaseMeta();
        this.database = this.repository.getDatabase();
        this.log = repository.getLog();
        this.pluginRegistry = PluginRegistry.getInstance();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void createRepositorySchema(ProgressMonitorListener monitor, boolean upgrade, List<String> statements, boolean dryrun) throws KettleException {
        block475: {
            block472: {
                block471: {
                    block470: {
                        block469: {
                            block468: {
                                KEY = 9;
                                this.log.logBasic("Starting to create or modify the repository tables...");
                                message = (upgrade != false ? "Upgrading " : "Creating") + " the Kettle repository...";
                                if (monitor != null) {
                                    monitor.beginTask(message, 31);
                                }
                                this.repository.connectionDelegate.setAutoCommit(true);
                                table = new RowMeta();
                                tablename = "R_REPOSITORY_LOG";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_REPOSITORY_LOG", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("REP_VERSION", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("LOG_DATE", 3));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("LOG_USER", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("OPERATION_DESC", 2, 2000000, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_REPOSITORY_LOG", false);
                                if (!Const.isEmpty((String)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        try {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                            }
                                            this.database.execStatements(sql);
                                            if (!this.log.isDetailed()) ** GOTO lbl35
                                            this.log.logDetailed("Created/altered table " + schemaTable);
                                        }
                                        catch (KettleException dbe) {
                                            throw new KettleException("Unable to create or modify table " + schemaTable, (Throwable)dbe);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
lbl35:
                                // 6 sources

                                if (!dryrun) {
                                    this.repository.insertLogEntry((upgrade != false ? "Upgrade" : "Creation") + " of the Kettle repository");
                                }
                                table = new RowMeta();
                                tablename = "R_VERSION";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_VERSION", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("MAJOR_VERSION", 5, 3, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("MINOR_VERSION", 5, 3, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("UPGRADE_DATE", 3, 0, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("IS_UPGRADE", 4, 1, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_VERSION", false);
                                create = false;
                                if (!Const.isEmpty((String)sql)) {
                                    create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                                    statements.add(sql);
                                    if (!dryrun) {
                                        try {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                            }
                                            this.database.execStatements(sql);
                                            if (!this.log.isDetailed()) ** GOTO lbl68
                                            this.log.logDetailed("Created/altered table " + schemaTable);
                                        }
                                        catch (KettleException dbe) {
                                            throw new KettleException("Unable to create or modify table " + schemaTable, (Throwable)dbe);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
lbl68:
                                // 6 sources

                                try {
                                    nextId = sql.toUpperCase().indexOf("CREATE TABLE") < 0 ? this.repository.connectionDelegate.getNextID(schemaTable, "ID_VERSION") : new LongObjectId(1L);
                                    data = new Object[]{nextId.longValue(), 5L, 0L, new Date(), upgrade};
                                    if (dryrun) {
                                        sql = this.database.getSQLOutput(null, "R_VERSION", (RowMetaInterface)table, data, null);
                                        statements.add(sql);
                                    } else {
                                        this.database.execStatement("INSERT INTO " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_VERSION") + " VALUES(?, ?, ?, ?, ?)", (RowMetaInterface)table, data);
                                    }
                                }
                                catch (KettleException e) {
                                    throw new KettleException("Unable to insert new version log record into " + schemaTable, (Throwable)e);
                                }
                                ok_database_type = true;
                                table = new RowMeta();
                                tablename = "R_DATABASE_TYPE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_TYPE", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE_TYPE", false);
                                create = false;
                                if (!Const.isEmpty((String)sql)) {
                                    create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                                    statements.add(sql);
                                    if (!dryrun) {
                                        try {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                            }
                                            this.database.execStatements(sql);
                                            if (!this.log.isDetailed()) ** GOTO lbl110
                                            this.log.logDetailed("Created/altered table " + schemaTable);
                                        }
                                        catch (KettleException dbe) {
                                            throw new KettleException("Unable to create or modify table " + schemaTable, (Throwable)dbe);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
lbl110:
                                // 6 sources

                                if (ok_database_type) {
                                    this.updateDatabaseTypes(statements, dryrun, create);
                                }
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                ok_database_contype = true;
                                table = new RowMeta();
                                tablename = "R_DATABASE_CONTYPE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_CONTYPE", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE_CONTYPE", false);
                                if (!Const.isEmpty((String)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created or altered table " + schemaTable);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
                                if (ok_database_contype = sql.toUpperCase().contains("CREATE TABLE")) {
                                    code = DatabaseMeta.dbAccessTypeCode;
                                    desc = DatabaseMeta.dbAccessTypeDesc;
                                    if (!dryrun) {
                                        this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                                    }
                                    for (i = 0; i < code.length; ++i) {
                                        lookup = null;
                                        if (upgrade) {
                                            lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_DATABASE_CONTYPE") + " FROM " + schemaTable + " WHERE " + this.repository.quote("CODE") + " = '" + code[i] + "'");
                                        }
                                        if (lookup != null) continue;
                                        nextid = new LongObjectId((long)(i + 1));
                                        if (!create) {
                                            nextid = this.repository.connectionDelegate.getNextDatabaseConnectionTypeID();
                                        }
                                        tableData = new Object[]{new LongObjectId((ObjectId)nextid).longValue(), code[i], desc[i]};
                                        if (dryrun) {
                                            sql = this.database.getSQLOutput(null, tablename, (RowMetaInterface)table, tableData, null);
                                            statements.add(sql);
                                            continue;
                                        }
                                        this.database.setValuesInsert((RowMetaInterface)table, tableData);
                                        this.database.insertRow();
                                    }
                                    try {
                                        if (!dryrun) {
                                            this.database.closeInsert();
                                        }
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Populated table " + schemaTable);
                                        }
                                    }
                                    catch (KettleException dbe) {
                                        throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                                    }
                                }
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                table = new RowMeta();
                                tablename = "R_NOTE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_NOTE", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_X", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_Y", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_WIDTH", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_HEIGHT", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_NAME", 2, 2000000, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_SIZE", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_BOLD", 4, 1, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_ITALIC", 4, 1, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_COLOR_RED", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_COLOR_GREEN", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_COLOR_BLUE", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_BACK_GROUND_COLOR_RED", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_BACK_GROUND_COLOR_GREEN", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_BACK_GROUND_COLOR_BLUE", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_BORDER_COLOR_RED", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_BORDER_COLOR_GREEN", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("FONT_BORDER_COLOR_BLUE", 5, 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("DRAW_SHADOW", 4, 1, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_NOTE", false);
                                if (!Const.isEmpty((String)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created or altered table " + schemaTable);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                table = new RowMeta();
                                tablename = "R_DATABASE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_TYPE", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_CONTYPE", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("HOST_NAME", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("DATABASE_NAME", 2, 2000000, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("PORT", 5, 7, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("USERNAME", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("PASSWORD", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("SERVERNAME", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("DATA_TBS", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("INDEX_TBS", 2, 255, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE", false);
                                if (!Const.isEmpty((String)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created or altered table " + schemaTable);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                table = new RowMeta();
                                tablename = "R_DATABASE_ATTRIBUTE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_ATTRIBUTE", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5, KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE_ATTRIBUTE", false);
                                if (!Const.isEmpty((String)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created or altered table " + schemaTable);
                                        }
                                    }
                                    try {
                                        indexname = "IDX_" + schemaTable.replace(this.databaseMeta.getStartQuote(), "").replace(this.databaseMeta.getEndQuote(), "") + "_AK";
                                        keyfield = new String[]{"ID_DATABASE", "CODE"};
                                        if (this.database.checkIndexExists(schemaTable, keyfield)) break block468;
                                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                        statements.add(sql);
                                        if (!dryrun) {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                            }
                                            this.database.execStatements(sql);
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                                            }
                                        }
                                    }
                                    catch (KettleException kdbe) {}
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
                            }
                            if (monitor != null) {
                                monitor.worked(1);
                            }
                            table = new RowMeta();
                            tablename = "R_DIRECTORY";
                            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                            if (monitor != null) {
                                monitor.subTask("Checking table " + schemaTable);
                            }
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DIRECTORY_PARENT", 5, KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMeta("DIRECTORY_NAME", 2, 255, 0));
                            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DIRECTORY", false);
                            if (!Const.isEmpty((String)sql)) {
                                statements.add(sql);
                                if (!dryrun) {
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                    }
                                    this.database.execStatements(sql);
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("Created or altered table " + schemaTable);
                                    }
                                }
                                try {
                                    indexname = "IDX_" + schemaTable.replace(this.databaseMeta.getStartQuote(), "").replace(this.databaseMeta.getEndQuote(), "") + "_AK";
                                    keyfield = new String[]{"ID_DIRECTORY_PARENT", "DIRECTORY_NAME"};
                                    if (this.database.checkIndexExists(schemaTable, keyfield)) break block469;
                                    sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                                        }
                                    }
                                }
                                catch (KettleException kdbe) {}
                            } else if (this.log.isDetailed()) {
                                this.log.logDetailed("Table " + schemaTable + " is OK.");
                            }
                        }
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        table = new RowMeta();
                        tablename = "R_TRANSFORMATION";
                        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                        if (monitor != null) {
                            monitor.subTask("Checking table " + schemaTable);
                        }
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("EXTENDED_DESCRIPTION", 2, 2000000, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("TRANS_VERSION", 2, 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("TRANS_STATUS", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_READ", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_WRITE", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_INPUT", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_OUTPUT", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_UPDATE", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_LOG", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME_LOG", 2, 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("USE_BATCHID", 4, 1, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("USE_LOGFIELD", 4, 1, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_MAXDATE", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME_MAXDATE", 2, 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("FIELD_NAME_MAXDATE", 2, 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("OFFSET_MAXDATE", 1, 12, 2));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("DIFF_MAXDATE", 1, 12, 2));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("CREATED_USER", 2, 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("CREATED_DATE", 3, 20, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("MODIFIED_USER", 2, 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("MODIFIED_DATE", 3, 20, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("SIZE_ROWSET", 5, KEY, 0));
                        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANSFORMATION", false);
                        if (!Const.isEmpty((String)sql)) {
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("Created or altered table " + schemaTable);
                                }
                            }
                        } else if (this.log.isDetailed()) {
                            this.log.logDetailed("Table " + schemaTable + " is OK.");
                        }
                        if (this.database.checkTableExists(schemaTable) && (rows = this.database.getRows(sql = "SELECT * FROM " + schemaTable + " WHERE " + this.repository.quote("ID_DIRECTORY") + " IS NULL", 1)) != null && rows.size() > 0) {
                            sql = "UPDATE " + schemaTable + " SET " + this.repository.quote("ID_DIRECTORY") + "=0 WHERE " + this.repository.quote("ID_DIRECTORY") + " IS NULL";
                            statements.add(sql);
                            if (!dryrun) {
                                this.database.execStatement(sql);
                            }
                        }
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        table = new RowMeta();
                        tablename = "R_TRANS_ATTRIBUTE";
                        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                        if (monitor != null) {
                            monitor.subTask("Checking table " + schemaTable);
                        }
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_ATTRIBUTE", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 6, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_NUM", 5, 18, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_ATTRIBUTE", false);
                        if (!Const.isEmpty((String)sql)) {
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("Created or altered table " + schemaTable);
                                }
                            }
                            try {
                                indexname = "IDX_TRANS_ATTRIBUTE_LOOKUP";
                                keyfield = new String[]{"ID_TRANSFORMATION", "CODE", "NR"};
                                if (this.database.checkIndexExists(schemaTable, keyfield)) break block470;
                                sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                statements.add(sql);
                                if (!dryrun) {
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                    }
                                    this.database.execStatements(sql);
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                                    }
                                }
                            }
                            catch (KettleException kdbe) {}
                        } else if (this.log.isDetailed()) {
                            this.log.logDetailed("Table " + schemaTable + " is OK.");
                        }
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_JOB_ATTRIBUTE";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB_ATTRIBUTE", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 6, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_NUM", 5, 18, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB_ATTRIBUTE", false);
                    if (!Const.isEmpty((String)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created or altered table " + schemaTable);
                            }
                        }
                        try {
                            indexname = "IDX_JOB_ATTRIBUTE_LOOKUP";
                            keyfield = new String[]{"ID_JOB", "CODE", "NR"};
                            if (this.database.checkIndexExists(schemaTable, keyfield)) break block471;
                            sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                                }
                            }
                        }
                        catch (KettleException kdbe) {}
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed("Table " + schemaTable + " is OK.");
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_DEPENDENCY";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DEPENDENCY", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("FIELD_NAME", 2, 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DEPENDENCY", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_PARTITION_SCHEMA";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PARTITION_SCHEMA", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("DYNAMIC_DEFINITION", 4, 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("PARTITIONS_PER_SLAVE", 2, 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_PARTITION_SCHEMA", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_PARTITION";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PARTITION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PARTITION_SCHEMA", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("PARTITION_ID", 2, 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_PARTITION", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_PARTITION_SCHEMA";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_PARTITION_SCHEMA", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_PARTITION_SCHEMA", 5, KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_PARTITION_SCHEMA", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_CLUSTER";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CLUSTER", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("BASE_PORT", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("SOCKETS_BUFFER_SIZE", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("SOCKETS_FLUSH_INTERVAL", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("SOCKETS_COMPRESSED", 4, 0, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("DYNAMIC_CLUSTER", 4, 0, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_CLUSTER", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_SLAVE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_SLAVE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("HOST_NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("PORT", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("WEB_APP_NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("USERNAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("PASSWORD", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("PROXY_HOST_NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("PROXY_PORT", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NON_PROXY_HOSTS", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("MASTER", 4));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_SLAVE", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_CLUSTER_SLAVE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CLUSTER_SLAVE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CLUSTER", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_SLAVE", 5, KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_CLUSTER_SLAVE", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_SLAVE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_SLAVE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_SLAVE", 5, KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_SLAVE", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_CLUSTER";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_CLUSTER", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CLUSTER", 5, KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_CLUSTER", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_HOP";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_HOP", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_FROM", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_TO", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ENABLED", 4, 1, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_HOP", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_STEP_CONDITION";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CONDITION", 5, KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_CONDITION";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CONDITION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_CONDITION_PARENT", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NEGATED", 4, 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("OPERATOR", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("LEFT_NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("CONDITION_FUNCTION", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("RIGHT_NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_VALUE_RIGHT", 5, KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_CONDITION", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                tablename = "R_VALUE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table = new RowMeta();
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_VALUE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_TYPE", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("IS_NULL", 4, 1, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_VALUE", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                ok_step_type = true;
                table = new RowMeta();
                tablename = "R_STEP_TYPE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_TYPE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("HELPTEXT", 2, 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_STEP_TYPE", false);
                create = false;
                if (!Const.isEmpty((String)sql)) {
                    create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (ok_step_type) {
                    this.updateStepTypes(statements, dryrun, create);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Populated table " + schemaTable);
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_STEP";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_TYPE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("DISTRIBUTE", 4, 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("COPIES", 5, 3, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_X", 5, 6, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_Y", 5, 6, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_DRAW", 4, 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("COPIES_STRING", 2, 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_STEP", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                tablename = "R_STEP_ATTRIBUTE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table = new RowMeta();
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP_ATTRIBUTE", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP", 5, KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 6, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_NUM", 5, 18, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_STEP_ATTRIBUTE", false);
                if (!Const.isEmpty((String)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                    try {
                        indexname = "IDX_" + schemaTable.replace(this.databaseMeta.getStartQuote(), "").replace(this.databaseMeta.getEndQuote(), "") + "_LOOKUP";
                        keyfield = new String[]{"ID_STEP", "CODE", "NR"};
                        if (this.database.checkIndexExists(schemaTable, keyfield)) break block472;
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                    catch (KettleException kdbe) {}
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            tablename = "R_STEP_DATABASE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table = new RowMeta();
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_STEP", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5, KEY, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
                try {
                    indexname = "IDX_" + schemaTable.replace(this.databaseMeta.getStartQuote(), "").replace(this.databaseMeta.getEndQuote(), "") + "_LU1";
                    keyfield = new String[]{"ID_TRANSFORMATION"};
                    if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                }
                catch (KettleException kdbe) {
                    // empty catch block
                }
                try {
                    indexname = "IDX_" + schemaTable.replace(this.databaseMeta.getStartQuote(), "").replace(this.databaseMeta.getEndQuote(), "") + "_LU2";
                    keyfield = new String[]{"ID_DATABASE"};
                    if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                }
                catch (KettleException kdbe) {}
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_TRANS_NOTE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_NOTE", 5, KEY, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ok_loglevel = true;
            tablename = "R_LOGLEVEL";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table = new RowMeta();
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_LOGLEVEL", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_LOGLEVEL", false);
            create = false;
            if (!Const.isEmpty((String)sql)) {
                create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (ok_loglevel) {
                code = LogLevel.logLogLevelCodes();
                desc = LogLevel.getLogLevelDescriptions();
                if (!dryrun) {
                    this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                }
                for (i = 1; i < code.length; ++i) {
                    lookup = null;
                    if (upgrade) {
                        lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_LOGLEVEL") + " FROM " + schemaTable + " WHERE " + this.database.getDatabaseMeta().quoteField("CODE") + " = '" + code[i] + "'");
                    }
                    if (lookup != null) continue;
                    nextid = new LongObjectId((long)i);
                    if (!create) {
                        nextid = this.repository.connectionDelegate.getNextLoglevelID();
                    }
                    tableData = new RowMetaAndData();
                    tableData.addValue((ValueMetaInterface)new ValueMeta("ID_LOGLEVEL", 5), (Object)nextid);
                    tableData.addValue((ValueMetaInterface)new ValueMeta("CODE", 2), (Object)code[i]);
                    tableData.addValue((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2), (Object)desc[i]);
                    if (dryrun) {
                        sql = this.database.getSQLOutput(null, tablename, tableData.getRowMeta(), tableData.getData(), null);
                        statements.add(sql);
                        continue;
                    }
                    this.database.setValuesInsert(tableData.getRowMeta(), tableData.getData());
                    this.database.insertRow();
                }
                try {
                    if (!dryrun) {
                        this.database.closeInsert();
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Populated table " + schemaTable);
                    }
                }
                catch (KettleException dbe) {
                    throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_LOG";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_LOG", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_LOGLEVEL", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("LOGTYPE", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("FILENAME", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("FILEEXTENTION", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ADD_DATE", 4, 1, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ADD_TIME", 4, 1, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_LOG", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME_LOG", 2, 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_LOG", false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOB";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DIRECTORY", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("EXTENDED_DESCRIPTION", 2, 2000000, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("JOB_VERSION", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("JOB_STATUS", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_LOG", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME_LOG", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("CREATED_USER", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("CREATED_DATE", 3, 20, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("MODIFIED_USER", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("MODIFIED_DATE", 3, 20, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("USE_BATCH_ID", 4, 0, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("PASS_BATCH_ID", 4, 0, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("USE_LOGFIELD", 4, 0, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("SHARED_FILE", 2, 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB", false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOBENTRY_DATABASE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE", 5, KEY, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB", false);
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
                try {
                    indexname = "IDX_" + schemaTable.replace(this.databaseMeta.getStartQuote(), "").replace(this.databaseMeta.getEndQuote(), "") + "_LU1";
                    keyfield = new String[]{"ID_JOB"};
                    if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                }
                catch (KettleException kdbe) {
                    // empty catch block
                }
                try {
                    indexname = "IDX_" + schemaTable.replace(this.databaseMeta.getStartQuote(), "").replace(this.databaseMeta.getEndQuote(), "") + "_LU2";
                    keyfield = new String[]{"ID_DATABASE"};
                    if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                }
                catch (KettleException kdbe) {}
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ok_jobentry_type = true;
            table = new RowMeta();
            tablename = "R_JOBENTRY_TYPE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_TYPE", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY_TYPE", false);
            create = false;
            if (!Const.isEmpty((String)sql)) {
                create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (ok_jobentry_type) {
                this.updateJobEntryTypes(statements, dryrun, create);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Populated table " + schemaTable);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOBENTRY";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_TYPE", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY", false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOBENTRY_COPY";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_COPY", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_TYPE", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 4, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_X", 5, 6, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_LOCATION_Y", 5, 6, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("GUI_DRAW", 4, 1, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("PARALLEL", 4, 1, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY_COPY", false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOBENTRY_ATTRIBUTE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_ATTRIBUTE", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY", 5, KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("NR", 5, 6, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_NUM", 1, 13, 2));
            table.addValueMeta((ValueMetaInterface)new ValueMeta("VALUE_STR", 2, 2000000, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY_ATTRIBUTE", false);
            if (!Const.isEmpty((String)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
                try {
                    indexname = "IDX_" + schemaTable.replace(this.databaseMeta.getStartQuote(), "").replace(this.databaseMeta.getEndQuote(), "") + "_LOOKUP";
                    keyfield = new String[]{"ID_JOBENTRY_ATTRIBUTE", "CODE", "NR"};
                    if (this.database.checkIndexExists(schemaTable, keyfield)) break block475;
                    sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                        }
                    }
                }
                catch (KettleException kdbe) {}
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_JOB_HOP";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB_HOP", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_COPY_FROM", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_COPY_TO", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ENABLED", 4, 1, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("EVALUATION", 4, 1, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("UNCONDITIONAL", 4, 1, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB_HOP", false);
        if (!Const.isEmpty((String)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_JOB_NOTE";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_NOTE", 5, KEY, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
        if (!Const.isEmpty((String)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_TRANS_LOCK";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANS_LOCK", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_USER", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("LOCK_MESSAGE", 2, 2000000, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("LOCK_DATE", 3, 0, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_LOCK", false);
        if (!Const.isEmpty((String)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_JOB_LOCK";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB_LOCK", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_JOB", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_USER", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("LOCK_MESSAGE", 2, 2000000, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("LOCK_DATE", 3, 0, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB_LOCK", false);
        if (!Const.isEmpty((String)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_NAMESPACE";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_NAMESPACE", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 2000000, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_NAMESPACE", false);
        if (!Const.isEmpty((String)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_ELEMENT_TYPE";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_ELEMENT_TYPE", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_NAMESPACE", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 2000000, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_ELEMENT_TYPE", false);
        if (!Const.isEmpty((String)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_ELEMENT";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_ELEMENT", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_ELEMENT_TYPE", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 2000000, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_ELEMENT", false);
        if (!Const.isEmpty((String)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_ELEMENT_ATTRIBUTE";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_ELEMENT_ATTRIBUTE", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_ELEMENT", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_ELEMENT_ATTRIBUTE_PARENT", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ATTR_KEY", 2, 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ATTR_VALUE", 2, 2000000, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_ELEMENT_ATTRIBUTE", false);
        if (!Const.isEmpty((String)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        users = new Hashtable<String, LongObjectId>();
        ok_user = true;
        table = new RowMeta();
        tablename = "R_USER";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ID_USER", 5, KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("LOGIN", 2, 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("PASSWORD", 2, 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2, 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMeta("ENABLED", 4, 1, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_USER", false);
        create = false;
        if (!Const.isEmpty((String)sql)) {
            create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (ok_user) {
            user = new String[]{"admin", "guest"};
            pass = new String[]{"admin", "guest"};
            code = new String[]{"Administrator", "Guest account"};
            desc = new String[]{"User manager", "Read-only guest account"};
            if (!dryrun) {
                this.database.prepareInsert((RowMetaInterface)table, null, tablename);
            }
            for (i = 0; i < user.length; ++i) {
                lookup = null;
                if (upgrade) {
                    lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_USER") + " FROM " + schemaTable + " WHERE " + this.repository.quote("LOGIN") + " = '" + user[i] + "'");
                }
                if (lookup != null) continue;
                nextid = new LongObjectId((long)(i + 1));
                if (!create) {
                    nextid = this.repository.connectionDelegate.getNextUserID();
                }
                password = Encr.encryptPassword((String)pass[i]);
                tableData = new RowMetaAndData();
                tableData.addValue((ValueMetaInterface)new ValueMeta("ID_USER", 5), (Object)nextid);
                tableData.addValue((ValueMetaInterface)new ValueMeta("LOGIN", 2), (Object)user[i]);
                tableData.addValue((ValueMetaInterface)new ValueMeta("PASSWORD", 2), (Object)password);
                tableData.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)code[i]);
                tableData.addValue((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2), (Object)desc[i]);
                tableData.addValue((ValueMetaInterface)new ValueMeta("ENABLED", 4), (Object)Boolean.TRUE);
                if (dryrun) {
                    sql = this.database.getSQLOutput(null, tablename, tableData.getRowMeta(), tableData.getData(), null);
                    statements.add(sql);
                } else {
                    this.database.setValuesInsert(tableData);
                    this.database.insertRow();
                }
                users.put(user[i], nextid);
            }
            try {
                if (!dryrun) {
                    this.database.closeInsert();
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Populated table " + schemaTable);
                }
            }
            catch (KettleException dbe) {
                throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        this.log.logBasic((upgrade != false ? "Upgraded" : "Created") + " " + KettleDatabaseRepository.repositoryTableNames.length + " repository tables.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateStepTypes(List<String> statements, boolean dryrun, boolean create) throws KettleException {
        KettleDatabaseRepository kettleDatabaseRepository = this.repository;
        synchronized (kettleDatabaseRepository) {
            List plugins = this.pluginRegistry.getPlugins(StepPluginType.class);
            for (int i = 0; i < plugins.size(); ++i) {
                PluginInterface sp = (PluginInterface)plugins.get(i);
                ObjectId id = null;
                if (!create) {
                    id = this.repository.stepDelegate.getStepTypeID(sp.getIds()[0]);
                }
                if (id != null) continue;
                id = new LongObjectId((long)(i + 1));
                if (!create) {
                    id = this.repository.connectionDelegate.getNextStepTypeID();
                }
                RowMetaAndData table = new RowMetaAndData();
                table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP_TYPE", 5), (Object)id);
                table.addValue((ValueMetaInterface)new ValueMeta("CODE", 2), (Object)sp.getIds()[0]);
                table.addValue((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2), (Object)sp.getName());
                table.addValue((ValueMetaInterface)new ValueMeta("HELPTEXT", 2), (Object)sp.getDescription());
                if (dryrun) {
                    String sql = this.database.getSQLOutput(null, "R_STEP_TYPE", table.getRowMeta(), table.getData(), null);
                    statements.add(sql);
                    continue;
                }
                this.database.prepareInsert(table.getRowMeta(), null, "R_STEP_TYPE");
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.database.closeInsert();
            }
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateDatabaseTypes(List<String> statements, boolean dryrun, boolean create) throws KettleException {
        KettleDatabaseRepository kettleDatabaseRepository = this.repository;
        synchronized (kettleDatabaseRepository) {
            List plugins = this.pluginRegistry.getPlugins(DatabasePluginType.class);
            for (int i = 0; i < plugins.size(); ++i) {
                PluginInterface plugin = (PluginInterface)plugins.get(i);
                ObjectId id = null;
                if (!create) {
                    id = this.repository.databaseDelegate.getDatabaseTypeID(plugin.getIds()[0]);
                }
                if (id != null) continue;
                id = new LongObjectId((long)(i + 1));
                if (!create) {
                    id = this.repository.connectionDelegate.getNextDatabaseTypeID();
                }
                RowMetaAndData table = new RowMetaAndData();
                table.addValue((ValueMetaInterface)new ValueMeta("ID_DATABASE_TYPE", 5), (Object)id);
                table.addValue((ValueMetaInterface)new ValueMeta("CODE", 2), (Object)plugin.getIds()[0]);
                table.addValue((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2), (Object)plugin.getName());
                if (dryrun) {
                    String sql = this.database.getSQLOutput(null, "R_DATABASE_TYPE", table.getRowMeta(), table.getData(), null);
                    statements.add(sql);
                    continue;
                }
                this.database.prepareInsert(table.getRowMeta(), null, "R_DATABASE_TYPE");
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.database.closeInsert();
            }
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobEntryTypes(List<String> statements, boolean dryrun, boolean create) throws KettleException {
        KettleDatabaseRepository kettleDatabaseRepository = this.repository;
        synchronized (kettleDatabaseRepository) {
            PluginRegistry registry = PluginRegistry.getInstance();
            List jobPlugins = registry.getPlugins(JobEntryPluginType.class);
            for (int i = 0; i < jobPlugins.size(); ++i) {
                PluginInterface jobPlugin = (PluginInterface)jobPlugins.get(i);
                String type_desc = jobPlugin.getIds()[0];
                String type_desc_long = jobPlugin.getName();
                ObjectId id = null;
                if (!create) {
                    id = this.repository.jobEntryDelegate.getJobEntryTypeID(type_desc);
                }
                if (id != null) continue;
                id = new LongObjectId((long)(i + 1));
                if (!create) {
                    id = this.repository.connectionDelegate.getNextJobEntryTypeID();
                }
                RowMetaAndData table = new RowMetaAndData();
                table.addValue((ValueMetaInterface)new ValueMeta("ID_JOBENTRY_TYPE", 5), (Object)id);
                table.addValue((ValueMetaInterface)new ValueMeta("CODE", 2), (Object)type_desc);
                table.addValue((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2), (Object)type_desc_long);
                if (dryrun) {
                    String sql = this.database.getSQLOutput(null, "R_JOBENTRY_TYPE", table.getRowMeta(), table.getData(), null);
                    statements.add(sql);
                    continue;
                }
                this.database.prepareInsert(table.getRowMeta(), null, "R_JOBENTRY_TYPE");
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.database.closeInsert();
            }
        }
    }
}

