/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;
import org.pentaho.di.repository.kdr.delegates.metastore.KDBRMetaStoreAttribute;
import org.pentaho.di.repository.kdr.delegates.metastore.KDBRMetaStoreElement;
import org.pentaho.di.repository.kdr.delegates.metastore.KDBRMetaStoreElementType;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class KettleDatabaseRepositoryMetaStoreDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    public KettleDatabaseRepositoryMetaStoreDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public synchronized LongObjectId getNamespaceId(String namespace) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_NAMESPACE"), this.quote("ID_NAMESPACE"), this.quote("NAME"), namespace);
    }

    public ObjectId verifyNamespace(String namespace) throws MetaStoreException {
        try {
            LongObjectId namespaceId = this.getNamespaceId(namespace);
            if (namespaceId == null) {
                throw new MetaStoreException("Unable to find namespace with name '" + namespace + "'");
            }
            return namespaceId;
        }
        catch (KettleException e) {
            throw new MetaStoreException("Unable to get id of namespace '" + namespace + "'", (Throwable)e);
        }
    }

    public synchronized LongObjectId getElementTypeId(LongObjectId namespaceId, String elementTypeName) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_ELEMENT_TYPE"), this.quote("ID_ELEMENT_TYPE"), this.quote("NAME"), elementTypeName, new String[]{this.quote("ID_NAMESPACE")}, new ObjectId[]{namespaceId});
    }

    public synchronized LongObjectId getElementId(LongObjectId elementTypeId, String elementName) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_ELEMENT"), this.quote("ID_ELEMENT"), this.quote("NAME"), elementName, new String[]{this.quote("ID_ELEMENT_TYPE")}, new ObjectId[]{elementTypeId});
    }

    public RowMetaAndData getElementType(LongObjectId elementTypeId) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_ELEMENT_TYPE"), this.quote("ID_ELEMENT_TYPE"), (ObjectId)elementTypeId);
    }

    public RowMetaAndData getElement(LongObjectId elementId) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_ELEMENT"), this.quote("ID_ELEMENT"), (ObjectId)elementId);
    }

    public RowMetaAndData getElementAttribute(LongObjectId elementAttributeId) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_ELEMENT_ATTRIBUTE"), this.quote("ID_ELEMENT_ATTRIBUTE"), (ObjectId)elementAttributeId);
    }

    public Collection<RowMetaAndData> getNamespaces() throws KettleDatabaseException, KettleValueException {
        ArrayList<RowMetaAndData> attrs = new ArrayList<RowMetaAndData>();
        String sql = "SELECT * FROM " + this.quoteTable("R_NAMESPACE");
        List<Object[]> rows = this.repository.connectionDelegate.getRows(sql, 0);
        for (Object[] row : rows) {
            RowMetaAndData rowWithMeta = new RowMetaAndData(this.repository.connectionDelegate.getReturnRowMeta(), row);
            long id = rowWithMeta.getInteger(this.quote("ID_NAMESPACE"), 0L);
            if (id <= 0L) continue;
            attrs.add(rowWithMeta);
        }
        return attrs;
    }

    public Collection<RowMetaAndData> getElementTypes(LongObjectId namespaceId) throws KettleDatabaseException, KettleValueException {
        ArrayList<RowMetaAndData> attrs = new ArrayList<RowMetaAndData>();
        String sql = "SELECT * FROM " + this.quoteTable("R_ELEMENT_TYPE") + " WHERE " + this.quote("ID_NAMESPACE") + " = " + namespaceId.getId();
        List<Object[]> rows = this.repository.connectionDelegate.getRows(sql, 0);
        for (Object[] row : rows) {
            RowMetaAndData rowWithMeta = new RowMetaAndData(this.repository.connectionDelegate.getReturnRowMeta(), row);
            long id = rowWithMeta.getInteger(this.quote("ID_ELEMENT_TYPE"), 0L);
            if (id <= 0L) continue;
            attrs.add(rowWithMeta);
        }
        return attrs;
    }

    public Collection<RowMetaAndData> getElements(LongObjectId elementTypeId) throws KettleDatabaseException, KettleValueException {
        ArrayList<RowMetaAndData> attrs = new ArrayList<RowMetaAndData>();
        String sql = "SELECT * FROM " + this.quoteTable("R_ELEMENT") + " WHERE " + this.quote("ID_ELEMENT_TYPE") + " = " + elementTypeId.getId();
        List<Object[]> rows = this.repository.connectionDelegate.getRows(sql, 0);
        for (Object[] row : rows) {
            RowMetaAndData rowWithMeta = new RowMetaAndData(this.repository.connectionDelegate.getReturnRowMeta(), row);
            long id = rowWithMeta.getInteger(this.quote("ID_ELEMENT_TYPE"), 0L);
            if (id <= 0L) continue;
            attrs.add(rowWithMeta);
        }
        return attrs;
    }

    public Collection<RowMetaAndData> getElementAttributes(ObjectId elementId, ObjectId parentAttributeId) throws KettleDatabaseException, KettleValueException {
        ArrayList<RowMetaAndData> attrs = new ArrayList<RowMetaAndData>();
        String sql = "SELECT * FROM " + this.quoteTable("R_ELEMENT_ATTRIBUTE") + " WHERE " + this.quote("ID_ELEMENT") + " = " + elementId.getId();
        if (parentAttributeId != null) {
            sql = sql + " AND " + this.quote("ID_ELEMENT_ATTRIBUTE_PARENT") + " = " + parentAttributeId.getId();
        }
        List<Object[]> rows = this.repository.connectionDelegate.getRows(sql, 0);
        for (Object[] row : rows) {
            RowMetaAndData rowWithMeta = new RowMetaAndData(this.repository.connectionDelegate.getReturnRowMeta(), row);
            long id = rowWithMeta.getInteger(this.quote("ID_ELEMENT_ATTRIBUTE"), 0L);
            if (id <= 0L) continue;
            attrs.add(rowWithMeta);
        }
        return attrs;
    }

    public ObjectId insertNamespace(String namespace) throws KettleException {
        LongObjectId idNamespace = this.repository.connectionDelegate.getNextID(this.quoteTable("R_NAMESPACE"), this.quote("ID_NAMESPACE"));
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_NAMESPACE", 5), (Object)idNamespace);
        table.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)namespace);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_NAMESPACE");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        if (this.log.isDebug()) {
            this.log.logDebug("Saved namespace [" + namespace + "]");
        }
        return idNamespace;
    }

    public ObjectId insertElementType(KDBRMetaStoreElementType type) throws KettleException {
        LongObjectId idType = this.repository.connectionDelegate.getNextID(this.quoteTable("R_ELEMENT_TYPE"), this.quote("ID_ELEMENT_TYPE"));
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_ELEMENT_TYPE", 5), (Object)idType);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_NAMESPACE", 5), (Object)type.getNamespaceId());
        table.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)type.getName());
        table.addValue((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2), (Object)type.getDescription());
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_ELEMENT_TYPE");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        type.setId(new LongObjectId((ObjectId)idType));
        if (this.log.isDebug()) {
            this.log.logDebug("Saved element type [" + type.getName() + "]");
        }
        return idType;
    }

    public ObjectId updateElementType(ObjectId namespaceId, ObjectId elementTypeId, IMetaStoreElementType type) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_ELEMENT_TYPE", 5), (Object)elementTypeId);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_NAMESPACE", 5), (Object)namespaceId);
        table.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)type.getName());
        table.addValue((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2), (Object)type.getDescription());
        this.repository.connectionDelegate.updateTableRow("R_ELEMENT_TYPE", "ID_ELEMENT_TYPE", table);
        if (this.log.isDebug()) {
            this.log.logDebug("Updated element type [" + type.getName() + "]");
        }
        return elementTypeId;
    }

    public KDBRMetaStoreElementType parseElementType(String namespace, ObjectId namespaceId, RowMetaAndData elementTypeRow) throws KettleValueException {
        Long id = elementTypeRow.getInteger("ID_ELEMENT_TYPE");
        String name = elementTypeRow.getString("NAME", null);
        String description = elementTypeRow.getString("DESCRIPTION", null);
        KDBRMetaStoreElementType type = new KDBRMetaStoreElementType(this, namespace, namespaceId, name, description);
        type.setId(new LongObjectId(id.longValue()));
        return type;
    }

    public void deleteElementType(ObjectId elementTypeId) throws KettleException {
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_ELEMENT_TYPE") + " WHERE " + this.quote("ID_ELEMENT_TYPE") + " = ? ", elementTypeId);
    }

    public void deleteNamespace(ObjectId namespaceId) throws KettleException {
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_NAMESPACE") + " WHERE " + this.quote("ID_NAMESPACE") + " = ? ", namespaceId);
    }

    public KDBRMetaStoreElement parseElement(IMetaStoreElementType elementType, RowMetaAndData elementRow) throws KettleException {
        Long elementId = elementRow.getInteger("ID_ELEMENT");
        String name = elementRow.getString("NAME", null);
        KDBRMetaStoreElement element = new KDBRMetaStoreElement(this, elementType, Long.toString(elementId), null);
        element.setName(name);
        this.addAttributes((IMetaStoreAttribute)element, (ObjectId)new LongObjectId(elementId.longValue()), new LongObjectId(0L));
        return element;
    }

    private void addAttributes(IMetaStoreAttribute parentAttribute, ObjectId elementId, LongObjectId parentAttributeId) throws KettleException {
        Collection<RowMetaAndData> attributeRows = this.getElementAttributes(elementId, (ObjectId)parentAttributeId);
        for (RowMetaAndData attributeRow : attributeRows) {
            KDBRMetaStoreAttribute attribute = this.parseAttribute(elementId, attributeRow);
            parentAttribute.addChild((IMetaStoreAttribute)attribute);
            this.addAttributes(attribute, elementId, attribute.getObjectId());
        }
    }

    private KDBRMetaStoreAttribute parseAttribute(ObjectId elementId, RowMetaAndData attributeRow) throws KettleException {
        try {
            Long attributeId = attributeRow.getInteger("ID_ELEMENT_ATTRIBUTE");
            String key = attributeRow.getString("ATTR_KEY", null);
            String value = attributeRow.getString("ATTR_VALUE", null);
            Object object = this.parseAttributeValue(value);
            KDBRMetaStoreAttribute attribute = new KDBRMetaStoreAttribute(this, key, object);
            attribute.setObjectId(new LongObjectId(attributeId.longValue()));
            return attribute;
        }
        catch (Exception e) {
            throw new KettleException("Unable to parse attribute from attribute row: " + attributeRow.toString(), (Throwable)e);
        }
    }

    public Object parseAttributeValue(String value) throws Exception {
        if (Const.isEmpty((String)value) || value.length() < 3) {
            return null;
        }
        String valueString = value.substring(2);
        char type = value.charAt(0);
        switch (type) {
            case 'S': {
                return valueString;
            }
            case 'D': {
                return new SimpleDateFormat(ValueMetaBase.DEFAULT_DATE_FORMAT_MASK).parse(valueString);
            }
            case 'N': {
                return Double.valueOf(valueString);
            }
            case 'I': {
                return Long.valueOf(valueString);
            }
            case 'B': {
                return "true".equalsIgnoreCase(valueString) || "y".equalsIgnoreCase(valueString);
            }
        }
        throw new KettleException("Unknown data type : " + type);
    }

    public String encodeAttributeValue(Object object) throws Exception {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return "S:" + object.toString();
        }
        if (object instanceof Date) {
            return "D:" + new SimpleDateFormat(ValueMetaBase.DEFAULT_DATE_FORMAT_MASK).format((Date)object);
        }
        if (object instanceof Double) {
            return "N:" + Double.toString((Double)object);
        }
        if (object instanceof Long) {
            return "I:" + Long.toString((Long)object);
        }
        if (object instanceof Boolean) {
            return "B:" + ((Boolean)object != false ? "true" : "false");
        }
        throw new KettleException("Can't encode object of class : " + object.getClass().getName());
    }

    public ObjectId insertElement(IMetaStoreElementType elementType, IMetaStoreElement element) throws MetaStoreException {
        try {
            LongObjectId elementId = this.repository.connectionDelegate.getNextID(this.quoteTable("R_ELEMENT"), this.quote("ID_ELEMENT"));
            RowMetaAndData table = new RowMetaAndData();
            table.addValue((ValueMetaInterface)new ValueMeta("ID_ELEMENT", 5), (Object)elementId.longValue());
            table.addValue((ValueMetaInterface)new ValueMeta("ID_ELEMENT_TYPE", 5), (Object)Long.valueOf(elementType.getId()));
            table.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)element.getName());
            this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_ELEMENT");
            this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
            this.repository.connectionDelegate.getDatabase().insertRow();
            this.repository.connectionDelegate.getDatabase().closeInsert();
            element.setId(elementId.toString());
            this.insertAttributes(element.getChildren(), elementId, new LongObjectId(0L));
            if (this.log.isDebug()) {
                this.log.logDebug("Saved element with name [" + element.getName() + "]");
            }
            return elementId;
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to create new element with name '" + element.getName() + "'", (Throwable)e);
        }
    }

    private void insertAttributes(List<IMetaStoreAttribute> children, LongObjectId elementId, LongObjectId parentAttributeId) throws Exception {
        for (IMetaStoreAttribute child : children) {
            LongObjectId attributeId = this.repository.connectionDelegate.getNextID(this.quoteTable("R_ELEMENT_ATTRIBUTE"), this.quote("ID_ELEMENT_ATTRIBUTE"));
            RowMetaAndData table = new RowMetaAndData();
            table.addValue((ValueMetaInterface)new ValueMeta("ID_ELEMENT_ATTRIBUTE", 5), (Object)attributeId.longValue());
            table.addValue((ValueMetaInterface)new ValueMeta("ID_ELEMENT", 5), (Object)elementId.longValue());
            table.addValue((ValueMetaInterface)new ValueMeta("ID_ELEMENT_ATTRIBUTE_PARENT", 5), (Object)parentAttributeId.longValue());
            table.addValue((ValueMetaInterface)new ValueMeta("ATTR_KEY", 2), (Object)child.getId());
            table.addValue((ValueMetaInterface)new ValueMeta("ATTR_VALUE", 2), (Object)this.encodeAttributeValue(child.getValue()));
            this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_ELEMENT_ATTRIBUTE");
            this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
            this.repository.connectionDelegate.getDatabase().insertRow();
            this.repository.connectionDelegate.getDatabase().closeInsert();
            child.setId(attributeId.toString());
        }
    }

    public void deleteElement(ObjectId elementId) throws KettleException {
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_ELEMENT_ATTRIBUTE") + " WHERE " + this.quote("ID_ELEMENT") + " = ? ", elementId);
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_ELEMENT") + " WHERE " + this.quote("ID_ELEMENT") + " = ? ", elementId);
    }
}

