/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginLoaderException;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;
import org.pentaho.di.trans.step.RowDistributionInterface;
import org.pentaho.di.trans.step.RowDistributionPluginType;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;

public class KettleDatabaseRepositoryStepDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    private static Class<?> PKG = StepMeta.class;
    public static final String STEP_ATTRIBUTE_PREFIX = "_ATTR_\t";

    public KettleDatabaseRepositoryStepDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public synchronized ObjectId getStepTypeID(String code) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_STEP_TYPE"), this.quote("ID_STEP_TYPE"), this.quote("CODE"), code);
    }

    public synchronized ObjectId getStepID(String name, ObjectId id_transformation) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_STEP"), this.quote("ID_STEP"), this.quote("NAME"), name, this.quote("ID_TRANSFORMATION"), id_transformation);
    }

    public synchronized String getStepTypeCode(ObjectId id_database_type) throws KettleException {
        return this.repository.connectionDelegate.getStringWithID(this.quoteTable("R_STEP_TYPE"), this.quote("ID_STEP_TYPE"), id_database_type, this.quote("CODE"));
    }

    public RowMetaAndData getStep(ObjectId id_step) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_STEP"), this.quote("ID_STEP"), id_step);
    }

    public RowMetaAndData getStepType(ObjectId id_step_type) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_STEP_TYPE"), this.quote("ID_STEP_TYPE"), id_step_type);
    }

    public RowMetaAndData getStepAttribute(ObjectId id_step_attribute) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_STEP_ATTRIBUTE"), this.quote("ID_STEP_ATTRIBUTE"), id_step_attribute);
    }

    public StepMeta loadStepMeta(ObjectId stepId, List<DatabaseMeta> databases, List<PartitionSchema> partitionSchemas) throws KettleException {
        StepMeta stepMeta = new StepMeta();
        PluginRegistry registry = PluginRegistry.getInstance();
        try {
            RowMetaAndData r = this.getStep(stepId);
            if (r != null) {
                stepMeta.setObjectId(stepId);
                stepMeta.setName(r.getString("NAME", null));
                stepMeta.setDescription(r.getString("DESCRIPTION", null));
                long id_step_type = r.getInteger("ID_STEP_TYPE", -1L);
                RowMetaAndData steptyperow = this.getStepType((ObjectId)new LongObjectId(id_step_type));
                stepMeta.setStepID(steptyperow.getString("CODE", null));
                stepMeta.setDistributes(r.getBoolean("DISTRIBUTE", true));
                int copies = (int)r.getInteger("COPIES", 1L);
                String copiesString = r.getString("COPIES_STRING", null);
                if (!Const.isEmpty((String)copiesString)) {
                    stepMeta.setCopiesString(copiesString);
                } else {
                    stepMeta.setCopies(copies);
                }
                int x = (int)r.getInteger("GUI_LOCATION_X", 0L);
                int y = (int)r.getInteger("GUI_LOCATION_Y", 0L);
                stepMeta.setLocation(new Point(x, y));
                stepMeta.setDraw(r.getBoolean("GUI_DRAW", false));
                PluginInterface sp = registry.findPluginWithId(StepPluginType.class, stepMeta.getStepID());
                if (sp == null) {
                    throw new KettlePluginLoaderException(stepMeta.getStepID(), BaseMessages.getString(PKG, (String)"StepMeta.Exception.UnableToLoadClass", (String[])new String[]{stepMeta.getStepID() + Const.CR}));
                }
                stepMeta.setStepMetaInterface((StepMetaInterface)registry.loadClass(sp));
                if (stepMeta.getStepMetaInterface() != null) {
                    this.readRepCompatibleStepMeta(stepMeta.getStepMetaInterface(), this.repository, stepMeta.getObjectId(), databases);
                    stepMeta.getStepMetaInterface().readRep((Repository)this.repository, this.repository.metaStore, stepMeta.getObjectId(), databases);
                }
                stepMeta.setStepPartitioningMeta(this.loadStepPartitioningMeta(stepMeta.getObjectId()));
                stepMeta.getStepPartitioningMeta().setPartitionSchemaAfterLoading(partitionSchemas);
                stepMeta.setClusterSchemaName(this.repository.getStepAttributeString(stepId, "cluster_schema"));
                String rowDistributionCode = this.repository.getStepAttributeString(stepId, 0, "row_distribution_code");
                RowDistributionInterface rowDistribution = (RowDistributionInterface)PluginRegistry.getInstance().loadClass(RowDistributionPluginType.class, rowDistributionCode, RowDistributionInterface.class);
                stepMeta.setRowDistribution(rowDistribution);
                stepMeta.setAttributesMap(this.loadStepAttributesMap(stepId));
                return stepMeta;
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"StepMeta.Exception.StepInfoCouldNotBeFound", (String[])new String[]{String.valueOf(stepId)}));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StepMeta.Exception.StepCouldNotBeLoaded", (String[])new String[]{String.valueOf(stepMeta.getObjectId())}), (Throwable)dbe);
        }
    }

    private void readRepCompatibleStepMeta(StepMetaInterface stepMetaInterface, KettleDatabaseRepository repository, ObjectId objectId, List<DatabaseMeta> databases) throws KettleException {
        stepMetaInterface.readRep((Repository)repository, objectId, databases, null);
    }

    public void saveStepMeta(StepMeta stepMeta, ObjectId transformationId) throws KettleException {
        try {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"StepMeta.Log.SaveNewStep", (String[])new String[0]));
            stepMeta.setObjectId(this.insertStep(transformationId, stepMeta.getName(), stepMeta.getDescription(), stepMeta.getStepID(), stepMeta.isDistributes(), stepMeta.getCopies(), stepMeta.getLocation() == null ? -1L : (long)stepMeta.getLocation().x, stepMeta.getLocation() == null ? -1L : (long)stepMeta.getLocation().y, stepMeta.isDrawn(), stepMeta.getCopiesString()));
            this.repository.stepDelegate.saveStepPartitioningMeta(stepMeta.getStepPartitioningMeta(), transformationId, stepMeta.getObjectId());
            this.log.logDebug(BaseMessages.getString(PKG, (String)"StepMeta.Log.SaveStepDetails", (String[])new String[0]));
            this.compatibleSaveRep(stepMeta.getStepMetaInterface(), this.repository, transformationId, stepMeta.getObjectId());
            stepMeta.getStepMetaInterface().saveRep(this.repository, this.repository.metaStore, transformationId, stepMeta.getObjectId());
            this.repository.saveStepAttribute(transformationId, stepMeta.getObjectId(), "cluster_schema", stepMeta.getClusterSchema() == null ? "" : stepMeta.getClusterSchema().getName());
            this.repository.saveStepAttribute(transformationId, stepMeta.getObjectId(), "row_distribution_code", stepMeta.getRowDistribution() == null ? null : stepMeta.getRowDistribution().getCode());
            this.saveAttributesMap(transformationId, stepMeta.getObjectId(), stepMeta.getAttributesMap());
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StepMeta.Exception.UnableToSaveStepInfo", (String[])new String[]{String.valueOf(transformationId)}), (Throwable)e);
        }
    }

    private void compatibleSaveRep(StepMetaInterface stepMetaInterface, KettleDatabaseRepository repository, ObjectId id_transformation, ObjectId objectId) throws KettleException {
        stepMetaInterface.saveRep(repository, id_transformation, objectId);
    }

    public void saveStepErrorMeta(StepErrorMeta meta, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_source_step", meta.getSourceStep() != null ? meta.getSourceStep().getName() : "");
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_target_step", meta.getTargetStep() != null ? meta.getTargetStep().getName() : "");
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_is_enabled", meta.isEnabled());
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_nr_valuename", meta.getNrErrorsValuename());
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_descriptions_valuename", meta.getErrorDescriptionsValuename());
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_fields_valuename", meta.getErrorFieldsValuename());
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_codes_valuename", meta.getErrorCodesValuename());
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_max_errors", meta.getMaxErrors());
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_max_pct_errors", meta.getMaxPercentErrors());
        this.repository.saveStepAttribute(id_transformation, id_step, "step_error_handling_min_pct_rows", meta.getMinPercentRows());
    }

    public StepErrorMeta loadStepErrorMeta(VariableSpace variables, StepMeta stepMeta, List<StepMeta> steps) throws KettleException {
        StepErrorMeta meta = new StepErrorMeta(variables, stepMeta);
        meta.setTargetStep(StepMeta.findStep(steps, this.repository.getStepAttributeString(stepMeta.getObjectId(), "step_error_handling_target_step")));
        meta.setEnabled(this.repository.getStepAttributeBoolean(stepMeta.getObjectId(), "step_error_handling_is_enabled"));
        meta.setNrErrorsValuename(this.repository.getStepAttributeString(stepMeta.getObjectId(), "step_error_handling_nr_valuename"));
        meta.setErrorDescriptionsValuename(this.repository.getStepAttributeString(stepMeta.getObjectId(), "step_error_handling_descriptions_valuename"));
        meta.setErrorFieldsValuename(this.repository.getStepAttributeString(stepMeta.getObjectId(), "step_error_handling_fields_valuename"));
        meta.setErrorCodesValuename(this.repository.getStepAttributeString(stepMeta.getObjectId(), "step_error_handling_codes_valuename"));
        meta.setMaxErrors(this.repository.getStepAttributeString(stepMeta.getObjectId(), "step_error_handling_max_errors"));
        meta.setMaxPercentErrors(this.repository.getStepAttributeString(stepMeta.getObjectId(), "step_error_handling_max_pct_errors"));
        meta.setMinPercentRows(this.repository.getStepAttributeString(stepMeta.getObjectId(), "step_error_handling_min_pct_rows"));
        return meta;
    }

    public StepPartitioningMeta loadStepPartitioningMeta(ObjectId id_step) throws KettleException {
        StepPartitioningMeta stepPartitioningMeta = new StepPartitioningMeta();
        stepPartitioningMeta.setPartitionSchemaName(this.repository.getStepAttributeString(id_step, "PARTITIONING_SCHEMA"));
        String methodCode = this.repository.getStepAttributeString(id_step, "PARTITIONING_METHOD");
        stepPartitioningMeta.setMethod(StepPartitioningMeta.getMethod(methodCode));
        if (stepPartitioningMeta.getPartitioner() != null) {
            stepPartitioningMeta.getPartitioner().loadRep(this.repository, id_step);
        }
        stepPartitioningMeta.hasChanged(true);
        return stepPartitioningMeta;
    }

    public void saveStepPartitioningMeta(StepPartitioningMeta meta, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        this.repository.saveStepAttribute(id_transformation, id_step, "PARTITIONING_SCHEMA", meta.getPartitionSchema() != null ? meta.getPartitionSchema().getName() : "");
        this.repository.saveStepAttribute(id_transformation, id_step, "PARTITIONING_METHOD", meta.getMethodCode());
        if (meta.getPartitioner() != null) {
            meta.getPartitioner().saveRep(this.repository, id_transformation, id_step);
        }
    }

    public synchronized ObjectId insertStep(ObjectId id_transformation, String name, String description, String steptype, boolean distribute, long copies, long gui_location_x, long gui_location_y, boolean gui_draw, String copiesString) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextStepID();
        ObjectId id_step_type = this.getStepTypeID(steptype);
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)name);
        table.addValue((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2), (Object)description);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_STEP_TYPE", 5), (Object)id_step_type);
        table.addValue((ValueMetaInterface)new ValueMeta("DISTRIBUTE", 4), (Object)distribute);
        table.addValue((ValueMetaInterface)new ValueMeta("COPIES", 5), (Object)new Long(copies));
        table.addValue((ValueMetaInterface)new ValueMeta("GUI_LOCATION_X", 5), (Object)new Long(gui_location_x));
        table.addValue((ValueMetaInterface)new ValueMeta("GUI_LOCATION_Y", 5), (Object)new Long(gui_location_y));
        table.addValue((ValueMetaInterface)new ValueMeta("GUI_DRAW", 4), (Object)gui_draw);
        table.addValue((ValueMetaInterface)new ValueMeta("COPIES_STRING", 2), (Object)copiesString);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_STEP");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized int getNrSteps(ObjectId id_transformation) throws KettleException {
        int retval = 0;
        RowMetaAndData par = this.repository.connectionDelegate.getParameterMetaData(id_transformation);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_STEP") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, par.getRowMeta(), par.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrStepAttributes(ObjectId id_step) throws KettleException {
        int retval = 0;
        RowMetaAndData par = this.repository.connectionDelegate.getParameterMetaData(id_step);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_STEP_ATTRIBUTE") + " WHERE " + this.quote("ID_STEP") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, par.getRowMeta(), par.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    private void saveAttributesMap(ObjectId transformationId, ObjectId stepId, Map<String, Map<String, String>> attributesMap) throws KettleException {
        for (String groupName : attributesMap.keySet()) {
            Map<String, String> attributes = attributesMap.get(groupName);
            for (String key : attributes.keySet()) {
                String value = attributes.get(key);
                if (key == null || value == null) continue;
                this.repository.connectionDelegate.insertStepAttribute(transformationId, stepId, 0L, STEP_ATTRIBUTE_PREFIX + groupName + '\t' + value, 0.0, value);
            }
        }
    }

    private Map<String, Map<String, String>> loadStepAttributesMap(ObjectId stepId) throws KettleException {
        HashMap<String, Map<String, String>> attributesMap = new HashMap<String, Map<String, String>>();
        List<Object[]> attributeRows = this.repository.connectionDelegate.getStepAttributesBuffer();
        RowMetaInterface rowMeta = this.repository.connectionDelegate.getStepAttributesRowMeta();
        for (Object[] attributeRow : attributeRows) {
            int tabIndex;
            String value;
            String code = rowMeta.getString(attributeRow, "CODE", null);
            if (code == null || !code.startsWith(STEP_ATTRIBUTE_PREFIX) || (value = rowMeta.getString(attributeRow, "VALUE_STR", null)) == null || (tabIndex = (code = code.substring(STEP_ATTRIBUTE_PREFIX.length())).indexOf(9)) <= 0) continue;
            String groupName = code.substring(0, tabIndex);
            String key = code.substring(tabIndex + 1);
            HashMap<String, String> attributes = (HashMap<String, String>)attributesMap.get(groupName);
            if (attributes == null) {
                attributes = new HashMap<String, String>();
                attributesMap.put(groupName, attributes);
            }
            attributes.put(key, value);
        }
        return attributesMap;
    }
}

