/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.BasePainter;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.gui.Rectangle;
import org.pentaho.di.core.gui.ScrollBarInterface;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPainterExtension;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;

public class TransPainter
extends BasePainter {
    private static Class<?> PKG = TransPainter.class;
    public static final String STRING_PARTITIONING_CURRENT_STEP = "PartitioningCurrentStep";
    public static final String STRING_REMOTE_INPUT_STEPS = "RemoteInputSteps";
    public static final String STRING_REMOTE_OUTPUT_STEPS = "RemoteOutputSteps";
    public static final String STRING_STEP_ERROR_LOG = "StepErrorLog";
    public static final String STRING_HOP_TYPE_COPY = "HopTypeCopy";
    public static final String STRING_ROW_DISTRIBUTION = "RowDistribution";
    public static final String[] magnificationDescriptions = new String[]{"  200% ", "  150% ", "  100% ", "  75% ", "  50% ", "  25% "};
    private TransMeta transMeta;
    private TransHopMeta candidate;
    private Map<StepMeta, String> stepLogMap;
    private List<StepMeta> mouseOverSteps;
    private StepMeta startHopStep;
    private Point endHopLocation;
    private StepMeta endHopStep;
    private StepMeta noInputStep;
    private StreamInterface.StreamType candidateHopType;
    private boolean startErrorHopStep;
    private StepMeta showTargetStreamsStep;
    private Trans trans;
    private boolean slowStepIndicatorEnabled;

    public TransPainter(GCInterface gc, TransMeta transMeta, Point area, ScrollBarInterface hori, ScrollBarInterface vert, TransHopMeta candidate, Point drop_candidate, Rectangle selrect, List<AreaOwner> areaOwners, List<StepMeta> mouseOverSteps, int iconsize, int linewidth, int gridsize, int shadowSize, boolean antiAliasing, String noteFontName, int noteFontHeight, Trans trans, boolean slowStepIndicatorEnabled) {
        super(gc, transMeta, area, hori, vert, drop_candidate, selrect, areaOwners, iconsize, linewidth, gridsize, shadowSize, antiAliasing, noteFontName, noteFontHeight);
        this.transMeta = transMeta;
        this.candidate = candidate;
        this.mouseOverSteps = mouseOverSteps;
        this.trans = trans;
        this.slowStepIndicatorEnabled = slowStepIndicatorEnabled;
        this.stepLogMap = null;
    }

    public TransPainter(GCInterface gc, TransMeta transMeta, Point area, ScrollBarInterface hori, ScrollBarInterface vert, TransHopMeta candidate, Point drop_candidate, Rectangle selrect, List<AreaOwner> areaOwners, List<StepMeta> mouseOverSteps, int iconsize, int linewidth, int gridsize, int shadowSize, boolean antiAliasing, String noteFontName, int noteFontHeight) {
        this(gc, transMeta, area, hori, vert, candidate, drop_candidate, selrect, areaOwners, mouseOverSteps, iconsize, linewidth, gridsize, shadowSize, antiAliasing, noteFontName, noteFontHeight, new Trans(transMeta), false);
    }

    private static String[] getPeekTitles() {
        String[] titles = new String[]{BaseMessages.getString(PKG, (String)"PeekMetric.Column.Copynr", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Read", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Written", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Input", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Output", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Updated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Rejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Errors", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Active", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Time", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Speed", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.PriorityBufferSizes", (String[])new String[0])};
        return titles;
    }

    public void buildTransformationImage() {
        Point max = this.transMeta.getMaximum();
        Point thumb = this.getThumb(this.area, max);
        this.offset = this.getOffset(thumb, this.area);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        this.gc.fillRectangle(0, 0, this.area.x, this.area.y);
        if (this.shadowSize > 0) {
            this.shadow = true;
            this.gc.setTransform(this.translationX, this.translationY, this.shadowSize, this.magnification);
            this.gc.setAlpha(20);
            this.drawTrans(thumb);
        }
        this.shadow = false;
        this.gc.setTransform(this.translationX, this.translationY, 0, this.magnification);
        this.gc.setAlpha(255);
        this.drawTrans(thumb);
        this.gc.dispose();
    }

    private void drawTrans(Point thumb) {
        StepMeta stepMeta;
        int i;
        Point end;
        Point start;
        Point to;
        int i2;
        if (!this.shadow && this.gridSize > 1) {
            this.drawGrid();
        }
        if (this.hori != null && this.vert != null) {
            this.hori.setThumb(thumb.x);
            this.vert.setThumb(thumb.y);
        }
        this.gc.setFont(PrimitiveGCInterface.EFont.NOTE);
        for (i2 = 0; i2 < this.transMeta.nrNotes(); ++i2) {
            NotePadMeta ni = this.transMeta.getNote(i2);
            this.drawNote(ni);
        }
        this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        for (i2 = 0; i2 < this.transMeta.nrTransHops(); ++i2) {
            TransHopMeta hi = this.transMeta.getTransHop(i2);
            this.drawHop(hi);
        }
        if (this.candidate != null) {
            this.drawHop(this.candidate, true);
        } else if (this.startHopStep != null && this.endHopLocation != null) {
            Point fr = this.startHopStep.getLocation();
            to = this.endHopLocation;
            if (this.endHopStep == null) {
                this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
            } else {
                this.gc.setForeground(PrimitiveGCInterface.EColor.BLUE);
            }
            start = this.real2screen(fr.x + this.iconsize / 2, fr.y + this.iconsize / 2);
            end = this.real2screen(to.x, to.y);
            this.drawArrow(start.x, start.y, end.x, end.y, this.theta, this.calcArrowLength(), 1.2, null, this.startHopStep, this.endHopStep == null ? this.endHopLocation : this.endHopStep);
        } else if (this.endHopStep != null && this.endHopLocation != null) {
            Point fr = this.endHopLocation;
            to = this.endHopStep.getLocation();
            if (this.startHopStep == null) {
                this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
            } else {
                this.gc.setForeground(PrimitiveGCInterface.EColor.BLUE);
            }
            start = this.real2screen(fr.x, fr.y);
            end = this.real2screen(to.x + this.iconsize / 2, to.y + this.iconsize / 2);
            this.drawArrow(start.x, start.y, end.x, end.y, this.theta, this.calcArrowLength(), 1.2, null, this.startHopStep == null ? this.endHopLocation : this.startHopStep, this.endHopStep);
        }
        for (i = 0; i < this.transMeta.nrSteps(); ++i) {
            stepMeta = this.transMeta.getStep(i);
            if (!stepMeta.isDrawn()) continue;
            this.drawStep(stepMeta);
        }
        if (this.slowStepIndicatorEnabled) {
            for (i = 0; i < this.transMeta.nrSteps(); ++i) {
                stepMeta = this.transMeta.getStep(i);
                if (!stepMeta.isDrawn()) continue;
                this.checkDrawSlowStepIndicator(stepMeta);
            }
        }
        for (i = 0; i < this.transMeta.nrSteps(); ++i) {
            stepMeta = this.transMeta.getStep(i);
            if (!stepMeta.isDrawn()) continue;
            this.drawStepStatusIndicator(stepMeta);
        }
        for (i = 0; i < this.transMeta.nrSteps(); ++i) {
            stepMeta = this.transMeta.getStep(i);
            if (!stepMeta.isDrawn()) continue;
            this.drawStepPerformanceTable(stepMeta);
        }
        if (this.noInputStep != null) {
            this.gc.setLineWidth(2);
            this.gc.setForeground(PrimitiveGCInterface.EColor.RED);
            Point n = this.noInputStep.getLocation();
            this.gc.drawLine(n.x - 5, n.y - 5, n.x + this.iconsize + 10, n.y + this.iconsize + 10);
            this.gc.drawLine(n.x - 5, n.y + this.iconsize + 5, n.x + this.iconsize + 5, n.y - 5);
        }
        if (this.drop_candidate != null) {
            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
            Point screen = this.real2screen(this.drop_candidate.x, this.drop_candidate.y);
            this.gc.drawRectangle(screen.x, screen.y, this.iconsize, this.iconsize);
        }
        if (!this.shadow) {
            this.drawRect(this.selrect);
        }
    }

    private void checkDrawSlowStepIndicator(StepMeta stepMeta) {
        if (stepMeta == null) {
            return;
        }
        if (this.trans != null) {
            Point pt = stepMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            List<StepInterface> steps = this.trans.findBaseSteps(stepMeta.getName());
            for (StepInterface step : steps) {
                if (step.isRunning()) {
                    int outputRows;
                    boolean isSlow;
                    int inputRows = step.rowsetInputSize();
                    boolean bl = isSlow = (double)inputRows * 0.85 > (double)(outputRows = step.rowsetOutputSize());
                    if (isSlow) {
                        this.gc.setLineWidth(this.linewidth + 1);
                        if (System.currentTimeMillis() % 2000L > 1000L) {
                            this.gc.setForeground(PrimitiveGCInterface.EColor.BACKGROUND);
                            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
                            this.gc.drawRectangle(x + 1, y + 1, this.iconsize - 2, this.iconsize - 2);
                            this.gc.setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
                            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.DOT);
                            this.gc.drawRectangle(x + 1, y + 1, this.iconsize - 2, this.iconsize - 2);
                        } else {
                            this.gc.setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
                            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
                            this.gc.drawRectangle(x + 1, y + 1, this.iconsize - 2, this.iconsize - 2);
                            this.gc.setForeground(PrimitiveGCInterface.EColor.BACKGROUND);
                            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.DOT);
                            this.gc.drawRectangle(x + 1, y + 1, this.iconsize - 2, this.iconsize - 2);
                        }
                    }
                }
                this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
            }
        }
    }

    private void drawStepPerformanceTable(StepMeta stepMeta) {
        if (stepMeta == null) {
            return;
        }
        if (this.trans != null) {
            Point pt = stepMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            List<StepInterface> steps = this.trans.findBaseSteps(stepMeta.getName());
            if (this.trans.isRunning() && stepMeta.isSelected()) {
                String[] titles;
                int popupX = x;
                int popupY = y;
                int popupWidth = 0;
                int popupHeight = 1;
                this.gc.setFont(PrimitiveGCInterface.EFont.SMALL);
                Point p = this.gc.textExtent("0000000000");
                int colWidth = p.x + 5;
                int rowHeight = p.y + 5;
                int titleWidth = 0;
                for (String title : titles = TransPainter.getPeekTitles()) {
                    Point titleExtent = this.gc.textExtent(title);
                    titleWidth = Math.max(titleExtent.x + 5, titleWidth);
                    popupHeight += titleExtent.y + 5;
                }
                popupWidth = titleWidth + 10;
                popupY = popupY - popupHeight - 5;
                this.gc.setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
                this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                this.gc.setLineWidth(1);
                this.gc.fillRoundRectangle(popupX += (this.iconsize - (popupWidth += steps.size() * colWidth)) / 2, popupY, popupWidth, popupHeight, 7, 7);
                this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                this.gc.drawRoundRectangle(popupX, popupY, popupWidth, popupHeight, 7, 7);
                int barY = popupY;
                for (int i = 0; i < titles.length; ++i) {
                    if (i % 2 == 1) {
                        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
                    } else {
                        this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                    }
                    this.gc.fillRoundRectangle(popupX + 1, barY + 1, popupWidth - 2, rowHeight, 7, 7);
                    barY += rowHeight;
                }
                int rowY = popupY + 5;
                int rowX = popupX + 5;
                this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
                this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
                for (int i = 0; i < titles.length; ++i) {
                    if (i % 2 == 1) {
                        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
                    } else {
                        this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                    }
                    this.gc.drawText(titles[i], rowX, rowY);
                    rowY += rowHeight;
                }
                this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                rowX += titleWidth;
                for (StepInterface step : steps) {
                    rowX += colWidth;
                    rowY = popupY + 5;
                    StepStatus stepStatus = new StepStatus(step);
                    String[] fields = stepStatus.getPeekFields();
                    for (int i = 0; i < fields.length; ++i) {
                        if (i % 2 == 1) {
                            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
                        } else {
                            this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                        }
                        this.drawTextRightAligned(fields[i], rowX, rowY);
                        rowY += rowHeight;
                    }
                }
            }
        }
    }

    private void drawStepStatusIndicator(StepMeta stepMeta) {
        if (stepMeta == null) {
            return;
        }
        if (this.trans != null) {
            Point pt = stepMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            List<StepInterface> steps = this.trans.findBaseSteps(stepMeta.getName());
            for (StepInterface step : steps) {
                if (!step.getStatus().equals((Object)BaseStepData.StepExecutionStatus.STATUS_FINISHED)) continue;
                this.gc.drawImage(PrimitiveGCInterface.EImage.TRUE, x + this.iconsize - 7, y - 7);
            }
        }
    }

    private void drawTextRightAligned(String txt, int x, int y) {
        int off = this.gc.textExtent((String)txt).x;
        this.gc.drawText(txt, x -= off, y);
    }

    private void drawHop(TransHopMeta hi) {
        this.drawHop(hi, false);
    }

    private void drawHop(TransHopMeta hi, boolean isCandidate) {
        StepMeta fs = hi.getFromStep();
        StepMeta ts = hi.getToStep();
        if (fs != null && ts != null) {
            this.drawLine(fs, ts, hi, isCandidate);
        }
    }

    private void drawStep(StepMeta stepMeta) {
        Point point;
        Point textExtent;
        String log;
        if (stepMeta == null) {
            return;
        }
        int alpha = this.gc.getAlpha();
        StepIOMetaInterface ioMeta = stepMeta.getStepMetaInterface().getStepIOMeta();
        Point pt = stepMeta.getLocation();
        if (pt == null) {
            pt = new Point(50, 50);
        }
        Point screen = this.real2screen(pt.x, pt.y);
        int x = screen.x;
        int y = screen.y;
        boolean stepError = false;
        if (this.stepLogMap != null && !this.stepLogMap.isEmpty() && !Const.isEmpty((String)(log = this.stepLogMap.get(stepMeta)))) {
            stepError = true;
        }
        if (!stepMeta.getRemoteInputSteps().isEmpty()) {
            this.gc.setLineWidth(1);
            this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            String nrInput = Integer.toString(stepMeta.getRemoteInputSteps().size());
            textExtent = this.gc.textExtent(nrInput);
            textExtent.x += 2;
            textExtent.y += 2;
            point = new Point(x - this.iconsize - this.iconsize / 2, y - this.iconsize);
            this.gc.drawRectangle(point.x, point.y, textExtent.x, textExtent.y);
            this.gc.drawText(nrInput, point.x + 1, point.y + 1);
            this.gc.drawLine(point.x + textExtent.x, point.y + textExtent.y / 2, x - this.iconsize / 2, point.y + textExtent.y / 2);
            this.drawArrow(x - this.iconsize / 2, point.y + textExtent.y / 2, x + this.iconsize / 3, y, Math.toRadians(15.0), 15, 1.8, null, null, null);
            if (!this.shadow) {
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.REMOTE_INPUT_STEP, point.x, point.y, textExtent.x, textExtent.y, this.offset, stepMeta, STRING_REMOTE_INPUT_STEPS));
            }
        }
        if (!stepMeta.getRemoteOutputSteps().isEmpty()) {
            this.gc.setLineWidth(1);
            this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            String nrOutput = Integer.toString(stepMeta.getRemoteOutputSteps().size());
            textExtent = this.gc.textExtent(nrOutput);
            textExtent.x += 2;
            textExtent.y += 2;
            point = new Point(x + 2 * this.iconsize + this.iconsize / 2 - textExtent.x, y - this.iconsize);
            this.gc.drawRectangle(point.x, point.y, textExtent.x, textExtent.y);
            this.gc.drawText(nrOutput, point.x + 1, point.y + 1);
            this.gc.drawLine(point.x, point.y + textExtent.y / 2, x + this.iconsize + this.iconsize / 2, point.y + textExtent.y / 2);
            this.drawArrow(x + 2 * this.iconsize / 3, y, x + this.iconsize + this.iconsize / 2, point.y + textExtent.y / 2, Math.toRadians(15.0), 15, 1.8, null, null, null);
            if (!this.shadow) {
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.REMOTE_OUTPUT_STEP, point.x, point.y, textExtent.x, textExtent.y, this.offset, stepMeta, STRING_REMOTE_OUTPUT_STEPS));
            }
        }
        if (stepMeta.isPartitioned()) {
            this.gc.setLineWidth(1);
            this.gc.setForeground(PrimitiveGCInterface.EColor.RED);
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            PartitionSchema partitionSchema = stepMeta.getStepPartitioningMeta().getPartitionSchema();
            if (partitionSchema != null) {
                String nrInput = partitionSchema.isDynamicallyDefined() ? "Dx" + partitionSchema.getNumberOfPartitionsPerSlave() : "Px" + Integer.toString(partitionSchema.getPartitionIDs().size());
                Point textExtent2 = this.gc.textExtent(nrInput);
                textExtent2.x += 2;
                textExtent2.y += 2;
                Point point2 = new Point(x - this.iconsize - this.iconsize / 2, y - this.iconsize - this.iconsize);
                this.gc.drawRectangle(point2.x, point2.y, textExtent2.x, textExtent2.y);
                this.gc.drawText(nrInput, point2.x + 1, point2.y + 1);
                this.gc.drawLine(point2.x + textExtent2.x, point2.y + textExtent2.y / 2, x - this.iconsize / 2, point2.y + textExtent2.y / 2);
                this.gc.drawLine(x - this.iconsize / 2, point2.y + textExtent2.y / 2, x + this.iconsize / 3, y);
                this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
                this.gc.drawText(Const.NVL((String)partitionSchema.getName(), (String)"<no partition name>"), point2.x, point2.y + textExtent2.y + 3, true);
                if (!this.shadow) {
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_PARTITIONING, point2.x, point2.y, textExtent2.x, textExtent2.y, this.offset, stepMeta, STRING_PARTITIONING_CURRENT_STEP));
                }
            }
        }
        String name = stepMeta.getName();
        if (stepMeta.isSelected()) {
            this.gc.setLineWidth(this.linewidth + 2);
        } else {
            this.gc.setLineWidth(this.linewidth);
        }
        if (!this.shadow) {
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_ICON, x, y, this.iconsize, this.iconsize, this.offset, this.transMeta, stepMeta));
        }
        this.gc.drawStepIcon(x, y, stepMeta);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        if (stepError) {
            this.gc.setForeground(PrimitiveGCInterface.EColor.RED);
        } else {
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
        }
        this.gc.drawRectangle(x - 1, y - 1, this.iconsize + 1, this.iconsize + 1);
        Point namePosition = this.getNamePosition(name, screen, this.iconsize);
        this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
        this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
        this.gc.drawText(name, namePosition.x, namePosition.y, true);
        boolean partitioned = false;
        StepPartitioningMeta meta = stepMeta.getStepPartitioningMeta();
        if (stepMeta.isPartitioned() && meta != null) {
            partitioned = true;
        }
        if (stepMeta.getClusterSchema() != null) {
            String message = "C";
            message = stepMeta.getClusterSchema().isDynamic() ? message + "xN" : message + "x" + stepMeta.getClusterSchema().findNrSlaves();
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
            this.gc.drawText(message, x + 3 + this.iconsize, y - 8);
        }
        if (stepMeta.getCopies() != 1 && !partitioned) {
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
            String copies = "x" + stepMeta.getCopiesString();
            Point textExtent3 = this.gc.textExtent(copies);
            this.gc.drawText(copies, x - textExtent3.x / 2, y - textExtent3.y, false);
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_COPIES_TEXT, x - textExtent3.x / 2, y - textExtent3.y, textExtent3.x, textExtent3.y, this.offset, this.transMeta, stepMeta));
        }
        if (stepError) {
            String log2 = this.stepLogMap.get(stepMeta);
            int xError = x + this.iconsize - 5;
            int yError = y + this.iconsize - 5;
            Point ib = this.gc.getImageBounds(PrimitiveGCInterface.EImage.STEP_ERROR);
            this.gc.drawImage(PrimitiveGCInterface.EImage.STEP_ERROR, xError, yError);
            if (!this.shadow) {
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_ERROR_ICON, pt.x + this.iconsize - 5, pt.y + this.iconsize - 5, ib.x, ib.y, this.offset, log2, STRING_STEP_ERROR_LOG));
            }
        }
        if (this.mouseOverSteps.contains(stepMeta)) {
            StepMetaInjectionInterface injectionInterface = stepMeta.getStepMetaInterface().getStepMetaInjectionInterface();
            PrimitiveGCInterface.EImage[] miniIcons = injectionInterface != null ? new PrimitiveGCInterface.EImage[]{PrimitiveGCInterface.EImage.INPUT, PrimitiveGCInterface.EImage.EDIT, PrimitiveGCInterface.EImage.CONTEXT_MENU, PrimitiveGCInterface.EImage.OUTPUT, PrimitiveGCInterface.EImage.INJECT} : new PrimitiveGCInterface.EImage[]{PrimitiveGCInterface.EImage.INPUT, PrimitiveGCInterface.EImage.EDIT, PrimitiveGCInterface.EImage.CONTEXT_MENU, PrimitiveGCInterface.EImage.OUTPUT};
            int totalHeight = 0;
            int totalIconsWidth = 0;
            int totalWidth = 10;
            for (PrimitiveGCInterface.EImage miniIcon : miniIcons) {
                Point bounds = this.gc.getImageBounds(miniIcon);
                totalWidth += bounds.x + 5;
                totalIconsWidth += bounds.x + 5;
                if (bounds.y <= totalHeight) continue;
                totalHeight = bounds.y;
            }
            totalHeight += 10;
            this.gc.setFont(PrimitiveGCInterface.EFont.SMALL);
            String trimmedName = stepMeta.getName().length() < 30 ? stepMeta.getName() : stepMeta.getName().substring(0, 30);
            Point nameExtent = this.gc.textExtent(trimmedName);
            nameExtent.y += 10;
            nameExtent.x += 15;
            totalHeight += nameExtent.y;
            if (nameExtent.x > totalWidth) {
                totalWidth = nameExtent.x;
            }
            int areaX = x + this.iconsize / 2 - totalWidth / 2 + 0;
            int areaY = y + this.iconsize + 7;
            this.gc.setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
            this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
            this.gc.setLineWidth(1);
            this.gc.fillRoundRectangle(areaX, areaY, totalWidth, totalHeight, 7, 7);
            this.gc.drawRoundRectangle(areaX, areaY, totalWidth, totalHeight, 7, 7);
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.fillRoundRectangle(areaX + 2, areaY + 2, totalWidth - 5 + 1, nameExtent.y - 5, 7, 7);
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
            this.gc.drawText(trimmedName, areaX + (totalWidth - nameExtent.x) / 2 + 5, areaY + 5, true);
            this.gc.setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
            this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.MINI_ICONS_BALLOON, areaX, areaY, totalWidth, totalHeight, this.offset, stepMeta, ioMeta));
            this.gc.fillPolygon(new int[]{areaX + totalWidth / 2 - 5 + 1, areaY + 2, areaX + totalWidth / 2 + 5, areaY + 2, areaX + totalWidth / 2 - 0, areaY - 7 - 5});
            this.gc.drawPolyline(new int[]{areaX + totalWidth / 2 - 5 + 1, areaY, areaX + totalWidth / 2 - 0, areaY - 7 - 5, areaX + totalWidth / 2 + 5, areaY, areaX + totalWidth / 2 - 0, areaY - 7 - 5});
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            int xIcon = areaX + (totalWidth - totalIconsWidth) / 2 + 5;
            int yIcon = areaY + 5 + nameExtent.y;
            for (int i = 0; i < miniIcons.length; ++i) {
                PrimitiveGCInterface.EImage miniIcon = miniIcons[i];
                Point bounds = this.gc.getImageBounds(miniIcon);
                boolean enabled = false;
                switch (i) {
                    case 0: {
                        enabled = ioMeta.isInputAcceptor() || ioMeta.isInputDynamic();
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_INPUT_HOP_ICON, xIcon, yIcon, bounds.x, bounds.y, this.offset, stepMeta, ioMeta));
                        break;
                    }
                    case 1: {
                        enabled = true;
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_EDIT_ICON, xIcon, yIcon, bounds.x, bounds.y, this.offset, stepMeta, ioMeta));
                        break;
                    }
                    case 2: {
                        enabled = true;
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_MENU_ICON, xIcon, yIcon, bounds.x, bounds.y, this.offset, stepMeta, ioMeta));
                        break;
                    }
                    case 3: {
                        enabled = ioMeta.isOutputProducer() || ioMeta.isOutputDynamic();
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_OUTPUT_HOP_ICON, xIcon, yIcon, bounds.x, bounds.y, this.offset, stepMeta, ioMeta));
                        break;
                    }
                    case 4: {
                        enabled = injectionInterface != null;
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_INJECT_ICON, xIcon, yIcon, bounds.x, bounds.y, this.offset, stepMeta, injectionInterface));
                        break;
                    }
                }
                if (enabled) {
                    this.gc.setAlpha(255);
                } else {
                    this.gc.setAlpha(100);
                }
                this.gc.drawImage(miniIcon, xIcon, yIcon);
                xIcon += bounds.x + 5;
            }
            if (this.showTargetStreamsStep != null) {
                ioMeta = this.showTargetStreamsStep.getStepMetaInterface().getStepIOMeta();
                List<StreamInterface> targetStreams = ioMeta.getTargetStreams();
                int targetsWidth = 0;
                int targetsHeight = 0;
                for (int i = 0; i < targetStreams.size(); ++i) {
                    String description = targetStreams.get(i).getDescription();
                    Point extent = this.gc.textExtent(description);
                    if (extent.x > targetsWidth) {
                        targetsWidth = extent.x;
                    }
                    targetsHeight += extent.y + 5;
                }
                this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                this.gc.fillRoundRectangle(areaX, areaY + totalHeight + 2, targetsWidth += 5, targetsHeight, 7, 7);
                this.gc.drawRoundRectangle(areaX, areaY + totalHeight + 2, targetsWidth, targetsHeight, 7, 7);
                int targetY = areaY + totalHeight + 5;
                for (int i = 0; i < targetStreams.size(); ++i) {
                    String description = targetStreams.get(i).getDescription();
                    Point extent = this.gc.textExtent(description);
                    this.gc.drawText(description, areaX + 5, targetY, true);
                    if (i < targetStreams.size() - 1) {
                        this.gc.drawLine(areaX + 2, targetY + extent.y + 3, areaX + targetsWidth - 2, targetY + extent.y + 2);
                    }
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_TARGET_HOP_ICON_OPTION, areaX, targetY, targetsWidth, extent.y + 5, this.offset, stepMeta, targetStreams.get(i)));
                    targetY += extent.y + 5;
                }
                this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            }
        }
        TransPainterExtension extension = new TransPainterExtension(this.gc, this.shadow, this.areaOwners, this.transMeta, stepMeta, null, x, y, 0, 0, 0, 0, this.offset, this.iconsize);
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransPainterStep.id, (Object)extension);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error calling extension point(s) for the transformation painter step", (Throwable)e);
        }
        this.gc.setAlpha(alpha);
    }

    public Point getNamePosition(String string, Point screen, int iconsize) {
        Point textsize = this.gc.textExtent(string);
        int xpos = screen.x + iconsize / 2 - textsize.x / 2;
        int ypos = screen.y + iconsize + 5;
        return new Point(xpos, ypos);
    }

    private void drawLine(StepMeta fs, StepMeta ts, TransHopMeta hi, boolean is_candidate) {
        StepIOMetaInterface ioMeta;
        List<StreamInterface> infoStreams;
        PrimitiveGCInterface.EColor col;
        int[] line = this.getLine(fs, ts);
        PrimitiveGCInterface.ELineStyle linestyle = PrimitiveGCInterface.ELineStyle.SOLID;
        int activeLinewidth = this.linewidth;
        if (is_candidate) {
            col = PrimitiveGCInterface.EColor.BLUE;
        } else if (hi.isEnabled()) {
            if (fs.isSendingErrorRowsToStep(ts)) {
                col = PrimitiveGCInterface.EColor.RED;
                linestyle = PrimitiveGCInterface.ELineStyle.DOT;
                activeLinewidth = this.linewidth + 1;
            } else {
                col = PrimitiveGCInterface.EColor.BLACK;
            }
        } else {
            col = PrimitiveGCInterface.EColor.GRAY;
        }
        if (hi.split) {
            activeLinewidth = this.linewidth + 2;
        }
        if (!(infoStreams = (ioMeta = ts.getStepMetaInterface().getStepIOMeta()).getInfoStreams()).isEmpty()) {
            for (StreamInterface stream : infoStreams) {
                if (!fs.getName().equalsIgnoreCase(stream.getStepname()) || fs.getCopies() <= 1) continue;
                col = PrimitiveGCInterface.EColor.RED;
            }
        }
        this.gc.setForeground(col);
        this.gc.setLineStyle(linestyle);
        this.gc.setLineWidth(activeLinewidth);
        this.drawArrow(line, hi, fs, ts);
        if (hi.split) {
            this.gc.setLineWidth(this.linewidth);
        }
        this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
    }

    private int[] getLine(StepMeta fs, StepMeta ts) {
        Point from = fs.getLocation();
        Point to = ts.getLocation();
        int x1 = from.x + this.iconsize / 2;
        int y1 = from.y + this.iconsize / 2;
        int x2 = to.x + this.iconsize / 2;
        int y2 = to.y + this.iconsize / 2;
        return new int[]{x1, y1, x2, y2};
    }

    private void drawArrow(int[] line, TransHopMeta transHop, Object startObject, Object endObject) {
        Point screen_from = this.real2screen(line[0], line[1]);
        Point screen_to = this.real2screen(line[2], line[3]);
        this.drawArrow(screen_from.x, screen_from.y, screen_to.x, screen_to.y, this.theta, this.calcArrowLength(), -1.0, transHop, startObject, endObject);
    }

    private void drawArrow(int x1, int y1, int x2, int y2, double theta, int size, double factor, TransHopMeta transHop, Object startObject, Object endObject) {
        this.gc.drawLine(x1, y1, x2, y2);
        int mx = x1 + (x2 - x1) / 2;
        int my = y1 + (y2 - y1) / 2;
        int a = Math.abs(x2 - x1);
        int b = Math.abs(y2 - y1);
        int dist = (int)Math.sqrt(a * a + b * b);
        if (factor < 0.0) {
            factor = dist >= 2 * this.iconsize ? 1.3 : 1.2;
        }
        mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0);
        my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0);
        double angle = Math.atan2(y2 - y1, x2 - x1) + Math.PI;
        int x3 = (int)((double)mx + Math.cos(angle - theta) * (double)size);
        int y3 = (int)((double)my + Math.sin(angle - theta) * (double)size);
        int x4 = (int)((double)mx + Math.cos(angle + theta) * (double)size);
        int y4 = (int)((double)my + Math.sin(angle + theta) * (double)size);
        this.gc.switchForegroundBackgroundColors();
        this.gc.fillPolygon(new int[]{mx, my, x3, y3, x4, y4});
        this.gc.switchForegroundBackgroundColors();
        if (startObject instanceof StepMeta && endObject instanceof StepMeta) {
            Point bounds;
            StepIOMetaInterface ioMeta;
            boolean targetHop;
            factor = 0.8;
            StepMeta fs = (StepMeta)startObject;
            StepMeta ts = (StepMeta)endObject;
            mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0) - 8;
            my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0) - 8;
            boolean errorHop = fs.isSendingErrorRowsToStep(ts) || this.startErrorHopStep && fs.equals(this.startHopStep);
            boolean bl = targetHop = Const.indexOfString((String)ts.getName(), (String[])fs.getStepMetaInterface().getStepIOMeta().getTargetStepnames()) >= 0;
            if (targetHop) {
                ioMeta = fs.getStepMetaInterface().getStepIOMeta();
                StreamInterface targetStream = ioMeta.findTargetStream(ts);
                if (targetStream != null) {
                    PrimitiveGCInterface.EImage hopsIcon = BasePainter.getStreamIconImage(targetStream.getStreamIcon());
                    Point bounds2 = this.gc.getImageBounds(hopsIcon);
                    this.gc.drawImage(hopsIcon, mx, my);
                    if (!this.shadow) {
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_TARGET_HOP_ICON, mx, my, bounds2.x, bounds2.y, this.offset, fs, targetStream));
                    }
                }
            } else if (fs.isDistributes() && fs.getRowDistribution() != null && !ts.getStepPartitioningMeta().isMethodMirror() && !errorHop) {
                PrimitiveGCInterface.EImage eImage = fs.getRowDistribution().getDistributionImage();
                if (eImage != null) {
                    Point bounds3 = this.gc.getImageBounds(eImage);
                    this.gc.drawImage(eImage, mx, my);
                    if (!this.shadow) {
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.ROW_DISTRIBUTION_ICON, mx, my, bounds3.x, bounds3.y, this.offset, fs, STRING_ROW_DISTRIBUTION));
                    }
                    mx += 16;
                }
            } else if (!(fs.isDistributes() || ts.getStepPartitioningMeta().isMethodMirror() || errorHop)) {
                bounds = this.gc.getImageBounds(PrimitiveGCInterface.EImage.COPY_ROWS);
                this.gc.drawImage(PrimitiveGCInterface.EImage.COPY_ROWS, mx, my);
                if (!this.shadow) {
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.HOP_COPY_ICON, mx, my, bounds.x, bounds.y, this.offset, fs, STRING_HOP_TYPE_COPY));
                }
                mx += 16;
            }
            if (errorHop) {
                bounds = this.gc.getImageBounds(PrimitiveGCInterface.EImage.COPY_ROWS);
                this.gc.drawImage(PrimitiveGCInterface.EImage.ERROR, mx, my);
                if (!this.shadow) {
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.HOP_ERROR_ICON, mx, my, bounds.x, bounds.y, this.offset, fs, ts));
                }
                mx += 16;
            }
            ioMeta = ts.getStepMetaInterface().getStepIOMeta();
            String[] infoStepnames = ioMeta.getInfoStepnames();
            if (this.candidateHopType == StreamInterface.StreamType.INFO && ts.equals(this.endHopStep) && fs.equals(this.startHopStep) || Const.indexOfString((String)fs.getName(), (String[])infoStepnames) >= 0) {
                Point bounds4 = this.gc.getImageBounds(PrimitiveGCInterface.EImage.INFO);
                this.gc.drawImage(PrimitiveGCInterface.EImage.INFO, mx, my);
                if (!this.shadow) {
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.HOP_INFO_ICON, mx, my, bounds4.x, bounds4.y, this.offset, fs, ts));
                }
                mx += 16;
            }
            if (!Const.isEmpty((String[])infoStepnames)) {
                for (String infoStep : infoStepnames) {
                    if (!fs.getName().equalsIgnoreCase(infoStep) || fs.getCopies() <= 1) continue;
                    this.gc.drawImage(PrimitiveGCInterface.EImage.ERROR, mx, my);
                    if (!this.shadow) {
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.HOP_INFO_STEP_COPIES_ERROR, mx, my, 16, 16, this.offset, fs, ts));
                    }
                    mx += 16;
                }
            }
        }
        TransPainterExtension extension = new TransPainterExtension(this.gc, this.shadow, this.areaOwners, this.transMeta, null, transHop, x1, y1, x2, y2, mx, my, this.offset, this.iconsize);
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransPainterArrow.id, (Object)extension);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error calling extension point(s) for the transformation painter arrow", (Throwable)e);
        }
    }

    public float getTranslationX() {
        return this.translationX;
    }

    public void setTranslationX(float translationX) {
        this.translationX = translationX;
    }

    public float getTranslationY() {
        return this.translationY;
    }

    public void setTranslationY(float translationY) {
        this.translationY = translationY;
    }

    public Map<StepMeta, String> getStepLogMap() {
        return this.stepLogMap;
    }

    public void setStepLogMap(Map<StepMeta, String> stepLogMap) {
        this.stepLogMap = stepLogMap;
    }

    public void setStartHopStep(StepMeta startHopStep) {
        this.startHopStep = startHopStep;
    }

    public void setEndHopLocation(Point endHopLocation) {
        this.endHopLocation = endHopLocation;
    }

    public void setNoInputStep(StepMeta noInputStep) {
        this.noInputStep = noInputStep;
    }

    public void setEndHopStep(StepMeta endHopStep) {
        this.endHopStep = endHopStep;
    }

    public void setCandidateHopType(StreamInterface.StreamType candidateHopType) {
        this.candidateHopType = candidateHopType;
    }

    public void setStartErrorHopStep(boolean startErrorHopStep) {
        this.startErrorHopStep = startErrorHopStep;
    }

    public StepMeta getShowTargetStreamsStep() {
        return this.showTargetStreamsStep;
    }

    public void setShowTargetStreamsStep(StepMeta showTargetStreamsStep) {
        this.showTargetStreamsStep = showTargetStreamsStep;
    }
}

