/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.sql;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.jdbc.FieldVariableMapping;
import org.pentaho.di.core.jdbc.TransDataService;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.core.sql.ServiceCacheMethod;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.sql.SqlTransMeta;
import org.pentaho.di.trans.sql.TransDataCache;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;

public class SqlTransExecutor {
    private TransMeta serviceTransMeta;
    private String serviceStepName;
    private String sqlQuery;
    private TransMeta genTransMeta;
    private Trans serviceTrans;
    private Trans genTrans;
    private RowMetaInterface serviceFields;
    private List<TransDataService> services;
    private String serviceName;
    private TransDataService service;
    private SQL sql;
    private Repository repository;
    private RowMetaInterface resultStepFields;
    private int rowLimit;
    private Map<String, String> parameters;
    private List<String> parameterNames;
    private String resultStepName;
    private DecimalFormat sqlNumericFormat;
    private SimpleDateFormat sqlDateFormat;
    private SimpleDateFormat jsonDateFormat;
    private List<Object[]> serviceData;

    public SqlTransExecutor(String sqlQuery, List<TransDataService> services) throws KettleException {
        this(sqlQuery, services, new HashMap<String, String>(), null, 0);
    }

    public SqlTransExecutor(String sqlQuery, List<TransDataService> services, Map<String, String> parameters) throws KettleException {
        this(sqlQuery, services, parameters, null, 0);
    }

    public SqlTransExecutor(String sqlQuery, List<TransDataService> services, Map<String, String> parameters, Repository repository, int rowLimit) throws KettleException {
        this.sqlQuery = sqlQuery;
        this.services = services;
        this.parameters = parameters;
        this.repository = repository;
        this.rowLimit = rowLimit;
        this.sqlNumericFormat = new DecimalFormat("0.#");
        this.sqlNumericFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        this.sqlNumericFormat.setGroupingUsed(false);
        this.sqlDateFormat = new SimpleDateFormat("'\"'yyyy/MM/dd HH:mm:ss'\"'");
        this.jsonDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.prepareExecution();
    }

    private void prepareExecution() throws KettleException {
        this.sql = new SQL(this.sqlQuery);
        this.serviceName = this.sql.getServiceName();
        if (Const.isEmpty((String)this.serviceName) || "dual".equalsIgnoreCase(this.serviceName)) {
            this.service = new TransDataService("dual");
            this.service.setDual(true);
            this.serviceFields = new RowMeta();
        } else {
            this.service = this.findService(this.serviceName);
            if (this.service == null) {
                throw new KettleException("Unable to find service with name '" + this.service + "' and SQL: " + this.sqlQuery);
            }
            if (this.service.getCacheMethod() == ServiceCacheMethod.LocalMemory) {
                this.serviceFields = TransDataCache.getInstance().retrieveRowMeta(this.serviceName);
                if (this.serviceFields != null) {
                    this.serviceData = TransDataCache.getInstance().retrieveRowData(this.serviceName);
                    this.service = this.findService(this.serviceName);
                    if (this.service == null) {
                        throw new KettleException("Unable to find service with name '" + this.service + "' and SQL: " + this.sqlQuery);
                    }
                    this.service.setDual(true);
                }
            }
            if (this.serviceFields == null) {
                this.serviceTransMeta = this.loadTransMeta(this.repository);
                this.serviceTransMeta.setName(SqlTransExecutor.calculateTransname(this.sql, true));
                this.serviceTransMeta.activateParameters();
                this.serviceStepName = this.service.getServiceStepName();
                this.serviceFields = this.serviceTransMeta.getStepFields(this.serviceStepName);
            }
        }
    }

    private void setAutomaticParameterValues() throws UnknownParamException, KettleValueException {
        if (this.sql.getWhereCondition() == null) {
            return;
        }
        Condition condition = this.sql.getWhereCondition().getCondition();
        for (FieldVariableMapping mapping : this.service.getFieldVariableMappings()) {
            switch (mapping.getMappingType()) {
                case SQL_WHERE: {
                    String sql = "WHERE " + this.convertConditionToSql(condition);
                    this.serviceTransMeta.setParameterValue(mapping.getVariableName(), sql);
                    break;
                }
                case JSON_QUERY: {
                    String json = "{ " + this.convertConditionToJson(condition) + " }";
                    this.serviceTransMeta.setParameterValue(mapping.getVariableName(), json);
                    break;
                }
            }
        }
    }

    private String convertAtomicConditionToSql(Condition atomicCondition) throws KettleValueException {
        StringBuilder sql = new StringBuilder();
        String fieldName = atomicCondition.getLeftValuename();
        FieldVariableMapping mapping = FieldVariableMapping.findFieldVariableMappingByFieldName((List)this.service.getFieldVariableMappings(), (String)atomicCondition.getLeftValuename());
        if (mapping != null) {
            fieldName = mapping.getTargetName();
        }
        sql.append(fieldName).append(" ");
        switch (atomicCondition.getFunction()) {
            case 0: {
                sql.append("=");
                break;
            }
            case 1: {
                sql.append("<>");
                break;
            }
            case 4: {
                sql.append(">");
                break;
            }
            case 5: {
                sql.append(">=");
                break;
            }
            case 2: {
                sql.append("<");
                break;
            }
            case 3: {
                sql.append("<=");
                break;
            }
            case 7: {
                sql.append("IS NULL");
                break;
            }
            case 8: {
                sql.append("IS NOT NULL");
                break;
            }
            case 10: {
                sql.append("LIKE");
                break;
            }
        }
        sql.append(" ");
        sql.append(this.getAtomicConditionRightSql(atomicCondition));
        return sql.toString();
    }

    private String getAtomicConditionRightSql(Condition atomicCondition) throws KettleValueException {
        ValueMetaAndData right = atomicCondition.getRightExact();
        if (right == null) {
            String rightName = atomicCondition.getRightValuename();
            FieldVariableMapping mapping = FieldVariableMapping.findFieldVariableMappingByFieldName((List)this.service.getFieldVariableMappings(), (String)atomicCondition.getRightValuename());
            if (mapping != null) {
                rightName = mapping.getVariableName();
            }
            return rightName;
        }
        if (right.getValueMeta().isNull(right.getValueData())) {
            return "NULL";
        }
        switch (right.getValueMeta().getType()) {
            case 2: {
                return "'" + right.toString() + "'";
            }
            case 1: 
            case 5: 
            case 6: {
                return this.sqlNumericFormat.format(right.getValueMeta().convertToNormalStorageType(right.getValueData()));
            }
            case 3: {
                return this.sqlDateFormat.format(right.getValueMeta().getDate(right.getValueData()));
            }
            case 4: {
                return right.getValueMeta().getBoolean(right.getValueData()) != false ? "TRUE" : "FALSE";
            }
        }
        throw new KettleValueException("Unsupported conversion of value from " + right.getValueMeta().toStringMeta() + " to SQL");
    }

    protected String convertConditionToSql(Condition condition) throws KettleValueException {
        if (condition.isAtomic()) {
            return this.convertAtomicConditionToSql(condition);
        }
        StringBuilder sql = new StringBuilder();
        if (condition.isNegated()) {
            sql.append("NOT(");
        }
        for (int i = 0; i < condition.nrConditions(); ++i) {
            Condition c = condition.getCondition(i);
            if (i > 0) {
                sql.append(" ").append(c.getOperatorDesc());
            }
            sql.append("(");
            sql.append(this.convertConditionToSql(c));
            sql.append(")");
        }
        if (condition.isNegated()) {
            sql.append(")");
        }
        return sql.toString();
    }

    private String convertAtomicConditionToJson(Condition atomicCondition) throws KettleValueException {
        StringBuilder sql = new StringBuilder();
        if (atomicCondition.getRightValuename() != null) {
            throw new KettleValueException("Converting a condition that compares 2 fields is not yet supported in a JSON query");
        }
        String fieldName = atomicCondition.getLeftValuename();
        FieldVariableMapping mapping = FieldVariableMapping.findFieldVariableMappingByFieldName((List)this.service.getFieldVariableMappings(), (String)atomicCondition.getLeftValuename());
        if (mapping != null) {
            fieldName = mapping.getTargetName();
        }
        switch (atomicCondition.getFunction()) {
            case 0: {
                sql.append("'").append(fieldName).append("' : ").append(this.getJsonString(atomicCondition.getRightExact()));
                break;
            }
            case 1: {
                sql.append("'").append(fieldName).append("' : { '$ne' : ").append(this.getJsonString(atomicCondition.getRightExact())).append(" }");
                break;
            }
            case 4: {
                sql.append(">");
                sql.append("'").append(fieldName).append("' : { '$gt' : ").append(this.getJsonString(atomicCondition.getRightExact())).append(" }");
                break;
            }
            case 5: {
                sql.append(">");
                sql.append("'").append(fieldName).append("' : { '$gte' : ").append(this.getJsonString(atomicCondition.getRightExact())).append(" }");
                break;
            }
            case 2: {
                sql.append("<");
                sql.append(">");
                sql.append("'").append(fieldName).append("' : { '$lt' : ").append(this.getJsonString(atomicCondition.getRightExact())).append(" }");
                break;
            }
            case 3: {
                sql.append("<=");
                sql.append(">");
                sql.append("'").append(fieldName).append("' : { '$lte' : ").append(this.getJsonString(atomicCondition.getRightExact())).append(" }");
                break;
            }
            case 7: {
                sql.append("IS NULL");
                sql.append(">");
                sql.append("'").append(fieldName).append("' : \"\"");
                break;
            }
            case 8: {
                sql.append("'").append(fieldName).append("' : { '$ne' : ").append("\"\"").append(" }");
                break;
            }
            case 10: {
                sql.append("'").append(fieldName).append("' : { '$regex' : '.*").append(atomicCondition.getRightExactString()).append(".*', '$options' : 'i' }");
                break;
            }
        }
        return sql.toString();
    }

    protected String getJsonString(ValueMetaAndData v) throws KettleValueException {
        ValueMetaInterface meta = v.getValueMeta();
        Object data = v.getValueData();
        switch (meta.getType()) {
            case 2: {
                return '\"' + meta.getString(data) + '\"';
            }
            case 1: {
                return this.sqlNumericFormat.format(meta.getNumber(data));
            }
            case 5: {
                return this.sqlNumericFormat.format(meta.getInteger(data));
            }
            case 6: {
                return this.sqlNumericFormat.format(meta.getBigNumber(data));
            }
            case 3: {
                return "{ $date : \"" + this.jsonDateFormat.format(meta.getBigNumber(data)) + "\" }";
            }
        }
        throw new KettleValueException("Converting data type " + meta.toStringMeta() + " to a JSON value is not yet supported");
    }

    protected String convertConditionToJson(Condition condition) throws KettleValueException {
        if (condition.isAtomic()) {
            return this.convertAtomicConditionToJson(condition);
        }
        StringBuilder sql = new StringBuilder();
        if (condition.isNegated()) {
            throw new KettleValueException("Negated conditions can't be converted to JSON");
        }
        for (int i = 0; i < condition.nrConditions(); ++i) {
            Condition c = condition.getCondition(i);
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.convertConditionToJson(c));
        }
        return sql.toString();
    }

    protected void extractAtomicConditions(Condition condition, List<Condition> atomicConditions) {
        if (condition.isAtomic()) {
            atomicConditions.add(condition);
        } else {
            for (Condition sub : condition.getChildren()) {
                this.extractAtomicConditions(sub, atomicConditions);
            }
        }
    }

    private TransDataService findService(String name) {
        for (TransDataService s : this.services) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }

    private void extractConditionParameters(Condition condition, Map<String, String> map) {
        if (condition.isAtomic()) {
            if (condition.getFunction() == 14) {
                map.put(condition.getLeftValuename(), condition.getRightExactString());
            }
        } else {
            for (Condition sub : condition.getChildren()) {
                this.extractConditionParameters(sub, map);
            }
        }
    }

    public void executeQuery(RowListener resultRowListener) throws KettleException {
        this.sql.parse(this.serviceFields);
        this.parameterNames = new ArrayList<String>();
        if (!this.service.isDual()) {
            HashMap<String, String> conditionParameters = new HashMap<String, String>();
            if (this.sql.getWhereCondition() != null) {
                this.extractConditionParameters(this.sql.getWhereCondition().getCondition(), conditionParameters);
            }
            this.parameters.putAll(conditionParameters);
            for (String name : conditionParameters.keySet()) {
                this.serviceTransMeta.setParameterValue(name, (String)conditionParameters.get(name));
            }
            this.setAutomaticParameterValues();
            this.serviceTransMeta.activateParameters();
            this.serviceTrans = new Trans(this.serviceTransMeta);
            this.serviceTrans.prepareExecution(null);
            for (String parameterName : this.serviceTransMeta.listParameters()) {
                this.parameterNames.add(parameterName);
            }
        }
        SqlTransMeta sqlTransMeta = new SqlTransMeta(this.sql, this.rowLimit);
        this.genTransMeta = sqlTransMeta.generateTransMeta();
        this.resultStepName = sqlTransMeta.getResultStepName();
        this.genTrans = new Trans(this.genTransMeta);
        this.genTrans.prepareExecution(null);
        final ArrayList serviceRowsWhenCached = new ArrayList();
        if (!this.service.isDual()) {
            final RowProducer rowProducer = this.genTrans.addRowProducer(sqlTransMeta.getInjectorStepName(), 0);
            StepInterface serviceStep = this.serviceTrans.findRunThread(this.serviceStepName);
            serviceStep.addRowListener(new RowAdapter(){

                @Override
                public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    LogChannelInterface log = SqlTransExecutor.this.serviceTrans.getLogChannel();
                    try {
                        if (log.isRowLevel()) {
                            log.logRowlevel("Passing along row: " + rowMeta.getString(row));
                        }
                    }
                    catch (KettleValueException e) {
                        // empty catch block
                    }
                    rowProducer.putRow(rowMeta, row);
                    if (SqlTransExecutor.this.service.getCacheMethod() == ServiceCacheMethod.LocalMemory) {
                        serviceRowsWhenCached.add(row);
                    }
                }
            });
            this.serviceTrans.addTransListener(new TransAdapter(){

                @Override
                public void transFinished(Trans trans) throws KettleException {
                    rowProducer.finished();
                    if (SqlTransExecutor.this.service.getCacheMethod() == ServiceCacheMethod.LocalMemory) {
                        TransDataCache.getInstance().store(SqlTransExecutor.this.serviceName, SqlTransExecutor.this.serviceFields, serviceRowsWhenCached);
                    }
                }
            });
        }
        if (this.serviceData != null) {
            RowProducer rowProducer = this.genTrans.addRowProducer(sqlTransMeta.getInjectorStepName(), 0);
            for (Object[] row : this.serviceData) {
                rowProducer.putRow(this.serviceFields, row);
            }
            rowProducer.finished();
        }
        StepInterface resultStep = this.genTrans.findRunThread(sqlTransMeta.getResultStepName());
        resultStep.addRowListener(resultRowListener);
        this.resultStepFields = this.genTransMeta.getStepFields(sqlTransMeta.getResultStepName());
        this.genTrans.startThreads();
        if (!this.service.isDual()) {
            this.serviceTrans.startThreads();
        }
    }

    private TransMeta loadTransMeta(Repository repository) throws KettleException {
        TransMeta transMeta = null;
        if (!Const.isEmpty((String)this.service.getFileName())) {
            try {
                transMeta = new TransMeta(this.service.getFileName(), false);
                transMeta.getLogChannel().logDetailed("Service transformation was loaded from XML file [" + this.service.getFileName() + "]");
            }
            catch (Exception e) {
                throw new KettleException("Unable to load service transformation for service '" + this.serviceName + "'", (Throwable)e);
            }
        }
        try {
            transMeta = repository.loadTransformation(this.service.getObjectId(), null);
            transMeta.getLogChannel().logDetailed("Service transformation was loaded from repository for service [" + this.service.getName() + "]");
        }
        catch (Exception e) {
            throw new KettleException("Unable to load service transformation for service '" + this.serviceName + "' from the repository", (Throwable)e);
        }
        return transMeta;
    }

    public void waitUntilFinished() {
        if (!this.service.isDual()) {
            this.serviceTrans.waitUntilFinished();
        }
        this.genTrans.waitUntilFinished();
    }

    public TransMeta getServiceTransMeta() {
        return this.serviceTransMeta;
    }

    public String getServiceStepName() {
        return this.serviceStepName;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public TransMeta getGenTransMeta() {
        return this.genTransMeta;
    }

    public Trans getServiceTrans() {
        return this.serviceTrans;
    }

    public Trans getGenTrans() {
        return this.genTrans;
    }

    public RowMetaInterface getServiceFields() {
        return this.serviceFields;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RowMetaInterface getResultStepFields() {
        return this.resultStepFields;
    }

    public void setResultStepFields(RowMetaInterface resultStepFields) {
        this.resultStepFields = resultStepFields;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public static String calculateTransname(SQL sql, boolean isService) {
        StringBuilder sbsql = new StringBuilder(sql.getServiceName());
        sbsql.append(" - ");
        if (isService) {
            sbsql.append("Service");
        } else {
            sbsql.append("SQL");
        }
        sbsql.append(" - ");
        sbsql.append(sql.getSqlString());
        for (int i = sbsql.length() - 1; i >= 0; --i) {
            if (sbsql.charAt(i) != '\n' && sbsql.charAt(i) != '\r') continue;
            sbsql.setCharAt(i, ' ');
        }
        return sbsql.toString();
    }

    public List<TransDataService> getServices() {
        return this.services;
    }

    public void setServices(List<TransDataService> services) {
        this.services = services;
    }

    public SQL getSql() {
        return this.sql;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public String getResultStepName() {
        return this.resultStepName;
    }
}

