/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.calculator;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.calculator.Calculator;
import org.pentaho.di.trans.steps.calculator.CalculatorData;
import org.pentaho.di.trans.steps.calculator.CalculatorMetaFunction;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class CalculatorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = CalculatorMeta.class;
    private CalculatorMetaFunction[] calculation;

    public CalculatorMetaFunction[] getCalculation() {
        return this.calculation;
    }

    public void setCalculation(CalculatorMetaFunction[] calcTypes) {
        this.calculation = calcTypes;
    }

    public void allocate(int nrCalcs) {
        this.calculation = new CalculatorMetaFunction[nrCalcs];
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        int nrCalcs = XMLHandler.countNodes((Node)stepnode, (String)"calculation");
        this.allocate(nrCalcs);
        for (int i = 0; i < nrCalcs; ++i) {
            Node calcnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"calculation", (int)i);
            this.calculation[i] = new CalculatorMetaFunction(calcnode);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        if (this.calculation != null) {
            for (int i = 0; i < this.calculation.length; ++i) {
                retval.append("       ").append(this.calculation[i].getXML()).append(Const.CR);
            }
        }
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            CalculatorMeta m = (CalculatorMeta)obj;
            return this.getXML() == m.getXML();
        }
        return false;
    }

    @Override
    public Object clone() {
        CalculatorMeta retval = (CalculatorMeta)super.clone();
        if (this.calculation != null) {
            retval.allocate(this.calculation.length);
            for (int i = 0; i < this.calculation.length; ++i) {
                retval.getCalculation()[i] = (CalculatorMetaFunction)this.calculation[i].clone();
            }
        } else {
            retval.allocate(0);
        }
        return retval;
    }

    @Override
    public void setDefault() {
        this.calculation = new CalculatorMetaFunction[0];
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        int nrCalcs = rep.countNrStepAttributes(id_step, "field_name");
        this.allocate(nrCalcs);
        for (int i = 0; i < nrCalcs; ++i) {
            this.calculation[i] = new CalculatorMetaFunction(rep, id_step, i);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        for (int i = 0; i < this.calculation.length; ++i) {
            this.calculation[i].saveRep(rep, metaStore, id_transformation, id_step, i);
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.calculation.length; ++i) {
            CalculatorMetaFunction fn = this.calculation[i];
            if (fn.isRemovedFromResult() || Const.isEmpty((String)fn.getFieldName())) continue;
            ValueMetaInterface v = this.getValueMeta(fn, origin);
            row.addValueMeta(v);
        }
    }

    private ValueMetaInterface getValueMeta(CalculatorMetaFunction fn, String origin) {
        ValueMeta v = new ValueMeta(fn.getFieldName(), fn.getValueType());
        if (fn.getValueType() == 0) {
            int defaultResultType = 0;
            switch (fn.getCalcType()) {
                case 0: {
                    break;
                }
                case 3: {
                    defaultResultType = 1;
                    break;
                }
                case 4: {
                    defaultResultType = 1;
                    break;
                }
                case 5: {
                    defaultResultType = 1;
                    break;
                }
                case 6: {
                    defaultResultType = 1;
                    break;
                }
                case 7: {
                    defaultResultType = 1;
                    break;
                }
                case 8: {
                    defaultResultType = 1;
                    break;
                }
                case 9: {
                    defaultResultType = 1;
                    break;
                }
                case 10: {
                    defaultResultType = 1;
                    break;
                }
                case 11: {
                    defaultResultType = 1;
                    break;
                }
                case 12: {
                    defaultResultType = 1;
                    break;
                }
                case 13: {
                    defaultResultType = 1;
                    break;
                }
                case 14: {
                    defaultResultType = 5;
                    break;
                }
                case 15: {
                    defaultResultType = 1;
                    break;
                }
                case 16: {
                    defaultResultType = 5;
                    break;
                }
                case 17: {
                    defaultResultType = 1;
                    break;
                }
                case 1: {
                    defaultResultType = 2;
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    defaultResultType = 3;
                    break;
                }
                case 22: {
                    defaultResultType = 5;
                    break;
                }
                case 23: {
                    defaultResultType = 5;
                    break;
                }
                case 24: {
                    defaultResultType = 5;
                    break;
                }
                case 25: {
                    defaultResultType = 5;
                    break;
                }
                case 26: {
                    defaultResultType = 5;
                    break;
                }
                case 27: {
                    defaultResultType = 5;
                    break;
                }
                case 28: {
                    defaultResultType = 5;
                    break;
                }
                case 29: {
                    defaultResultType = 5;
                    break;
                }
                case 30: {
                    defaultResultType = 2;
                    break;
                }
                case 31: {
                    defaultResultType = 2;
                    break;
                }
                case 32: {
                    defaultResultType = 2;
                    break;
                }
                case 33: {
                    defaultResultType = 2;
                    break;
                }
                case 34: {
                    defaultResultType = 5;
                    break;
                }
                case 35: {
                    defaultResultType = 5;
                    break;
                }
                case 36: {
                    defaultResultType = 2;
                    break;
                }
                case 37: {
                    defaultResultType = 2;
                    break;
                }
                case 38: {
                    defaultResultType = 5;
                    break;
                }
                case 39: {
                    defaultResultType = 2;
                    break;
                }
                case 40: {
                    defaultResultType = 2;
                    break;
                }
                case 41: {
                    defaultResultType = 5;
                    break;
                }
                case 42: {
                    defaultResultType = 3;
                    break;
                }
                case 43: {
                    defaultResultType = 5;
                    break;
                }
                case 44: {
                    defaultResultType = 1;
                    break;
                }
                case 45: {
                    defaultResultType = 2;
                    break;
                }
                case 46: {
                    defaultResultType = 2;
                    break;
                }
                case 47: {
                    defaultResultType = 2;
                    break;
                }
                case 48: {
                    defaultResultType = 2;
                    break;
                }
                case 49: {
                    defaultResultType = 2;
                    break;
                }
                case 50: {
                    defaultResultType = 2;
                    break;
                }
                case 51: {
                    defaultResultType = 2;
                    break;
                }
                case 52: {
                    defaultResultType = 2;
                    break;
                }
                case 53: {
                    defaultResultType = 2;
                    break;
                }
                case 54: {
                    defaultResultType = 5;
                    break;
                }
                case 55: {
                    defaultResultType = 2;
                    break;
                }
                case 56: {
                    defaultResultType = 5;
                    break;
                }
                case 57: {
                    defaultResultType = 8;
                    break;
                }
                case 58: {
                    defaultResultType = 3;
                    break;
                }
                case 59: {
                    defaultResultType = 5;
                    break;
                }
                case 60: {
                    defaultResultType = 2;
                    break;
                }
                case 62: {
                    defaultResultType = 2;
                    break;
                }
                case 64: {
                    defaultResultType = 2;
                    break;
                }
                case 63: {
                    defaultResultType = 2;
                    break;
                }
                case 61: {
                    defaultResultType = 2;
                    break;
                }
                case 65: {
                    defaultResultType = 5;
                    break;
                }
                case 66: {
                    defaultResultType = 3;
                    break;
                }
                case 67: {
                    defaultResultType = 4;
                    break;
                }
                case 68: {
                    defaultResultType = 4;
                    break;
                }
                case 69: {
                    defaultResultType = 2;
                    break;
                }
                case 70: {
                    defaultResultType = 5;
                    break;
                }
                case 71: {
                    defaultResultType = 5;
                    break;
                }
                case 72: {
                    defaultResultType = 1;
                    break;
                }
                case 73: {
                    defaultResultType = 1;
                    break;
                }
                case 74: {
                    defaultResultType = 2;
                    break;
                }
                case 75: {
                    defaultResultType = 2;
                    break;
                }
                case 18: {
                    defaultResultType = 5;
                    break;
                }
                case 19: {
                    defaultResultType = 5;
                    break;
                }
                case 82: {
                    defaultResultType = 5;
                    break;
                }
                case 83: {
                    defaultResultType = 5;
                    break;
                }
                case 84: {
                    defaultResultType = 5;
                    break;
                }
            }
            v = new ValueMeta(fn.getFieldName(), defaultResultType);
        }
        v.setLength(fn.getValueLength());
        v.setPrecision(fn.getValuePrecision());
        v.setOrigin(origin);
        v.setComments(fn.getCalcTypeDesc());
        v.setConversionMask(fn.getConversionMask());
        v.setDecimalSymbol(fn.getDecimalSymbol());
        v.setGroupingSymbol(fn.getGroupingSymbol());
        v.setCurrencySymbol(fn.getCurrencySymbol());
        return v;
    }

    public RowMetaInterface getAllFields(RowMetaInterface inputRowMeta) {
        RowMetaInterface rowMeta = inputRowMeta.clone();
        for (int i = 0; i < this.calculation.length; ++i) {
            CalculatorMetaFunction fn = this.calculation[i];
            if (Const.isEmpty((String)fn.getFieldName())) continue;
            ValueMetaInterface v = this.getValueMeta(fn, null);
            rowMeta.addValueMeta(v);
        }
        return rowMeta;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = null;
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CalculatorMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            if (prev == null || prev.size() == 0) {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"CalculatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CalculatorMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CalculatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Calculator(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CalculatorData();
    }
}

