/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.checksum;

import java.security.MessageDigest;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.apache.commons.codec.binary.Hex;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.checksum.CheckSumData;
import org.pentaho.di.trans.steps.checksum.CheckSumMeta;

public class CheckSum
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CheckSumMeta.class;
    private CheckSumMeta meta;
    private CheckSumData data;

    public CheckSum(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block19: {
            this.meta = (CheckSumMeta)smi;
            this.data = (CheckSumData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.data.nrInfields = this.data.outputRowMeta.size();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (this.meta.getFieldName() == null || this.meta.getFieldName().length > 0) {
                    this.data.fieldnrs = new int[this.meta.getFieldName().length];
                    for (i = 0; i < this.meta.getFieldName().length; ++i) {
                        this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldName()[i]);
                        if (this.data.fieldnrs[i] >= 0) continue;
                        this.logError(BaseMessages.getString(PKG, (String)"CheckSum.Log.CanNotFindField", (String[])new String[]{this.meta.getFieldName()[i]}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"CheckSum.Log.CanNotFindField", (String[])new String[]{this.meta.getFieldName()[i]}));
                    }
                } else {
                    this.data.fieldnrs = new int[r.length];
                    for (i = 0; i < r.length; ++i) {
                        this.data.fieldnrs[i] = i;
                    }
                }
                this.data.fieldnr = this.data.fieldnrs.length;
                try {
                    if (this.meta.getCheckSumType().equals("MD5") || this.meta.getCheckSumType().equals("SHA-1")) {
                        this.data.digest = MessageDigest.getInstance(this.meta.getCheckSumType());
                    }
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"CheckSum.Error.Digest", (String[])new String[0]), (Throwable)e);
                }
            }
            Object[] outputRowData = null;
            try {
                if (this.meta.getCheckSumType().equals("ADLER32") || this.meta.getCheckSumType().equals("CRC32")) {
                    Long checksum = this.calculCheckSum(r);
                    outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.data.nrInfields, (Object)checksum);
                } else {
                    byte[] o = this.createCheckSum(r);
                    switch (this.meta.getResultType()) {
                        case 2: {
                            outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.data.nrInfields, (Object)o);
                            break;
                        }
                        case 1: {
                            String hex = this.meta.isCompatibilityMode() ? this.byteToHexEncode_compatible(o) : new String(Hex.encodeHex((byte[])o));
                            outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.data.nrInfields, (Object)hex);
                            break;
                        }
                        default: {
                            outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.data.nrInfields, (Object)CheckSum.getStringFromBytes(o));
                        }
                    }
                }
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"CheckSum.Log.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"CheckSum.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block19;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "CheckSum001");
            }
        }
        return true;
    }

    private byte[] createCheckSum(Object[] r) throws Exception {
        StringBuffer Buff = new StringBuffer();
        for (int i = 0; i < this.data.fieldnr; ++i) {
            String fieldvalue = this.getInputRowMeta().getString(r, this.data.fieldnrs[i]);
            Buff.append(fieldvalue);
        }
        this.data.digest.update(Buff.toString().getBytes());
        byte[] hash = this.data.digest.digest();
        return hash;
    }

    private static String getStringFromBytes(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public String byteToHexEncode_compatible(byte[] in) {
        if (in == null) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String hex = new String(in);
        char[] s = hex.toCharArray();
        StringBuffer hexString = new StringBuffer(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        return hexString.toString();
    }

    private Long calculCheckSum(Object[] r) throws Exception {
        Long retval;
        StringBuffer Buff = new StringBuffer();
        for (int i = 0; i < this.data.fieldnr; ++i) {
            String fieldvalue = this.getInputRowMeta().getString(r, this.data.fieldnrs[i]);
            Buff.append(fieldvalue);
        }
        if (this.meta.getCheckSumType().equals("CRC32")) {
            CRC32 crc32 = new CRC32();
            crc32.update(Buff.toString().getBytes());
            retval = new Long(crc32.getValue());
        } else {
            Adler32 adler32 = new Adler32();
            adler32.update(Buff.toString().getBytes());
            retval = new Long(adler32.getValue());
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CheckSumMeta)smi;
        this.data = (CheckSumData)sdi;
        if (super.init(smi, sdi)) {
            if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"CheckSum.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            return true;
        }
        return false;
    }
}

