/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookup;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class DatabaseLookupMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = DatabaseLookupMeta.class;
    public static final String[] conditionStrings = new String[]{"=", "<>", "<", "<=", ">", ">=", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL"};
    public static final int CONDITION_EQ = 0;
    public static final int CONDITION_NE = 1;
    public static final int CONDITION_LT = 2;
    public static final int CONDITION_LE = 3;
    public static final int CONDITION_GT = 4;
    public static final int CONDITION_GE = 5;
    public static final int CONDITION_LIKE = 6;
    public static final int CONDITION_BETWEEN = 7;
    public static final int CONDITION_IS_NULL = 8;
    public static final int CONDITION_IS_NOT_NULL = 9;
    private String schemaName;
    private String tablename;
    private DatabaseMeta databaseMeta;
    private String[] streamKeyField1;
    private String[] streamKeyField2;
    private String[] keyCondition;
    private String[] tableKeyField;
    private String[] returnValueField;
    private String[] returnValueNewName;
    private String[] returnValueDefault;
    private int[] returnValueDefaultType;
    private String orderByClause;
    private boolean cached;
    private int cacheSize;
    private boolean loadingAllDataInCache;
    private boolean failingOnMultipleResults;
    private boolean eatingRowOnLookupFailure;

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String[] getReturnValueDefault() {
        return this.returnValueDefault;
    }

    public void setReturnValueDefault(String[] returnValueDefault) {
        this.returnValueDefault = returnValueDefault;
    }

    public int[] getReturnValueDefaultType() {
        return this.returnValueDefaultType;
    }

    public void setReturnValueDefaultType(int[] returnValueDefaultType) {
        this.returnValueDefaultType = returnValueDefaultType;
    }

    public String[] getReturnValueField() {
        return this.returnValueField;
    }

    public void setReturnValueField(String[] returnValueField) {
        this.returnValueField = returnValueField;
    }

    public String[] getReturnValueNewName() {
        return this.returnValueNewName;
    }

    public void setReturnValueNewName(String[] returnValueNewName) {
        this.returnValueNewName = returnValueNewName;
    }

    public String[] getStreamKeyField1() {
        return this.streamKeyField1;
    }

    public void setStreamKeyField1(String[] streamKeyField1) {
        this.streamKeyField1 = streamKeyField1;
    }

    public String[] getStreamKeyField2() {
        return this.streamKeyField2;
    }

    public void setStreamKeyField2(String[] streamKeyField2) {
        this.streamKeyField2 = streamKeyField2;
    }

    public String[] getTableKeyField() {
        return this.tableKeyField;
    }

    public void setTableKeyField(String[] tableKeyField) {
        this.tableKeyField = tableKeyField;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public boolean isFailingOnMultipleResults() {
        return this.failingOnMultipleResults;
    }

    public void setFailingOnMultipleResults(boolean failOnMultipleResults) {
        this.failingOnMultipleResults = failOnMultipleResults;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.streamKeyField1 = null;
        this.returnValueField = null;
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.streamKeyField1 = new String[nrkeys];
        this.tableKeyField = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.streamKeyField2 = new String[nrkeys];
        this.returnValueField = new String[nrvalues];
        this.returnValueNewName = new String[nrvalues];
        this.returnValueDefault = new String[nrvalues];
        this.returnValueDefaultType = new int[nrvalues];
    }

    @Override
    public Object clone() {
        int i;
        DatabaseLookupMeta retval = (DatabaseLookupMeta)super.clone();
        int nrkeys = this.streamKeyField1.length;
        int nrvalues = this.returnValueField.length;
        retval.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            retval.streamKeyField1[i] = this.streamKeyField1[i];
            retval.tableKeyField[i] = this.tableKeyField[i];
            retval.keyCondition[i] = this.keyCondition[i];
            retval.streamKeyField2[i] = this.streamKeyField2[i];
        }
        for (i = 0; i < nrvalues; ++i) {
            retval.returnValueField[i] = this.returnValueField[i];
            retval.returnValueNewName[i] = this.returnValueNewName[i];
            retval.returnValueDefault[i] = this.returnValueDefault[i];
            retval.returnValueDefaultType[i] = this.returnValueDefaultType[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            int i;
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.cached = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"cache"));
            this.loadingAllDataInCache = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"cache_load_all"));
            String csize = XMLHandler.getTagValue((Node)stepnode, (String)"cache_size");
            this.cacheSize = Const.toInt((String)csize, (int)0);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"schema");
            this.tablename = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"table");
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XMLHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.streamKeyField1[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.tableKeyField[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
                this.keyCondition[i] = XMLHandler.getTagValue((Node)knode, (String)"condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.streamKeyField2[i] = XMLHandler.getTagValue((Node)knode, (String)"name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.returnValueField[i] = XMLHandler.getTagValue((Node)vnode, (String)"name");
                this.returnValueNewName[i] = XMLHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.returnValueNewName[i] == null) {
                    this.returnValueNewName[i] = this.returnValueField[i];
                }
                this.returnValueDefault[i] = XMLHandler.getTagValue((Node)vnode, (String)"default");
                String dtype = XMLHandler.getTagValue((Node)vnode, (String)"type");
                this.returnValueDefaultType[i] = ValueMeta.getType((String)dtype);
                if (this.returnValueDefaultType[i] >= 0) continue;
                this.returnValueDefaultType[i] = 2;
            }
            this.orderByClause = XMLHandler.getTagValue((Node)lookup, (String)"orderby");
            this.failingOnMultipleResults = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)lookup, (String)"fail_on_multiple"));
            this.eatingRowOnLookupFailure = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)lookup, (String)"eat_row_on_failure"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.ERROR0001.UnableToLoadStepFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.streamKeyField1 = null;
        this.returnValueField = null;
        this.databaseMeta = null;
        this.cached = false;
        this.cacheSize = 0;
        this.schemaName = "";
        this.tablename = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Default.TableName", (String[])new String[0]);
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.tableKeyField[i] = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Default.KeyFieldPrefix", (String[])new String[0]);
            this.keyCondition[i] = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Default.KeyCondition", (String[])new String[0]);
            this.streamKeyField1[i] = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Default.KeyStreamField1", (String[])new String[0]);
            this.streamKeyField2[i] = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Default.KeyStreamField2", (String[])new String[0]);
        }
        for (i = 0; i < nrvalues; ++i) {
            this.returnValueField[i] = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Default.ReturnFieldPrefix", (String[])new String[0]) + i;
            this.returnValueNewName[i] = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Default.ReturnNewNamePrefix", (String[])new String[0]) + i;
            this.returnValueDefault[i] = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Default.ReturnDefaultValuePrefix", (String[])new String[0]) + i;
            this.returnValueDefaultType[i] = 2;
        }
        this.orderByClause = "";
        this.failingOnMultipleResults = false;
        this.eatingRowOnLookupFailure = false;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (Const.isEmpty((Object[])info) || info[0] == null) {
            for (int i = 0; i < this.returnValueNewName.length; ++i) {
                try {
                    ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)this.returnValueNewName[i], (int)this.returnValueDefaultType[i]);
                    v.setOrigin(name);
                    row.addValueMeta(v);
                    continue;
                }
                catch (Exception e) {
                    throw new KettleStepException((Throwable)e);
                }
            }
        } else {
            for (int i = 0; i < this.returnValueNewName.length; ++i) {
                ValueMetaInterface v = info[0].searchValueMeta(this.returnValueField[i]);
                if (v == null) continue;
                v.setName(this.returnValueNewName[i]);
                v.setOrigin(name);
                row.addValueMeta(v);
            }
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"cache", (boolean)this.cached));
        retval.append("    ").append(XMLHandler.addTagValue((String)"cache_load_all", (boolean)this.loadingAllDataInCache));
        retval.append("    ").append(XMLHandler.addTagValue((String)"cache_size", (int)this.cacheSize));
        retval.append("    <lookup>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"table", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"orderby", (String)this.orderByClause));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fail_on_multiple", (boolean)this.failingOnMultipleResults));
        retval.append("      ").append(XMLHandler.addTagValue((String)"eat_row_on_failure", (boolean)this.eatingRowOnLookupFailure));
        for (i = 0; i < this.streamKeyField1.length; ++i) {
            retval.append("      <key>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.streamKeyField1[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.tableKeyField[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"condition", (String)this.keyCondition[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name2", (String)this.streamKeyField2[i]));
            retval.append("      </key>").append(Const.CR);
        }
        for (i = 0; i < this.returnValueField.length; ++i) {
            retval.append("      <value>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.returnValueField[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"rename", (String)this.returnValueNewName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"default", (String)this.returnValueDefault[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.returnValueDefaultType[i])));
            retval.append("      </value>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.cached = rep.getStepAttributeBoolean(id_step, "cache");
            this.loadingAllDataInCache = rep.getStepAttributeBoolean(id_step, "cache_load_all");
            this.cacheSize = (int)rep.getStepAttributeInteger(id_step, "cache_size");
            this.schemaName = rep.getStepAttributeString(id_step, "lookup_schema");
            this.tablename = rep.getStepAttributeString(id_step, "lookup_table");
            this.orderByClause = rep.getStepAttributeString(id_step, "lookup_orderby");
            this.failingOnMultipleResults = rep.getStepAttributeBoolean(id_step, "fail_on_multiple");
            this.eatingRowOnLookupFailure = rep.getStepAttributeBoolean(id_step, "eat_row_on_failure");
            int nrkeys = rep.countNrStepAttributes(id_step, "lookup_key_field");
            int nrvalues = rep.countNrStepAttributes(id_step, "return_value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.streamKeyField1[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name");
                this.tableKeyField[i] = rep.getStepAttributeString(id_step, i, "lookup_key_field");
                this.keyCondition[i] = rep.getStepAttributeString(id_step, i, "lookup_key_condition");
                this.streamKeyField2[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.returnValueField[i] = rep.getStepAttributeString(id_step, i, "return_value_name");
                this.returnValueNewName[i] = rep.getStepAttributeString(id_step, i, "return_value_rename");
                this.returnValueDefault[i] = rep.getStepAttributeString(id_step, i, "return_value_default");
                this.returnValueDefaultType[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "return_value_type"));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.ERROR0002.UnexpectedErrorReadingFromTheRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "cache", this.cached);
            rep.saveStepAttribute(id_transformation, id_step, "cache_load_all", this.loadingAllDataInCache);
            rep.saveStepAttribute(id_transformation, id_step, "cache_size", this.cacheSize);
            rep.saveStepAttribute(id_transformation, id_step, "lookup_schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "lookup_table", this.tablename);
            rep.saveStepAttribute(id_transformation, id_step, "lookup_orderby", this.orderByClause);
            rep.saveStepAttribute(id_transformation, id_step, "fail_on_multiple", this.failingOnMultipleResults);
            rep.saveStepAttribute(id_transformation, id_step, "eat_row_on_failure", this.eatingRowOnLookupFailure);
            for (i = 0; i < this.streamKeyField1.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_name", this.streamKeyField1[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_field", this.tableKeyField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_condition", this.keyCondition[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_name2", this.streamKeyField2[i]);
            }
            for (i = 0; i < this.returnValueField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_name", this.returnValueField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_rename", this.returnValueNewName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_default", this.returnValueDefault[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_type", ValueMeta.getTypeDesc((int)this.returnValueDefaultType[i]));
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.ERROR0003.UnableToSaveStepToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            this.databases = new Database[]{db};
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (!Const.isEmpty((String)this.tablename)) {
                    first = true;
                    error_found = false;
                    error_message = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(db.environmentSubstitute(this.schemaName), db.environmentSubstitute(this.tablename));
                    RowMetaInterface r = db.getTableFields(schemaTable);
                    if (r != null) {
                        ValueMetaInterface v;
                        String lufield;
                        int i;
                        for (i = 0; i < this.tableKeyField.length; ++i) {
                            lufield = this.tableKeyField[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingCompareFieldsInLookupTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.AllLookupFieldsFoundInTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        for (i = 0; i < this.returnValueField.length; ++i) {
                            lufield = this.returnValueField[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingReturnFieldsInLookupTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.AllReturnFieldsFoundInTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (int i = 0; i < this.streamKeyField1.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.streamKeyField1[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingFieldsNotFoundInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.streamKeyField1[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.CouldNotReadFromPreviousSteps", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleDatabaseException dbe) {
                error_message = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.DatabaseErrorWhileChecking", (String[])new String[0]) + dbe.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingConnectionError", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.StepIsReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowMetaInterface getTableFields() {
        RowMetaInterface fields = null;
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                String tableName = this.databaseMeta.environmentSubstitute(this.tablename);
                String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, tableName);
                fields = db.getTableFields(schemaTable);
            }
            catch (KettleDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.ERROR0004.ErrorGettingTableFields", (String[])new String[0]) + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new DatabaseLookup(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DatabaseLookupData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) {
        int i;
        for (i = 0; i < this.streamKeyField1.length; ++i) {
            ValueMetaInterface v = prev.searchValueMeta(this.streamKeyField1[i]);
            DatabaseImpact ii = new DatabaseImpact(1, transMeta.getName(), stepinfo.getName(), this.databaseMeta.getDatabaseName(), this.tablename, this.tableKeyField[i], this.streamKeyField1[i], v != null ? v.getOrigin() : "?", "", BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Impact.Key", (String[])new String[0]));
            impact.add(ii);
        }
        for (i = 0; i < this.returnValueField.length; ++i) {
            DatabaseImpact ii = new DatabaseImpact(1, transMeta.getName(), stepinfo.getName(), this.databaseMeta.getDatabaseName(), this.tablename, this.returnValueField[i], "", "", "", BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Impact.ReturnValue", (String[])new String[0]));
            impact.add(ii);
        }
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isEatingRowOnLookupFailure() {
        return this.eatingRowOnLookupFailure;
    }

    public void setEatingRowOnLookupFailure(boolean eatingRowOnLookupFailure) {
        this.eatingRowOnLookupFailure = eatingRowOnLookupFailure;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean isLoadingAllDataInCache() {
        return this.loadingAllDataInCache;
    }

    public void setLoadingAllDataInCache(boolean loadingAllDataInCache) {
        this.loadingAllDataInCache = loadingAllDataInCache;
    }
}

