/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.datagrid;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.datagrid.DataGrid;
import org.pentaho.di.trans.steps.datagrid.DataGridData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class DataGridMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] currency;
    private String[] decimal;
    private String[] group;
    private String[] fieldName;
    private String[] fieldType;
    private String[] fieldFormat;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private boolean[] setEmptyString;
    private List<List<String>> dataLines;

    public boolean[] isSetEmptyString() {
        return this.setEmptyString;
    }

    public void setEmptyString(boolean[] setEmptyString) {
        this.setEmptyString = setEmptyString;
    }

    public String[] getCurrency() {
        return this.currency;
    }

    public void setCurrency(String[] currency) {
        this.currency = currency;
    }

    public String[] getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String[] decimal) {
        this.decimal = decimal;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getGroup() {
        return this.group;
    }

    public void setGroup(String[] group) {
        this.group = group;
    }

    public List<List<String>> getDataLines() {
        return this.dataLines;
    }

    public void setDataLines(List<List<String>> dataLines) {
        this.dataLines = dataLines;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldType = new String[nrfields];
        this.fieldFormat = new String[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
        this.currency = new String[nrfields];
        this.decimal = new String[nrfields];
        this.group = new String[nrfields];
        this.setEmptyString = new boolean[nrfields];
    }

    @Override
    public Object clone() {
        DataGridMeta retval = (DataGridMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
            retval.fieldFormat[i] = this.fieldFormat[i];
            retval.currency[i] = this.currency[i];
            retval.decimal[i] = this.decimal[i];
            retval.group[i] = this.group[i];
            retval.fieldLength[i] = this.fieldLength[i];
            retval.fieldPrecision[i] = this.fieldPrecision[i];
            retval.setEmptyString[i] = this.setEmptyString[i];
        }
        retval.setDataLines(new ArrayList<List<String>>());
        for (List<String> line : this.dataLines) {
            ArrayList<String> newLine = new ArrayList<String>();
            newLine.addAll(line);
            retval.getDataLines().add(newLine);
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldType[i] = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldFormat[i] = XMLHandler.getTagValue((Node)fnode, (String)"format");
                this.currency[i] = XMLHandler.getTagValue((Node)fnode, (String)"currency");
                this.decimal[i] = XMLHandler.getTagValue((Node)fnode, (String)"decimal");
                this.group[i] = XMLHandler.getTagValue((Node)fnode, (String)"group");
                String slength = XMLHandler.getTagValue((Node)fnode, (String)"length");
                String sprecision = XMLHandler.getTagValue((Node)fnode, (String)"precision");
                this.fieldLength[i] = Const.toInt((String)slength, (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)sprecision, (int)-1);
                String emptyString = XMLHandler.getTagValue((Node)fnode, (String)"set_empty_string");
                this.setEmptyString[i] = !Const.isEmpty((String)emptyString) && "Y".equalsIgnoreCase(emptyString);
            }
            Node datanode = XMLHandler.getSubNode((Node)stepnode, (String)"data");
            this.dataLines = new ArrayList<List<String>>();
            for (Node lineNode = datanode.getFirstChild(); lineNode != null; lineNode = lineNode.getNextSibling()) {
                if (!"line".equals(lineNode.getNodeName())) continue;
                ArrayList<String> line = new ArrayList<String>();
                for (Node itemNode = lineNode.getFirstChild(); itemNode != null; itemNode = itemNode.getNextSibling()) {
                    if (!"item".equals(itemNode.getNodeName())) continue;
                    line.add(XMLHandler.getNodeValue((Node)itemNode));
                }
                this.dataLines.add(line);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
        DecimalFormat decimalFormat = new DecimalFormat();
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = "Number";
            this.fieldFormat[i] = "\u00a40,000,000.00;\u00a4-0,000,000.00";
            this.fieldLength[i] = 9;
            this.fieldPrecision[i] = 2;
            this.currency[i] = decimalFormat.getDecimalFormatSymbols().getCurrencySymbol();
            this.decimal[i] = new String(new char[]{decimalFormat.getDecimalFormatSymbols().getDecimalSeparator()});
            this.group[i] = new String(new char[]{decimalFormat.getDecimalFormatSymbols().getGroupingSeparator()});
            this.setEmptyString[i] = false;
        }
        this.dataLines = new ArrayList<List<String>>();
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            try {
                if (Const.isEmpty((String)this.fieldName[i])) continue;
                int type = ValueMeta.getType((String)this.fieldType[i]);
                if (type == 0) {
                    type = 2;
                }
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)this.fieldName[i], (int)type);
                v.setLength(this.fieldLength[i]);
                v.setPrecision(this.fieldPrecision[i]);
                v.setOrigin(name);
                v.setConversionMask(this.fieldFormat[i]);
                v.setCurrencySymbol(this.currency[i]);
                v.setGroupingSymbol(this.group[i]);
                v.setDecimalSymbol(this.decimal[i]);
                rowMeta.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException("Unable to create value of type " + this.fieldType[i], (Throwable)e);
            }
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.fieldType[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.fieldFormat[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.currency[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.decimal[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.group[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"set_empty_string", (boolean)this.setEmptyString[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    <data>").append(Const.CR);
        for (List<String> line : this.dataLines) {
            retval.append("      <line> ");
            for (String item : line) {
                retval.append(XMLHandler.addTagValue((String)"item", (String)item, (boolean)false, (String[])new String[0]));
            }
            retval.append(" </line>").append(Const.CR);
        }
        retval.append("    </data>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(idStep, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(idStep, i, "field_name");
                this.fieldType[i] = rep.getStepAttributeString(idStep, i, "field_type");
                this.fieldFormat[i] = rep.getStepAttributeString(idStep, i, "field_format");
                this.currency[i] = rep.getStepAttributeString(idStep, i, "field_currency");
                this.decimal[i] = rep.getStepAttributeString(idStep, i, "field_decimal");
                this.group[i] = rep.getStepAttributeString(idStep, i, "field_group");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(idStep, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(idStep, i, "field_precision");
                this.setEmptyString[i] = rep.getStepAttributeBoolean(idStep, i, "set_empty_string", false);
            }
            int nrLines = (int)rep.getStepAttributeInteger(idStep, "nr_lines");
            this.dataLines = new ArrayList<List<String>>();
            for (int i = 0; i < nrLines; ++i) {
                ArrayList<String> line = new ArrayList<String>();
                for (int f = 0; f < nrfields; ++f) {
                    String item = rep.getStepAttributeString(idStep, i, "item_" + f);
                    line.add(item);
                }
                this.dataLines.add(line);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                rep.saveStepAttribute(idTransformation, idStep, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(idTransformation, idStep, i, "field_type", this.fieldType[i]);
                rep.saveStepAttribute(idTransformation, idStep, i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(idTransformation, idStep, i, "field_currency", this.currency[i]);
                rep.saveStepAttribute(idTransformation, idStep, i, "field_decimal", this.decimal[i]);
                rep.saveStepAttribute(idTransformation, idStep, i, "field_group", this.group[i]);
                rep.saveStepAttribute(idTransformation, idStep, i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(idTransformation, idStep, i, "field_precision", this.fieldPrecision[i]);
                rep.saveStepAttribute(idTransformation, idStep, i, "set_empty_string", this.setEmptyString[i]);
            }
            rep.saveStepAttribute(idTransformation, idStep, "nr_lines", this.dataLines.size());
            for (i = 0; i < this.dataLines.size(); ++i) {
                List<String> line = this.dataLines.get(i);
                for (int f = 0; f < line.size(); ++f) {
                    String item = line.get(f);
                    rep.saveStepAttribute(idTransformation, idStep, i, "item_" + f, item);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + idStep, (Throwable)e);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new DataGrid(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DataGridData();
    }
}

