/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterData;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;

public class FieldSplitter
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = FieldSplitterMeta.class;
    private FieldSplitterMeta meta;
    private FieldSplitterData data;

    public FieldSplitter(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] splitField(Object[] r) throws KettleException {
        int i;
        if (this.first) {
            this.first = false;
            this.data.previousMeta = this.getInputRowMeta().clone();
            this.data.fieldnr = this.data.previousMeta.indexOfValue(this.meta.getSplitField());
            if (this.data.fieldnr < 0) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.CouldNotFindFieldToSplit", (String[])new String[]{this.meta.getSplitField()}));
            }
            if (!this.data.previousMeta.getValueMeta(this.data.fieldnr).isString()) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitFieldNotValid", (String[])new String[]{this.meta.getSplitField()}));
            }
            this.data.outputMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.conversionMeta = this.data.outputMeta.cloneToType(2);
            this.data.delimiter = this.environmentSubstitute(this.meta.getDelimiter());
            this.data.enclosure = this.environmentSubstitute(this.meta.getEnclosure());
        }
        String v = this.data.previousMeta.getString(r, this.data.fieldnr);
        Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputMeta.size());
        int nrExtraFields = this.meta.getFieldID().length - 1;
        for (i = 0; i < this.data.fieldnr; ++i) {
            outputRow[i] = r[i];
        }
        for (i = this.data.fieldnr + 1; i < this.data.previousMeta.size(); ++i) {
            outputRow[i + nrExtraFields] = r[i];
        }
        boolean use_ids = this.meta.getFieldID().length > 0 && this.meta.getFieldID()[0] != null && this.meta.getFieldID()[0].length() > 0;
        Object value = null;
        String[] splits = Const.splitString((String)v, (String)this.data.delimiter, (String)this.data.enclosure);
        if (use_ids) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.UsingIds", (String[])new String[0]));
            }
            for (int i2 = 0; i2 < this.meta.getFieldName().length; ++i2) {
                String split;
                String string = split = splits == null || i2 >= splits.length ? null : splits[i2];
                if (split != null && this.meta.getFieldRemoveID()[i2]) {
                    StringBuilder sb = new StringBuilder(split);
                    int idx = sb.indexOf(this.meta.getFieldID()[i2]);
                    sb.delete(idx, idx + this.meta.getFieldID()[i2].length());
                    split = sb.toString();
                }
                if (split == null) {
                    split = "";
                }
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitInfo", (String[])new String[0]) + split);
                }
                try {
                    ValueMetaInterface valueMeta = this.data.outputMeta.getValueMeta(this.data.fieldnr + i2);
                    ValueMetaInterface conversionValueMeta = this.data.conversionMeta.getValueMeta(this.data.fieldnr + i2);
                    value = valueMeta.convertDataFromString(split, conversionValueMeta, this.meta.getFieldNullIf()[i2], this.meta.getFieldIfNull()[i2], this.meta.getFieldTrimType()[i2]);
                }
                catch (Exception e) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.ErrorConvertingSplitValue", (String[])new String[]{split, this.meta.getSplitField() + "]!"}), (Throwable)e);
                }
                outputRow[this.data.fieldnr + i2] = value;
            }
        } else {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.UsingPositionOfValue", (String[])new String[0]));
            }
            int prev = 0;
            for (int i3 = 0; i3 < this.meta.getFieldName().length; ++i3) {
                String pol;
                String string = pol = splits == null || i3 >= splits.length ? null : splits[i3];
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitFieldsInfo", (String[])new String[]{pol, String.valueOf(prev)}));
                }
                prev += (pol == null ? 0 : pol.length()) + this.data.delimiter.length();
                try {
                    ValueMetaInterface valueMeta = this.data.outputMeta.getValueMeta(this.data.fieldnr + i3);
                    ValueMetaInterface conversionValueMeta = this.data.conversionMeta.getValueMeta(this.data.fieldnr + i3);
                    value = valueMeta.convertDataFromString(pol, conversionValueMeta, this.meta.getFieldNullIf()[i3], this.meta.getFieldIfNull()[i3], this.meta.getFieldTrimType()[i3]);
                }
                catch (Exception e) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.ErrorConvertingSplitValue", (String[])new String[]{pol, this.meta.getSplitField() + "]!"}), (Throwable)e);
                }
                outputRow[this.data.fieldnr + i3] = value;
            }
        }
        return outputRow;
    }

    @Override
    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (FieldSplitterMeta)smi;
        this.data = (FieldSplitterData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        Object[] outputRowData = this.splitField(r);
        this.putRow(this.data.outputMeta, outputRowData);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FieldSplitterMeta)smi;
        this.data = (FieldSplitterData)sdi;
        return super.init(smi, sdi);
    }
}

