/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;

public class FieldSplitterMetaInjection
implements StepMetaInjectionInterface {
    private FieldSplitterMeta meta;

    public FieldSplitterMetaInjection(FieldSplitterMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] fieldsEntries;
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.FIELD_TO_SPLIT, Entry.DELIMITER}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry("FIELDS", 0, Entry.FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry("FIELD", 0, Entry.FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : fieldsEntries = new Entry[]{Entry.NAME, Entry.ID, Entry.REMOVE_ID, Entry.DATA_TYPE, Entry.LENGTH, Entry.PRECISION, Entry.FORMAT, Entry.GROUPING, Entry.DECIMAL, Entry.CURRENCY, Entry.NULL_IF, Entry.DEFAULT, Entry.TRIM_TYPE}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<Split> splits = new ArrayList<Split>();
        block20: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case FIELDS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry == null || fieldEntry != Entry.FIELD) continue;
                        Split split = new Split();
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case NAME: {
                                    split.name = value;
                                    break;
                                }
                                case ID: {
                                    split.id = value;
                                    break;
                                }
                                case REMOVE_ID: {
                                    split.removeId = "Y".equalsIgnoreCase(value);
                                    break;
                                }
                                case DATA_TYPE: {
                                    split.dataType = ValueMeta.getType((String)value);
                                    break;
                                }
                                case LENGTH: {
                                    split.length = Const.toInt((String)value, (int)-1);
                                    break;
                                }
                                case PRECISION: {
                                    split.precision = Const.toInt((String)value, (int)-1);
                                    break;
                                }
                                case FORMAT: {
                                    split.format = value;
                                    break;
                                }
                                case GROUPING: {
                                    split.grouping = value;
                                    break;
                                }
                                case DECIMAL: {
                                    split.decimal = value;
                                    break;
                                }
                                case CURRENCY: {
                                    split.currency = value;
                                    break;
                                }
                                case NULL_IF: {
                                    split.nullIf = value;
                                    break;
                                }
                                case DEFAULT: {
                                    split.ifNull = value;
                                    break;
                                }
                                case TRIM_TYPE: {
                                    split.trimType = ValueMeta.getTrimTypeByCode((String)value);
                                    break;
                                }
                            }
                        }
                        splits.add(split);
                    }
                    continue block20;
                }
                case FIELD_TO_SPLIT: {
                    this.meta.setSplitField(lookValue);
                    break;
                }
                case DELIMITER: {
                    this.meta.setDelimiter(lookValue);
                    break;
                }
            }
        }
        if (splits.size() > 0) {
            this.meta.allocate(splits.size());
            for (int i = 0; i < splits.size(); ++i) {
                Split split = (Split)splits.get(i);
                this.meta.getFieldName()[i] = split.name;
                this.meta.getFieldID()[i] = split.id;
                this.meta.getFieldRemoveID()[i] = split.removeId;
                this.meta.getFieldType()[i] = split.dataType;
                this.meta.getFieldFormat()[i] = split.format;
                this.meta.getFieldGroup()[i] = split.grouping;
                this.meta.getFieldDecimal()[i] = split.decimal;
                this.meta.getFieldCurrency()[i] = split.currency;
                this.meta.getFieldLength()[i] = split.length;
                this.meta.getFieldPrecision()[i] = split.precision;
                this.meta.getFieldNullIf()[i] = split.nullIf;
                this.meta.getFieldIfNull()[i] = split.ifNull;
                this.meta.getFieldTrimType()[i] = split.trimType;
            }
        }
    }

    public FieldSplitterMeta getMeta() {
        return this.meta;
    }

    private class Split {
        String name;
        String id;
        boolean removeId;
        int dataType;
        int length;
        int precision;
        String format;
        String grouping;
        String decimal;
        String currency;
        String nullIf;
        String ifNull;
        int trimType;

        private Split() {
        }
    }

    private static enum Entry {
        FIELD_TO_SPLIT(2, "The name of the field to split"),
        DELIMITER(2, "The delimiter"),
        FIELDS(0, "All the resulting fields"),
        FIELD(0, "One result field"),
        NAME(2, "Field name"),
        ID(2, "The ID"),
        REMOVE_ID(2, "Remove ID? (Y/N)"),
        DATA_TYPE(2, "Data type (String, Number, ...)"),
        LENGTH(2, "Length"),
        PRECISION(2, "Precision"),
        FORMAT(2, "The format (mask)"),
        GROUPING(2, "The grouping symbol"),
        DECIMAL(2, "The decimal symbol"),
        CURRENCY(2, "The currency symbol"),
        NULL_IF(2, "Value to convert to null"),
        DEFAULT(2, "The default value in case of null"),
        TRIM_TYPE(2, "The trim type (none, left, right, both)");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

