/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.filterrows;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.filterrows.FilterRows;
import org.pentaho.di.trans.steps.filterrows.FilterRowsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class FilterRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = FilterRowsMeta.class;
    private Condition condition = new Condition();

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void allocate() {
        this.condition = new Condition();
    }

    @Override
    public Object clone() {
        FilterRowsMeta retval = (FilterRowsMeta)super.clone();
        retval.condition = this.condition != null ? (Condition)this.condition.clone() : null;
        return retval;
    }

    @Override
    public String getXML() throws KettleException {
        StringBuffer retval = new StringBuffer(200);
        List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
        retval.append(XMLHandler.addTagValue((String)"send_true_to", (String)targetStreams.get(0).getStepname()));
        retval.append(XMLHandler.addTagValue((String)"send_false_to", (String)targetStreams.get(1).getStepname()));
        retval.append("    <compare>").append(Const.CR);
        if (this.condition != null) {
            retval.append(this.condition.getXML());
        }
        retval.append("    </compare>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
            targetStreams.get(0).setSubject(XMLHandler.getTagValue((Node)stepnode, (String)"send_true_to"));
            targetStreams.get(1).setSubject(XMLHandler.getTagValue((Node)stepnode, (String)"send_false_to"));
            Node compare = XMLHandler.getSubNode((Node)stepnode, (String)"compare");
            Node condnode = XMLHandler.getSubNode((Node)compare, (String)"condition");
            if (condnode != null) {
                this.condition = new Condition(condnode);
            } else {
                this.condition = new Condition();
                int nrkeys = XMLHandler.countNodes((Node)compare, (String)"key");
                if (nrkeys == 1) {
                    Node knode = XMLHandler.getSubNodeByNr((Node)compare, (String)"key", (int)0);
                    String key = XMLHandler.getTagValue((Node)knode, (String)"name");
                    String value = XMLHandler.getTagValue((Node)knode, (String)"value");
                    String field = XMLHandler.getTagValue((Node)knode, (String)"field");
                    String comparator = XMLHandler.getTagValue((Node)knode, (String)"condition");
                    this.condition.setOperator(0);
                    this.condition.setLeftValuename(key);
                    this.condition.setFunction(Condition.getFunction((String)comparator));
                    this.condition.setRightValuename(field);
                    this.condition.setRightExact(new ValueMetaAndData("value", (Object)value));
                } else {
                    for (int i = 0; i < nrkeys; ++i) {
                        Node knode = XMLHandler.getSubNodeByNr((Node)compare, (String)"key", (int)i);
                        String key = XMLHandler.getTagValue((Node)knode, (String)"name");
                        String value = XMLHandler.getTagValue((Node)knode, (String)"value");
                        String field = XMLHandler.getTagValue((Node)knode, (String)"field");
                        String comparator = XMLHandler.getTagValue((Node)knode, (String)"condition");
                        Condition subc = new Condition();
                        if (i > 0) {
                            subc.setOperator(1);
                        } else {
                            subc.setOperator(0);
                        }
                        subc.setLeftValuename(key);
                        subc.setFunction(Condition.getFunction((String)comparator));
                        subc.setRightValuename(field);
                        subc.setRightExact(new ValueMetaAndData("value", (Object)value));
                        this.condition.addCondition(subc);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"FilterRowsMeta.Exception..UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.allocate();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.allocate();
            List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
            targetStreams.get(0).setSubject(rep.getStepAttributeString(id_step, "send_true_to"));
            targetStreams.get(1).setSubject(rep.getStepAttributeString(id_step, "send_false_to"));
            this.condition = rep.loadConditionFromStepAttribute(id_step, "id_condition");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FilterRowsMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getTargetStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            if (this.condition != null) {
                List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
                rep.saveConditionStepAttribute(id_transformation, id_step, "id_condition", this.condition);
                rep.saveStepAttribute(id_transformation, id_step, "send_true_to", targetStreams.get(0).getStepname());
                rep.saveStepAttribute(id_transformation, id_step, "send_false_to", targetStreams.get(1).getStepname());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FilterRowsMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        String[] conditionField = this.condition.getUsedFields();
        for (int i = 0; i < conditionField.length; ++i) {
            int idx = rowMeta.indexOfValue(conditionField[i]);
            if (idx < 0) continue;
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(idx);
            valueMeta.setSortedDescending(false);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int falseTargetIdx;
        CheckResult cr;
        int trueTargetIdx;
        String error_message = "";
        List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
        if (targetStreams.get(0).getStepname() != null && (trueTargetIdx = Const.indexOfString((String)targetStreams.get(0).getStepname(), (String[])output)) < 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.TargetStepInvalid", (String[])new String[]{"true", targetStreams.get(0).getStepname()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (targetStreams.get(1).getStepname() != null && (falseTargetIdx = Const.indexOfString((String)targetStreams.get(1).getStepname(), (String[])output)) < 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.TargetStepInvalid", (String[])new String[]{"false", targetStreams.get(1).getStepname()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = this.condition.isEmpty() ? new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.NoConditionSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.ConditionSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            boolean first = true;
            error_message = "";
            boolean error_found = false;
            String[] key = this.condition.getUsedFields();
            for (int i = 0; i < key.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(key[i]);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.FieldsNotFoundFromPreviousStep", (String[])new String[0]) + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + key[i] + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.AllFieldsFoundInInputStream", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.CouldNotReadFieldsFromPreviousStep", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new FilterRows(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FilterRowsData();
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, false, false);
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"FilterRowsMeta.InfoStream.True.Description", (String[])new String[0]), StreamIcon.TRUE, null));
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"FilterRowsMeta.InfoStream.False.Description", (String[])new String[0]), StreamIcon.FALSE, null));
        }
        return this.ioMeta;
    }

    @Override
    public void resetStepIoMeta() {
    }

    @Override
    public void handleStreamSelection(StreamInterface stream) {
        StepMeta trueStep;
        StepMeta falseStep;
        List<StreamInterface> targets = this.getStepIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        if (index == 0 && (falseStep = targets.get(1).getStepMeta()) != null && falseStep.equals(stream.getStepMeta())) {
            targets.get(1).setStepMeta(null);
        }
        if (index == 1 && (trueStep = targets.get(0).getStepMeta()) != null && trueStep.equals(stream.getStepMeta())) {
            targets.get(0).setStepMeta(null);
        }
    }

    @Override
    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }
}

