/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.formula;

import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.formula.FormulaData;
import org.pentaho.di.trans.steps.formula.FormulaMeta;
import org.pentaho.di.trans.steps.formula.FormulaMetaFunction;
import org.pentaho.di.trans.steps.formula.RowForumulaContext;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;

public class Formula
extends BaseStep
implements StepInterface {
    private FormulaMeta meta;
    private FormulaData data;

    public Formula(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (FormulaMeta)smi;
        this.data = (FormulaData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.context = new RowForumulaContext(this.data.outputRowMeta);
            this.data.parser = new FormulaParser();
            this.data.replaceIndex = new int[this.meta.getFormula().length];
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                FormulaMetaFunction fn = this.meta.getFormula()[i];
                if (!Const.isEmpty((String)fn.getReplaceField())) {
                    this.data.replaceIndex[i] = this.getInputRowMeta().indexOfValue(fn.getReplaceField());
                    if (this.data.replaceIndex[i] >= 0) continue;
                    throw new KettleException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
                }
                this.data.replaceIndex[i] = -1;
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + r);
        }
        Object[] outputRowData = this.calcFields(this.getInputRowMeta(), r);
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.log.isRowLevel()) {
            this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + r);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private Object[] calcFields(RowMetaInterface rowMeta, Object[] r) throws KettleValueException {
        try {
            FormulaMetaFunction fn;
            int i;
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)this.data.outputRowMeta.size());
            int tempIndex = rowMeta.size();
            this.data.context.setRowData(outputRowData);
            if (this.data.lValue == null) {
                this.data.lValue = new LValue[this.meta.getFormula().length];
                for (i = 0; i < this.meta.getFormula().length; ++i) {
                    fn = this.meta.getFormula()[i];
                    if (Const.isEmpty((String)fn.getFieldName())) {
                        throw new KettleException("Unable to find field name for formula [" + Const.NVL((String)fn.getFormula(), (String)"") + "]");
                    }
                    this.data.lValue[i] = this.data.parser.parse(this.meta.getFormula()[i].getFormula());
                    this.data.lValue[i].initialize((FormulaContext)this.data.context);
                }
            }
            for (i = 0; i < this.meta.getFormula().length; ++i) {
                Object formulaResult;
                block46: {
                    fn = this.meta.getFormula()[i];
                    if (Const.isEmpty((String)fn.getFieldName())) continue;
                    if (this.data.lValue[i] == null) {
                        this.data.lValue[i] = this.data.parser.parse(this.meta.getFormula()[i].getFormula());
                        this.data.lValue[i].initialize((FormulaContext)this.data.context);
                    }
                    formulaResult = null;
                    try {
                        formulaResult = this.data.lValue[i].evaluate().getValue();
                    }
                    catch (EvaluationException e) {
                        if (e.getErrorValue() == LibFormulaErrorValue.ERROR_NA_VALUE) break block46;
                        throw e;
                    }
                }
                Object value = null;
                if (this.data.returnType[i] < 0) {
                    if (formulaResult instanceof String) {
                        this.data.returnType[i] = 0;
                        if (fn.getValueType() != 2) {
                            throw new KettleValueException("Please specify a String type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Number) {
                        this.data.returnType[i] = 1;
                        if (fn.getValueType() != 1) {
                            throw new KettleValueException("Please specify a Number type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Integer) {
                        this.data.returnType[i] = 2;
                        if (fn.getValueType() != 5) {
                            throw new KettleValueException("Please specify an Integer type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Long) {
                        this.data.returnType[i] = 3;
                        if (fn.getValueType() != 5) {
                            throw new KettleValueException("Please specify an Integer type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Date) {
                        this.data.returnType[i] = 4;
                        if (fn.getValueType() != 3) {
                            throw new KettleValueException("Please specify a Date type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof BigDecimal) {
                        this.data.returnType[i] = 5;
                        if (fn.getValueType() != 6) {
                            throw new KettleValueException("Please specify a BigNumber type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof byte[]) {
                        this.data.returnType[i] = 6;
                        if (fn.getValueType() != 8) {
                            throw new KettleValueException("Please specify a Binary type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Boolean) {
                        this.data.returnType[i] = 7;
                        if (fn.getValueType() != 4) {
                            throw new KettleValueException("Please specify a Boolean type for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else {
                        this.data.returnType[i] = 0;
                    }
                }
                switch (this.data.returnType[i]) {
                    case 0: {
                        if (formulaResult != null) {
                            value = formulaResult.toString();
                            break;
                        }
                        value = null;
                        break;
                    }
                    case 1: {
                        value = new Double(((Number)formulaResult).doubleValue());
                        break;
                    }
                    case 2: {
                        value = new Long(((Integer)formulaResult).intValue());
                        break;
                    }
                    case 3: {
                        value = formulaResult;
                        break;
                    }
                    case 4: {
                        value = formulaResult;
                        break;
                    }
                    case 5: {
                        value = formulaResult;
                        break;
                    }
                    case 6: {
                        value = formulaResult;
                        break;
                    }
                    case 7: {
                        value = formulaResult;
                        break;
                    }
                    default: {
                        value = null;
                    }
                }
                if (this.data.replaceIndex[i] < 0) {
                    outputRowData[tempIndex++] = value;
                    continue;
                }
                outputRowData[this.data.replaceIndex[i]] = value;
            }
            return outputRowData;
        }
        catch (Throwable e) {
            throw new KettleValueException(e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FormulaMeta)smi;
        this.data = (FormulaData)sdi;
        if (super.init(smi, sdi)) {
            this.data.returnType = new int[this.meta.getFormula().length];
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                this.data.returnType[i] = -1;
            }
            return true;
        }
        return false;
    }
}

