/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getvariable;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getvariable.GetVariable;
import org.pentaho.di.trans.steps.getvariable.GetVariableData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class GetVariableMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GetVariableMeta.class;
    private String[] fieldName;
    private String[] variableString;
    private int[] fieldType;
    private String[] fieldFormat;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private String[] currency;
    private String[] decimal;
    private String[] group;
    private int[] trimType;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getVariableString() {
        return this.variableString;
    }

    public void setVariableString(String[] variableString) {
        this.variableString = variableString;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.variableString = new String[count];
        this.fieldType = new int[count];
        this.fieldFormat = new String[count];
        this.fieldLength = new int[count];
        this.fieldPrecision = new int[count];
        this.currency = new String[count];
        this.decimal = new String[count];
        this.group = new String[count];
        this.trimType = new int[count];
    }

    @Override
    public Object clone() {
        GetVariableMeta retval = (GetVariableMeta)super.clone();
        int count = this.fieldName.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.variableString[i] = this.variableString[i];
            retval.fieldType[i] = this.fieldType[i];
            retval.fieldFormat[i] = this.fieldFormat[i];
            retval.currency[i] = this.currency[i];
            retval.decimal[i] = this.decimal[i];
            retval.group[i] = this.group[i];
            retval.fieldLength[i] = this.fieldLength[i];
            retval.fieldPrecision[i] = this.fieldPrecision[i];
            retval.trimType[i] = this.trimType[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.variableString[i] = XMLHandler.getTagValue((Node)fnode, (String)"variable");
                this.fieldType[i] = ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type"));
                this.fieldFormat[i] = XMLHandler.getTagValue((Node)fnode, (String)"format");
                this.currency[i] = XMLHandler.getTagValue((Node)fnode, (String)"currency");
                this.decimal[i] = XMLHandler.getTagValue((Node)fnode, (String)"decimal");
                this.group[i] = XMLHandler.getTagValue((Node)fnode, (String)"group");
                this.fieldLength[i] = Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1);
                this.trimType[i] = ValueMeta.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type"));
                if (this.fieldType[i] != 0) continue;
                this.fieldType[i] = 2;
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step information from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.variableString[i] = "";
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        int length = -1;
        for (int i = 0; i < this.fieldName.length; ++i) {
            String string;
            if (this.variableString[i] == null || (string = space.environmentSubstitute(this.variableString[i])).length() <= length) continue;
            length = string.length();
        }
        RowMeta row = new RowMeta();
        for (int i = 0; i < this.fieldName.length; ++i) {
            ValueMeta v = new ValueMeta(this.fieldName[i], this.fieldType[i]);
            if (this.fieldLength[i] < 0) {
                v.setLength(length);
            } else {
                v.setLength(this.fieldLength[i]);
            }
            if (this.fieldPrecision[i] >= 0) {
                v.setPrecision(this.fieldPrecision[i]);
            }
            v.setConversionMask(this.fieldFormat[i]);
            v.setGroupingSymbol(this.group[i]);
            v.setDecimalSymbol(this.decimal[i]);
            v.setCurrencySymbol(this.currency[i]);
            v.setTrimType(this.trimType[i]);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        inputRowMeta.mergeRowMeta((RowMetaInterface)row);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"variable", (String)this.variableString[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.fieldType[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.fieldFormat[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.currency[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.decimal[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.group[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)ValueMeta.getTrimTypeCode((int)this.trimType[i])));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.variableString[i] = rep.getStepAttributeString(id_step, i, "field_variable");
                this.fieldType[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.fieldFormat[i] = rep.getStepAttributeString(id_step, i, "field_format");
                this.currency[i] = rep.getStepAttributeString(id_step, i, "field_currency");
                this.decimal[i] = rep.getStepAttributeString(id_step, i, "field_decimal");
                this.group[i] = rep.getStepAttributeString(id_step, i, "field_group");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.trimType[i] = ValueMeta.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type"));
                if (this.fieldType[i] != 0) continue;
                this.fieldType[i] = 2;
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.fieldName.length; ++i) {
            }
            for (i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_variable", this.variableString[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMeta.getTypeDesc((int)this.fieldType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", this.currency[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.decimal[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.group[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.fieldPrecision[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", ValueMeta.getTrimTypeCode((int)this.trimType[i]));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (!Const.isEmpty((String)this.variableString[i])) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetVariableMeta.CheckResult.VariableNotSpecified", (String[])new String[]{this.fieldName[i]}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetVariableMeta.CheckResult.AllVariablesSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetVariable(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetVariableData();
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getCurrency() {
        return this.currency;
    }

    public void setCurrency(String[] currency) {
        this.currency = currency;
    }

    public String[] getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String[] decimal) {
        this.decimal = decimal;
    }

    public String[] getGroup() {
        return this.group;
    }

    public void setGroup(String[] group) {
        this.group = group;
    }

    public int[] getTrimType() {
        return this.trimType;
    }

    public void setTrimType(int[] trimType) {
        this.trimType = trimType;
    }
}

