/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getxmldata;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.trans.step.BaseStepMetaInjection;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionEnumEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataField;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;

public class GetXMLDataMetaInjection
extends BaseStepMetaInjection
implements StepMetaInjectionInterface {
    private GetXMLDataMeta meta;

    public GetXMLDataMetaInjection(GetXMLDataMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        this.addTopLevelStepMetaInjectionEntries(all, Entry.values());
        this.addNestedStepMetaInjectionEntries(all, Entry.values(), Entry.FILENAMES, Entry.FILENAME);
        this.addNestedStepMetaInjectionEntries(all, Entry.values(), Entry.INPUTFIELDS, Entry.INPUTFIELD);
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<FilenameLine> filenameLines = new ArrayList<FilenameLine>();
        ArrayList<GetXMLDataField> fields = new ArrayList<GetXMLDataField>();
        block51: for (StepInjectionMetaEntry lookFields : all) {
            String lookFieldsValue;
            String string = lookFieldsValue = lookFields.getValue() instanceof String ? (String)lookFields.getValue() : null;
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            switch (fieldsEntry) {
                case FILENAMES: {
                    Entry fieldEntry;
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry == null || fieldEntry != Entry.FILENAME) continue;
                        String fileName = null;
                        String fileMask = null;
                        String fileRequired = null;
                        String excludeFileMask = null;
                        String includeSubFolders = null;
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case FILE_PATH: {
                                    fileName = value;
                                    break;
                                }
                                case FILE_INCLUDE_MASK: {
                                    fileMask = value;
                                    break;
                                }
                                case FILE_EXCLUDE_MASK: {
                                    excludeFileMask = value;
                                    break;
                                }
                                case FILE_REQUIRED: {
                                    fileRequired = value;
                                    break;
                                }
                                case FILE_INCLUDE_SUBFOLDERS: {
                                    includeSubFolders = value;
                                    break;
                                }
                            }
                        }
                        if (Const.isEmpty(fileName)) continue;
                        filenameLines.add(new FilenameLine(fileName, fileMask, fileRequired, excludeFileMask, includeSubFolders));
                    }
                    continue block51;
                }
                case INPUTFIELDS: {
                    Entry fieldEntry;
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry == null || fieldEntry != Entry.INPUTFIELD) continue;
                        GetXMLDataField field = new GetXMLDataField();
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case INPUTFIELD_NAME: {
                                    field.setName(value);
                                    break;
                                }
                                case INPUTFIELD_XPATH: {
                                    field.setXPath(value);
                                    break;
                                }
                                case INPUTFIELD_TYPE: {
                                    field.setType(ValueMetaFactory.getIdForValueMeta((String)value));
                                    break;
                                }
                                case INPUTFIELD_ELEMENT_TYPE: {
                                    field.setElementType(GetXMLDataField.getElementTypeByCode(value));
                                    break;
                                }
                                case INPUTFIELD_RESULT_TYPE: {
                                    field.setResultType(GetXMLDataField.getResultTypeByCode(value));
                                    break;
                                }
                                case INPUTFIELD_LENGTH: {
                                    field.setLength(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case INPUTFIELD_PRECISION: {
                                    field.setPrecision(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case INPUTFIELD_FORMAT: {
                                    field.setFormat(value);
                                    break;
                                }
                                case INPUTFIELD_TRIM_TYPE: {
                                    field.setTrimType(ValueMeta.getTrimTypeByCode((String)value));
                                    break;
                                }
                                case INPUTFIELD_CURRENCY: {
                                    field.setCurrencySymbol(value);
                                    break;
                                }
                                case INPUTFIELD_GROUPING: {
                                    field.setGroupSymbol(value);
                                    break;
                                }
                                case INPUTFIELD_DECIMAL: {
                                    field.setDecimalSymbol(value);
                                    break;
                                }
                                case INPUTFIELD_REPEAT: {
                                    field.setRepeated("Y".equalsIgnoreCase(value));
                                    break;
                                }
                            }
                        }
                        fields.add(field);
                    }
                    continue block51;
                }
                case INCLUDE_ROWNUMBER: {
                    this.meta.setIncludeRowNumber("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case ROWNUMBER_FIELD: {
                    this.meta.setRowNumberField(lookFieldsValue);
                    break;
                }
                case ROWLIMIT: {
                    this.meta.setRowLimit(Const.toLong((String)lookFieldsValue, (long)0L));
                    break;
                }
                case LOOP_XPATH: {
                    this.meta.setLoopXPath(lookFieldsValue);
                    break;
                }
                case ENCODING: {
                    this.meta.setEncoding(lookFieldsValue);
                    break;
                }
                case XML_FIELD: {
                    this.meta.setXMLField(lookFieldsValue);
                    break;
                }
                case IN_FIELD: {
                    this.meta.setInFields("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case IN_FILE: {
                    this.meta.setIsAFile("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case ADD_RESULT_FILE: {
                    this.meta.setAddResultFile("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case NAMESPACE_AWARE: {
                    this.meta.setNamespaceAware("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case VALIDATE: {
                    this.meta.setValidating("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case USE_TOKENS: {
                    this.meta.setuseToken("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case IGNORE_EMPTY_FILES: {
                    this.meta.setIgnoreEmptyFile("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case IGNORE_MISSING_FILES: {
                    this.meta.setdoNotFailIfNoFile("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case IGNORE_COMMENTS: {
                    this.meta.setIgnoreComments("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case READ_URL: {
                    this.meta.setReadUrl("Y".equalsIgnoreCase(lookFieldsValue));
                    break;
                }
                case PRUNE_PATH: {
                    this.meta.setPrunePath(lookFieldsValue);
                    break;
                }
                case SHORT_FILE_FIELDNAME: {
                    this.meta.setShortFileNameField(lookFieldsValue);
                    break;
                }
                case FILE_PATH_FIELDNAME: {
                    this.meta.setFilenameField(lookFieldsValue);
                    break;
                }
                case FILE_HIDDEN_FIELDNAME: {
                    this.meta.setIsHiddenField(lookFieldsValue);
                    break;
                }
                case FILE_MODIFICATION_FIELDNAME: {
                    this.meta.setLastModificationDateField(lookFieldsValue);
                    break;
                }
                case FILE_URI_NAME_FIELDNAME: {
                    this.meta.setUriField(lookFieldsValue);
                    break;
                }
                case FILE_ROOT_URI_FIELDNAME: {
                    this.meta.setRootUriField(lookFieldsValue);
                    break;
                }
                case FILE_EXTENSION_FIELDNAME: {
                    this.meta.setExtensionField(lookFieldsValue);
                    break;
                }
                case FILE_SIZE_FIELDNAME: {
                    this.meta.setSizeField(lookFieldsValue);
                    break;
                }
            }
        }
        if (fields.size() > 0) {
            this.meta.setInputFields(fields.toArray(new GetXMLDataField[fields.size()]));
        }
        if (filenameLines.size() > 0) {
            this.meta.allocateFiles(filenameLines.size());
            for (int i = 0; i < filenameLines.size(); ++i) {
                FilenameLine line = (FilenameLine)filenameLines.get(i);
                this.meta.getFileName()[i] = line.fileName;
                this.meta.getFileMask()[i] = line.fileMask;
                this.meta.getFileRequired()[i] = line.fileRequired;
                this.meta.getExludeFileMask()[i] = line.excludeFileMask;
                this.meta.getIncludeSubFolders()[i] = line.includeSubFolders;
            }
        }
    }

    public GetXMLDataMeta getMeta() {
        return this.meta;
    }

    public class ExcelInputSheet {
        public String sheetName;
        public int startCol;
        public int startRow;

        private ExcelInputSheet(String sheetName, int startCol, int startRow) {
            this.sheetName = sheetName;
            this.startCol = startCol;
            this.startRow = startRow;
        }
    }

    protected class FilenameLine {
        public String fileName;
        public String fileMask;
        public String fileRequired;
        public String excludeFileMask;
        public String includeSubFolders;

        public FilenameLine(String fileName, String fileMask, String fileRequired, String excludeFileMask, String includeSubFolders) {
            this.fileName = fileName;
            this.fileMask = fileMask;
            this.fileRequired = fileRequired;
            this.excludeFileMask = excludeFileMask;
            this.includeSubFolders = includeSubFolders;
        }
    }

    private static enum Entry implements StepMetaInjectionEnumEntry
    {
        INCLUDE_ROWNUMBER(2, "Flag indicating that a row number field should be included in the output (Y/N)"),
        ROWNUMBER_FIELD(2, "The name of the field in the output containing the row number"),
        ROWLIMIT(2, "The maximum number or lines to read (integer)"),
        LOOP_XPATH(2, "The maximum number or lines to read (The XPath location to loop over"),
        ENCODING(2, "The file encoding"),
        XML_FIELD(2, "The name of the input field which contains the XML"),
        IN_FIELD(2, "Flag indicating that the XML source is in a field"),
        IN_FILE(2, "Flag indicating that the XML source is in a file"),
        ADD_RESULT_FILE(2, "Add the file(s) to the result? (Y/N)"),
        NAMESPACE_AWARE(2, "Parse namespace aware? (Y/N)"),
        VALIDATE(2, "Validate the XML? (Y/N)"),
        USE_TOKENS(2, "Process using tokens? (Y/N)"),
        IGNORE_EMPTY_FILES(2, "Ignore empty files? (Y/N)"),
        IGNORE_MISSING_FILES(2, "Ignore missing files? (Y/N)"),
        IGNORE_COMMENTS(2, "Ignore comments? (Y/N)"),
        READ_URL(2, "Read URL as source? (Y/N)"),
        PRUNE_PATH(2, "If you set this path, it activates the streaming algorithm to process large files"),
        SHORT_FILE_FIELDNAME(2, "Output field: short file name"),
        FILE_PATH_FIELDNAME(2, "Output field: file path"),
        FILE_HIDDEN_FIELDNAME(2, "Output field: hidden file"),
        FILE_MODIFICATION_FIELDNAME(2, "Output field: file modification date"),
        FILE_URI_NAME_FIELDNAME(2, "Output field: file URI name"),
        FILE_ROOT_URI_FIELDNAME(2, "Output field: file root URI"),
        FILE_EXTENSION_FIELDNAME(2, "Output field: file extesion"),
        FILE_SIZE_FIELDNAME(2, "Output field: file size"),
        INPUTFIELDS(0, "All the input fields"),
        INPUTFIELD(0, "One input field"),
        INPUTFIELD_NAME(INPUTFIELD, 2, "The name of the field"),
        INPUTFIELD_XPATH(INPUTFIELD, 2, "The xpath of the field"),
        INPUTFIELD_TYPE(INPUTFIELD, 2, "The type of the field (String, Integer, Date, ...)"),
        INPUTFIELD_ELEMENT_TYPE(INPUTFIELD, 2, "The element type of the field (node, attribute)"),
        INPUTFIELD_RESULT_TYPE(INPUTFIELD, 2, "The element result type (valueof, singlenode)"),
        INPUTFIELD_LENGTH(INPUTFIELD, 2, "The length of the field"),
        INPUTFIELD_PRECISION(INPUTFIELD, 2, "The precision of the field"),
        INPUTFIELD_FORMAT(INPUTFIELD, 2, "The format mask of the field"),
        INPUTFIELD_TRIM_TYPE(INPUTFIELD, 2, "The trim type of the field (none, left, right, both)"),
        INPUTFIELD_CURRENCY(INPUTFIELD, 2, "The currency symbol"),
        INPUTFIELD_GROUPING(INPUTFIELD, 2, "The grouping symbol"),
        INPUTFIELD_DECIMAL(INPUTFIELD, 2, "The decimal symbol"),
        INPUTFIELD_REPEAT(INPUTFIELD, 2, "Flag to indicate we need to repeat the previous row value if the current value is null (Y/N)"),
        FILENAMES(0, "All the file names"),
        FILENAME(0, "One file name"),
        FILE_PATH(FILENAME, 2, "The path to the file"),
        FILE_INCLUDE_MASK(FILENAME, 2, "The regular expression to match files to include"),
        FILE_EXCLUDE_MASK(FILENAME, 2, "The regular expression to match files to exclude"),
        FILE_REQUIRED(FILENAME, 2, "Flag to indicate that this file is required or not (Y/N)"),
        FILE_INCLUDE_SUBFOLDERS(FILENAME, 2, "Flag to indicate that subfolders should be included or not (Y/N)");

        private int valueType;
        private String description;
        private Entry parent;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        private Entry(Entry parent, int valueType, String description) {
            this.parent = parent;
            this.valueType = valueType;
            this.description = description;
        }

        @Override
        public int getValueType() {
            return this.valueType;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }

        @Override
        public Entry getParent() {
            return this.parent;
        }
    }
}

