/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.groupby;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;

public class GroupByMetaInjection
implements StepMetaInjectionInterface {
    private GroupByMeta meta;

    public GroupByMetaInjection(GroupByMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] aggEntries;
        Entry[] fieldsEntries;
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.PASS_ALL_ROWS, Entry.TEMP_DIRECTORY, Entry.TEMP_FILE_PREFIX, Entry.GROUP_LINE_NUMBER_ENABLED, Entry.GROUP_LINE_NUMBER_FIELDNAME, Entry.ALLWAYS_PASS_A_ROW}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.GROUP_FIELDS.name(), 0, Entry.GROUP_FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.GROUP_FIELD.name(), 0, Entry.GROUP_FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : fieldsEntries = new Entry[]{Entry.GROUP_FIELDNAME}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        StepInjectionMetaEntry aggsEntry = new StepInjectionMetaEntry(Entry.AGG_FIELDS.name(), 0, Entry.AGG_FIELDS.description);
        all.add(aggsEntry);
        StepInjectionMetaEntry aggEntry = new StepInjectionMetaEntry(Entry.AGG_FIELD.name(), 0, Entry.AGG_FIELD.description);
        aggsEntry.getDetails().add(aggEntry);
        for (Entry entry : aggEntries = new Entry[]{Entry.AGG_FIELDNAME, Entry.AGG_SUBJECT, Entry.AGG_TYPE, Entry.AGG_VALUE}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            aggEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<String> groupFields = new ArrayList<String>();
        ArrayList<String> aggFields = new ArrayList<String>();
        ArrayList<String> aggSubjects = new ArrayList<String>();
        ArrayList<Integer> aggTypes = new ArrayList<Integer>();
        ArrayList<String> aggValues = new ArrayList<String>();
        block19: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case GROUP_FIELDS: {
                    Entry fieldEntry;
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.GROUP_FIELD) continue;
                        String groupFieldname = null;
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case GROUP_FIELDNAME: {
                                    groupFieldname = value;
                                    break;
                                }
                            }
                        }
                        groupFields.add(groupFieldname);
                    }
                    continue block19;
                }
                case AGG_FIELDS: {
                    Entry fieldEntry;
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.AGG_FIELD) continue;
                        String aggFieldname = null;
                        String aggSubject = null;
                        int aggType = -1;
                        String aggValue = null;
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case AGG_FIELDNAME: {
                                    aggFieldname = value;
                                    break;
                                }
                                case AGG_SUBJECT: {
                                    aggSubject = value;
                                    break;
                                }
                                case AGG_TYPE: {
                                    aggType = GroupByMeta.getType(value);
                                    break;
                                }
                                case AGG_VALUE: {
                                    aggValue = value;
                                    break;
                                }
                            }
                        }
                        aggFields.add(aggFieldname);
                        aggSubjects.add(aggSubject);
                        aggTypes.add(aggType);
                        aggValues.add(aggValue);
                    }
                    continue block19;
                }
                case PASS_ALL_ROWS: {
                    this.meta.setPassAllRows("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case TEMP_DIRECTORY: {
                    this.meta.setDirectory(lookValue);
                    break;
                }
                case TEMP_FILE_PREFIX: {
                    this.meta.setPrefix(lookValue);
                    break;
                }
                case GROUP_LINE_NUMBER_ENABLED: {
                    this.meta.setAddingLineNrInGroup("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case GROUP_LINE_NUMBER_FIELDNAME: {
                    this.meta.setLineNrInGroupField(lookValue);
                    break;
                }
                case ALLWAYS_PASS_A_ROW: {
                    this.meta.setAlwaysGivingBackOneRow("Y".equalsIgnoreCase(lookValue));
                    break;
                }
            }
        }
        if (groupFields.size() > 0) {
            this.meta.setGroupField(groupFields.toArray(new String[groupFields.size()]));
        }
        if (aggFields.size() > 0) {
            this.meta.setAggregateField(aggFields.toArray(new String[aggFields.size()]));
            this.meta.setSubjectField(aggSubjects.toArray(new String[aggSubjects.size()]));
            int[] types = new int[aggTypes.size()];
            for (int i = 0; i < types.length; ++i) {
                types[i] = (Integer)aggTypes.get(i);
            }
            this.meta.setAggregateType(types);
            this.meta.setValueField(aggValues.toArray(new String[aggValues.size()]));
        }
    }

    public GroupByMeta getMeta() {
        return this.meta;
    }

    private static enum Entry {
        PASS_ALL_ROWS(2, "Pass all rows? (Y/N)"),
        TEMP_DIRECTORY(2, "The temporary directory"),
        TEMP_FILE_PREFIX(2, "The temporary file prefix"),
        GROUP_LINE_NUMBER_ENABLED(2, "Group line number enabled? (Y/N)"),
        GROUP_LINE_NUMBER_FIELDNAME(2, "Group line number field name"),
        ALLWAYS_PASS_A_ROW(2, "Always give back a row? (Y/N)"),
        GROUP_FIELDS(0, "The group definition fields"),
        GROUP_FIELD(0, "One group definition field"),
        GROUP_FIELDNAME(2, "Group definition field name"),
        AGG_FIELDS(0, "The aggregation fields"),
        AGG_FIELD(0, "One aggregation field"),
        AGG_FIELDNAME(2, "Result field name"),
        AGG_SUBJECT(2, "Aggregation subject field name"),
        AGG_TYPE(2, "Aggregation type (for allowed values see: http://wiki.pentaho.com/display/EAI/Group+By)"),
        AGG_VALUE(2, "Value (field separator, ...)");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

