/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ivwloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ivwloader.IngresVectorwiseLoaderData;
import org.pentaho.di.trans.steps.ivwloader.IngresVectorwiseLoaderMeta;

public class IngresVectorwiseLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = IngresVectorwiseLoaderMeta.class;
    private IngresVectorwiseLoaderMeta meta;
    private IngresVectorwiseLoaderData data;

    public IngresVectorwiseLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean execute(IngresVectorwiseLoaderMeta meta) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        try {
            this.data.fifoFilename = this.environmentSubstitute(meta.getFifoFileName());
            File fifoFile = new File(this.data.fifoFilename);
            if (!fifoFile.exists()) {
                String mkFifoCmd = "mkfifo -m 666 [" + this.data.fifoFilename + "]";
                String[] args = new String[]{"mkfifo", "-m", "666", this.data.fifoFilename};
                this.logDetailed("Creating FIFO file using this command : " + mkFifoCmd);
                Process mkFifoProcess = rt.exec(args);
                StreamLogger errorLogger = new StreamLogger(this.log, mkFifoProcess.getErrorStream(), "mkFifoError");
                StreamLogger outputLogger = new StreamLogger(this.log, mkFifoProcess.getInputStream(), "mkFifoOuptut");
                new Thread((Runnable)errorLogger).start();
                new Thread((Runnable)outputLogger).start();
                int result = mkFifoProcess.waitFor();
                if (result != 0) {
                    throw new Exception("Return code " + result + " received from statement : " + mkFifoCmd);
                }
            }
            String cmd = this.createCommandLine(meta);
            try {
                if (meta.isUseDynamicVNode()) {
                    this.logDetailed("Executing command: " + cmd.substring(0, cmd.indexOf("[")) + "[username,password]" + cmd.substring(cmd.indexOf("]") + 1));
                } else {
                    this.logDetailed("Executing command: " + cmd);
                }
                this.data.sqlProcess = rt.exec(cmd);
                this.data.errorLogger = new StreamLogger(this.log, this.data.sqlProcess.getErrorStream(), "ERR_SQL");
                this.data.outputLogger = new StreamLogger(this.log, this.data.sqlProcess.getInputStream(), "OUT_SQL");
                this.data.sqlOutputStream = this.data.sqlProcess.getOutputStream();
                new Thread((Runnable)this.data.errorLogger).start();
                new Thread((Runnable)this.data.outputLogger).start();
            }
            catch (Exception ex) {
                throw new KettleException("Error while executing psql : " + cmd, (Throwable)ex);
            }
            this.logDetailed("Connected to VectorWise with the 'sql' command.");
            String loadCommand = this.createLoadCommand();
            this.logDetailed("Executing command: " + loadCommand);
            this.data.sqlRunner = new SqlRunner(this.data, loadCommand);
            this.data.sqlRunner.start();
            this.logDetailed("LOAD TABLE command started");
            this.openFifoFile();
            this.logDetailed("Fifo stream opened");
            this.waitForAConnection();
            this.logDetailed("Ready to start bulk loading!");
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        return true;
    }

    private String createLoadCommand() {
        String loadCommand = "";
        loadCommand = loadCommand + "COPY TABLE " + this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(null, this.meta.getTableName()) + " ";
        loadCommand = loadCommand + "(" + Const.CR;
        for (int cnt = 0; cnt < this.meta.getFieldDatabase().length; ++cnt) {
            loadCommand = loadCommand + "  " + this.meta.getFieldDatabase()[cnt];
            if (cnt < this.meta.getFieldDatabase().length - 1) {
                if (this.meta.isUseSSV()) {
                    loadCommand = loadCommand + "= c0ssv ";
                } else {
                    loadCommand = loadCommand + "= char(0) ";
                    loadCommand = "\t".equals(this.meta.getDelimiter()) ? loadCommand + "TAB" : loadCommand + "'" + this.meta.getDelimiter() + "'";
                }
            } else {
                loadCommand = this.meta.isUseSSV() ? loadCommand + "= c0ssv" : loadCommand + "= char(0) NL";
            }
            if (cnt < this.meta.getFieldDatabase().length - 1) {
                loadCommand = loadCommand + ",";
            }
            loadCommand = loadCommand + Const.CR;
        }
        loadCommand = loadCommand + ") FROM '" + this.environmentSubstitute(this.meta.getFifoFileName()) + "'";
        boolean withDone = false;
        if (this.meta.isContinueOnError()) {
            loadCommand = loadCommand + "WITH ON_ERROR=CONTINUE";
            withDone = true;
        }
        if (this.meta.getErrorFileName() != null && this.meta.getErrorFileName().trim().length() != 0) {
            loadCommand = withDone ? loadCommand + ", " : loadCommand + "WITH ";
            loadCommand = loadCommand + "LOG='" + this.environmentSubstitute(this.meta.getErrorFileName()) + "'";
        }
        loadCommand = loadCommand + " \\g" + Const.CR;
        loadCommand = loadCommand + " \\q" + Const.CR;
        return loadCommand;
    }

    private void openFifoFile() throws Exception {
        this.logDetailed("Opening fifo file " + this.data.fifoFilename + " for writing.");
        this.data.fifoOpener = new FifoOpener(this.data.fifoFilename);
        this.data.fifoOpener.start();
    }

    private void waitForAConnection() throws Exception {
        while (!this.isStopped()) {
            this.data.fifoOpener.join(1000L);
            if (!this.checkSqlProcessRunning(this.data.sqlProcess)) {
                throw new Exception("Ingres SQL process has stopped");
            }
            if (this.data.fifoOpener.getState() == Thread.State.TERMINATED) break;
            try {
                this.data.sqlRunner.checkExcn();
            }
            catch (Exception e) {
                this.data.fifoOpener.join();
                this.logError("Make sure user has been granted the FILE privilege.");
                this.logError("");
                throw e;
            }
            this.data.fifoOpener.checkExcn();
        }
        this.logDetailed("Opened fifo file " + this.data.fifoFilename + " for writing.");
    }

    public String createCommandLine(IngresVectorwiseLoaderMeta meta) throws KettleException {
        StringBuffer sb = new StringBuffer(300);
        if (!Const.isEmpty((String)meta.getSqlPath())) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getSqlPath()), (VariableSpace)this.getTransMeta());
                String sqlexec = Const.optionallyQuoteStringByOS((String)KettleVFS.getFilename((FileObject)fileObject));
                sb.append(sqlexec);
            }
            catch (KettleFileException ex) {
                throw new KettleException("Error retrieving command string", (Throwable)ex);
            }
        } else if (meta.isUsingVwload()) {
            if (this.isDetailed()) {
                this.logDetailed("vwload defaults to system path");
            }
            sb.append("vwload");
        } else {
            if (this.isDetailed()) {
                this.logDetailed("sql defaults to system path");
            }
            sb.append("sql");
        }
        DatabaseMeta dm = meta.getDatabaseMeta();
        if (dm != null) {
            String databaseName = this.environmentSubstitute(Const.NVL((String)dm.getDatabaseName(), (String)""));
            String password = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(Const.NVL((String)dm.getDatabaseInterface().getPassword(), (String)"")));
            String port = this.environmentSubstitute(Const.NVL((String)dm.getDatabasePortNumberString(), (String)"")).replace("7", "");
            String username = this.environmentSubstitute(Const.NVL((String)dm.getDatabaseInterface().getUsername(), (String)""));
            String hostname = this.environmentSubstitute(Const.NVL((String)dm.getDatabaseInterface().getHostname(), (String)""));
            String schemaTable = dm.getQuotedSchemaTableCombination(null, this.environmentSubstitute(meta.getTableName()));
            String encoding = this.environmentSubstitute(Const.NVL((String)meta.getEncoding(), (String)""));
            String fifoFile = Const.optionallyQuoteStringByOS((String)this.environmentSubstitute(Const.NVL((String)meta.getFifoFileName(), (String)"")));
            String errorFile = Const.optionallyQuoteStringByOS((String)this.environmentSubstitute(Const.NVL((String)meta.getErrorFileName(), (String)"")));
            int maxNrErrors = Const.toInt((String)this.environmentSubstitute(Const.NVL((String)meta.getMaxNrErrors(), (String)"0")), (int)0);
            if (meta.isUsingVwload()) {
                sb.append(" -u ").append(username);
                sb.append(" -P ").append(password);
                sb.append(" -f ").append(meta.getDelimiter()).append("");
                sb.append(" -t ").append(schemaTable);
                if (!Const.isEmpty((String)encoding)) {
                    sb.append(" -C ").append(encoding);
                }
                if (!Const.isEmpty((String)errorFile)) {
                    sb.append(" -l ").append(errorFile);
                }
                if (maxNrErrors > 0) {
                    sb.append(" -x ").append(maxNrErrors);
                }
                sb.append(" ").append(databaseName);
                sb.append(" ").append(fifoFile);
            } else if (meta.isUseDynamicVNode()) {
                sb.append(" @").append(hostname).append(",").append(port).append("[").append(username).append(",").append(password).append("]::").append(databaseName);
            } else {
                sb.append(" ").append(databaseName);
                if (meta.isUseAuthentication()) {
                    sb.append("-P").append(password);
                }
            }
        } else {
            throw new KettleException("No connection specified");
        }
        return sb.toString();
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (IngresVectorwiseLoaderMeta)smi;
        this.data = (IngresVectorwiseLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                if (!this.first) {
                    this.closeOutput();
                }
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.data.bulkRowMeta = this.getInputRowMeta().clone();
                if (this.meta.isUseStandardConversion()) {
                    for (i = 0; i < this.data.bulkRowMeta.size(); ++i) {
                        ValueMetaInterface valueMeta = this.data.bulkRowMeta.getValueMeta(i);
                        if (!valueMeta.isStorageNormal()) continue;
                        if (valueMeta.isDate()) {
                            valueMeta.setConversionMask("yyyy-MM-dd HH:mm:ss");
                            continue;
                        }
                        if (!valueMeta.isNumeric()) continue;
                        valueMeta.setDecimalSymbol(".");
                        valueMeta.setGroupingSymbol("");
                    }
                }
                this.execute(this.meta);
                this.data.fileChannel = this.data.fifoOpener.getFileChannel();
                this.data.byteBuffer = ByteBuffer.allocate(this.data.bufferSize);
            }
            if (!this.checkSqlProcessRunning(this.data.sqlProcess)) {
                throw new Exception("Ingres SQL process has stopped");
            }
            this.writeRowToBulk(this.data.bulkRowMeta, r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            if (this.checkFeedback(this.getLinesOutput())) {
                this.logBasic(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoader.Log.LineNumber", (String[])new String[0]) + this.getLinesOutput());
            }
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoader.Log.ErrorInStep", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    private void closeOutput() throws Exception {
        if (this.data.byteBuffer.position() > 0) {
            this.data.byteBuffer.flip();
            this.data.fileChannel.write(this.data.byteBuffer);
        }
        this.data.fifoOpener.close();
        this.data.fileChannel = null;
        this.data.sqlRunner.join();
        SqlRunner sqlRunner = this.data.sqlRunner;
        this.data.sqlRunner = null;
        sqlRunner.checkExcn();
        this.data.sqlOutputStream.close();
        this.data.sqlOutputStream = null;
    }

    private void writeRowToBulk(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            byte[] delimiter = this.meta.isUseSSV() ? this.data.semicolon : this.data.separator;
            for (int i = 0; i < this.data.keynrs.length; ++i) {
                if (i > 0) {
                    this.write(delimiter);
                }
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData == null) continue;
                if (valueMeta.isStorageBinaryString()) {
                    byte[] value = valueMeta.getBinaryString(valueData);
                    this.write(value);
                    continue;
                }
                String string = valueMeta.getString(valueData);
                if (string == null) continue;
                if (this.meta.isEscapingSpecialCharacters() && valueMeta.isString()) {
                    string = this.replace(string, new String[]{"\n", "\r"}, new String[]{"\\n", "\\r"});
                }
                if (this.meta.isUseSSV()) {
                    if (this.meta.isEscapingSpecialCharacters() && valueMeta.isString()) {
                        string = this.replace(string, new String[]{"\""}, new String[]{"\\\""});
                    }
                    this.write(this.data.doubleQuote);
                    this.write(this.data.getBytes(string));
                    this.write(this.data.doubleQuote);
                    continue;
                }
                this.write(this.data.getBytes(string));
            }
            this.write(this.data.newline);
        }
        catch (Exception e) {
            try {
                this.data.sqlRunner.checkExcn();
            }
            catch (Exception loadEx) {
                throw new KettleException("Error serializing rows of data to the fifo file", (Throwable)loadEx);
            }
            throw new KettleException("Error serializing rows of data to the fifo file", (Throwable)e);
        }
    }

    private void write(byte[] content) throws IOException {
        if (content == null || content.length == 0) {
            return;
        }
        if (content.length > this.data.byteBuffer.capacity()) {
            ByteBuffer buf = ByteBuffer.wrap(content);
            this.data.byteBuffer.flip();
            this.data.fileChannel.write(buf);
        } else if (this.data.byteBuffer.remaining() > content.length) {
            this.data.byteBuffer.put(content);
        } else {
            this.data.byteBuffer.flip();
            this.data.fileChannel.write(this.data.byteBuffer);
            this.data.byteBuffer.clear();
            this.data.byteBuffer.put(content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (IngresVectorwiseLoaderMeta)smi;
        this.data = (IngresVectorwiseLoaderData)sdi;
        if (super.init(smi, sdi)) {
            this.data.separator = Const.isEmpty((String)this.meta.getDelimiter()) ? this.data.getBytes("|") : this.data.getBytes(this.meta.getDelimiter());
            this.data.newline = this.data.getBytes("\n");
            this.data.semicolon = this.data.getBytes(";");
            this.data.doubleQuote = this.data.getBytes("\"");
            this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(null, this.environmentSubstitute(this.meta.getTableName()));
            this.data.encoding = this.environmentSubstitute(this.meta.getEncoding());
            this.data.isEncoding = !Const.isEmpty((String)this.environmentSubstitute(this.meta.getEncoding()));
            this.data.byteBuffer = null;
            String bufferSizeString = this.environmentSubstitute(this.meta.getBufferSize());
            int n = this.data.bufferSize = Const.isEmpty((String)bufferSizeString) ? 5000 : Const.toInt((String)bufferSizeString, (int)5000);
            if (this.meta.isTruncatingTable() && this.meta.getDatabaseMeta() != null) {
                Database db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                try {
                    db.connect();
                    db.execStatement("CALL VECTORWISE( COMBINE '" + this.data.schemaTable + " - " + this.data.schemaTable + "' )");
                    db.execStatement("CALL VECTORWISE( COMBINE '" + this.data.schemaTable + " - " + this.data.schemaTable + "' )");
                    this.log.logDetailed("Table " + this.data.schemaTable + " was truncated using a 'combine' statement.");
                }
                catch (Exception e) {
                    this.log.logError("Error truncating table", (Throwable)e);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    db.disconnect();
                }
            }
            return true;
        }
        return false;
    }

    public boolean checkSqlProcessRunning(Process sqlProcess) {
        try {
            int exitValue = this.data.sqlProcess.exitValue();
            this.logError("SQL process exit code: " + exitValue);
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (IngresVectorwiseLoaderMeta)smi;
        this.data = (IngresVectorwiseLoaderData)sdi;
        this.closeClientConnections(this.data);
        super.dispose(smi, sdi);
    }

    public boolean closeClientConnections(IngresVectorwiseLoaderData data) {
        try {
            if (data.fifoOpener != null) {
                data.fifoOpener.close();
            }
            if (data.sqlRunner != null) {
                data.sqlRunner.join();
                data.sqlRunner = null;
            }
            try {
                if (data.fifoFilename != null) {
                    new File(data.fifoFilename).delete();
                }
            }
            catch (Exception e) {
                this.logError("Unable to delete FIFO file : " + data.fifoFilename, e);
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError("Unexpected error encountered while closing the client connection", e);
            return false;
        }
        return true;
    }

    private String replace(String string, String[] searchStrings, String[] replaceStrings) {
        StringBuilder builder = new StringBuilder(string);
        for (int e = 0; e < Math.min(searchStrings.length, replaceStrings.length); ++e) {
            String chr = searchStrings[e];
            String rep = replaceStrings[e];
            int idx = builder.indexOf(chr, 0);
            while (idx > 0) {
                builder.replace(idx, idx + chr.length(), rep);
                idx = builder.indexOf(chr, idx + rep.length());
            }
        }
        return builder.toString();
    }

    static class SqlRunner
    extends Thread {
        private IngresVectorwiseLoaderData data;
        private String loadCommand;
        private Exception ex;

        SqlRunner(IngresVectorwiseLoaderData data, String loadCommand) {
            this.data = data;
            this.loadCommand = loadCommand;
        }

        @Override
        public void run() {
            try {
                this.data.sqlOutputStream.write(this.data.getBytes(this.loadCommand));
                this.data.sqlOutputStream.flush();
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        void checkExcn() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }

    public class FifoOpener
    extends Thread {
        private FileOutputStream fileOutputStream = null;
        private FileChannel fileChannel = null;
        private Exception ex;
        private String fifoName;

        public FifoOpener(String fifoName) {
            this.fifoName = fifoName;
        }

        @Override
        public void run() {
            try {
                this.fileOutputStream = new FileOutputStream(this.fifoName);
                this.fileChannel = this.fileOutputStream.getChannel();
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        public void checkExcn() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
        }

        public FileChannel getFileChannel() {
            return this.fileChannel;
        }

        public void close() throws IOException {
            if (this.fileChannel != null && this.fileOutputStream != null) {
                this.fileChannel.close();
                this.fileOutputStream.close();
            }
        }
    }
}

