/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.jsonpath.JsonJar;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;
import org.pentaho.di.trans.steps.jsoninput.NJSONArray;

public class JsonReader {
    private static Class<?> PKG = JsonInputMeta.class;
    private static final String JAVA_SCRIPT = "JavaScript";
    private static final String JSON_SCRIPT = "json.js";
    private static final String JSON_PATH_SCRIPT = "jsonpath.js";
    private static final String EVAL_FALSE = "false";
    private static final String EVAL = "var obj=";
    private static final String JSON_PATH = "jsonPath";
    private ScriptEngine jsEngine;
    private boolean ignoreMissingPath;

    public JsonReader() throws KettleException {
        this.init();
        this.ignoreMissingPath = false;
    }

    public void SetIgnoreMissingPath(boolean value) {
        this.ignoreMissingPath = value;
    }

    private void init() throws KettleException {
        try {
            ScriptEngineManager sm = new ScriptEngineManager();
            this.setEngine(sm.getEngineByName(JAVA_SCRIPT));
            if (this.getEngine() == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.NoScriptEngineFound", (String[])new String[0]));
            }
            this.loadJsonScript(JSON_SCRIPT);
            this.loadJsonScript(JSON_PATH_SCRIPT);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.EngineInit", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJsonScript(String script) throws Exception {
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            is = JsonJar.class.getResource(script).openStream();
            isr = new InputStreamReader(is);
            this.getEngine().eval(new BufferedReader(isr));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private ScriptEngine getEngine() {
        return this.jsEngine;
    }

    private void setEngine(ScriptEngine script) {
        this.jsEngine = script;
    }

    private Invocable getInvocable() {
        return (Invocable)((Object)this.getEngine());
    }

    public void readFile(String filename) throws KettleException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(KettleVFS.getInputStream((String)filename));
            Object o = JSONValue.parse((Reader)isr);
            if (o == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ParsingFile", (String[])new String[]{filename}));
            }
            this.eval(o);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void readString(String value) throws KettleException {
        try {
            Object o = JSONValue.parse((String)value);
            if (o == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ParsingString", (String[])new String[]{value}));
            }
            this.eval(o);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void readUrl(String value) throws KettleException {
        InputStreamReader is = null;
        try {
            URL url = new URL(value);
            is = new InputStreamReader(url.openConnection().getInputStream());
            Object o = JSONValue.parse((Reader)is);
            if (o == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ParsingUrl", (String[])new String[]{value}));
            }
            this.eval(o);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void eval(Object o) throws Exception {
        this.getEngine().eval(EVAL + o.toString());
    }

    public NJSONArray getPath(String value) throws KettleException {
        try {
            String ro = this.getInvocable().invokeFunction(JSON_PATH, value).toString();
            if (!ro.equals(EVAL_FALSE)) {
                NJSONArray ra = new NJSONArray((JSONArray)JSONValue.parse((String)ro));
                return ra;
            }
            if (!this.isIgnoreMissingPath()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.CanNotFindPath", (String[])new String[]{value}));
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        NJSONArray ja = new NJSONArray();
        ja.setNull(true);
        return ja;
    }

    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }
}

