/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.steps.ldapinput.LdapMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapProtocol;
import org.pentaho.di.trans.steps.ldapinput.LdapSslProtocol;
import org.pentaho.di.trans.steps.ldapinput.LdapTlsProtocol;

public class LdapProtocolFactory {
    private static final List<Class<? extends LdapProtocol>> protocols = LdapProtocolFactory.initProtocols();
    private final LogChannelInterface log;

    private static List<Class<? extends LdapProtocol>> initProtocols() {
        ArrayList<Class<? extends LdapProtocol>> protocols = new ArrayList<Class<? extends LdapProtocol>>();
        protocols.add(LdapProtocol.class);
        protocols.add(LdapSslProtocol.class);
        protocols.add(LdapTlsProtocol.class);
        return protocols;
    }

    private static String getName(Class<? extends LdapProtocol> protocol) throws KettleException {
        try {
            return protocol.getMethod("getName", new Class[0]).invoke(null, new Object[0]).toString();
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<String> getConnectionTypes(LogChannelInterface log) {
        ArrayList<String> result = new ArrayList<String>();
        List<Class<? extends LdapProtocol>> list = protocols;
        synchronized (list) {
            for (Class<? extends LdapProtocol> protocol : protocols) {
                try {
                    result.add(LdapProtocolFactory.getName(protocol));
                }
                catch (KettleException e) {
                    log.logError("Unable to get name for " + protocol.getCanonicalName());
                }
            }
        }
        return result;
    }

    public LdapProtocolFactory(LogChannelInterface log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapProtocol createLdapProtocol(VariableSpace variableSpace, LdapMeta meta, Collection<String> binaryAttributes) throws KettleException {
        String connectionType = meta.getProtocol();
        List<Class<? extends LdapProtocol>> list = protocols;
        synchronized (list) {
            for (Class<? extends LdapProtocol> protocol : protocols) {
                if (!LdapProtocolFactory.getName(protocol).equals(connectionType)) continue;
                try {
                    return protocol.getConstructor(LogChannelInterface.class, VariableSpace.class, LdapMeta.class, Collection.class).newInstance(this.log, variableSpace, meta, binaryAttributes);
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
            }
        }
        return null;
    }
}

