/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import java.util.Iterator;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;

public class BatchFolderIterator
implements Iterator<Message> {
    private static final int SIZE_ERR = -1;
    private int start;
    private int end;
    private int batchSize;
    private int batchFirst;
    private int batchLast;
    private Folder folder;
    private Message[] messages;
    private int buffIndex;
    private int msgCount;

    public BatchFolderIterator(Folder folder, int batchSize) {
        this(folder, batchSize, null, null);
    }

    public BatchFolderIterator(Folder folder, Integer batchSize, Integer start, Integer end) {
        this.folder = folder;
        try {
            this.msgCount = folder.getMessageCount();
        }
        catch (MessagingException e) {
            this.msgCount = -1;
        }
        this.batchSize = batchSize == null ? this.msgCount : batchSize;
        this.start = start == null ? 1 : start;
        this.end = end == null ? this.msgCount : end;
        this.batchFirst = this.start;
        this.batchLast = this.start - 1;
        this.messages = new Message[0];
    }

    public Message getMessage() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.buffIndex < Math.min(this.messages.length, this.end) || this.getNextBatch();
    }

    private boolean getNextBatch() {
        if (this.batchLast >= this.end) {
            return false;
        }
        this.batchFirst = this.batchLast + 1;
        this.batchLast = Math.min(this.batchFirst + this.batchSize - 1, this.end);
        if (this.batchLast <= this.batchFirst) {
            return false;
        }
        try {
            this.messages = this.folder.getMessages(this.batchFirst, this.batchLast);
            this.buffIndex = 0;
            return this.messages != null && this.messages.length > 0;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    @Override
    public Message next() {
        return this.messages[this.buffIndex++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String getFolderName() {
        return this.folder != null ? this.folder.getName() : null;
    }
}

