/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.mail.Message;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.getpop.MailConnection;
import org.pentaho.di.job.entries.getpop.MailConnectionMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mailinput.BatchFolderIterator;
import org.pentaho.di.trans.steps.mailinput.MailInputData;
import org.pentaho.di.trans.steps.mailinput.MailInputMeta;
import org.pentaho.di.trans.steps.mailinput.SearchEnabledFolderIterator;

public class MailInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MailInputMeta.class;
    private MailInputMeta meta;
    private MailInputData data;

    public MailInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MailInputMeta)smi;
        this.data = (MailInputData)sdi;
        Object[] outputRowData = this.getOneRow();
        if (outputRowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"MailInput.Log.OutputRow", (String[])new String[]{this.data.outputRowMeta.getString(outputRowData)})});
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.data.rowlimit > 0 && this.data.rownr >= (long)this.data.rowlimit) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public String[] getFolders(String realIMAPFolder) throws KettleException {
        this.data.folderenr = 0;
        this.data.messagesCount = 0;
        this.data.rownr = 0L;
        String[] folderslist = null;
        if (this.meta.isIncludeSubFolders()) {
            String[] folderslist0 = this.data.mailConn.returnAllFolders(realIMAPFolder);
            if (folderslist0 == null || folderslist0.length == 0) {
                String[] stringArray;
                if (this.data.mailConn.getProtocol() == 2) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
                }
                folderslist = stringArray;
            } else {
                folderslist = new String[folderslist0.length + 1];
                folderslist[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
                for (int i = 0; i < folderslist0.length; ++i) {
                    folderslist[i + 1] = folderslist0[i];
                }
            }
        } else {
            String[] stringArray;
            if (this.data.mailConn.getProtocol() == 2) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "";
            } else {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
            }
            folderslist = stringArray;
        }
        return folderslist;
    }

    private void applySearch(Date beginDate, Date endDate) {
        String realSearchSubject;
        String realSearchReceipient;
        String realSearchSender = this.environmentSubstitute(this.meta.getSenderSearchTerm());
        if (!Const.isEmpty((String)realSearchSender)) {
            this.data.mailConn.setSenderTerm(realSearchSender, this.meta.isNotTermSenderSearch());
        }
        if (!Const.isEmpty((String)(realSearchReceipient = this.environmentSubstitute(this.meta.getRecipientSearch())))) {
            this.data.mailConn.setReceipientTerm(realSearchReceipient);
        }
        if (!Const.isEmpty((String)(realSearchSubject = this.environmentSubstitute(this.meta.getSubjectSearch())))) {
            this.data.mailConn.setSubjectTerm(realSearchSubject, this.meta.isNotTermSubjectSearch());
        }
        switch (this.meta.getConditionOnReceivedDate()) {
            case 1: {
                this.data.mailConn.setReceivedDateTermEQ(beginDate);
                break;
            }
            case 3: {
                this.data.mailConn.setReceivedDateTermGT(beginDate);
                break;
            }
            case 2: {
                this.data.mailConn.setReceivedDateTermLT(beginDate);
                break;
            }
            case 4: {
                this.data.mailConn.setReceivedDateTermBetween(beginDate, endDate);
                break;
            }
        }
        if (this.data.usePOP) {
            if (this.meta.getRetrievemails() == 1) {
                this.data.mailConn.setFlagTermNew();
            }
        } else {
            switch (this.meta.getValueImapList()) {
                case 1: {
                    this.data.mailConn.setFlagTermNew();
                    break;
                }
                case 2: {
                    this.data.mailConn.setFlagTermOld();
                    break;
                }
                case 3: {
                    this.data.mailConn.setFlagTermRead();
                    break;
                }
                case 4: {
                    this.data.mailConn.setFlagTermUnread();
                    break;
                }
                case 5: {
                    this.data.mailConn.setFlagTermFlagged();
                    break;
                }
                case 6: {
                    this.data.mailConn.setFlagTermNotFlagged();
                    break;
                }
                case 7: {
                    this.data.mailConn.setFlagTermDraft();
                    break;
                }
                case 8: {
                    this.data.mailConn.setFlagTermNotDraft();
                    break;
                }
            }
        }
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    private boolean isFolderExausted() {
        return this.data.folder == null || !this.data.folderIterator.hasNext();
    }

    private Object[] getOneRow() throws KettleException {
        while (this.isFolderExausted()) {
            if (this.openNextFolder()) continue;
            return null;
        }
        Object[] r = this.buildEmptyRow();
        if (this.meta.isDynamicFolder()) {
            System.arraycopy(this.data.readrow, 0, r, 0, this.data.readrow.length);
        }
        try {
            Message message = this.data.folderIterator.next();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.FetchingMessage", (Object[])new Object[]{message.getMessageNumber()}));
            }
            for (int i = 0; i < this.data.nrFields; ++i) {
                int index = this.data.totalpreviousfields + i;
                try {
                    switch (this.meta.getInputFields()[i].getColumn()) {
                        case 0: {
                            r[index] = new Long(message.getMessageNumber());
                            break;
                        }
                        case 1: {
                            r[index] = message.getSubject();
                            break;
                        }
                        case 2: {
                            r[index] = StringUtils.join((Object[])message.getFrom(), (String)";");
                            break;
                        }
                        case 3: {
                            r[index] = StringUtils.join((Object[])message.getReplyTo(), (String)";");
                            break;
                        }
                        case 4: {
                            r[index] = StringUtils.join((Object[])message.getAllRecipients(), (String)";");
                            break;
                        }
                        case 5: {
                            r[index] = message.getDescription();
                            break;
                        }
                        case 6: {
                            r[index] = this.data.mailConn.getMessageBody(message);
                            break;
                        }
                        case 7: {
                            Date receivedDate = message.getReceivedDate();
                            r[index] = receivedDate != null ? new Date(receivedDate.getTime()) : null;
                            break;
                        }
                        case 8: {
                            Date sentDate = message.getSentDate();
                            r[index] = sentDate != null ? new Date(sentDate.getTime()) : null;
                            break;
                        }
                        case 9: {
                            r[index] = message.getContentType();
                            break;
                        }
                        case 10: {
                            r[index] = this.data.mailConn.getFolderName();
                            break;
                        }
                        case 11: {
                            r[index] = new Long(message.getSize());
                            break;
                        }
                        case 15: {
                            r[index] = new Boolean(this.data.mailConn.isMessageDraft(message));
                            break;
                        }
                        case 14: {
                            r[index] = new Boolean(this.data.mailConn.isMessageFlagged(message));
                            break;
                        }
                        case 12: {
                            r[index] = new Boolean(this.data.mailConn.isMessageNew(message));
                            break;
                        }
                        case 13: {
                            r[index] = new Boolean(this.data.mailConn.isMessageRead(message));
                            break;
                        }
                        case 16: {
                            r[index] = new Boolean(this.data.mailConn.isMessageDeleted(message));
                            break;
                        }
                        case 17: {
                            r[index] = new Long(this.data.mailConn.getAttachedFilesCount(message, null));
                            break;
                        }
                        case 18: {
                            String name = this.meta.getInputFields()[i].getName();
                            Object[] headerValues = message.getHeader(name);
                            r[index] = StringUtils.join((Object[])headerValues, (String)";");
                            break;
                        }
                        case 19: {
                            r[index] = this.data.mailConn.getMessageBodyContentType(message);
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    String errMsg = "Error adding value for field " + this.meta.getInputFields()[i].getName();
                    if (this.meta.isStopOnError()) {
                        throw new KettleException(errMsg, (Throwable)e);
                    }
                    this.logError(errMsg, e);
                }
            }
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException("Error adding values to row!", (Throwable)e);
        }
        return r;
    }

    private boolean openNextFolder() {
        try {
            if (!this.meta.isDynamicFolder()) {
                if (this.data.folderenr >= this.data.folders.length) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
            } else {
                String foldername;
                if (this.first) {
                    this.first = false;
                    this.data.readrow = this.getRow();
                    if (this.data.readrow == null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                        }
                        return false;
                    }
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    if (Const.isEmpty((String)this.meta.getFolderField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.DynamicFolderFieldMissing", (String[])new String[0]));
                        this.stopAll();
                        this.setErrors(1L);
                        return false;
                    }
                    this.data.indexOfFolderField = this.data.inputRowMeta.indexOfValue(this.meta.getFolderField());
                    if (this.data.indexOfFolderField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.DynamicFolderUnreachable", (String[])new String[]{this.meta.getFolderField()}));
                        this.stopAll();
                        this.setErrors(1L);
                        return false;
                    }
                    foldername = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfFolderField);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.FoldernameInStream", (String[])new String[]{this.meta.getFolderField(), foldername}));
                    }
                    this.data.folders = this.getFolders(foldername);
                }
                if (this.data.folderenr >= this.data.folders.length) {
                    this.data.readrow = this.getRow();
                    if (this.data.readrow == null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                        }
                        return false;
                    }
                    foldername = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfFolderField);
                    this.data.folders = this.getFolders(foldername);
                }
            }
            this.data.start = this.parseIntWithSubstitute(this.meta.getStart());
            this.data.end = this.parseIntWithSubstitute(this.meta.getEnd());
            this.data.folder = this.data.folders[this.data.folderenr];
            ++this.data.folderenr;
            if (!this.data.usePOP && !Const.isEmpty((String)this.data.folder)) {
                this.data.mailConn.openFolder(this.data.folder, false);
            } else {
                this.data.mailConn.openFolder(false);
            }
            if (this.meta.useBatch()) {
                this.data.folderIterator = new BatchFolderIterator(this.data.mailConn.getFolder(), this.meta.getBatchSize(), this.data.start, this.data.end);
                if (this.data.mailConn.getSearchTerm() != null) {
                    this.data.folderIterator = new SearchEnabledFolderIterator(this.data.folderIterator, this.data.mailConn.getSearchTerm());
                }
            } else {
                this.data.mailConn.retrieveMessages();
                this.data.folderIterator = new ArrayIterator((Object)this.data.mailConn.getMessages());
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.MessagesInFolder", (Object[])new Object[]{this.data.folder, this.data.messagesCount}));
            }
        }
        catch (Exception e) {
            this.logError("Error opening folder " + this.data.folderenr + " " + this.data.folder + ": " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailInputMeta)smi;
        this.data = (MailInputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.isDynamicFolder()) {
                try {
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"MailInput.ErrorInit", (String[])new String[]{e.toString()}));
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.usePOP = this.meta.getProtocol().equals("POP3");
            String realserver = this.environmentSubstitute(this.meta.getServerName());
            if (this.meta.getProtocol().equals(MailConnectionMeta.PROTOCOL_STRING_MBOX) && StringUtils.startsWith((String)realserver, (String)"file://")) {
                realserver = StringUtils.remove((String)realserver, (String)"file://");
            }
            String realusername = this.environmentSubstitute(this.meta.getUserName());
            String realpassword = this.environmentSubstitute(this.meta.getPassword());
            int realport = Const.toInt((String)this.environmentSubstitute(this.meta.getPort()), (int)-1);
            String realProxyUsername = this.environmentSubstitute(this.meta.getProxyUsername());
            if (!this.meta.isDynamicFolder()) {
                String reallimitrow = this.environmentSubstitute(this.meta.getRowLimit());
                this.data.rowlimit = Const.toInt((String)reallimitrow, (int)0);
            }
            Date beginDate = null;
            Date endDate = null;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                switch (this.meta.getConditionOnReceivedDate()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        String realBeginDate = this.environmentSubstitute(this.meta.getReceivedDate1());
                        if (Const.isEmpty((String)realBeginDate)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDateSearchTermEmpty", (String[])new String[0]));
                        }
                        beginDate = df.parse(realBeginDate);
                        break;
                    }
                    case 4: {
                        String realBeginDate = this.environmentSubstitute(this.meta.getReceivedDate1());
                        if (Const.isEmpty((String)realBeginDate)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                        }
                        beginDate = df.parse(realBeginDate);
                        String realEndDate = this.environmentSubstitute(this.meta.getReceivedDate2());
                        if (Const.isEmpty((String)realEndDate)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                        }
                        endDate = df.parse(realEndDate);
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.SettingSearchTerms", (String[])new String[]{e.getMessage()}));
                this.setErrors(1L);
                this.stopAll();
            }
            try {
                this.data.mailConn = new MailConnection(this.log, MailConnectionMeta.getProtocolFromString(this.meta.getProtocol(), 1), realserver, realport, realusername, realpassword, this.meta.isUseSSL(), this.meta.isUseProxy(), realProxyUsername);
                this.data.mailConn.connect();
                this.applySearch(beginDate, endDate);
                if (!this.meta.isDynamicFolder()) {
                    String realIMAPFolder = this.environmentSubstitute(this.meta.getIMAPFolder());
                    this.data.folders = this.getFolders(realIMAPFolder);
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.OpeningConnection", (String[])new String[]{e.getMessage()}));
                this.setErrors(1L);
                this.stopAll();
            }
            this.data.nrFields = this.meta.getInputFields() != null ? this.meta.getInputFields().length : 0;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailInputMeta)smi;
        this.data = (MailInputData)sdi;
        if (this.data.mailConn != null) {
            try {
                this.data.mailConn.disconnect();
                this.data.mailConn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }

    private Integer parseIntWithSubstitute(String toParse) {
        if (!StringUtils.isEmpty((String)(toParse = this.environmentSubstitute(toParse)))) {
            try {
                return Integer.parseInt(toParse);
            }
            catch (NumberFormatException e) {
                this.log.logError(e.getLocalizedMessage());
            }
        }
        return null;
    }
}

