/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransStoppedListener;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.metainject.MetaInjectData;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;

public class MetaInject
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MetaInject.class;
    private MetaInjectMeta meta;
    private MetaInjectData data;

    public MetaInject(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        String targetFile;
        this.meta = (MetaInjectMeta)smi;
        this.data = (MetaInjectData)sdi;
        this.data.rowMap = new HashMap<String, List<RowMetaAndData>>();
        for (String prevStepName : this.getTransMeta().getPrevStepNames(this.getStepMeta())) {
            ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
            RowSet rowSet = this.findInputRowSet(prevStepName);
            Object[] row = this.getRowFrom(rowSet);
            while (row != null) {
                RowMetaAndData rd = new RowMetaAndData();
                rd.setRowMeta(rowSet.getRowMeta());
                rd.setData(row);
                list.add(rd);
                row = this.getRowFrom(rowSet);
            }
            if (list.isEmpty()) continue;
            this.data.rowMap.put(prevStepName, list);
        }
        for (String targetStep : this.data.stepInjectionMap.keySet()) {
            if (this.log.isDetailed()) {
                this.logDetailed("Handing step '" + targetStep + "' injection!");
            }
            StepMetaInjectionInterface injectionInterface = this.data.stepInjectionMap.get(targetStep);
            List<StepInjectionMetaEntry> metadataEntries = injectionInterface.getStepInjectionMetadataEntries();
            ArrayList<StepInjectionMetaEntry> inject = new ArrayList<StepInjectionMetaEntry>();
            Map<TargetStepAttribute, SourceStepField> targetMap = this.meta.getTargetSourceMapping();
            for (TargetStepAttribute target : targetMap.keySet()) {
                SourceStepField source = targetMap.get(target);
                if (!target.getStepname().equalsIgnoreCase(targetStep)) continue;
                List<RowMetaAndData> rows = this.data.rowMap.get(source.getStepname());
                if (rows != null && rows.size() > 0) {
                    StepInjectionMetaEntry entry = this.findMetaEntry(metadataEntries, target.getAttributeKey());
                    if (entry != null) {
                        StepInjectionMetaEntry rootEntry;
                        if (!target.isDetail()) {
                            this.setEntryValue(entry, rows.get(0), source);
                            inject.add(entry);
                            continue;
                        }
                        StepInjectionMetaEntry metaEntries = this.findMetaEntry(inject, entry.getKey());
                        if (metaEntries == null) {
                            rootEntry = this.findDetailRootEntry(metadataEntries, entry);
                            metaEntries = rootEntry.clone();
                            metaEntries.setDetails(new ArrayList<StepInjectionMetaEntry>());
                            inject.add(metaEntries);
                            StepInjectionMetaEntry metaEntry = rootEntry.getDetails().get(0);
                            for (int i = 0; i < rows.size(); ++i) {
                                StepInjectionMetaEntry metaCopy = metaEntry.clone();
                                metaEntries.getDetails().add(metaCopy);
                                metaCopy.setDetails(new ArrayList<StepInjectionMetaEntry>());
                                for (StepInjectionMetaEntry me : metaEntry.getDetails()) {
                                    StepInjectionMetaEntry meCopy = me.clone();
                                    metaCopy.getDetails().add(meCopy);
                                }
                            }
                        } else {
                            metaEntries = rootEntry = this.findDetailRootEntry(inject, metaEntries);
                        }
                        for (int i = 0; i < rows.size(); ++i) {
                            RowMetaAndData row = rows.get(i);
                            try {
                                List<StepInjectionMetaEntry> rowEntries = metaEntries.getDetails().get(i).getDetails();
                                for (StepInjectionMetaEntry rowEntry : rowEntries) {
                                    SourceStepField detailSource = this.findDetailSource(targetMap, targetStep, rowEntry.getKey());
                                    if (detailSource != null) {
                                        this.setEntryValue(rowEntry, row, detailSource);
                                        continue;
                                    }
                                    if (!this.log.isDetailed()) continue;
                                    this.logDetailed("No detail source found for key: " + rowEntry.getKey() + " and target step: " + targetStep);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                throw new KettleException("Unexpected error occurred while injecting metadata", (Throwable)e);
                            }
                        }
                        if (!this.log.isDetailed()) continue;
                        this.logDetailed("injected entry: " + entry);
                        continue;
                    }
                    if (!this.log.isDetailed()) continue;
                    this.logDetailed("entry not found: " + target.getAttributeKey());
                    continue;
                }
                if (!this.log.isDetailed()) continue;
                this.logDetailed("No rows found for source step: " + source.getStepname());
            }
            injectionInterface.injectStepMetadataEntries(inject);
        }
        if (this.log.isDetailed()) {
            this.logDetailed("XML of transformation after injection: " + this.data.transMeta.getXML());
        }
        if (!Const.isEmpty((String)(targetFile = this.environmentSubstitute(this.meta.getTargetFile())))) {
            OutputStream os = null;
            try {
                os = KettleVFS.getOutputStream((String)targetFile, (boolean)false);
                os.write(XMLHandler.getXMLHeader().getBytes("UTF-8"));
                os.write(this.data.transMeta.getXML().getBytes("UTF-8"));
            }
            catch (IOException e) {
                throw new KettleException("Unable to write target file (ktr after injection) to file '" + targetFile + "'", (Throwable)e);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                }
            }
        }
        if (!this.meta.isNoExecution()) {
            final Trans injectTrans = new Trans(this.data.transMeta, this);
            this.getTrans().addTransStoppedListener(new TransStoppedListener(){

                @Override
                public void transStopped(Trans parentTrans) {
                    injectTrans.stopAll();
                }
            });
            injectTrans.prepareExecution(null);
            this.getTrans().getActiveSubtransformations().put(this.getStepname(), injectTrans);
            if (!Const.isEmpty((String)this.meta.getSourceStepName())) {
                StepInterface stepInterface = injectTrans.getStepInterface(this.meta.getSourceStepName(), 0);
                if (stepInterface == null) {
                    throw new KettleException("Unable to find step '" + this.meta.getSourceStepName() + "' to read from.");
                }
                stepInterface.addRowListener(new RowAdapter(){

                    @Override
                    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                        MetaInject.this.putRow(rowMeta, row);
                    }
                });
            }
            injectTrans.startThreads();
            while (!injectTrans.isFinished() && !injectTrans.isStopped()) {
                this.copyResult(injectTrans);
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {}
            }
            this.copyResult(injectTrans);
        }
        this.setOutputDone();
        return false;
    }

    private void copyResult(Trans trans) {
        Result result = trans.getResult();
        this.setLinesInput(result.getNrLinesInput());
        this.setLinesOutput(result.getNrLinesOutput());
        this.setLinesRead(result.getNrLinesRead());
        this.setLinesWritten(result.getNrLinesWritten());
        this.setLinesUpdated(result.getNrLinesUpdated());
        this.setLinesRejected(result.getNrLinesRejected());
        this.setErrors(result.getNrErrors());
    }

    private StepInjectionMetaEntry findDetailRootEntry(List<StepInjectionMetaEntry> metadataEntries, StepInjectionMetaEntry entry) {
        for (StepInjectionMetaEntry rowsEntry : metadataEntries) {
            for (StepInjectionMetaEntry rowEntry : rowsEntry.getDetails()) {
                for (StepInjectionMetaEntry detailEntry : rowEntry.getDetails()) {
                    if (!detailEntry.equals(entry)) continue;
                    return rowsEntry;
                }
            }
        }
        return null;
    }

    private SourceStepField findDetailSource(Map<TargetStepAttribute, SourceStepField> targetMap, String targetStep, String key) {
        return targetMap.get(new TargetStepAttribute(targetStep, key, true));
    }

    private StepInjectionMetaEntry findMetaEntry(List<StepInjectionMetaEntry> metadataEntries, String attributeKey) {
        for (StepInjectionMetaEntry entry : metadataEntries) {
            if (entry.getKey().equals(attributeKey)) {
                return entry;
            }
            if ((entry = this.findMetaEntry(entry.getDetails(), attributeKey)) == null) continue;
            return entry;
        }
        return null;
    }

    private void setEntryValue(StepInjectionMetaEntry entry, RowMetaAndData row, SourceStepField source) throws KettleValueException {
        Object value = null;
        switch (entry.getValueType()) {
            case 2: {
                value = row.getString(source.getField(), null);
                break;
            }
            case 4: {
                value = row.getBoolean(source.getField(), false);
                break;
            }
            case 5: {
                value = row.getInteger(source.getField(), 0L);
                break;
            }
            case 1: {
                value = row.getNumber(source.getField(), 0.0);
                break;
            }
            case 3: {
                value = row.getDate(source.getField(), null);
                break;
            }
            case 6: {
                value = row.getBigNumber(source.getField(), null);
                break;
            }
        }
        entry.setValue(value);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MetaInjectMeta)smi;
        this.data = (MetaInjectData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.transMeta = MetaInjectMeta.loadTransformationMeta(this.meta, this.getTrans().getRepository(), this.getTrans().getMetaStore(), this);
                this.data.transMeta.copyVariablesFrom(this);
                this.data.stepInjectionMap = new HashMap<String, StepMetaInjectionInterface>();
                for (StepMeta stepMeta : this.data.transMeta.getUsedSteps()) {
                    StepMetaInjectionInterface injectionInterface = stepMeta.getStepMetaInterface().getStepMetaInjectionInterface();
                    if (injectionInterface == null) continue;
                    this.data.stepInjectionMap.put(stepMeta.getName(), injectionInterface);
                }
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MetaInject.BadEncoding.Message", (String[])new String[0]), e);
                return false;
            }
        }
        return false;
    }
}

