/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.multimerge;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.multimerge.MultiMergeJoinData;
import org.pentaho.di.trans.steps.multimerge.MultiMergeJoinMeta;

public class MultiMergeJoin
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MultiMergeJoinMeta.class;
    private MultiMergeJoinMeta meta;
    private MultiMergeJoinData data;

    public MultiMergeJoin(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        MultiMergeJoinData.QueueComparator comparator;
        int drainSize;
        int i;
        this.meta = (MultiMergeJoinMeta)smi;
        this.data = (MultiMergeJoinData)sdi;
        if (this.first) {
            int i2;
            this.first = false;
            List<StreamInterface> infoStreams = this.meta.getStepIOMeta().getInfoStreams();
            int streamSize = infoStreams.size();
            this.data.rowSets = new RowSet[streamSize];
            this.data.rows = new Object[streamSize][];
            this.data.metas = new RowMetaInterface[streamSize];
            this.data.rowLengths = new int[streamSize];
            this.data.queue = new PriorityQueue<MultiMergeJoinData.QueueEntry>(streamSize, new MultiMergeJoinData.QueueComparator(this.data));
            this.data.results = new ArrayList<List<Object[]>>(streamSize);
            this.data.queueEntries = new MultiMergeJoinData.QueueEntry[streamSize];
            this.data.drainIndices = new int[streamSize];
            for (i2 = 0; i2 < streamSize; ++i2) {
                this.data.queueEntries[i2] = new MultiMergeJoinData.QueueEntry();
                this.data.queueEntries[i2].index = i2;
                this.data.results.add(new ArrayList());
                this.data.rowSets[i2] = this.findInputRowSet(infoStreams.get(i2).getStepname());
                if (this.data.rowSets[i2] == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Exception.UnableToFindSpecifiedStep", (String[])new String[]{infoStreams.get(0).getStepname()}));
                }
                this.data.rows[i2] = this.getRowFrom(this.data.rowSets[i2]);
                if (this.data.rows[i2] == null) {
                    this.data.metas[i2] = this.getTransMeta().getStepFields(infoStreams.get(i2).getStepname());
                } else {
                    this.data.queueEntries[i2].row = this.data.rows[i2];
                    this.data.metas[i2] = this.data.rowSets[i2].getRowMeta();
                }
                this.data.rowLengths[i2] = this.data.metas[i2].size();
            }
            this.data.outputRowMeta = new RowMeta();
            for (i2 = 0; i2 < streamSize; ++i2) {
                this.data.outputRowMeta.mergeRowMeta(this.data.metas[i2].clone());
            }
            this.data.keyNrs = new int[streamSize][];
            for (int j = 0; j < streamSize; ++j) {
                if (this.data.rows[j] == null) continue;
                String[] keyFields = this.meta.getKeyFields()[j].split(",");
                this.data.keyNrs[j] = new int[keyFields.length];
                for (int i3 = 0; i3 < keyFields.length; ++i3) {
                    this.data.keyNrs[j][i3] = this.data.metas[j].indexOfValue(keyFields[i3]);
                    if (this.data.keyNrs[j][i3] >= 0) continue;
                    String message = BaseMessages.getString(PKG, (String)"MultiMergeJoin.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{this.meta.getKeyFields()[i3]});
                    this.logError(message);
                    throw new KettleStepException(message);
                }
                this.data.queue.add(this.data.queueEntries[j]);
            }
            this.data.dummy = new Object[streamSize][];
            for (i2 = 0; i2 < streamSize; ++i2) {
                this.data.dummy[i2] = RowDataUtil.allocateRowData((int)this.data.metas[i2].size());
            }
        }
        if (this.log.isRowLevel()) {
            String metaString = BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.DataInfo", (String[])new String[]{this.data.metas[0].getString(this.data.rows[0]) + ""});
            for (i = 1; i < this.data.metas.length; ++i) {
                metaString = metaString + this.data.metas[i].getString(this.data.rows[i]);
            }
            this.logRowlevel(metaString);
        }
        int streamSize = this.data.metas.length;
        if (this.data.optional) {
            int i4;
            int i5;
            if (this.data.queue.isEmpty()) {
                this.setOutputDone();
                return false;
            }
            MultiMergeJoinData.QueueEntry minEntry = this.data.queue.poll();
            drainSize = 1;
            this.data.rows[minEntry.index] = minEntry.row;
            this.data.drainIndices[0] = minEntry.index;
            comparator = (MultiMergeJoinData.QueueComparator)this.data.queue.comparator();
            while (!this.data.queue.isEmpty() && comparator.compare(this.data.queue.peek(), minEntry) == 0) {
                MultiMergeJoinData.QueueEntry entry = this.data.queue.poll();
                this.data.rows[entry.index] = entry.row;
                this.data.drainIndices[drainSize++] = entry.index;
            }
            Object[] row = null;
            for (i5 = 0; i5 < drainSize; ++i5) {
                int index = this.data.drainIndices[i5];
                this.data.results.get(index).add(this.data.rows[index]);
                while (!this.isStopped() && (row = this.getRowFrom(this.data.rowSets[index])) != null && this.data.metas[index].compare(this.data.rows[index], row, this.data.keyNrs[index]) == 0) {
                    this.data.results.get(index).add(row);
                }
                if (this.isStopped()) {
                    return false;
                }
                if (row == null) continue;
                this.data.queueEntries[index].row = row;
                this.data.queue.add(this.data.queueEntries[index]);
            }
            for (i5 = 0; i5 < streamSize; ++i5) {
                this.data.drainIndices[i5] = 0;
                if (!this.data.results.get(i5).isEmpty()) continue;
                this.data.results.get(i5).add(this.data.dummy[i5]);
            }
            int current = 0;
            while (true) {
                for (i4 = 0; i4 < streamSize; ++i4) {
                    this.data.rows[i4] = this.data.results.get(i4).get(this.data.drainIndices[i4]);
                }
                row = RowDataUtil.createResizedCopy((Object[][])this.data.rows, (int[])this.data.rowLengths);
                this.putRow(this.data.outputRowMeta, row);
                do {
                    int n = current;
                    this.data.drainIndices[n] = this.data.drainIndices[n] + 1;
                    if (this.data.drainIndices[n] < this.data.results.get(current).size()) break;
                    this.data.drainIndices[current] = 0;
                } while (++current < streamSize);
                if (current >= streamSize) break;
                current = 0;
            }
            for (i4 = 0; i4 < streamSize; ++i4) {
                this.data.results.get(i4).clear();
            }
        } else {
            if (this.data.queue.size() < streamSize) {
                this.data.queue.clear();
                for (i = 0; i < streamSize; ++i) {
                    while (this.data.rows[i] != null && !this.isStopped()) {
                        this.data.rows[i] = this.getRowFrom(this.data.rowSets[i]);
                    }
                }
                this.setOutputDone();
                return false;
            }
            MultiMergeJoinData.QueueEntry minEntry = this.data.queue.poll();
            drainSize = 1;
            this.data.rows[minEntry.index] = minEntry.row;
            this.data.drainIndices[0] = minEntry.index;
            comparator = (MultiMergeJoinData.QueueComparator)this.data.queue.comparator();
            while (!this.data.queue.isEmpty() && comparator.compare(this.data.queue.peek(), minEntry) == 0) {
                MultiMergeJoinData.QueueEntry entry = this.data.queue.poll();
                this.data.rows[entry.index] = entry.row;
                this.data.drainIndices[drainSize++] = entry.index;
            }
            Object[] row = null;
            if (this.data.queue.isEmpty()) {
                int i6;
                int i7;
                for (i7 = 0; i7 < streamSize; ++i7) {
                    this.data.results.get(i7).add(this.data.rows[i7]);
                    while (!this.isStopped() && (row = this.getRowFrom(this.data.rowSets[i7])) != null && this.data.metas[i7].compare(this.data.rows[i7], row, this.data.keyNrs[i7]) == 0) {
                        this.data.results.get(i7).add(row);
                    }
                    if (this.isStopped()) {
                        return false;
                    }
                    if (row == null) continue;
                    this.data.queueEntries[i7].row = row;
                    this.data.queue.add(this.data.queueEntries[i7]);
                }
                for (i7 = 0; i7 < streamSize; ++i7) {
                    this.data.drainIndices[i7] = 0;
                }
                int current = 0;
                while (true) {
                    for (i6 = 0; i6 < streamSize; ++i6) {
                        this.data.rows[i6] = this.data.results.get(i6).get(this.data.drainIndices[i6]);
                    }
                    row = RowDataUtil.createResizedCopy((Object[][])this.data.rows, (int[])this.data.rowLengths);
                    this.putRow(this.data.outputRowMeta, row);
                    do {
                        int n = current;
                        this.data.drainIndices[n] = this.data.drainIndices[n] + 1;
                        if (this.data.drainIndices[n] < this.data.results.get(current).size()) break;
                        this.data.drainIndices[current] = 0;
                    } while (++current < streamSize);
                    if (current >= streamSize) break;
                    current = 0;
                }
                for (i6 = 0; i6 < streamSize; ++i6) {
                    this.data.results.get(i6).clear();
                }
            } else {
                for (int i8 = 0; i8 < drainSize; ++i8) {
                    int index = this.data.drainIndices[i8];
                    while (!this.isStopped() && (row = this.getRowFrom(this.data.rowSets[index])) != null && this.data.metas[index].compare(this.data.rows[index], row, this.data.keyNrs[index]) == 0) {
                    }
                    if (this.isStopped() || row == null) break;
                    this.data.queueEntries[index].row = row;
                    this.data.queue.add(this.data.queueEntries[index]);
                }
                if (this.isStopped()) {
                    return false;
                }
            }
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MultiMergeJoin.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MultiMergeJoinMeta)smi;
        this.data = (MultiMergeJoinData)sdi;
        if (super.init(smi, sdi)) {
            List<StreamInterface> infoStreams = this.meta.getStepIOMeta().getInfoStreams();
            for (int i = 0; i < infoStreams.size(); ++i) {
                if (infoStreams.get(i).getStepMeta() != null) continue;
                this.logError(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.BothTrueAndFalseNeeded", (String[])new String[0]));
                return false;
            }
            String joinType = this.meta.getJoinType();
            for (int i = 0; i < MultiMergeJoinMeta.join_types.length; ++i) {
                if (!joinType.equalsIgnoreCase(MultiMergeJoinMeta.join_types[i])) continue;
                this.data.optional = MultiMergeJoinMeta.optionals[i];
                return true;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.InvalidJoinType", (String[])new String[]{this.meta.getJoinType()}));
            return false;
        }
        return true;
    }

    protected boolean isInputLayoutValid(RowMetaInterface[] rows) {
        if (rows != null) {
            int i;
            String[] keyFields = this.meta.getKeyFields();
            if (rows.length != keyFields.length) {
                this.logError("keys are not configured for all the streams ");
                return false;
            }
            int prevCount = 0;
            ArrayList<String[]> keyList = new ArrayList<String[]>();
            for (i = 0; i < keyFields.length; ++i) {
                String[] keys = keyFields[i].split(",");
                keyList.add(keys);
                int count = keys.length;
                if (i != 0 && prevCount != count) {
                    this.logError("Number of keys do not match ");
                    return false;
                }
                prevCount = count;
            }
            for (i = 0; i < prevCount; ++i) {
                ValueMetaInterface preValue = null;
                for (int j = 0; j < rows.length; ++j) {
                    ValueMetaInterface v = rows[j].searchValueMeta(((String[])keyList.get(j))[i]);
                    if (v == null) {
                        return false;
                    }
                    if (j != 0 && v.getType() != preValue.getType()) {
                        this.logError("key data type do not match ");
                        return false;
                    }
                    preValue = v;
                }
            }
        }
        return true;
    }
}

