/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.multimerge;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.multimerge.MultiMergeJoin;
import org.pentaho.di.trans.steps.multimerge.MultiMergeJoinData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class MultiMergeJoinMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MultiMergeJoinMeta.class;
    public static final String[] join_types = new String[]{"INNER", "FULL OUTER"};
    public static final boolean[] optionals = new boolean[]{false, true};
    private String joinType;
    private String[] keyFields;
    private String[] inputSteps;

    public String getJoinType() {
        return this.joinType;
    }

    public void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    public String[] getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(String[] keyFields) {
        this.keyFields = keyFields;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocateKeys(int nrKeys) {
        this.keyFields = new String[nrKeys];
    }

    @Override
    public Object clone() {
        MultiMergeJoinMeta retval = (MultiMergeJoinMeta)super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
        retval.append(XMLHandler.addTagValue((String)"join_type", (String)this.getJoinType()));
        for (i = 0; i < infoStreams.size(); ++i) {
            retval.append(XMLHandler.addTagValue((String)("step" + i), (String)infoStreams.get(i).getStepname()));
        }
        retval.append("    <number_input>" + infoStreams.size() + "</number_input>" + Const.CR);
        retval.append("    <keys>" + Const.CR);
        for (i = 0; i < this.keyFields.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"key", (String)this.keyFields[i]));
        }
        retval.append("    </keys>" + Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node keysNode = XMLHandler.getSubNode((Node)stepnode, (String)"keys");
            int nrKeys = XMLHandler.countNodes((Node)keysNode, (String)"key");
            this.allocateKeys(nrKeys);
            for (int i = 0; i < nrKeys; ++i) {
                Node keynode = XMLHandler.getSubNodeByNr((Node)keysNode, (String)"key", (int)i);
                this.keyFields[i] = XMLHandler.getNodeValue((Node)keynode);
            }
            int nInputStreams = Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"number_input"));
            this.allocateInputSteps(nInputStreams);
            for (int i = 0; i < nInputStreams; ++i) {
                this.getStepIOMeta().addStream(new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MultiMergeJoin.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            }
            List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
            for (int i = 0; i < infoStreams.size(); ++i) {
                String stepName = XMLHandler.getTagValue((Node)stepnode, (String)("step" + i));
                infoStreams.get(i).setSubject(stepName);
                this.inputSteps[i] = stepName;
            }
            this.joinType = XMLHandler.getTagValue((Node)stepnode, (String)"join_type");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.joinType = join_types[0];
        this.allocateKeys(0);
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrKeys = rep.countNrStepAttributes(id_step, "keys");
            this.allocateKeys(nrKeys);
            for (int i = 0; i < nrKeys; ++i) {
                this.keyFields[i] = rep.getStepAttributeString(id_step, i, "keys");
            }
            long nInputStreams = rep.getStepAttributeInteger(id_step, "number_imput");
            int i = 0;
            while ((long)i < nInputStreams) {
                this.getStepIOMeta().addStream(new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MultiMergeJoin.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
                ++i;
            }
            List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
            for (int i2 = 0; i2 < infoStreams.size(); ++i2) {
                infoStreams.get(i2).setSubject(rep.getStepAttributeString(id_step, "step" + i2));
            }
            this.joinType = rep.getStepAttributeString(id_step, "join_type");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getInfoStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.keyFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "keys", this.keyFields[i]);
            }
            List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
            rep.saveStepAttribute(id_transformation, id_step, "number_inputs", infoStreams.size());
            for (int i = 0; i < infoStreams.size(); ++i) {
                rep.saveStepAttribute(id_transformation, id_step, "step" + i, infoStreams.get(i).getStepname());
            }
            rep.saveStepAttribute(id_transformation, id_step, "join_type", this.getJoinType());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.CheckResult.StepNotVerified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        int i;
        if (info != null) {
            for (i = 0; i < info.length; ++i) {
                if (info[i] == null) continue;
                r.mergeRowMeta(info[i]);
            }
        }
        for (i = 0; i < r.size(); ++i) {
            r.getValueMeta(i).setOrigin(name);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MultiMergeJoin(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MultiMergeJoinData();
    }

    @Override
    public void resetStepIoMeta() {
    }

    public void setInputSteps(String[] inputSteps) {
        this.inputSteps = inputSteps;
    }

    public String[] getInputSteps() {
        return this.inputSteps;
    }

    public void allocateInputSteps(int count) {
        this.inputSteps = new String[count];
    }
}

