/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.normaliser;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.normaliser.NormaliserMeta;

public class NormaliserMetaInjection
implements StepMetaInjectionInterface {
    private NormaliserMeta meta;

    public NormaliserMetaInjection(NormaliserMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry("FIELDS", 0, "All the fields on the spreadsheets");
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry("FIELD", 0, "All the fields on the spreadsheets");
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getValueType() == 0) continue;
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<NormaliserField> normaliserFields = new ArrayList<NormaliserField>();
        for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null || fieldsEntry != Entry.FIELDS) continue;
            for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                Entry fieldEntry = Entry.findEntry(lookField.getKey());
                if (fieldEntry == null || fieldEntry != Entry.FIELD) continue;
                NormaliserField normaliserField = new NormaliserField();
                List<StepInjectionMetaEntry> entries = lookField.getDetails();
                for (StepInjectionMetaEntry entry : entries) {
                    Entry metaEntry = Entry.findEntry(entry.getKey());
                    if (metaEntry == null) continue;
                    String value = (String)entry.getValue();
                    switch (metaEntry) {
                        case NAME: {
                            normaliserField.setName(value);
                            break;
                        }
                        case VALUE: {
                            normaliserField.setValue(value);
                            break;
                        }
                        case NORMALISED: {
                            normaliserField.setNorm(value);
                            break;
                        }
                    }
                }
                normaliserFields.add(normaliserField);
            }
        }
        this.meta.allocate(normaliserFields.size());
        for (int i = 0; i < normaliserFields.size(); ++i) {
            this.meta.getFieldName()[i] = ((NormaliserField)normaliserFields.get(i)).getName();
            this.meta.getFieldValue()[i] = ((NormaliserField)normaliserFields.get(i)).getValue();
            this.meta.getFieldNorm()[i] = ((NormaliserField)normaliserFields.get(i)).getNorm();
        }
    }

    public NormaliserMeta getMeta() {
        return this.meta;
    }

    private static enum Entry {
        FIELDS(0, "All the fields"),
        FIELD(0, "One field"),
        NAME(2, "Input field name"),
        VALUE(2, "Type field value"),
        NORMALISED(2, "Normalised field name");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }

    private class NormaliserField {
        private String name;
        private String value;
        private String norm;

        private NormaliserField() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getNorm() {
            return this.norm;
        }

        public void setNorm(String norm) {
            this.norm = norm;
        }
    }
}

