/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.olapinput;

import java.util.List;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.olapinput.OlapData;
import org.pentaho.di.trans.steps.olapinput.OlapHelper;
import org.pentaho.di.trans.steps.olapinput.OlapInput;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class OlapInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String mdx;
    private String username;
    private String password;
    private String olap4jUrl;
    private final String olap4jDriver = "org.olap4j.driver.xmla.XmlaOlap4jDriver";
    private String catalog;
    private OlapData data;
    private boolean variableReplacementActive;

    public boolean isVariableReplacementActive() {
        return this.variableReplacementActive;
    }

    public void setVariableReplacementActive(boolean variableReplacementActive) {
        this.variableReplacementActive = variableReplacementActive;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        OlapInputMeta retval = (OlapInputMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.olap4jUrl = XMLHandler.getTagValue((Node)stepnode, (String)"url");
            this.username = XMLHandler.getTagValue((Node)stepnode, (String)"username");
            this.password = XMLHandler.getTagValue((Node)stepnode, (String)"password");
            this.catalog = XMLHandler.getTagValue((Node)stepnode, (String)"catalog");
            this.mdx = XMLHandler.getTagValue((Node)stepnode, (String)"mdx");
            this.variableReplacementActive = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"variables_active"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.olap4jUrl = "http://localhost:8080/pentaho/Xmla";
        this.username = "joe";
        this.password = "password";
        this.catalog = "SampleData";
        this.mdx = "SELECT NON EMPTY Hierarchize(Union(Crossjoin({[Measures].[Actual]}, Union(Crossjoin({[Region].[All Regions]}, \n {[Department].[All Departments]}), Crossjoin({[Region].[All Regions]}, [Department].[All Departments].Children))), Crossjoin({[Measures].[Actual]}, \n Union(Crossjoin([Region].[All Regions].Children, {[Department].[All Departments]}),  Crossjoin([Region].[All Regions].Children, [Department].[All Departments].Children))))) ON COLUMNS, \n NON EMPTY Hierarchize(Union({[Positions].[All Positions]}, [Positions].[All Positions].Children)) ON ROWS \n from [Quadrant Analysis]";
        this.variableReplacementActive = false;
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        RowMetaInterface add = null;
        try {
            this.initData(space);
            add = this.data.outputRowMeta;
        }
        catch (Exception dbe) {
            throw new KettleStepException("Unable to get query result for MDX query: " + Const.CR + this.mdx, (Throwable)dbe);
        }
        for (int i = 0; i < add.size(); ++i) {
            ValueMetaInterface v = add.getValueMeta(i);
            v.setOrigin(origin);
        }
        row.addRowMeta(add);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"url", (String)this.olap4jUrl));
        retval.append("    " + XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("    " + XMLHandler.addTagValue((String)"password", (String)this.password));
        retval.append("    " + XMLHandler.addTagValue((String)"mdx", (String)this.mdx));
        retval.append("    " + XMLHandler.addTagValue((String)"catalog", (String)this.catalog));
        retval.append("    " + XMLHandler.addTagValue((String)"variables_active", (boolean)this.variableReplacementActive));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.olap4jUrl = rep.getStepAttributeString(id_step, "url");
            this.username = rep.getStepAttributeString(id_step, "username");
            this.password = rep.getStepAttributeString(id_step, "password");
            this.mdx = rep.getStepAttributeString(id_step, "mdx");
            this.catalog = rep.getStepAttributeString(id_step, "catalog");
            this.variableReplacementActive = rep.getStepAttributeBoolean(id_step, "variables_active");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "url", this.olap4jUrl);
            rep.saveStepAttribute(id_transformation, id_step, "username", this.username);
            rep.saveStepAttribute(id_transformation, id_step, "password", this.mdx);
            rep.saveStepAttribute(id_transformation, id_step, "catalog", this.catalog);
            rep.saveStepAttribute(id_transformation, id_step, "mdx", this.mdx);
            rep.saveStepAttribute(id_transformation, id_step, "variables_active", this.variableReplacementActive);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        this.data = (OlapData)stepDataInterface;
        return new OlapInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new OlapData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    public RowMeta createRowMeta(String[] headerValues, String[][] cellValues) {
        RowMeta outputRowMeta = new RowMeta();
        for (int i = 0; cellValues != null && cellValues.length > 0 && i < cellValues[0].length; ++i) {
            String name = "";
            name = Const.isEmpty((String[])headerValues) ? "Column" + i : headerValues[i];
            ValueMeta valueMeta = new ValueMeta(name, 2);
            outputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        }
        return outputRowMeta;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getMdx() {
        return this.mdx;
    }

    public void setMdx(String mdx) {
        this.mdx = mdx;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOlap4jUrl() {
        return this.olap4jUrl;
    }

    public void setOlap4jUrl(String olap4jUrl) {
        this.olap4jUrl = olap4jUrl;
    }

    public String getOlap4jDriver() {
        return "org.olap4j.driver.xmla.XmlaOlap4jDriver";
    }

    public void initData(VariableSpace space) throws Exception {
        if (this.data == null) {
            this.data = (OlapData)this.getStepData();
        }
        String driver = this.getOlap4jDriver();
        String url = space.environmentSubstitute(this.getOlap4jUrl());
        String username = space.environmentSubstitute(this.getUsername());
        String password = space.environmentSubstitute(this.getPassword());
        String mdx = this.getMdx();
        if (this.isVariableReplacementActive()) {
            mdx = space.environmentSubstitute(this.getMdx());
        }
        String catalog = space.environmentSubstitute(this.getCatalog());
        this.data.olapHelper = new OlapHelper(driver, url, username, password, catalog, mdx);
        this.data.olapHelper.openQuery();
        this.data.olapHelper.createRectangularOutput();
        this.data.outputRowMeta = this.createRowMeta(this.data.olapHelper.getHeaderValues(), this.data.olapHelper.getCellValues()).clone();
    }
}

