/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pentahoreporting;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutputData;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutputMeta;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.CSVReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.RTFReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.ExcelReportUtil;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PentahoReportingOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = PentahoReportingOutput.class;
    private PentahoReportingOutputMeta meta;
    private PentahoReportingOutputData data;

    public PentahoReportingOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (PentahoReportingOutputMeta)smi;
        this.data = (PentahoReportingOutputData)sdi;
        boolean result = true;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.inputFieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getInputFileField());
            if (this.data.inputFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Exception.CanNotFindField", (String[])new String[]{this.meta.getInputFileField()}));
            }
            this.data.outputFieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getOutputFileField());
            if (this.data.inputFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Exception.CanNotFindField", (String[])new String[]{this.meta.getOutputFileField()}));
            }
            PentahoReportingOutput.performPentahoReportingBoot(this.log, this.getClass());
        }
        String sourceFilename = this.getInputRowMeta().getString(r, this.data.inputFieldIndex);
        String targetFilename = this.getInputRowMeta().getString(r, this.data.outputFieldIndex);
        this.processReport(r, sourceFilename, targetFilename, this.meta.getOutputProcessorType());
        this.putRow(this.getInputRowMeta(), r);
        if (this.checkFeedback(this.getLinesOutput())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Log.LineNumber", (String[])new String[0]) + this.getLinesOutput());
        }
        return result;
    }

    public static void performPentahoReportingBoot(LogChannelInterface log, Class<?> referenceClass) {
        if (!ClassicEngineBoot.getInstance().isBootDone()) {
            ObjectUtilities.setClassLoader((ClassLoader)referenceClass.getClassLoader());
            ObjectUtilities.setClassLoaderSource((String)"ClassContext");
            LibLoaderBoot.getInstance().start();
            LibFontBoot.getInstance().start();
            ClassicEngineBoot.getInstance().start();
            Exception exception = ClassicEngineBoot.getInstance().getBootFailureReason();
            if (exception != null) {
                log.logError("Error booting the Pentaho reporting engine", (Throwable)exception);
            }
        }
    }

    public static MasterReport loadMasterReport(String sourceFilename) throws Exception {
        ResourceManager manager = new ResourceManager();
        manager.registerDefaults();
        FileObject fileObject = KettleVFS.getFileObject((String)sourceFilename);
        URL url = new URL(fileObject.getName().getURI());
        Resource resource = manager.createDirectly((Object)url, MasterReport.class);
        MasterReport report = (MasterReport)resource.getResource();
        return report;
    }

    private void processReport(Object[] r, String sourceFilename, String targetFilename, PentahoReportingOutputMeta.ProcessorType outputProcessorType) throws KettleException {
        try {
            MasterReport report = PentahoReportingOutput.loadMasterReport(sourceFilename);
            ReportParameterValues values = report.getParameterValues();
            ReportParameterDefinition definition = report.getParameterDefinition();
            for (String parameterName : this.meta.getParameterFieldMap().keySet()) {
                String fieldName = this.meta.getParameterFieldMap().get(parameterName);
                if (fieldName == null) continue;
                int index = this.getInputRowMeta().indexOfValue(fieldName);
                if (index < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Exception.CanNotFindField", (String[])new String[]{fieldName}));
                }
                Class<?> clazz = this.findParameterClass(definition, parameterName);
                Object value = null;
                if (clazz != null) {
                    value = clazz.equals(String.class) ? this.getInputRowMeta().getString(r, index) : (clazz.equals(new String[0].getClass()) ? this.getInputRowMeta().getString(r, index).split("\t") : (clazz.equals(Date.class) ? this.getInputRowMeta().getDate(r, index) : (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class) ? Byte.valueOf(this.getInputRowMeta().getInteger(r, index).byteValue()) : (clazz.equals(Short.class) || clazz.equals(Short.TYPE) ? Short.valueOf(this.getInputRowMeta().getInteger(r, index).shortValue()) : (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) ? Integer.valueOf(this.getInputRowMeta().getInteger(r, index).intValue()) : (clazz.equals(Long.class) || clazz.equals(Long.TYPE) ? this.getInputRowMeta().getInteger(r, index) : (clazz.equals(Double.class) || clazz.equals(Double.TYPE) ? this.getInputRowMeta().getNumber(r, index) : (clazz.equals(Float.class) || clazz.equals(Float.TYPE) ? Float.valueOf(this.getInputRowMeta().getNumber(r, index).floatValue()) : (clazz.equals(Number.class) ? Float.valueOf(this.getInputRowMeta().getBigNumber(r, index).floatValue()) : (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) ? this.getInputRowMeta().getBoolean(r, index) : (clazz.equals(BigDecimal.class) ? this.getInputRowMeta().getBigNumber(r, index) : (clazz.equals(new byte[0].getClass()) ? (Object)this.getInputRowMeta().getBinary(r, index) : this.getInputRowMeta().getValueMeta(index).convertToNormalStorageType(r[index])))))))))))));
                    values.put(parameterName, value);
                    continue;
                }
                this.logBasic(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Log.ParameterNotFoundInReport", (String[])new String[]{parameterName, sourceFilename}));
            }
            switch (outputProcessorType) {
                case PDF: {
                    PdfReportUtil.createPDF((MasterReport)report, (String)targetFilename);
                    break;
                }
                case CSV: {
                    CSVReportUtil.createCSV((MasterReport)report, (String)targetFilename);
                    break;
                }
                case Excel: {
                    ExcelReportUtil.createXLS((MasterReport)report, (String)targetFilename);
                    break;
                }
                case Excel_2007: {
                    ExcelReportUtil.createXLSX((MasterReport)report, (String)targetFilename);
                    break;
                }
                case StreamingHTML: {
                    HtmlReportUtil.createStreamHTML((MasterReport)report, (String)targetFilename);
                    break;
                }
                case PagedHTML: {
                    HtmlReportUtil.createDirectoryHTML((MasterReport)report, (String)targetFilename);
                    break;
                }
                case RTF: {
                    RTFReportUtil.createRTF((MasterReport)report, (String)targetFilename);
                    break;
                }
            }
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)targetFilename, (VariableSpace)this.getTransMeta()), this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment("This file was created with a Pentaho Reporting Output step");
            this.addResultFile(resultFile);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Exception.UnexpectedErrorRenderingReport", (String[])new String[]{sourceFilename, targetFilename, outputProcessorType.getDescription()}), (Throwable)e);
        }
    }

    private Class<?> findParameterClass(ReportParameterDefinition definition, String parameterName) {
        for (int i = 0; i < definition.getParameterCount(); ++i) {
            ParameterDefinitionEntry entry = definition.getParameterDefinition(i);
            if (!parameterName.equals(entry.getName())) continue;
            return entry.getValueType();
        }
        return null;
    }
}

