/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rest;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rest.Rest;
import org.pentaho.di.trans.steps.rest.RestData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class RestMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = RestMeta.class;
    public static final String[] APPLICATION_TYPES = new String[]{"TEXT PLAIN", "XML", "JSON", "OCTET STREAM", "XHTML", "FORM URLENCODED", "ATOM XML", "SVG XML", "TEXT XML"};
    public static final String APPLICATION_TYPE_TEXT_PLAIN = "TEXT PLAIN";
    public static final String APPLICATION_TYPE_XML = "XML";
    public static final String APPLICATION_TYPE_JSON = "JSON";
    public static final String APPLICATION_TYPE_OCTET_STREAM = "OCTET STREAM";
    public static final String APPLICATION_TYPE_XHTML = "XHTML";
    public static final String APPLICATION_TYPE_FORM_URLENCODED = "FORM URLENCODED";
    public static final String APPLICATION_TYPE_ATOM_XML = "ATOM XML";
    public static final String APPLICATION_TYPE_SVG_XML = "SVG XML";
    public static final String APPLICATION_TYPE_TEXT_XML = "TEXT XML";
    private String applicationType;
    public static final String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS"};
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_PUT = "PUT";
    public static final String HTTP_METHOD_DELETE = "DELETE";
    public static final String HTTP_METHOD_HEAD = "HEAD";
    public static final String HTTP_METHOD_OPTIONS = "OPTIONS";
    private String url;
    private boolean urlInField;
    private String urlField;
    private String[] headerField;
    private String[] headerName;
    private String[] parameterField;
    private String[] parameterName;
    private String fieldName;
    private String resultCodeFieldName;
    private String responseTimeFieldName;
    private String proxyHost;
    private String proxyPort;
    private String httpLogin;
    private String httpPassword;
    private boolean preemptive;
    private String bodyField;
    private String method;
    private boolean dynamicMethod;
    private String methodFieldName;
    private String trustStoreFile;
    private String trustStorePassword;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String value) {
        this.method = value;
    }

    public String getBodyField() {
        return this.bodyField;
    }

    public void setBodyField(String value) {
        this.bodyField = value;
    }

    public String[] getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String[] value) {
        this.headerName = value;
    }

    public String[] getParameterField() {
        return this.parameterField;
    }

    public void setParameterField(String[] value) {
        this.parameterField = value;
    }

    public String[] getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String[] value) {
        this.parameterName = value;
    }

    public String[] getHeaderField() {
        return this.headerField;
    }

    public void setHeaderField(String[] value) {
        this.headerField = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String procedure) {
        this.url = procedure;
    }

    public boolean isUrlInField() {
        return this.urlInField;
    }

    public void setUrlInField(boolean urlInField) {
        this.urlInField = urlInField;
    }

    public boolean isPreemptive() {
        return this.preemptive;
    }

    public void setPreemptive(boolean preemptive) {
        this.preemptive = preemptive;
    }

    public boolean isDynamicMethod() {
        return this.dynamicMethod;
    }

    public void setDynamicMethod(boolean dynamicMethod) {
        this.dynamicMethod = dynamicMethod;
    }

    public String getMethodFieldName() {
        return this.methodFieldName;
    }

    public void setMethodFieldName(String methodFieldName) {
        this.methodFieldName = methodFieldName;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String resultName) {
        this.fieldName = resultName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrheaders, int nrparamers) {
        this.headerField = new String[nrheaders];
        this.headerName = new String[nrheaders];
        this.parameterField = new String[nrparamers];
        this.parameterName = new String[nrparamers];
    }

    @Override
    public Object clone() {
        int i;
        RestMeta retval = (RestMeta)super.clone();
        int nrheaders = this.headerName.length;
        int nrparameters = this.parameterField.length;
        retval.allocate(nrheaders, nrparameters);
        for (i = 0; i < nrheaders; ++i) {
            retval.headerField[i] = this.headerField[i];
            retval.headerName[i] = this.headerName[i];
        }
        for (i = 0; i < nrparameters; ++i) {
            retval.parameterField[i] = this.parameterField[i];
            retval.parameterName[i] = this.parameterName[i];
        }
        return retval;
    }

    @Override
    public void setDefault() {
        int i;
        int nrheaders = 0;
        int nrparameters = 0;
        this.allocate(nrheaders, nrparameters);
        for (i = 0; i < nrheaders; ++i) {
            this.headerField[i] = "header" + i;
            this.headerName[i] = "header";
        }
        for (i = 0; i < nrparameters; ++i) {
            this.parameterField[i] = "param" + i;
            this.parameterName[i] = "param";
        }
        this.fieldName = "result";
        this.resultCodeFieldName = "";
        this.responseTimeFieldName = "";
        this.method = HTTP_METHOD_GET;
        this.dynamicMethod = false;
        this.methodFieldName = null;
        this.preemptive = false;
        this.trustStoreFile = null;
        this.trustStorePassword = null;
        this.applicationType = APPLICATION_TYPE_TEXT_PLAIN;
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta v;
        if (!Const.isEmpty((String)this.fieldName)) {
            v = new ValueMeta(space.environmentSubstitute(this.fieldName), 2);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)this.resultCodeFieldName)) {
            v = new ValueMeta(space.environmentSubstitute(this.resultCodeFieldName), 5);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)this.responseTimeFieldName)) {
            v = new ValueMeta(space.environmentSubstitute(this.responseTimeFieldName), 5);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"applicationType", (String)this.applicationType));
        retval.append("    " + XMLHandler.addTagValue((String)"method", (String)this.method));
        retval.append("    " + XMLHandler.addTagValue((String)"url", (String)this.url));
        retval.append("    " + XMLHandler.addTagValue((String)"urlInField", (boolean)this.urlInField));
        retval.append("    " + XMLHandler.addTagValue((String)"dynamicMethod", (boolean)this.dynamicMethod));
        retval.append("    " + XMLHandler.addTagValue((String)"methodFieldName", (String)this.methodFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"urlField", (String)this.urlField));
        retval.append("    " + XMLHandler.addTagValue((String)"bodyField", (String)this.bodyField));
        retval.append("    " + XMLHandler.addTagValue((String)"httpLogin", (String)this.httpLogin));
        retval.append("    " + XMLHandler.addTagValue((String)"httpPassword", (String)this.httpPassword));
        retval.append("    " + XMLHandler.addTagValue((String)"httpPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.httpPassword)));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("    " + XMLHandler.addTagValue((String)"preemptive", (boolean)this.preemptive));
        retval.append("    " + XMLHandler.addTagValue((String)"trustStoreFile", (String)this.trustStoreFile));
        retval.append("    " + XMLHandler.addTagValue((String)"trustStorePassword", (String)this.trustStorePassword));
        retval.append("    <headers>" + Const.CR);
        for (i = 0; i < this.headerName.length; ++i) {
            retval.append("      <header>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"field", (String)this.headerField[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.headerName[i]));
            retval.append("        </header>" + Const.CR);
        }
        retval.append("      </headers>" + Const.CR);
        retval.append("    <parameters>" + Const.CR);
        for (i = 0; i < this.parameterName.length; ++i) {
            retval.append("      <parameter>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"field", (String)this.parameterField[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.parameterName[i]));
            retval.append("        </parameter>" + Const.CR);
        }
        retval.append("      </parameters>" + Const.CR);
        retval.append("    <result>" + Const.CR);
        retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fieldName));
        retval.append("      " + XMLHandler.addTagValue((String)"code", (String)this.resultCodeFieldName));
        retval.append("      " + XMLHandler.addTagValue((String)"response_time", (String)this.responseTimeFieldName));
        retval.append("      </result>" + Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            Node anode;
            int i;
            this.applicationType = XMLHandler.getTagValue((Node)stepnode, (String)"applicationType");
            this.method = XMLHandler.getTagValue((Node)stepnode, (String)"method");
            this.url = XMLHandler.getTagValue((Node)stepnode, (String)"url");
            this.urlInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"urlInField"));
            this.methodFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"methodFieldName");
            this.dynamicMethod = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dynamicMethod"));
            this.urlField = XMLHandler.getTagValue((Node)stepnode, (String)"urlField");
            this.bodyField = XMLHandler.getTagValue((Node)stepnode, (String)"bodyField");
            this.httpLogin = XMLHandler.getTagValue((Node)stepnode, (String)"httpLogin");
            this.httpPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"httpPassword"));
            this.proxyHost = XMLHandler.getTagValue((Node)stepnode, (String)"proxyHost");
            this.proxyPort = XMLHandler.getTagValue((Node)stepnode, (String)"proxyPort");
            this.preemptive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"preemptive"));
            this.trustStoreFile = XMLHandler.getTagValue((Node)stepnode, (String)"trustStoreFile");
            this.trustStorePassword = XMLHandler.getTagValue((Node)stepnode, (String)"trustStorePassword");
            Node headernode = XMLHandler.getSubNode((Node)stepnode, (String)"headers");
            int nrheaders = XMLHandler.countNodes((Node)headernode, (String)"header");
            Node paramnode = XMLHandler.getSubNode((Node)stepnode, (String)"parameters");
            int nrparameters = XMLHandler.countNodes((Node)paramnode, (String)"parameter");
            this.allocate(nrheaders, nrparameters);
            for (i = 0; i < nrheaders; ++i) {
                anode = XMLHandler.getSubNodeByNr((Node)headernode, (String)"header", (int)i);
                this.headerField[i] = XMLHandler.getTagValue((Node)anode, (String)"field");
                this.headerName[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
            }
            for (i = 0; i < nrparameters; ++i) {
                anode = XMLHandler.getSubNodeByNr((Node)paramnode, (String)"parameter", (int)i);
                this.parameterField[i] = XMLHandler.getTagValue((Node)anode, (String)"field");
                this.parameterName[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
            }
            this.fieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"name");
            this.resultCodeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"code");
            this.responseTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"response_time");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"RestMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.applicationType = rep.getStepAttributeString(id_step, "applicationType");
            this.method = rep.getStepAttributeString(id_step, "method");
            this.url = rep.getStepAttributeString(id_step, "url");
            this.urlInField = rep.getStepAttributeBoolean(id_step, "urlInField");
            this.methodFieldName = rep.getStepAttributeString(id_step, "methodFieldName");
            this.dynamicMethod = rep.getStepAttributeBoolean(id_step, "dynamicMethod");
            this.urlField = rep.getStepAttributeString(id_step, "urlField");
            this.bodyField = rep.getStepAttributeString(id_step, "bodyField");
            this.httpLogin = rep.getStepAttributeString(id_step, "httpLogin");
            this.httpPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "httpPassword"));
            this.proxyHost = rep.getStepAttributeString(id_step, "proxyHost");
            this.proxyPort = rep.getStepAttributeString(id_step, "proxyPort");
            this.trustStoreFile = rep.getStepAttributeString(id_step, "trustStoreFile");
            this.trustStorePassword = rep.getStepAttributeString(id_step, "trustStorePassword");
            this.preemptive = rep.getStepAttributeBoolean(id_step, "preemptive");
            int nrheaders = rep.countNrStepAttributes(id_step, "header_field");
            int nrparams = rep.countNrStepAttributes(id_step, "parameter_field");
            this.allocate(nrheaders, nrparams);
            for (i = 0; i < nrheaders; ++i) {
                this.headerField[i] = rep.getStepAttributeString(id_step, i, "header_field");
                this.headerName[i] = rep.getStepAttributeString(id_step, i, "header_name");
            }
            for (i = 0; i < nrparams; ++i) {
                this.parameterField[i] = rep.getStepAttributeString(id_step, i, "parameter_field");
                this.parameterName[i] = rep.getStepAttributeString(id_step, i, "parameter_name");
            }
            this.fieldName = rep.getStepAttributeString(id_step, "result_name");
            this.resultCodeFieldName = rep.getStepAttributeString(id_step, "result_code");
            this.responseTimeFieldName = rep.getStepAttributeString(id_step, "response_time");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RestMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "applicationType", this.applicationType);
            rep.saveStepAttribute(id_transformation, id_step, "method", this.method);
            rep.saveStepAttribute(id_transformation, id_step, "url", this.url);
            rep.saveStepAttribute(id_transformation, id_step, "methodFieldName", this.methodFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicMethod", this.dynamicMethod);
            rep.saveStepAttribute(id_transformation, id_step, "urlInField", this.urlInField);
            rep.saveStepAttribute(id_transformation, id_step, "urlField", this.urlField);
            rep.saveStepAttribute(id_transformation, id_step, "bodyField", this.bodyField);
            rep.saveStepAttribute(id_transformation, id_step, "httpLogin", this.httpLogin);
            rep.saveStepAttribute(id_transformation, id_step, "httpPassword", Encr.encryptPasswordIfNotUsingVariables((String)this.httpPassword));
            rep.saveStepAttribute(id_transformation, id_step, "proxyHost", this.proxyHost);
            rep.saveStepAttribute(id_transformation, id_step, "proxyPort", this.proxyPort);
            rep.saveStepAttribute(id_transformation, id_step, "trustStoreFile", this.trustStoreFile);
            rep.saveStepAttribute(id_transformation, id_step, "trustStorePassword", this.trustStorePassword);
            rep.saveStepAttribute(id_transformation, id_step, "preemptive", this.preemptive);
            for (i = 0; i < this.headerName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "header_field", this.headerField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "header_name", this.headerName[i]);
            }
            for (i = 0; i < this.parameterField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_field", this.parameterField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_name", this.parameterName[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "result_name", this.fieldName);
            rep.saveStepAttribute(id_transformation, id_step, "result_code", this.resultCodeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "response_time", this.responseTimeFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RestMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = this.urlInField ? (Const.isEmpty((String)this.urlField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlfieldMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlfieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta)) : (Const.isEmpty((String)this.url) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        remarks.add((CheckResultInterface)cr);
        cr = this.dynamicMethod ? (Const.isEmpty((String)this.methodFieldName) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodFieldMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodFieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta)) : (Const.isEmpty((String)this.method) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Rest(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new RestData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public String getResultCodeFieldName() {
        return this.resultCodeFieldName;
    }

    public void setResultCodeFieldName(String resultCodeFieldName) {
        this.resultCodeFieldName = resultCodeFieldName;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setHttpLogin(String httpLogin) {
        this.httpLogin = httpLogin;
    }

    public String getHttpLogin() {
        return this.httpLogin;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getResponseTimeFieldName() {
        return this.responseTimeFieldName;
    }

    public void setResponseTimeFieldName(String responseTimeFieldName) {
        this.responseTimeFieldName = responseTimeFieldName;
    }

    public static boolean isActiveBody(String method) {
        if (Const.isEmpty((String)method)) {
            return false;
        }
        return method.equals(HTTP_METHOD_POST) || method.equals(HTTP_METHOD_PUT) || method.equals(HTTP_METHOD_DELETE);
    }

    public static boolean isActiveParameters(String method) {
        if (Const.isEmpty((String)method)) {
            return false;
        }
        return method.equals(HTTP_METHOD_POST) || method.equals(HTTP_METHOD_PUT) || method.equals(HTTP_METHOD_DELETE);
    }
}

