/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rules;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.rules.Rules;
import org.pentaho.di.trans.steps.rules.RulesExecutor;

public class RulesExecutorData
extends BaseStepData
implements StepDataInterface {
    private static Class<?> PKG = RulesExecutor.class;
    private RowMetaInterface outputRowMeta;
    private KnowledgeBuilder kbuilder;
    private KnowledgeBase kbase;
    private Rules.Column[] columnList;
    private Map<String, Rules.Column> resultMap = new HashMap<String, Rules.Column>();
    private String ruleString;
    private String ruleFilePath;

    public String getRuleString() {
        return this.ruleString;
    }

    public void setRuleString(String ruleString) {
        this.ruleString = ruleString;
    }

    public String getRuleFilePath() {
        return this.ruleFilePath;
    }

    public void setRuleFilePath(String ruleFilePath) {
        this.ruleFilePath = ruleFilePath;
    }

    public void setOutputRowMeta(RowMetaInterface outputRowMeta) {
        this.outputRowMeta = outputRowMeta;
    }

    public RowMetaInterface getOutputRowMeta() {
        return this.outputRowMeta;
    }

    public void initializeRules() {
        Resource ruleSet = null;
        ruleSet = this.ruleString != null ? ResourceFactory.newReaderResource((Reader)new StringReader(this.ruleString)) : ResourceFactory.newFileResource((String)this.ruleFilePath);
        this.kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        this.kbuilder.add(ruleSet, ResourceType.DRL);
        if (this.kbuilder.hasErrors()) {
            System.out.println(this.kbuilder.getErrors().toString());
            throw new RuntimeException(BaseMessages.getString(PKG, (String)"RulesData.Error.CompileDRL", (String[])new String[0]));
        }
        Collection pkgs = this.kbuilder.getKnowledgePackages();
        this.kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.kbase.addKnowledgePackages(pkgs);
    }

    public void initializeColumns(RowMetaInterface inputRowMeta) {
        if (inputRowMeta == null) {
            BaseMessages.getString(PKG, (String)"RulesData.InitializeColumns.InputRowMetaIsNull", (String[])new String[0]);
            return;
        }
        List columns = inputRowMeta.getValueMetaList();
        this.columnList = new Rules.Column[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            ValueMetaInterface column = (ValueMetaInterface)columns.get(i);
            Rules.Column c = new Rules.Column(true);
            c.setName(column.getName());
            c.setType(column.getTypeDesc());
            c.setPayload(null);
            this.columnList[i] = c;
        }
    }

    public void loadRow(Object[] r) {
        for (int i = 0; i < this.columnList.length; ++i) {
            this.columnList[i].setPayload(r[i]);
        }
    }

    public void execute() {
        StatefulKnowledgeSession session = this.kbase.newStatefulKnowledgeSession();
        for (int i = 0; i < this.columnList.length; ++i) {
            session.insert((Object)this.columnList[i]);
        }
        session.fireAllRules();
        Collection oList = session.getObjects(new ObjectFilter(){

            public boolean accept(Object o) {
                return o instanceof Rules.Column && ((Rules.Column)o).isExternalSource() == false;
            }
        });
        for (Object o : oList) {
            this.resultMap.put(((Rules.Column)o).getName(), (Rules.Column)o);
        }
        session.dispose();
    }

    public Object fetchResult(String columnName) {
        return this.resultMap.get(columnName);
    }

    public void shutdown() {
    }
}

