/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sasinput;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs.FileObject;
import org.eobjects.sassy.SasColumnType;
import org.eobjects.sassy.SasReader;
import org.eobjects.sassy.SasReaderCallback;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sasinput.SasInputData;
import org.pentaho.di.trans.steps.sasinput.SasInputField;
import org.pentaho.di.trans.steps.sasinput.SasInputHelper;
import org.pentaho.di.trans.steps.sasinput.SasInputMeta;

public class SasInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SasInputMeta.class;
    private SasInputMeta meta;
    private SasInputData data;

    public SasInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SasInputMeta)smi;
        this.data = (SasInputData)sdi;
        final Object[] fileRowData = this.getRow();
        if (fileRowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.data.outputRowMeta = new RowMeta();
            int idx = this.getInputRowMeta().indexOfValue(this.meta.getAcceptingField());
            if (idx < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SASInput.Log.Error.UnableToFindFilenameField", (String[])new String[]{this.meta.getAcceptingField()}));
            }
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
        }
        String rawFilename = this.getInputRowMeta().getString(fileRowData, this.meta.getAcceptingField(), null);
        final String filename = KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)rawFilename));
        this.data.helper = new SasInputHelper(filename);
        this.logBasic(BaseMessages.getString(PKG, (String)"SASInput.Log.OpenedSASFile", (String[])new String[0]) + " : [" + this.data.helper + "]");
        if (this.data.fileLayout == null) {
            this.data.fileLayout = this.data.helper.getRowMeta();
        } else {
            if (this.data.fileLayout.size() != this.data.helper.getRowMeta().size()) {
                throw new KettleException("All input files need to have the same number of fields. File '" + filename + "' has " + this.data.helper.getRowMeta().size() + " fields while the first file only had " + this.data.fileLayout.size());
            }
            for (int i = 0; i < this.data.fileLayout.size(); ++i) {
                ValueMetaInterface first = this.data.fileLayout.getValueMeta(i);
                ValueMetaInterface second = this.data.helper.getRowMeta().getValueMeta(i);
                if (!first.getName().equalsIgnoreCase(second.getName())) {
                    throw new KettleException("Field nr " + i + " in file '" + filename + "' is called '" + second.getName() + "' while it was called '" + first.getName() + "' in the first file");
                }
                if (first.getType() == second.getType()) continue;
                throw new KettleException("Field nr " + i + " in file '" + filename + "' is of data type '" + second.getTypeDesc() + "' while it was '" + first.getTypeDesc() + "' in the first file");
            }
        }
        if (this.first) {
            this.first = false;
            this.data.fieldIndexes = new ArrayList<Integer>();
            for (SasInputField field : this.meta.getOutputFields()) {
                int fieldIndex = this.data.fileLayout.indexOfValue(field.getName());
                if (fieldIndex < 0) {
                    throw new KettleException("Selected field '" + field.getName() + "' couldn't be found in file '" + filename + "'");
                }
                this.data.fieldIndexes.add(fieldIndex);
            }
        }
        ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)filename), this.getTransMeta().getName(), this.getStepname());
        resultFile.setComment(BaseMessages.getString(PKG, (String)"SASInput.ResultFile.Comment", (String[])new String[0]));
        this.addResultFile(resultFile);
        SasReader sasReader = new SasReader(new File(filename));
        sasReader.read(new SasReaderCallback(){
            private boolean firstRead = true;

            public void column(int index, String name, String label, SasColumnType type, int length) {
            }

            public boolean readData() {
                return true;
            }

            public boolean row(int rowNumber, Object[] rowData) {
                try {
                    if (this.firstRead) {
                        this.firstRead = false;
                    } else if (rowNumber == 1) {
                        return false;
                    }
                    Object[] row = RowDataUtil.createResizedCopy((Object[])fileRowData, (int)((SasInput)SasInput.this).data.outputRowMeta.size());
                    int outputIndex = SasInput.this.getInputRowMeta().size();
                    block6: for (int i = 0; i < ((SasInput)SasInput.this).data.fieldIndexes.size(); ++i) {
                        int fieldIndex = ((SasInput)SasInput.this).data.fieldIndexes.get(i);
                        int type = ((SasInput)SasInput.this).data.fileLayout.getValueMeta(fieldIndex).getType();
                        switch (type) {
                            case 2: {
                                row[outputIndex++] = rowData[fieldIndex];
                                continue block6;
                            }
                            case 1: {
                                Double value = (Double)rowData[fieldIndex];
                                if (value.equals(Double.NaN)) {
                                    value = null;
                                }
                                row[outputIndex++] = value;
                                continue block6;
                            }
                            default: {
                                throw new RuntimeException("Unhandled data type '" + ValueMeta.getTypeDesc((int)type));
                            }
                        }
                    }
                    SasInput.this.convertData(((SasInput)SasInput.this).data.fileLayout, row, ((SasInput)SasInput.this).data.outputRowMeta);
                    SasInput.this.putRow(((SasInput)SasInput.this).data.outputRowMeta, row);
                    return !SasInput.this.isStopped();
                }
                catch (Exception e) {
                    throw new RuntimeException("There was an error reading from SAS7BAT file '" + filename + "'", e);
                }
            }
        });
        return true;
    }

    protected void convertData(RowMetaInterface source, Object[] sourceData, RowMetaInterface target) throws KettleException {
        int targetIndex = this.getInputRowMeta().size();
        for (int i = 0; i < this.data.fieldIndexes.size(); ++i) {
            int fieldIndex = this.data.fieldIndexes.get(i);
            ValueMetaInterface sourceValueMeta = source.getValueMeta(fieldIndex);
            ValueMetaInterface targetValueMeta = target.getValueMeta(targetIndex);
            sourceData[targetIndex] = targetValueMeta.convertData(sourceValueMeta, sourceData[targetIndex]);
            ++targetIndex;
        }
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
    }
}

