/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.script;

import java.math.BigDecimal;
import java.util.Date;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.script.ScriptData;
import org.pentaho.di.trans.steps.script.ScriptMeta;
import org.pentaho.di.trans.steps.script.ScriptValuesScript;

public class Script
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ScriptMeta.class;
    private ScriptMeta meta;
    private ScriptData data;
    public static final int SKIP_TRANSFORMATION = 1;
    public static final int ABORT_TRANSFORMATION = -1;
    public static final int ERROR_TRANSFORMATION = -2;
    public static final int CONTINUE_TRANSFORMATION = 0;
    private boolean bWithTransStat = false;
    private boolean bRC = false;
    private int iTranStat = 0;
    private boolean bFirstRun = false;
    private ScriptValuesScript[] jsScripts;
    private String strTransformScript = "";
    private String strStartScript = "";
    private String strEndScript = "";

    public Script(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void determineUsedFields(RowMetaInterface row) {
        String valname;
        int i;
        int nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valname = row.getValueMeta(i).getName().toUpperCase();
            if (this.strTransformScript.toUpperCase().indexOf(valname) < 0) continue;
            ++nr;
        }
        this.data.fields_used = new int[nr];
        this.data.values_used = new Value[nr];
        nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valname = row.getValueMeta(i).getName();
            if (this.strTransformScript.indexOf(valname) < 0) continue;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Script.Log.UsedValueName", (String[])new String[]{String.valueOf(i), valname}));
            }
            this.data.fields_used[nr] = i;
            ++nr;
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"Script.Log.UsingValuesFromInputStream", (String[])new String[]{String.valueOf(this.data.fields_used.length)}));
        }
    }

    private boolean addValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        if (this.first) {
            int i;
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.determineUsedFields(rowMeta);
            this.data.replaceIndex = new int[this.meta.getFieldname().length];
            for (i = 0; i < this.meta.getFieldname().length; ++i) {
                if (this.meta.getReplace()[i]) {
                    this.data.replaceIndex[i] = rowMeta.indexOfValue(this.meta.getFieldname()[i]);
                    if (this.data.replaceIndex[i] >= 0) continue;
                    if (Const.isEmpty((String)this.meta.getFieldname()[i])) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{this.meta.getFieldname()[i]}));
                    }
                    this.data.replaceIndex[i] = rowMeta.indexOfValue(this.meta.getRename()[i]);
                    if (this.data.replaceIndex[i] >= 0) continue;
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{this.meta.getRename()[i]}));
                }
                this.data.replaceIndex[i] = -1;
            }
            this.data.cx = ScriptMeta.createNewScriptEngine(this.getStepname());
            this.data.scope = this.data.cx.getBindings(100);
            this.bFirstRun = true;
            this.data.scope.put("_step_", (Object)this);
            for (i = 0; i < this.meta.getNumberOfJSScripts(); ++i) {
                this.data.scope.put(this.jsScripts[i].getScriptName(), (Object)this.jsScripts[i].getScript());
            }
            this.data.scope.put("_TransformationName_", (Object)this.getStepname());
            try {
                this.data.scope.put("row", (Object)row);
                for (i = 0; i < this.data.fields_used.length; ++i) {
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.fields_used[i]);
                    Object valueData = row[this.data.fields_used[i]];
                    Object normalStorageValueData = valueMeta.convertToNormalStorageType(valueData);
                    this.data.scope.put(valueMeta.getName(), normalStorageValueData);
                }
                this.data.scope.put("rowMeta", (Object)rowMeta);
                try {
                    if (this.meta.getAddClasses() != null) {
                        for (i = 0; i < this.meta.getAddClasses().length; ++i) {
                            this.data.scope.put(this.meta.getAddClasses()[i].getJSName(), this.meta.getAddClasses()[i].getAddObject());
                        }
                    }
                }
                catch (Exception e) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"Script.Log.CouldNotAttachAdditionalScripts", (String[])new String[0]), (Throwable)e);
                }
                try {
                    this.data.scope.put("SKIP_TRANSFORMATION", (Object)1);
                    this.data.scope.put("ABORT_TRANSFORMATION", (Object)-1);
                    this.data.scope.put("ERROR_TRANSFORMATION", (Object)-2);
                    this.data.scope.put("CONTINUE_TRANSFORMATION", (Object)0);
                }
                catch (Exception ex) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"Script.Log.CouldNotAddDefaultConstants", (String[])new String[0]), (Throwable)ex);
                }
                try {
                    if (this.strStartScript != null && this.strStartScript.length() > 0) {
                        CompiledScript startScript = ((Compilable)((Object)this.data.cx)).compile(this.strStartScript);
                        startScript.eval(this.data.scope);
                        if (this.log.isDetailed()) {
                            this.logDetailed("Start Script found!");
                        }
                    } else if (this.log.isDetailed()) {
                        this.logDetailed("No starting Script found!");
                    }
                }
                catch (Exception es) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"Script.Log.ErrorProcessingStartScript", (String[])new String[0]), (Throwable)es);
                }
                this.data.script = ((Compilable)((Object)this.data.cx)).compile(this.strTransformScript);
            }
            catch (Exception e) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"Script.Log.CouldNotCompileJavascript", (String[])new String[0]), (Throwable)e);
            }
        }
        Object[] outputRow = RowDataUtil.resizeArray((Object[])row, (int)this.data.outputRowMeta.size());
        int outputIndex = rowMeta.size();
        try {
            Object valueData;
            try {
                this.data.scope.put("row", (Object)row);
                for (int i = 0; i < this.data.fields_used.length; ++i) {
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.fields_used[i]);
                    valueData = row[this.data.fields_used[i]];
                    Object normalStorageValueData = valueMeta.convertToNormalStorageType(valueData);
                    this.data.scope.put(valueMeta.getName(), normalStorageValueData);
                }
                this.data.scope.put("rowMeta", (Object)rowMeta);
            }
            catch (Exception e) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"Script.Log.UnexpectedeError", (String[])new String[0]), (Throwable)e);
            }
            this.data.script.eval(this.data.scope);
            if (this.bFirstRun) {
                this.bFirstRun = false;
                Object tran_stat = this.data.scope.get("trans_Status");
                if (tran_stat != null) {
                    this.bWithTransStat = true;
                    if (this.log.isDetailed()) {
                        this.logDetailed("tran_Status found. Checking transformation status while script execution.");
                    }
                } else {
                    if (this.log.isDetailed()) {
                        this.logDetailed("No tran_Status found. Transformation status checking not available.");
                    }
                    this.bWithTransStat = false;
                }
            }
            this.iTranStat = this.bWithTransStat ? (Integer)this.data.scope.get("trans_Status") : 0;
            if (this.iTranStat == 0) {
                this.bRC = true;
                for (int i = 0; i < this.meta.getFieldname().length; ++i) {
                    Object result = this.data.scope.get(this.meta.getFieldname()[i]);
                    valueData = this.getValueFromJScript(result, i);
                    if (this.data.replaceIndex[i] < 0) {
                        outputRow[outputIndex++] = valueData;
                        continue;
                    }
                    outputRow[this.data.replaceIndex[i]] = valueData;
                }
                this.putRow(this.data.outputRowMeta, outputRow);
            } else {
                switch (this.iTranStat) {
                    case 1: {
                        this.bRC = true;
                        break;
                    }
                    case -1: {
                        if (this.data.cx != null) {
                            this.stopAll();
                        }
                        this.setOutputDone();
                        this.bRC = false;
                        break;
                    }
                    case -2: {
                        if (this.data.cx != null) {
                            this.setErrors(1L);
                        }
                        this.stopAll();
                        this.bRC = false;
                        break;
                    }
                }
            }
        }
        catch (ScriptException e) {
            throw new KettleValueException(BaseMessages.getString(PKG, (String)"Script.Log.JavascriptError", (String[])new String[0]), (Throwable)e);
        }
        return this.bRC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValueFromJScript(Object result, int i) throws KettleValueException {
        if (this.meta.getFieldname()[i] == null) throw new KettleValueException("No name was specified for result value #" + (i + 1));
        if (this.meta.getFieldname()[i].length() <= 0) throw new KettleValueException("No name was specified for result value #" + (i + 1));
        try {
            if (result == null) {
                return null;
            }
            String classType = result.getClass().getName();
            switch (this.meta.getType()[i]) {
                case 1: {
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                        return null;
                    }
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) {
                        try {
                            Value v = (Value)result;
                            return v.getNumber();
                        }
                        catch (Exception e) {
                            String string = (String)result;
                            return new Double(Double.parseDouble(Const.trim((String)string)));
                        }
                    }
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeNumber")) {
                        Number nb = (Number)result;
                        return new Double(nb.doubleValue());
                    }
                    Number nb = (Number)result;
                    return new Double(nb.doubleValue());
                }
                case 5: {
                    if (classType.equalsIgnoreCase("java.lang.Byte")) {
                        return new Long(((Byte)result).longValue());
                    }
                    if (classType.equalsIgnoreCase("java.lang.Short")) {
                        return new Long(((Short)result).longValue());
                    }
                    if (classType.equalsIgnoreCase("java.lang.Integer")) {
                        return new Long(((Integer)result).longValue());
                    }
                    if (classType.equalsIgnoreCase("java.lang.Long")) {
                        return new Long((Long)result);
                    }
                    if (classType.equalsIgnoreCase("java.lang.Double")) {
                        return new Long(((Double)result).longValue());
                    }
                    if (classType.equalsIgnoreCase("java.lang.String")) {
                        return new Long(new Long((String)result));
                    }
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                        return null;
                    }
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeNumber")) {
                        Number nb = (Number)result;
                        return new Long(nb.longValue());
                    }
                    if (!classType.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) {
                        return Long.parseLong(result.toString());
                    }
                    try {
                        Value value = (Value)result;
                        return value.getInteger();
                    }
                    catch (Exception e2) {
                        String string = (String)result;
                        return new Long(Long.parseLong(Const.trim((String)string)));
                    }
                }
                case 2: {
                    if (!classType.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject") && !classType.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                        return (String)result;
                    }
                    try {
                        Value v = (Value)result;
                        return v.toString();
                    }
                    catch (Exception ev) {
                        return (String)result;
                    }
                }
                case 3: {
                    double dbl = 0.0;
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                        return null;
                    }
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeDate")) {
                        dbl = (Double)result;
                    } else if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject") || classType.equalsIgnoreCase("java.util.Date")) {
                        try {
                            Date dat = (Date)result;
                            dbl = dat.getTime();
                        }
                        catch (Exception e) {
                            try {
                                Value value = (Value)result;
                                return value.getDate();
                            }
                            catch (Exception e2) {
                                try {
                                    String string = (String)result;
                                    return XMLHandler.stringToDate((String)string);
                                }
                                catch (Exception e3) {
                                    throw new KettleValueException("Can't convert a string to a date");
                                }
                            }
                        }
                    } else if (classType.equalsIgnoreCase("java.lang.Double")) {
                        dbl = (Double)result;
                    } else {
                        String string = (String)result;
                        dbl = Double.parseDouble(string);
                    }
                    long lng = Math.round(dbl);
                    return new Date(lng);
                }
                case 4: {
                    return result;
                }
                case 6: {
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                        return null;
                    }
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeNumber")) {
                        Number nb = (Number)result;
                        return new BigDecimal(nb.longValue());
                    }
                    if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) {
                        try {
                            return (BigDecimal)result;
                        }
                        catch (Exception e) {
                            try {
                                Value v = (Value)result;
                                if (v.isNull()) return null;
                                return v.getBigNumber();
                            }
                            catch (Exception e2) {
                                String string = (String)result;
                                return new BigDecimal(string);
                            }
                        }
                    }
                    if (classType.equalsIgnoreCase("java.lang.Byte")) {
                        return new BigDecimal(((Byte)result).longValue());
                    }
                    if (classType.equalsIgnoreCase("java.lang.Short")) {
                        return new BigDecimal(((Short)result).longValue());
                    }
                    if (classType.equalsIgnoreCase("java.lang.Integer")) {
                        return new BigDecimal(((Integer)result).longValue());
                    }
                    if (classType.equalsIgnoreCase("java.lang.Long")) {
                        return new BigDecimal((Long)result);
                    }
                    if (classType.equalsIgnoreCase("java.lang.Double")) {
                        return new BigDecimal(((Double)result).longValue());
                    }
                    if (!classType.equalsIgnoreCase("java.lang.String")) throw new RuntimeException("JavaScript conversion to BigNumber not implemented for " + classType);
                    return new BigDecimal(new Long((String)result));
                }
                case 8: {
                    return result;
                }
                case 0: {
                    throw new RuntimeException("No data output data type was specified for new field [" + this.meta.getFieldname()[i] + "]");
                }
            }
            throw new RuntimeException("JavaScript conversion not implemented for type " + this.meta.getType()[i] + " (" + ValueMeta.getTypeDesc((int)this.meta.getType()[i]) + ")");
        }
        catch (Exception e) {
            throw new KettleValueException(BaseMessages.getString(PKG, (String)"Script.Log.JavascriptError", (String[])new String[0]), (Throwable)e);
        }
    }

    public RowMetaInterface getOutputRowMeta() {
        return this.data.outputRowMeta;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ScriptMeta)smi;
        this.data = (ScriptData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            try {
                if (this.data.cx != null) {
                    if (this.strEndScript != null && this.strEndScript.length() > 0) {
                        this.data.cx.eval(this.strEndScript, this.data.scope);
                        if (this.log.isDetailed()) {
                            this.logDetailed("End Script found!");
                        }
                    } else if (this.log.isDetailed()) {
                        this.logDetailed("No end Script found!");
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"Script.Log.UnexpectedeError", (String[])new String[0]) + " : " + e.toString());
                this.logError(BaseMessages.getString(PKG, (String)"Script.Log.ErrorStackTrace", (String[])new String[0]) + Const.CR + Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
            }
            if (this.data.cx != null) {
                this.setOutputDone();
            }
            return false;
        }
        try {
            this.addValues(this.getInputRowMeta(), r);
        }
        catch (KettleValueException e) {
            String location = null;
            if (e.getCause() instanceof ScriptException) {
                ScriptException ee = (ScriptException)e.getCause();
                location = "--> " + ee.getLineNumber() + ":" + ee.getColumnNumber();
            }
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.getMessage() + Const.CR + location, null, "SCR-001");
                this.bRC = true;
            }
            throw e;
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Script.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return this.bRC;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ScriptMeta)smi;
        this.data = (ScriptData)sdi;
        if (super.init(smi, sdi)) {
            this.jsScripts = this.meta.getJSScripts();
            block5: for (int j = 0; j < this.jsScripts.length; ++j) {
                switch (this.jsScripts[j].getScriptType()) {
                    case 0: {
                        this.strTransformScript = this.jsScripts[j].getScript();
                        continue block5;
                    }
                    case 1: {
                        this.strStartScript = this.jsScripts[j].getScript();
                        continue block5;
                    }
                    case 2: {
                        this.strEndScript = this.jsScripts[j].getScript();
                        continue block5;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            if (this.data.cx != null) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }
}

