/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sftpput;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sftpput.SFTPPutData;
import org.pentaho.di.trans.steps.sftpput.SFTPPutMeta;

public class SFTPPut
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SFTPPutMeta.class;
    private SFTPPutMeta meta;
    private SFTPPutData data;

    public SFTPPut(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SFTPPutMeta)smi;
        this.data = (SFTPPutData)sdi;
        boolean sendToErrorRow = false;
        String errorMessage = null;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            try {
                String realServerName = this.environmentSubstitute(this.meta.getServerName());
                String realServerPort = this.environmentSubstitute(this.meta.getServerPort());
                String realUsername = this.environmentSubstitute(this.meta.getUserName());
                String realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getPassword()));
                String realKeyFilename = null;
                String realPassPhrase = null;
                if (this.meta.isUseKeyFile()) {
                    realKeyFilename = this.environmentSubstitute(this.meta.getKeyFilename());
                    if (Const.isEmpty((String)realKeyFilename)) {
                        this.logError(BaseMessages.getString(PKG, (String)"SFTPPut.Error.KeyFileMissing", (String[])new String[0]));
                        return false;
                    }
                    if (!KettleVFS.fileExists((String)realKeyFilename)) {
                        this.logError(BaseMessages.getString(PKG, (String)"SFTPPut.Error.KeyFileNotFound", (String[])new String[]{realKeyFilename}));
                        return false;
                    }
                    realPassPhrase = this.environmentSubstitute(this.meta.getKeyPassPhrase());
                }
                this.data.sftpclient = new SFTPClient(InetAddress.getByName(realServerName), Const.toInt((String)realServerPort, (int)22), realUsername, realKeyFilename, realPassPhrase);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SFTPPUT.Log.OpenedConnection", (String[])new String[]{realServerName, realServerPort, realUsername}));
                }
                this.data.sftpclient.setCompression(this.meta.getCompression());
                String realProxyHost = this.environmentSubstitute(this.meta.getProxyHost());
                if (!Const.isEmpty((String)realProxyHost)) {
                    this.data.sftpclient.setProxy(realProxyHost, this.environmentSubstitute(this.meta.getProxyPort()), this.environmentSubstitute(this.meta.getProxyUsername()), this.environmentSubstitute(this.meta.getProxyPassword()), this.meta.getProxyType());
                }
                this.data.sftpclient.login(realPassword);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SFTPPUT.Error.Connection", (String[])new String[0]), (Throwable)e);
            }
            String sourceFilenameFieldName = this.environmentSubstitute(this.meta.getSourceFileFieldName());
            if (Const.isEmpty((String)sourceFilenameFieldName)) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.SourceFileNameFieldMissing", (String[])new String[0]));
            }
            this.data.indexOfSourceFileFieldName = this.getInputRowMeta().indexOfValue(sourceFilenameFieldName);
            if (this.data.indexOfSourceFileFieldName < -1) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.CanNotFindField", (String[])new String[]{sourceFilenameFieldName}));
            }
            String remoteFoldernameFieldName = this.environmentSubstitute(this.meta.getRemoteDirectoryFieldName());
            if (Const.isEmpty((String)remoteFoldernameFieldName)) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.RemoteFolderNameFieldMissing", (String[])new String[0]));
            }
            this.data.indexOfRemoteDirectory = this.getInputRowMeta().indexOfValue(remoteFoldernameFieldName);
            if (this.data.indexOfRemoteDirectory < -1) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.CanNotFindField", (String[])new String[]{remoteFoldernameFieldName}));
            }
            if (this.meta.getAfterFTPS() == 2) {
                String realDestinationFoldernameFieldName = this.environmentSubstitute(this.meta.getDestinationFolderFieldName());
                if (Const.isEmpty((String)realDestinationFoldernameFieldName)) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Log.DestinatFolderNameFieldNameMissing", (String[])new String[0]));
                }
                this.data.indexOfMoveToFolderFieldName = this.getInputRowMeta().indexOfValue(realDestinationFoldernameFieldName);
                if (this.data.indexOfMoveToFolderFieldName < -1) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.CanNotFindField", (String[])new String[]{realDestinationFoldernameFieldName}));
                }
            }
        }
        String sourceData = this.getInputRowMeta().getString(r, this.data.indexOfSourceFileFieldName);
        InputStream inputStream = null;
        FileObject destinationFolder = null;
        FileObject file = null;
        try {
            if (Const.isEmpty((String)sourceData)) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.SourceDataEmpty", (String[])new String[0]));
            }
            if (this.meta.isInputStream()) {
                inputStream = new ByteArrayInputStream(sourceData.getBytes());
            } else {
                file = KettleVFS.getFileObject((String)sourceData);
                if (!file.exists()) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.CanNotFindField", (String[])new String[]{sourceData}));
                }
                inputStream = KettleVFS.getInputStream((FileObject)file);
            }
            if (file != null && this.meta.getAfterFTPS() == 2) {
                String realDestationFolder = this.getInputRowMeta().getString(r, this.data.indexOfMoveToFolderFieldName);
                if (Const.isEmpty((String)realDestationFolder)) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.MoveToDestinationFolderIsEmpty", (String[])new String[0]));
                }
                destinationFolder = KettleVFS.getFileObject((String)realDestationFolder);
                if (!destinationFolder.exists()) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.CanNotFindFolder", (String[])new String[]{realDestationFolder}));
                }
            }
            this.setSFTPDirectory(this.getInputRowMeta().getString(r, this.data.indexOfRemoteDirectory));
            String destinationFilename = file.getName().getBaseName();
            this.data.sftpclient.put(inputStream, destinationFilename);
            if (file != null) {
                this.finishTheJob(file, sourceData, destinationFolder);
            }
            this.putRow(this.getInputRowMeta(), r);
            if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SFTPPut.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (Exception e) {
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"SFTPPut.Log.ErrorInStep", (String[])new String[0]), e);
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                boolean bl = false;
                return bl;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "SFTPPUT001");
            }
        }
        finally {
            try {
                if (destinationFolder != null) {
                    destinationFolder.close();
                }
                if (file != null) {
                    file.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void finishTheJob(FileObject file, String sourceData, FileObject destinationFolder) throws KettleException {
        try {
            switch (this.meta.getAfterFTPS()) {
                case 1: {
                    if (file.exists()) return;
                    file.delete();
                    if (!this.isDetailed()) return;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SFTPPut.Log.DeletedFile", (String[])new String[]{sourceData}));
                    return;
                }
                case 2: {
                    FileObject destination = null;
                    try {
                        destination = KettleVFS.getFileObject((String)(destinationFolder.getName().getBaseName() + Const.FILE_SEPARATOR + file.getName().getBaseName()), (VariableSpace)this);
                        file.moveTo(destination);
                        if (!this.isDetailed()) return;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SFTPPut.Log.FileMoved", (Object[])new Object[]{file, destination}));
                        return;
                    }
                    finally {
                        if (destination != null) {
                            destination.close();
                        }
                    }
                }
                default: {
                    if (!this.meta.isAddFilenameResut()) return;
                    ResultFile resultFile = new ResultFile(0, file, this.getTransMeta().getName(), this.getStepname());
                    resultFile.setComment(BaseMessages.getString(PKG, (String)"SFTPPut.Log.FilenameAddedToResultFilenames", (String[])new String[0]));
                    this.addResultFile(resultFile);
                    if (!this.isDetailed()) return;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SFTPPut.Log.FilenameAddedToResultFilenames", (String[])new String[]{sourceData}));
                }
            }
            return;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    protected void setSFTPDirectory(String spoolDirectory) throws KettleException {
        boolean existfolder = this.data.sftpclient.folderExists(spoolDirectory);
        if (!existfolder) {
            if (!this.meta.isCreateRemoteFolder()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SFTPPut.Error.CanNotFindRemoteFolder", (String[])new String[]{spoolDirectory}));
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SFTPPut.Error.CanNotFindRemoteFolder", (String[])new String[]{spoolDirectory}));
            }
            this.data.sftpclient.createFolder(spoolDirectory);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SFTPPut.Log.RemoteFolderCreated", (String[])new String[]{spoolDirectory}));
            }
        }
        this.data.sftpclient.chdir(spoolDirectory);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"SFTPPut.Log.ChangedDirectory", (String[])new String[]{spoolDirectory}));
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SFTPPutMeta)smi;
        this.data = (SFTPPutData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SFTPPutMeta)smi;
        this.data = (SFTPPutData)sdi;
        try {
            if (this.data.sftpclient != null) {
                this.data.sftpclient.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }
}

