/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.simplemapping;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingParameters;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.di.trans.steps.simplemapping.PutRowInterface;
import org.pentaho.di.trans.steps.simplemapping.RowDataInputMapper;
import org.pentaho.di.trans.steps.simplemapping.RowOutputDataMapper;
import org.pentaho.di.trans.steps.simplemapping.SimpleMappingData;
import org.pentaho.di.trans.steps.simplemapping.SimpleMappingMeta;

public class SimpleMapping
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SimpleMappingMeta.class;
    private SimpleMappingMeta meta;
    private SimpleMappingData data;

    public SimpleMapping(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            Object[] row;
            this.meta = (SimpleMappingMeta)smi;
            this.data = (SimpleMappingData)sdi;
            if (this.first) {
                this.first = false;
                String mappingInputStepname = this.data.mappingInput.getStepname();
                RowProducer rowProducer = this.data.mappingTrans.addRowProducer(mappingInputStepname, 0);
                this.data.rowDataInputMapper = new RowDataInputMapper(this.meta.getInputMapping(), rowProducer);
                String mappingOutputStepname = this.data.mappingOutput.getStepname();
                StepInterface outputStepInterface = this.data.mappingTrans.findStepInterface(mappingOutputStepname, 0);
                RowOutputDataMapper outputDataMapper = new RowOutputDataMapper(this.meta.getInputMapping(), this.meta.getOutputMapping(), new PutRowInterface(){

                    @Override
                    public void putRow(RowMetaInterface rowMeta, Object[] rowData) throws KettleStepException {
                        SimpleMapping.this.putRow(rowMeta, rowData);
                    }
                });
                outputStepInterface.addRowListener(outputDataMapper);
                this.data.mappingTrans.startThreads();
            }
            if ((row = this.getRow()) == null) {
                this.data.rowDataInputMapper.finished();
                this.data.mappingTrans.waitUntilFinished();
                this.setOutputDone();
                return false;
            }
            this.data.rowDataInputMapper.putRow(this.getInputRowMeta(), row);
            return true;
        }
        catch (Throwable t) {
            if (this.data.mappingTrans != null) {
                this.data.mappingTrans.stopAll();
            }
            throw new KettleException(t);
        }
    }

    private void setMappingParameters() throws KettleException {
        MappingParameters mappingParameters = this.meta.getMappingParameters();
        if (mappingParameters != null) {
            int i;
            String[] parameterValues;
            String[] parameters;
            if (mappingParameters.isInheritingAllVariables()) {
                parameters = this.data.mappingTransMeta.listParameters();
                parameterValues = new String[parameters.length];
                for (i = 0; i < parameters.length; ++i) {
                    parameterValues[i] = this.getVariable(parameters[i]);
                }
            } else {
                parameters = mappingParameters.getVariable();
                parameterValues = new String[parameters.length];
                for (i = 0; i < parameters.length; ++i) {
                    parameterValues[i] = this.environmentSubstitute(mappingParameters.getInputField()[i]);
                }
            }
            for (i = 0; i < parameters.length; ++i) {
                String value = Const.NVL((String)parameterValues[i], (String)"");
                this.data.mappingTrans.setParameterValue(parameters[i], value);
            }
            this.data.mappingTrans.activateParameters();
        }
    }

    public void prepareMappingExecution() throws KettleException {
        this.data.mappingTrans = new Trans(this.data.mappingTransMeta, this.getTrans());
        this.setMappingParameters();
        if (this.data.mappingTransMeta.getTransformationType() != TransMeta.TransformationType.Normal) {
            this.data.mappingTrans.getTransMeta().setUsingThreadPriorityManagment(false);
        }
        this.data.mappingTrans.setParentTrans(this.getTrans());
        this.data.mappingTrans.setSafeModeEnabled(this.getTrans().isSafeModeEnabled());
        this.data.mappingTrans.setGatheringMetrics(this.getTrans().isGatheringMetrics());
        this.data.mappingTrans.setMappingStepName(this.getStepname());
        this.data.mappingTrans.setServletPrintWriter(this.getTrans().getServletPrintWriter());
        this.data.mappingTrans.setServletReponse(this.getTrans().getServletResponse());
        this.data.mappingTrans.setServletRequest(this.getTrans().getServletRequest());
        try {
            this.data.mappingTrans.prepareExecution(this.getTrans().getArguments());
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SimpleMapping.Exception.UnableToPrepareExecutionOfMapping", (String[])new String[0]), (Throwable)e);
        }
        MappingInput[] mappingInputs = this.data.mappingTrans.findMappingInput();
        if (mappingInputs.length == 0) {
            throw new KettleException("The simple mapping step needs one Mapping Input step to write to in the sub-transformation");
        }
        if (mappingInputs.length > 1) {
            throw new KettleException("The simple mapping step does not support multiple Mapping Input steps to write to in the sub-transformation");
        }
        this.data.mappingInput = mappingInputs[0];
        this.data.mappingInput.setConnectorSteps(new StepInterface[0], new ArrayList<MappingValueRename>(), null);
        MappingOutput[] mappingOutputs = this.data.mappingTrans.findMappingOutput();
        if (mappingOutputs.length == 0) {
            throw new KettleException("The simple mapping step needs one Mapping Output step to read from in the sub-transformation");
        }
        if (mappingOutputs.length > 1) {
            throw new KettleException("The simple mapping step does not support multiple Mapping Output steps to read from in the sub-transformation");
        }
        this.data.mappingOutput = mappingOutputs[0];
        this.getTrans().getActiveSubtransformations().put(this.getStepname(), this.data.mappingTrans);
    }

    public static void addInputRenames(List<MappingValueRename> renameList, List<MappingValueRename> addRenameList) {
        for (MappingValueRename rename : addRenameList) {
            if (renameList.indexOf(rename) >= 0) continue;
            renameList.add(rename);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SimpleMappingMeta)smi;
        this.data = (SimpleMappingData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.meta.setRepository(this.getTransMeta().getRepository());
                this.data.mappingTransMeta = SimpleMappingMeta.loadMappingMeta(this.meta, this.meta.getRepository(), this.meta.getMetaStore(), this);
                if (this.data.mappingTransMeta != null) {
                    this.prepareMappingExecution();
                    return true;
                }
                this.logError("No valid mapping was specified!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the mapping transformation because of an error : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.wasStarted) {
            this.data.mappingTrans.waitUntilFinished();
            this.getTrans().getActiveSubtransformations().remove(this.getStepname());
            if (this.data.mappingTrans.getErrors() > 0) {
                this.logError(BaseMessages.getString(PKG, (String)"SimpleMapping.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
                this.setErrors(1L);
            }
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.data.mappingTrans != null) {
            this.data.mappingTrans.stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.data.mappingTrans != null) {
            this.data.mappingTrans.stopAll();
        }
        super.stopAll();
    }

    public Trans getMappingTrans() {
        return this.data.mappingTrans;
    }

    @Override
    public void addRowListener(RowListener rowListener) {
        MappingOutput[] mappingOutputs = this.data.mappingTrans.findMappingOutput();
        if (mappingOutputs == null || mappingOutputs.length == 0) {
            return;
        }
        for (MappingOutput mappingOutput : mappingOutputs) {
            mappingOutput.addRowListener(rowListener);
        }
    }
}

