/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.singlethreader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.HasRepositoryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportLocation;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.singlethreader.SingleThreader;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SingleThreaderMeta
extends BaseStepMeta
implements StepMetaInterface,
HasRepositoryInterface {
    private static Class<?> PKG = SingleThreaderMeta.class;
    private String transName;
    private String fileName;
    private String directoryPath;
    private ObjectId transObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private String batchSize;
    private String batchTime;
    private String injectStep;
    private String retrieveStep;
    private boolean passingAllParameters;
    private String[] parameters;
    private String[] parameterValues;
    private IMetaStore metaStore;

    public SingleThreaderMeta() {
        this.setDefault();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            String method = XMLHandler.getTagValue((Node)stepnode, (String)"specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String transId = XMLHandler.getTagValue((Node)stepnode, (String)"trans_object_id");
            this.transObjectId = Const.isEmpty((String)transId) ? null : new StringObjectId(transId);
            this.transName = XMLHandler.getTagValue((Node)stepnode, (String)"trans_name");
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.directoryPath = XMLHandler.getTagValue((Node)stepnode, (String)"directory_path");
            this.batchSize = XMLHandler.getTagValue((Node)stepnode, (String)"batch_size");
            this.batchTime = XMLHandler.getTagValue((Node)stepnode, (String)"batch_time");
            this.injectStep = XMLHandler.getTagValue((Node)stepnode, (String)"inject_step");
            this.retrieveStep = XMLHandler.getTagValue((Node)stepnode, (String)"retrieve_step");
            Node parametersNode = XMLHandler.getSubNode((Node)stepnode, (String)"parameters");
            String passAll = XMLHandler.getTagValue((Node)parametersNode, (String)"pass_all_parameters");
            this.passingAllParameters = Const.isEmpty((String)passAll) || "Y".equalsIgnoreCase(passAll);
            int nrParameters = XMLHandler.countNodes((Node)parametersNode, (String)"parameter");
            this.parameters = new String[nrParameters];
            this.parameterValues = new String[nrParameters];
            for (int i = 0; i < nrParameters; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameters[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.parameterValues[i] = XMLHandler.getTagValue((Node)knode, (String)"value");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SingleThreaderMeta.Exception.ErrorLoadingTransformationStepFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString()));
        if (this.repository != null && this.transObjectId != null) {
            try {
                RepositoryObject objectInformation = this.repository.getObjectInformation(this.transObjectId, RepositoryObjectType.TRANSFORMATION);
                if (objectInformation != null) {
                    this.transName = objectInformation.getName();
                    this.directoryPath = objectInformation.getRepositoryDirectory().getPath();
                }
            }
            catch (KettleException e) {
                // empty catch block
            }
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_name", (String)this.transName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.fileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"directory_path", (String)this.directoryPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"batch_size", (String)this.batchSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"batch_time", (String)this.batchTime));
        retval.append("    ").append(XMLHandler.addTagValue((String)"inject_step", (String)this.injectStep));
        retval.append("    ").append(XMLHandler.addTagValue((String)"retrieve_step", (String)this.retrieveStep));
        if (this.parameters != null) {
            retval.append("      ").append(XMLHandler.openTag((String)"parameters"));
            retval.append("        ").append(XMLHandler.addTagValue((String)"pass_all_parameters", (boolean)this.passingAllParameters));
            for (int i = 0; i < this.parameters.length; ++i) {
                retval.append("            ").append(XMLHandler.openTag((String)"parameter"));
                retval.append("            ").append(XMLHandler.addTagValue((String)"name", (String)this.parameters[i]));
                retval.append("            ").append(XMLHandler.addTagValue((String)"value", (String)this.parameterValues[i]));
                retval.append("            ").append(XMLHandler.closeTag((String)"parameter"));
            }
            retval.append("      ").append(XMLHandler.closeTag((String)"parameters"));
        }
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        String method = rep.getStepAttributeString(id_step, "specification_method");
        this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
        String transId = rep.getStepAttributeString(id_step, "trans_object_id");
        this.transObjectId = Const.isEmpty((String)transId) ? null : new StringObjectId(transId);
        this.transName = rep.getStepAttributeString(id_step, "trans_name");
        this.fileName = rep.getStepAttributeString(id_step, "filename");
        this.directoryPath = rep.getStepAttributeString(id_step, "directory_path");
        this.batchSize = rep.getStepAttributeString(id_step, "batch_size");
        this.batchTime = rep.getStepAttributeString(id_step, "batch_time");
        this.injectStep = rep.getStepAttributeString(id_step, "inject_step");
        this.retrieveStep = rep.getStepAttributeString(id_step, "retrieve_step");
        int parameternr = rep.countNrStepAttributes(id_step, "parameter_name");
        this.parameters = new String[parameternr];
        this.parameterValues = new String[parameternr];
        for (int a = 0; a < parameternr; ++a) {
            this.parameters[a] = rep.getStepAttributeString(id_step, a, "parameter_name");
            this.parameterValues[a] = rep.getStepAttributeString(id_step, a, "parameter_value");
        }
        this.passingAllParameters = rep.getStepAttributeBoolean(id_step, 0, "pass_all_parameters", true);
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode());
        rep.saveStepAttribute(id_transformation, id_step, "trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString());
        rep.saveStepAttribute(id_transformation, id_step, "filename", this.fileName);
        rep.saveStepAttribute(id_transformation, id_step, "trans_name", this.transName);
        rep.saveStepAttribute(id_transformation, id_step, "directory_path", this.directoryPath);
        rep.saveStepAttribute(id_transformation, id_step, "batch_size", this.batchSize);
        rep.saveStepAttribute(id_transformation, id_step, "batch_time", this.batchTime);
        rep.saveStepAttribute(id_transformation, id_step, "inject_step", this.injectStep);
        rep.saveStepAttribute(id_transformation, id_step, "retrieve_step", this.retrieveStep);
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_name", this.parameters[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_value", Const.NVL((String)this.parameterValues[i], (String)""));
            }
        }
        rep.saveStepAttribute(id_transformation, id_step, "pass_all_parameters", this.passingAllParameters);
    }

    @Override
    public void setDefault() {
        this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
        this.batchSize = "100";
        this.batchTime = "";
        this.passingAllParameters = true;
        this.parameters = new String[0];
        this.parameterValues = new String[0];
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        TransMeta mappingTransMeta = null;
        try {
            mappingTransMeta = SingleThreaderMeta.loadSingleThreadedTransMeta(this, repository, space);
        }
        catch (KettleException e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"SingleThreaderMeta.Exception.UnableToLoadMappingTransformation", (String[])new String[0]), (Throwable)e);
        }
        row.clear();
        if (!Const.isEmpty((String)space.environmentSubstitute(this.retrieveStep))) {
            RowMetaInterface stepFields = mappingTransMeta.getStepFields(this.retrieveStep);
            row.addRowMeta(stepFields);
        }
    }

    public static final synchronized TransMeta loadSingleThreadedTransMeta(SingleThreaderMeta mappingMeta, Repository rep, VariableSpace space) throws KettleException {
        return SingleThreaderMeta.loadSingleThreadedTransMeta(mappingMeta, rep, null, space);
    }

    public static final synchronized TransMeta loadSingleThreadedTransMeta(SingleThreaderMeta mappingMeta, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        TransMeta mappingTransMeta = null;
        switch (mappingMeta.getSpecificationMethod()) {
            case FILENAME: {
                String realFilename = space.environmentSubstitute(mappingMeta.getFileName());
                try {
                    mappingTransMeta = new TransMeta(realFilename, false);
                    mappingTransMeta.getLogChannel().logDetailed("Loading Mapping from repository", new Object[]{"Mapping transformation was loaded from XML file [" + realFilename + "]"});
                    break;
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderMeta.Exception.UnableToLoadMapping", (String[])new String[0]), (Throwable)e);
                }
            }
            case REPOSITORY_BY_NAME: {
                String realTransname = space.environmentSubstitute(mappingMeta.getTransName());
                String realDirectory = space.environmentSubstitute(mappingMeta.getDirectoryPath());
                if (Const.isEmpty((String)realTransname) || Const.isEmpty((String)realDirectory) || rep == null) break;
                RepositoryDirectoryInterface repdir = rep.findDirectory(realDirectory);
                if (repdir != null) {
                    try {
                        mappingTransMeta = rep.loadTransformation(realTransname, repdir, null, true, null);
                        mappingTransMeta.getLogChannel().logDetailed("Loading Mapping from repository", new Object[]{"Mapping transformation [" + realTransname + "] was loaded from the repository"});
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException("Unable to load transformation [" + realTransname + "]", (Throwable)e);
                    }
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderMeta.Exception.UnableToLoadTransformation", (String[])new String[]{realTransname}) + realDirectory);
            }
            case REPOSITORY_BY_REFERENCE: {
                mappingTransMeta = rep.loadTransformation(mappingMeta.getTransObjectId(), null);
                break;
            }
        }
        mappingTransMeta.copyVariablesFrom(space);
        mappingTransMeta.setRepository(rep);
        mappingTransMeta.setMetaStore(metaStore);
        mappingTransMeta.setFilename(mappingTransMeta.getFilename());
        return mappingTransMeta;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"SingleThreaderMeta.CheckResult.NotReceivingAnyFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SingleThreaderMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SingleThreaderMeta.CheckResult.StepReceivingFieldsFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SingleThreaderMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SingleThreader(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SingleThreaderData();
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String transName) {
        this.transName = transName;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = transMeta.environmentSubstitute(this.fileName);
        String realTransname = transMeta.environmentSubstitute(this.transName);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        if (!Const.isEmpty((String)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        } else if (!Const.isEmpty((String)realTransname)) {
            reference.getEntries().add(new ResourceEntry(realTransname, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            TransMeta mappingTransMeta = SingleThreaderMeta.loadSingleThreadedTransMeta(this, repository, space);
            String proposedNewFilename = mappingTransMeta.exportResources(mappingTransMeta, definitions, resourceNamingInterface, repository, metaStore);
            String newFilename = "${Internal.Transformation.Filename.Directory}/" + proposedNewFilename;
            mappingTransMeta.setFilename(newFilename);
            mappingTransMeta.setRepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory());
            this.fileName = newFilename;
            return proposedNewFilename;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderMeta.Exception.UnableToLoadTransformation", (String[])new String[]{this.fileName}));
        }
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public ObjectId getTransObjectId() {
        return this.transObjectId;
    }

    public void setTransObjectId(ObjectId transObjectId) {
        this.transObjectId = transObjectId;
    }

    public ObjectLocationSpecificationMethod getSpecificationMethod() {
        return this.specificationMethod;
    }

    public void setSpecificationMethod(ObjectLocationSpecificationMethod specificationMethod) {
        this.specificationMethod = specificationMethod;
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getInjectStep() {
        return this.injectStep;
    }

    public void setInjectStep(String injectStep) {
        this.injectStep = injectStep;
    }

    public String getRetrieveStep() {
        return this.retrieveStep;
    }

    public void setRetrieveStep(String retrieveStep) {
        this.retrieveStep = retrieveStep;
    }

    public boolean isPassingAllParameters() {
        return this.passingAllParameters;
    }

    public void setPassingAllParameters(boolean passingAllParameters) {
        this.passingAllParameters = passingAllParameters;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public String[] getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(String[] parameterValues) {
        this.parameterValues = parameterValues;
    }

    public String getBatchTime() {
        return this.batchTime;
    }

    public void setBatchTime(String batchTime) {
        this.batchTime = batchTime;
    }

    @Override
    public boolean hasRepositoryReferences() {
        return this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
    }

    @Override
    public void lookupRepositoryReferences(Repository repository) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = RepositoryImportLocation.getRepositoryImportLocation().findDirectory(this.directoryPath);
        this.transObjectId = repository.getTransformationID(this.transName, repositoryDirectoryInterface);
    }

    @Override
    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"SingleThreaderMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isTransformationDefined() {
        return !Const.isEmpty((String)this.fileName) || this.transObjectId != null || !Const.isEmpty((String)this.directoryPath) && !Const.isEmpty((String)this.transName);
    }

    @Override
    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isTransformationDefined()};
    }

    @Override
    @Deprecated
    public Object loadReferencedObject(int index, Repository rep, VariableSpace space) throws KettleException {
        return SingleThreaderMeta.loadSingleThreadedTransMeta(this, rep, space);
    }

    @Override
    public Object loadReferencedObject(int index, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return SingleThreaderMeta.loadSingleThreadedTransMeta(this, rep, metaStore, space);
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }
}

