/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sort;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sort.RowTempFile;
import org.pentaho.di.trans.steps.sort.SortRowsData;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;

public class SortRows
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SortRows.class;
    private SortRowsMeta meta = (SortRowsMeta)this.getStepMeta().getStepMetaInterface();
    private SortRowsData data;

    public SortRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (SortRowsData)stepDataInterface;
    }

    private boolean addBuffer(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        if (r != null) {
            for (int i = 0; i < this.data.fieldnrs.length; ++i) {
                if (!this.data.convertKeysToNative[i]) continue;
                int index = this.data.fieldnrs[i];
                r[index] = rowMeta.getValueMeta(index).convertBinaryStringToNativeType((byte[])r[index]);
            }
            this.data.buffer.add(r);
        }
        if (this.data.files.size() == 0 && r == null) {
            this.quickSort(this.data.buffer);
        }
        ++this.data.freeCounter;
        if (this.data.sortSize <= 0 && this.data.freeCounter >= 1000) {
            this.data.freeMemoryPct = Const.getPercentageFreeMemory();
            this.data.freeCounter = 0;
            if (this.log.isDetailed()) {
                ++this.data.memoryReporting;
                if (this.data.memoryReporting >= 10) {
                    if (this.log.isDetailed()) {
                        this.logDetailed("Available memory : " + this.data.freeMemoryPct + "%");
                    }
                    this.data.memoryReporting = 0;
                }
            }
        }
        boolean doSort = this.data.buffer.size() == this.data.sortSize;
        doSort |= this.data.files.size() > 0 && r == null && this.data.buffer.size() > 0;
        if (doSort |= this.data.freeMemoryPctLimit > 0 && this.data.freeMemoryPct < this.data.freeMemoryPctLimit && this.data.buffer.size() >= this.data.minSortSize) {
            this.sortExternalRows();
        }
        return true;
    }

    private void sortExternalRows() throws KettleException {
        this.quickSort(this.data.buffer);
        try {
            DataOutputStream dos;
            GZIPOutputStream gzos;
            FileObject fileObject = KettleVFS.createTempFile((String)this.meta.getPrefix(), (String)".tmp", (String)this.environmentSubstitute(this.meta.getDirectory()), (VariableSpace)this.getTransMeta());
            this.data.files.add(fileObject);
            OutputStream outputStream = KettleVFS.getOutputStream((FileObject)fileObject, (boolean)false);
            if (this.data.compressFiles) {
                gzos = new GZIPOutputStream(new BufferedOutputStream(outputStream));
                dos = new DataOutputStream(gzos);
            } else {
                dos = new DataOutputStream(new BufferedOutputStream(outputStream, 500000));
                gzos = null;
            }
            ArrayList<Integer> duplicates = new ArrayList<Integer>();
            Object[] previousRow = null;
            if (this.meta.isOnlyPassingUniqueRows()) {
                for (int index = 0; index < this.data.buffer.size(); ++index) {
                    int result;
                    Object[] row = this.data.buffer.get(index);
                    if (previousRow != null && (result = this.data.outputRowMeta.compare(row, previousRow, this.data.fieldnrs)) == 0) {
                        duplicates.add(index);
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("Duplicate row removed: " + this.data.outputRowMeta.getString(row));
                        }
                    }
                    previousRow = row;
                }
            }
            this.data.bufferSizes.add(this.data.buffer.size() - duplicates.size());
            int duplicatesIndex = 0;
            for (int p = 0; p < this.data.buffer.size(); ++p) {
                boolean skip = false;
                if (duplicatesIndex < duplicates.size() && p == (Integer)duplicates.get(duplicatesIndex)) {
                    skip = true;
                    ++duplicatesIndex;
                }
                if (skip) continue;
                this.data.outputRowMeta.writeData(dos, this.data.buffer.get(p));
            }
            if (this.data.sortSize < 0 && this.data.buffer.size() > this.data.minSortSize) {
                this.data.minSortSize = this.data.buffer.size();
                this.data.minSortSize = (int)Math.round((double)this.data.minSortSize * 0.9);
            }
            this.data.buffer.clear();
            dos.close();
            if (gzos != null) {
                gzos.close();
            }
            outputStream.close();
            this.data.freeMemoryPct = Const.getPercentageFreeMemory();
            this.data.freeCounter = 0;
            if (this.data.sortSize <= 0 && this.log.isDetailed()) {
                this.logDetailed("Available memory : " + this.data.freeMemoryPct + "%");
            }
        }
        catch (Exception e) {
            throw new KettleException("Error processing temp-file!", (Throwable)e);
        }
        this.data.getBufferIndex = 0;
    }

    private DataInputStream getDataInputStream(GZIPInputStream gzipInputStream) {
        DataInputStream result = new DataInputStream(gzipInputStream);
        this.data.gzis.add(gzipInputStream);
        return result;
    }

    private Object[] getBuffer() throws KettleValueException {
        Object[] retval;
        if (this.data.files.size() > 0 && (this.data.dis.size() == 0 || this.data.fis.size() == 0)) {
            if (this.log.isBasic()) {
                this.logBasic("Opening " + this.data.files.size() + " tmp-files...");
            }
            try {
                for (int f = 0; f < this.data.files.size() && !this.isStopped(); ++f) {
                    FileObject fileObject = this.data.files.get(f);
                    String filename = KettleVFS.getFilename((FileObject)fileObject);
                    if (this.log.isDetailed()) {
                        this.logDetailed("Opening tmp-file: [" + filename + "]");
                    }
                    InputStream fi = KettleVFS.getInputStream((FileObject)fileObject);
                    this.data.fis.add(fi);
                    DataInputStream di = this.data.compressFiles ? this.getDataInputStream(new GZIPInputStream(new BufferedInputStream(fi))) : new DataInputStream(new BufferedInputStream(fi, 50000));
                    this.data.dis.add(di);
                    int buffersize = this.data.bufferSizes.get(f);
                    if (this.log.isDetailed()) {
                        this.logDetailed("[" + filename + "] expecting " + buffersize + " rows...");
                    }
                    if (buffersize <= 0) continue;
                    Object[] row = this.data.outputRowMeta.readData(di);
                    this.data.rowbuffer.add(row);
                    this.data.tempRows.add(new RowTempFile(row, f));
                }
                Collections.sort(this.data.tempRows, this.data.comparator);
            }
            catch (Exception e) {
                this.logError("Error reading back tmp-files : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        if (this.data.files.size() == 0) {
            if (this.data.getBufferIndex < this.data.buffer.size()) {
                retval = this.data.buffer.get(this.data.getBufferIndex);
                ++this.data.getBufferIndex;
            } else {
                retval = null;
            }
        } else if (this.data.rowbuffer.size() == 0) {
            retval = null;
        } else {
            if (this.log.isRowLevel()) {
                for (int i = 0; i < this.data.rowbuffer.size() && !this.isStopped(); ++i) {
                    Object[] b = this.data.rowbuffer.get(i);
                    this.logRowlevel("--BR#" + i + ": " + this.data.outputRowMeta.getString(b));
                }
            }
            RowTempFile rowTempFile = this.data.tempRows.remove(0);
            retval = rowTempFile.row;
            int smallest = rowTempFile.fileNumber;
            FileObject file = this.data.files.get(smallest);
            DataInputStream di = this.data.dis.get(smallest);
            InputStream fi = this.data.fis.get(smallest);
            try {
                Object[] row2 = this.data.outputRowMeta.readData(di);
                RowTempFile extra = new RowTempFile(row2, smallest);
                int index = Collections.binarySearch(this.data.tempRows, extra, this.data.comparator);
                if (index < 0) {
                    this.data.tempRows.add(index * -1 - 1, extra);
                } else {
                    this.data.tempRows.add(index, extra);
                }
            }
            catch (KettleFileException fe) {
                GZIPInputStream gzfi = this.data.compressFiles ? this.data.gzis.get(smallest) : null;
                try {
                    di.close();
                    fi.close();
                    if (gzfi != null) {
                        gzfi.close();
                    }
                    file.delete();
                }
                catch (IOException e) {
                    this.logError("Unable to close/delete file #" + smallest + " --> " + file.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
                this.data.files.remove(smallest);
                this.data.dis.remove(smallest);
                this.data.fis.remove(smallest);
                if (gzfi != null) {
                    this.data.gzis.remove(smallest);
                }
                for (RowTempFile rtf : this.data.tempRows) {
                    if (rtf.fileNumber <= smallest) continue;
                    --rtf.fileNumber;
                }
            }
            catch (SocketTimeoutException e) {
                throw new KettleValueException((Throwable)e);
            }
        }
        return retval;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (!this.meta.isGroupSortEnabled()) {
            boolean retval = this.processSortRow(smi, sdi, this.getRow(), this.first);
            return retval;
        }
        Object[] r = this.getRow();
        if (this.first) {
            if (r == null) {
                this.setOutputDone();
                return true;
            }
            this.data.groupnrs = new int[this.meta.getGroupFields().size()];
            for (int i = 0; i < this.meta.getGroupFields().size(); ++i) {
                this.data.groupnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getGroupFields().get(i));
                if (this.data.groupnrs[i] >= 0) continue;
                this.logError(String.format("Presorted Field %s cound not be found", this.meta.getGroupFields().get(i)));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        boolean retval = true;
        if (this.first || this.data.newBatch) {
            this.first = false;
            this.data.newBatch = false;
            this.setPrevious(r);
            boolean moreInput = r != null;
            retval = this.processSortRow(smi, sdi, r, moreInput);
        } else if (this.sameGroup(this.data.previous, r)) {
            this.setPrevious(r);
            retval = this.processSortRow(smi, sdi, r, false);
        } else {
            this.processSortRow(smi, sdi, null, false);
            this.setPrevious(r);
            this.data.newBatch = true;
            this.init(smi, sdi);
            retval = this.processSortRow(smi, sdi, r, true);
        }
        if (r == null) {
            this.setOutputDone();
        }
        return retval;
    }

    public boolean processSortRow(StepMetaInterface smi, StepDataInterface sdi, Object[] r, boolean first) throws KettleException {
        boolean err = true;
        if (first && r != null) {
            first = false;
            this.data.convertKeysToNative = new boolean[this.meta.getFieldName().length];
            this.data.fieldnrs = new int[this.meta.getFieldName().length];
            for (int i = 0; i < this.meta.getFieldName().length; ++i) {
                this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldName()[i]);
                if (this.data.fieldnrs[i] < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.StepFieldNotInInputStream", (String[])new String[]{this.meta.getFieldName()[i], this.getStepname()}));
                }
                this.data.convertKeysToNative[i] = this.getInputRowMeta().getValueMeta(this.data.fieldnrs[i]).isStorageBinaryString();
            }
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
        }
        if (!(err = this.addBuffer(this.getInputRowMeta(), r))) {
            this.setOutputDone();
            return false;
        }
        if (r == null) {
            this.passBuffer(!this.meta.isGroupSortEnabled());
            return false;
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private void passBuffer(boolean signal) throws KettleException {
        Object[] r = this.getBuffer();
        Object[] previousRow = null;
        while (r != null && !this.isStopped()) {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Read row: " + this.getInputRowMeta().getString(r));
            }
            if (this.meta.isOnlyPassingUniqueRows()) {
                if (previousRow != null) {
                    int result = this.data.outputRowMeta.compare(r, previousRow, this.data.fieldnrs);
                    if (result != 0) {
                        this.putRow(this.data.outputRowMeta, r);
                    }
                } else {
                    this.putRow(this.data.outputRowMeta, r);
                }
                previousRow = r;
            } else {
                this.putRow(this.data.outputRowMeta, r);
            }
            r = this.getBuffer();
        }
        this.clearBuffers();
        if (signal) {
            this.setOutputDone();
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SortRowsMeta)smi;
        this.data = (SortRowsData)sdi;
        if (super.init(smi, sdi)) {
            this.data.sortSize = Const.toInt((String)this.environmentSubstitute(this.meta.getSortSize()), (int)-1);
            this.data.freeMemoryPctLimit = Const.toInt((String)this.meta.getFreeMemoryLimit(), (int)-1);
            if (this.data.sortSize <= 0 && this.data.freeMemoryPctLimit <= 0) {
                this.data.freeMemoryPctLimit = 25;
            }
            this.data.buffer = new ArrayList<Object[]>(5000);
            this.data.rowbuffer = new ArrayList<Object[]>(5000);
            this.data.compressFiles = this.getBooleanValueOfVariable(this.meta.getCompressFilesVariable(), this.meta.getCompressFiles());
            this.data.comparator = new Comparator<RowTempFile>(){

                @Override
                public int compare(RowTempFile o1, RowTempFile o2) {
                    try {
                        return ((SortRows)SortRows.this).data.outputRowMeta.compare(o1.row, o2.row, ((SortRows)SortRows.this).data.fieldnrs);
                    }
                    catch (KettleValueException e) {
                        SortRows.this.logError("Error comparing rows: " + e.toString());
                        return 0;
                    }
                }
            };
            this.data.tempRows = new ArrayList<RowTempFile>();
            this.data.minSortSize = 5000;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.clearBuffers();
        super.dispose(smi, sdi);
    }

    private void clearBuffers() {
        this.data.buffer = new ArrayList<Object[]>(1);
        this.data.getBufferIndex = 0;
        this.data.rowbuffer = new ArrayList<Object[]>(1);
        if (this.data.dis != null && this.data.dis.size() > 0) {
            for (DataInputStream dis : this.data.dis) {
                BaseStep.closeQuietly(dis);
            }
        }
        if (this.data.fis != null && this.data.fis.size() > 0) {
            for (InputStream is : this.data.fis) {
                BaseStep.closeQuietly(is);
            }
        }
        for (int f = 0; f < this.data.files.size(); ++f) {
            FileObject fileToDelete = this.data.files.get(f);
            try {
                if (fileToDelete == null || !fileToDelete.exists()) continue;
                fileToDelete.delete();
                continue;
            }
            catch (FileSystemException e) {
                this.logError(e.getLocalizedMessage(), e);
            }
        }
    }

    public void quickSort(List<Object[]> elements) throws KettleException {
        if (this.log.isDetailed()) {
            this.logDetailed("Starting quickSort algorithm...");
        }
        if (elements.size() > 0) {
            Collections.sort(elements, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] o1, Object[] o2) {
                    Object[] r1 = o1;
                    Object[] r2 = o2;
                    try {
                        return ((SortRows)SortRows.this).data.outputRowMeta.compare(r1, r2, ((SortRows)SortRows.this).data.fieldnrs);
                    }
                    catch (KettleValueException e) {
                        SortRows.this.logError("Error comparing rows: " + e.toString());
                        return 0;
                    }
                }
            });
            long nrConversions = 0L;
            for (ValueMetaInterface valueMeta : this.data.outputRowMeta.getValueMetaList()) {
                nrConversions += valueMeta.getNumberOfBinaryStringConversions();
                valueMeta.setNumberOfBinaryStringConversions(0L);
            }
            if (this.log.isDetailed()) {
                this.logDetailed("The number of binary string to data type conversions done in this sort block is " + nrConversions);
            }
        }
        if (this.log.isDetailed()) {
            this.logDetailed("QuickSort algorithm has finished.");
        }
    }

    @Override
    public void batchComplete() throws KettleException {
        if (this.data.files.size() > 0) {
            this.sortExternalRows();
        } else {
            this.quickSort(this.data.buffer);
        }
        this.passBuffer(!this.meta.isGroupSortEnabled());
    }

    private boolean sameGroup(Object[] previous, Object[] r) throws KettleValueException {
        if (r == null) {
            return false;
        }
        return this.getInputRowMeta().compare(previous, r, this.data.groupnrs) == 0;
    }

    private void setPrevious(Object[] r) throws KettleException {
        if (r != null) {
            this.data.previous = this.getInputRowMeta().cloneRow(r);
        }
    }
}

