/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sort;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;

public class SortRowsMetaInjection
implements StepMetaInjectionInterface {
    private SortRowsMeta meta;

    public SortRowsMetaInjection(SortRowsMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] fieldsEntries;
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.SORT_SIZE_ROWS, Entry.ONLY_PASS_UNIQUE_ROWS, Entry.COMPRESS_TEMP_FILES, Entry.SORT_DIRECTORY, Entry.SORT_FILE_PREFIX, Entry.FREE_MEMORY_TRESHOLD}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry("FIELDS", 0, Entry.FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry("FIELD", 0, Entry.FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : fieldsEntries = new Entry[]{Entry.NAME, Entry.SORT_ASCENDING, Entry.IGNORE_CASE, Entry.PRESORTED}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<String> sortNames = new ArrayList<String>();
        ArrayList<Boolean> sortAscs = new ArrayList<Boolean>();
        ArrayList<Boolean> sortCases = new ArrayList<Boolean>();
        ArrayList<Boolean> sortPresorteds = new ArrayList<Boolean>();
        block15: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case FIELDS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry == null || fieldEntry != Entry.FIELD) continue;
                        String sortName = null;
                        boolean sortAsc = false;
                        boolean sortCase = false;
                        boolean sortPresorted = false;
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case NAME: {
                                    sortName = value;
                                    break;
                                }
                                case SORT_ASCENDING: {
                                    sortAsc = "Y".equalsIgnoreCase(value);
                                    break;
                                }
                                case IGNORE_CASE: {
                                    sortCase = "Y".equalsIgnoreCase(value);
                                    break;
                                }
                                case PRESORTED: {
                                    sortPresorted = "Y".equalsIgnoreCase(value);
                                    break;
                                }
                            }
                        }
                        sortNames.add(sortName);
                        sortAscs.add(sortAsc);
                        sortCases.add(sortCase);
                        sortPresorteds.add(sortPresorted);
                    }
                    continue block15;
                }
                case COMPRESS_TEMP_FILES: {
                    this.meta.setCompressFiles("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ONLY_PASS_UNIQUE_ROWS: {
                    this.meta.setOnlyPassingUniqueRows("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case SORT_SIZE_ROWS: {
                    this.meta.setSortSize(lookValue);
                    break;
                }
                case SORT_DIRECTORY: {
                    this.meta.setDirectory(lookValue);
                    break;
                }
                case SORT_FILE_PREFIX: {
                    this.meta.setPrefix(lookValue);
                    break;
                }
                case FREE_MEMORY_TRESHOLD: {
                    this.meta.setFreeMemoryLimit(lookValue);
                    break;
                }
            }
        }
        this.meta.setFieldName(sortNames.toArray(new String[sortNames.size()]));
        boolean[] ascending = new boolean[sortAscs.size()];
        boolean[] cases = new boolean[sortCases.size()];
        boolean[] presorteds = new boolean[sortPresorteds.size()];
        for (int i = 0; i < ascending.length; ++i) {
            ascending[i] = (Boolean)sortAscs.get(i);
            cases[i] = (Boolean)sortCases.get(i);
            presorteds[i] = (Boolean)sortPresorteds.get(i);
        }
        this.meta.setAscending(ascending);
        this.meta.setCaseSensitive(cases);
        this.meta.setPreSortedField(presorteds);
    }

    public SortRowsMeta getMeta() {
        return this.meta;
    }

    private static enum Entry {
        SORT_SIZE_ROWS(2, "In memory sort size (in rows)"),
        SORT_DIRECTORY(2, "The sort directory"),
        SORT_FILE_PREFIX(2, "The sort file prefix"),
        FREE_MEMORY_TRESHOLD(2, "The free memory treshold (in %)"),
        ONLY_PASS_UNIQUE_ROWS(2, "Only pass unique rows? (Y/N)"),
        COMPRESS_TEMP_FILES(2, "Compress temporary files? (Y/N)"),
        FIELDS(0, "All the fields to sort"),
        FIELD(0, "One field to sort"),
        NAME(2, "Field name"),
        SORT_ASCENDING(2, "Sort ascending? (Y/N)"),
        IGNORE_CASE(2, "Ignore case? (Y/N)"),
        PRESORTED(2, "Presorted? (Y/N)");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

