/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.switchcase;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.switchcase.ContainsKeyToRowSetMap;
import org.pentaho.di.trans.steps.switchcase.KeyToRowSetMap;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseData;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseMeta;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseTarget;

public class SwitchCase
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SwitchCaseMeta.class;
    private SwitchCaseMeta meta;
    private SwitchCaseData data;

    public SwitchCase(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SwitchCaseMeta)smi;
        this.data = (SwitchCaseData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.getInputRowMeta(), this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.fieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getFieldname());
            if (this.data.fieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCase.Exception.UnableToFindFieldName", (String[])new String[]{this.meta.getFieldname()}));
            }
            this.data.inputValueMeta = this.getInputRowMeta().getValueMeta(this.data.fieldIndex);
            try {
                SwitchCaseTarget target;
                StepIOMetaInterface ioMeta = this.meta.getStepIOMeta();
                List<StreamInterface> targetStreams = ioMeta.getTargetStreams();
                for (int i = 0; i < targetStreams.size() && (target = (SwitchCaseTarget)targetStreams.get(i).getSubject()) != null; ++i) {
                    if (target.caseTargetStep == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCase.Log.NoTargetStepSpecifiedForValue", (String[])new String[]{target.caseValue}));
                    }
                    RowSet rowSet = this.findOutputRowSet(target.caseTargetStep.getName());
                    if (rowSet != null) {
                        try {
                            Object value = this.data.valueMeta.convertDataFromString(target.caseValue, this.data.stringValueMeta, null, null, 0);
                            if (this.data.valueMeta.isNull(value)) {
                                this.data.nullRowSet = rowSet;
                                continue;
                            }
                            this.data.outputMap.put(value, rowSet);
                            continue;
                        }
                        catch (Exception e) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCase.Log.UnableToConvertValue", (String[])new String[]{target.caseValue}), (Throwable)e);
                        }
                    }
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCase.Log.UnableToFindTargetRowSetForStep", (Object[])new Object[]{target.caseTargetStep}));
                }
                this.data.defaultRowSet = this.meta.getDefaultTargetStep() != null ? this.findOutputRowSet(this.meta.getDefaultTargetStep().getName()) : null;
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
        Object lookupData = this.data.valueMeta.convertData(this.data.inputValueMeta, r[this.data.fieldIndex]);
        RowSet rowSet = null;
        rowSet = lookupData == null ? this.data.nullRowSet : this.data.outputMap.get(lookupData);
        if (rowSet == null) {
            if (this.data.defaultRowSet != null) {
                this.putRowTo(this.data.outputRowMeta, r, this.data.defaultRowSet);
            }
        } else {
            this.putRowTo(this.data.outputRowMeta, r, rowSet);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SwitchCase.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SwitchCaseMeta)smi;
        this.data = (SwitchCaseData)sdi;
        if (super.init(smi, sdi)) {
            KeyToRowSetMap keyToRowSetMap = this.data.outputMap = this.meta.isContains() ? new ContainsKeyToRowSetMap() : new KeyToRowSetMap();
            if (Const.isEmpty((String)this.meta.getFieldname())) {
                this.logError(BaseMessages.getString(PKG, (String)"SwitchCase.Log.NoFieldSpecifiedToSwitchWith", (String[])new String[0]));
                return false;
            }
            try {
                this.data.valueMeta = ValueMetaFactory.createValueMeta((String)this.meta.getFieldname(), (int)this.meta.getCaseValueType());
                this.data.valueMeta.setConversionMask(this.meta.getCaseValueFormat());
                this.data.valueMeta.setGroupingSymbol(this.meta.getCaseValueGroup());
                this.data.valueMeta.setDecimalSymbol(this.meta.getCaseValueDecimal());
                this.data.stringValueMeta = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)this.data.valueMeta, (int)2);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"SwitchCase.Log.UnexpectedError", (Object[])new Object[]{e}));
            }
            return true;
        }
        return false;
    }
}

