/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.systemdata;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.systemdata.Management;
import org.pentaho.di.trans.steps.systemdata.SystemDataData;
import org.pentaho.di.trans.steps.systemdata.SystemDataMeta;
import org.pentaho.di.version.BuildVersion;

public class SystemData
extends BaseStep
implements StepInterface {
    private SystemDataMeta meta;
    private SystemDataData data;

    public SystemData(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] getSystemData(RowMetaInterface inputRowMeta, Object[] inputRowData) throws KettleException {
        int i;
        Object[] row = new Object[this.data.outputRowMeta.size()];
        for (i = 0; i < inputRowMeta.size(); ++i) {
            row[i] = inputRowData[i];
        }
        i = 0;
        int index = inputRowMeta.size();
        while (i < this.meta.getFieldName().length) {
            int argnr = 0;
            switch (this.meta.getFieldType()[i]) {
                case 2: {
                    row[index] = this.getTrans().getCurrentDate();
                    break;
                }
                case 1: {
                    row[index] = new Date();
                    break;
                }
                case 3: {
                    row[index] = this.getTrans().getStartDate();
                    break;
                }
                case 4: {
                    row[index] = this.getTrans().getEndDate();
                    break;
                }
                case 5: {
                    row[index] = this.getTrans().getJobStartDate();
                    break;
                }
                case 6: {
                    row[index] = this.getTrans().getJobEndDate();
                    break;
                }
                case 7: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 8: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 9: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 10: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 11: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 12: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 13: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 14: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 15: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 16: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 17: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 18: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 1);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 19: {
                    row[index] = new Long(this.getCopy());
                    break;
                }
                case 20: {
                    row[index] = this.getTransMeta().getName();
                    break;
                }
                case 22: {
                    row[index] = this.getTransMeta().getModifiedUser();
                    break;
                }
                case 23: {
                    row[index] = this.getTransMeta().getModifiedDate();
                    break;
                }
                case 24: {
                    row[index] = new Long(this.getTrans().getBatchId());
                    break;
                }
                case 25: {
                    row[index] = new Long(this.getTrans().getPassedBatchId());
                    break;
                }
                case 26: {
                    row[index] = Const.getHostname();
                    break;
                }
                case 27: {
                    try {
                        row[index] = Const.getIPAddress();
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                }
                case 21: {
                    row[index] = this.getTransMeta().getFilename();
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    argnr = this.meta.getFieldType()[i] - 28;
                    if (this.getTrans().getArguments() != null && argnr < this.getTrans().getArguments().length) {
                        row[index] = this.getTrans().getArguments()[argnr];
                        break;
                    }
                    row[index] = null;
                    break;
                }
                case 38: {
                    row[index] = "5.0.1-stable";
                    break;
                }
                case 39: {
                    row[index] = BuildVersion.getInstance().getVersion();
                    break;
                }
                case 40: {
                    row[index] = BuildVersion.getInstance().getBuildDateAsLocalDate();
                    break;
                }
                case 41: {
                    row[index] = new Long(Management.getPID());
                    break;
                }
                case 43: {
                    row[index] = Runtime.getRuntime().totalMemory();
                    break;
                }
                case 44: {
                    row[index] = Runtime.getRuntime().freeMemory();
                    break;
                }
                case 42: {
                    row[index] = Runtime.getRuntime().maxMemory();
                    break;
                }
                case 45: {
                    Runtime rt = Runtime.getRuntime();
                    row[index] = rt.freeMemory() + (rt.maxMemory() - rt.totalMemory());
                    break;
                }
                case 46: {
                    row[index] = (long)Runtime.getRuntime().availableProcessors();
                    break;
                }
                case 47: {
                    row[index] = Management.getJVMCpuTime() / 1000000L;
                    break;
                }
                case 48: {
                    row[index] = Management.getTotalPhysicalMemorySize();
                    break;
                }
                case 49: {
                    row[index] = Management.getTotalSwapSpaceSize();
                    break;
                }
                case 50: {
                    row[index] = Management.getCommittedVirtualMemorySize();
                    break;
                }
                case 51: {
                    row[index] = Management.getFreePhysicalMemorySize();
                    break;
                }
                case 52: {
                    row[index] = Management.getFreeSwapSpaceSize();
                    break;
                }
                case 53: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, -1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 54: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case 55: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    cal.add(7, -2);
                    row[index] = cal.getTime();
                    break;
                }
                case 56: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, -1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 57: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case 58: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 59: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case 60: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    cal.add(7, -2);
                    row[index] = cal.getTime();
                    break;
                }
                case 61: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 62: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case 63: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 64: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 2);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case 65: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 2);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    cal.add(7, -2);
                    row[index] = cal.getTime();
                    break;
                }
                case 66: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 67: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, 2);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case 68: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -3 - cal.get(2) % 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 69: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1 - cal.get(2) % 3);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 70: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 0 - cal.get(2) % 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 71: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 2 - cal.get(2) % 3);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 72: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 3 - cal.get(2) % 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 73: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 5 - cal.get(2) % 3);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 74: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, -1);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 75: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(6, cal.getActualMinimum(5));
                    cal.add(6, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 76: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(6, cal.getActualMinimum(5));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 77: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, 1);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.add(6, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 78: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, 1);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 79: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, 2);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.add(6, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 80: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    boolean result = false;
                    if (previousResult != null) {
                        result = previousResult.getResult();
                    }
                    row[index] = result;
                    break;
                }
                case 81: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getExitStatus();
                    }
                    row[index] = value;
                    break;
                }
                case 82: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getEntryNr();
                    }
                    row[index] = value;
                    break;
                }
                case 93: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getResultFiles().size();
                    }
                    row[index] = value;
                    break;
                }
                case 94: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrFilesRetrieved();
                    }
                    row[index] = value;
                    break;
                }
                case 89: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesDeleted();
                    }
                    row[index] = value;
                    break;
                }
                case 84: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesInput();
                    }
                    row[index] = value;
                    break;
                }
                case 85: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesOutput();
                    }
                    row[index] = value;
                    break;
                }
                case 86: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesRead();
                    }
                    row[index] = value;
                    break;
                }
                case 90: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesRejected();
                    }
                    row[index] = value;
                    break;
                }
                case 87: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesUpdated();
                    }
                    row[index] = value;
                    break;
                }
                case 88: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesWritten();
                    }
                    row[index] = value;
                    break;
                }
                case 91: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getRows().size();
                    }
                    row[index] = value;
                    break;
                }
                case 92: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    boolean stop = false;
                    if (previousResult != null) {
                        stop = previousResult.isStopped();
                    }
                    row[index] = stop;
                    break;
                }
                case 83: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrErrors();
                    }
                    row[index] = value;
                    break;
                }
                case 95: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    String errorReason = null;
                    if (previousResult != null) {
                        errorReason = previousResult.getLogText();
                    }
                    row[index] = errorReason;
                    break;
                }
            }
            ++i;
            ++index;
        }
        return row;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        RowMetaInterface imeta;
        Object[] row;
        if (this.data.readsRows) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            }
        } else {
            row = new Object[]{};
            this.incrementLinesRead();
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            }
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        row = this.getSystemData(imeta, row);
        if (this.log.isRowLevel()) {
            this.logRowlevel("System info returned: " + this.data.outputRowMeta.getString(row));
        }
        this.putRow(this.data.outputRowMeta, row);
        if (!this.data.readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SystemDataMeta)smi;
        this.data = (SystemDataData)sdi;
        if (super.init(smi, sdi)) {
            this.data.readsRows = this.getStepMeta().getRemoteInputSteps().size() > 0;
            List<StepMeta> previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
            if (previous != null && previous.size() > 0) {
                this.data.readsRows = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }
}

