/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.transexecutor;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.DelegationListener;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorData;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;

public class TransExecutor
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = TransExecutorMeta.class;
    private TransExecutorMeta meta;
    private TransExecutorData data;

    public TransExecutor(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            long now;
            this.meta = (TransExecutorMeta)smi;
            this.data = (TransExecutorData)sdi;
            Object[] row = this.getRow();
            if (row == null) {
                if (!this.data.groupBuffer.isEmpty()) {
                    this.executeTrans();
                }
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.executionResultsOutputRowMeta = this.data.inputRowMeta.clone();
                this.data.resultRowsOutputRowMeta = this.data.inputRowMeta.clone();
                this.data.resultFilesOutputRowMeta = this.data.inputRowMeta.clone();
                if (this.meta.getExecutionResultTargetStepMeta() != null) {
                    this.meta.getFields(this.data.executionResultsOutputRowMeta, this.getStepname(), null, this.meta.getExecutionResultTargetStepMeta(), this, this.repository, this.metaStore);
                    this.data.executionResultRowSet = this.findOutputRowSet(this.meta.getExecutionResultTargetStepMeta().getName());
                }
                if (this.meta.getResultFilesTargetStepMeta() != null) {
                    this.meta.getFields(this.data.resultFilesOutputRowMeta, this.getStepname(), null, this.meta.getResultFilesTargetStepMeta(), this, this.repository, this.metaStore);
                    this.data.resultFilesRowSet = this.findOutputRowSet(this.meta.getResultFilesTargetStepMeta().getName());
                }
                this.data.groupFieldIndex = -1;
                if (!Const.isEmpty((String)this.data.groupField)) {
                    this.data.groupFieldIndex = this.getInputRowMeta().indexOfValue(this.data.groupField);
                    if (this.data.groupFieldIndex < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.Exception.GroupFieldNotFound", (String[])new String[]{this.data.groupField}));
                    }
                    this.data.groupFieldMeta = this.getInputRowMeta().getValueMeta(this.data.groupFieldIndex);
                }
            }
            boolean newGroup = false;
            if (this.data.groupSize >= 0) {
                if (this.data.groupSize != 0 && this.data.groupBuffer.size() >= this.data.groupSize) {
                    newGroup = true;
                }
            } else if (this.data.groupFieldIndex >= 0) {
                Object groupFieldData = row[this.data.groupFieldIndex];
                if (this.data.prevGroupFieldData != null && this.data.groupFieldMeta.compare(this.data.prevGroupFieldData, groupFieldData) != 0) {
                    newGroup = true;
                }
                this.data.prevGroupFieldData = groupFieldData;
            } else if (this.data.groupTime > 0 && (now = System.currentTimeMillis()) - this.data.groupTimeStart >= (long)this.data.groupTime) {
                newGroup = true;
            }
            if (newGroup) {
                this.executeTrans();
            }
            this.data.groupBuffer.add(new RowMetaAndData(this.getInputRowMeta(), row));
            return true;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.UnexpectedError", (String[])new String[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTrans() throws KettleException {
        if (this.data.groupBuffer.isEmpty()) {
            return;
        }
        this.data.groupTimeStart = System.currentTimeMillis();
        if (this.data.executorTrans != null) {
            KettleLogStore.discardLines((String)this.data.executorTrans.getLogChannelId(), (boolean)false);
            LoggingRegistry.getInstance().removeIncludingChildren(this.data.executorTrans.getLogChannelId());
        }
        this.data.executorTrans = new Trans(this.data.executorTransMeta, this);
        this.data.executorTrans.setParentTrans(this.getTrans());
        this.data.executorTrans.setLogLevel(this.getLogLevel());
        this.data.executorTrans.setArguments(this.getTrans().getArguments());
        if (this.meta.getParameters().isInheritingAllVariables()) {
            this.data.executorTrans.shareVariablesWith(this);
        }
        this.data.executorTrans.setInternalKettleVariables(this);
        this.data.executorTrans.copyParametersFrom(this.data.executorTransMeta);
        this.data.executorTrans.setPreview(this.getTrans().isPreview());
        this.data.executorTrans.setServletPrintWriter(this.getTrans().getServletPrintWriter());
        this.data.executorTrans.setServletReponse(this.getTrans().getServletResponse());
        this.data.executorTrans.setServletRequest(this.getTrans().getServletRequest());
        this.passParametersToTrans();
        this.getTrans().getActiveSubtransformations().put(this.getStepname(), this.data.executorTrans);
        Result result = new Result();
        result.setRows(this.data.groupBuffer);
        try {
            this.data.executorTrans.setPreviousResult(result);
            this.data.executorTrans.prepareExecution(this.getTrans().getArguments());
            if (this.meta.getOutputRowsSourceStepMeta() != null) {
                StepInterface stepInterface = this.data.executorTrans.findRunThread(this.meta.getOutputRowsSourceStepMeta().getName());
                stepInterface.addRowListener(new RowAdapter(){

                    @Override
                    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                        TransExecutor.this.putRow(rowMeta, row);
                    }
                });
            }
            for (DelegationListener delegationListener : this.getTrans().getDelegationListeners()) {
                delegationListener.transformationDelegationStarted(this.data.executorTrans, new TransExecutionConfiguration());
            }
            this.data.executorTrans.waitUntilFinished();
            result = this.data.executorTrans.getResult();
        }
        catch (KettleException e) {
            this.log.logError("An error occurred executing the transformation: ", (Throwable)e);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        if (this.meta.getExecutionResultTargetStepMeta() != null) {
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.executionResultsOutputRowMeta.size());
            int idx = 0;
            if (!Const.isEmpty((String)this.meta.getExecutionTimeField())) {
                outputRow[idx++] = System.currentTimeMillis() - this.data.groupTimeStart;
            }
            if (!Const.isEmpty((String)this.meta.getExecutionResultField())) {
                outputRow[idx++] = result.getResult();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionNrErrorsField())) {
                outputRow[idx++] = result.getNrErrors();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesReadField())) {
                outputRow[idx++] = result.getNrLinesRead();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesWrittenField())) {
                outputRow[idx++] = result.getNrLinesWritten();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesInputField())) {
                outputRow[idx++] = result.getNrLinesInput();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesOutputField())) {
                outputRow[idx++] = result.getNrLinesOutput();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesRejectedField())) {
                outputRow[idx++] = result.getNrLinesRejected();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesUpdatedField())) {
                outputRow[idx++] = result.getNrLinesUpdated();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesDeletedField())) {
                outputRow[idx++] = result.getNrLinesDeleted();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionFilesRetrievedField())) {
                outputRow[idx++] = result.getNrFilesRetrieved();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionExitStatusField())) {
                outputRow[idx++] = (long)result.getExitStatus();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLogTextField())) {
                String channelId = this.data.executorTrans.getLogChannelId();
                String logText = KettleLogStore.getAppender().getBuffer(channelId, false).toString();
                outputRow[idx++] = logText;
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLogChannelIdField())) {
                outputRow[idx++] = this.data.executorTrans.getLogChannelId();
            }
            this.putRowTo(this.data.executionResultsOutputRowMeta, outputRow, this.data.executionResultRowSet);
        }
        if (this.meta.getResultFilesTargetStepMeta() != null && result.getResultFilesList() != null) {
            for (ResultFile resultFile : result.getResultFilesList()) {
                Object[] targetRow = RowDataUtil.allocateRowData((int)this.data.resultFilesOutputRowMeta.size());
                int idx = 0;
                targetRow[idx++] = resultFile.getFile().getName().toString();
                this.putRowTo(this.data.resultFilesOutputRowMeta, targetRow, this.data.resultFilesRowSet);
            }
        }
        this.data.groupBuffer.clear();
    }

    private void passParametersToTrans() throws KettleException {
        TransExecutorParameters parameters = this.meta.getParameters();
        this.data.executorTrans.clearParameters();
        String[] parameterNames = this.data.executorTrans.listParameters();
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            String value;
            String variable = parameters.getVariable()[i];
            String fieldName = parameters.getField()[i];
            String inputValue = parameters.getInput()[i];
            if (!Const.isEmpty((String)fieldName)) {
                int idx = this.getInputRowMeta().indexOfValue(fieldName);
                if (idx < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.Exception.UnableToFindField", (String[])new String[]{fieldName}));
                }
                value = this.data.groupBuffer.get(0).getString(idx, "");
            } else {
                value = this.environmentSubstitute(inputValue);
            }
            if (Const.indexOfString((String)variable, (String[])parameterNames) < 0) {
                this.data.executorTrans.setVariable(variable, Const.NVL((String)value, (String)""));
                continue;
            }
            this.data.executorTrans.setParameterValue(variable, Const.NVL((String)value, (String)""));
        }
        this.data.executorTrans.activateParameters();
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TransExecutorMeta)smi;
        this.data = (TransExecutorData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.meta.setRepository(this.getTransMeta().getRepository());
                this.data.executorTransMeta = TransExecutorMeta.loadTransMeta(this.meta, this.meta.getRepository(), this.meta.getMetaStore(), this);
                if (this.data.executorTransMeta != null) {
                    this.data.groupBuffer = new ArrayList<RowMetaAndData>();
                    this.data.groupSize = -1;
                    if (!Const.isEmpty((String)this.meta.getGroupSize())) {
                        this.data.groupSize = Const.toInt((String)this.environmentSubstitute(this.meta.getGroupSize()), (int)-1);
                    }
                    this.data.groupTime = -1;
                    if (!Const.isEmpty((String)this.meta.getGroupTime())) {
                        this.data.groupTime = Const.toInt((String)this.environmentSubstitute(this.meta.getGroupTime()), (int)-1);
                    }
                    this.data.groupTimeStart = System.currentTimeMillis();
                    this.data.groupField = null;
                    if (!Const.isEmpty((String)this.meta.getGroupField())) {
                        this.data.groupField = this.environmentSubstitute(this.meta.getGroupField());
                    }
                    return true;
                }
                this.logError("No valid transformation was specified nor loaded!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the transformation executor because of an error : ", e);
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.data.groupBuffer = null;
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.data.executorTrans != null) {
            this.data.executorTrans.stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.data.executorTrans != null) {
            this.data.executorTrans.stopAll();
        }
        super.stopAll();
    }

    public Trans getExecutorTrans() {
        return this.data.executorTrans;
    }
}

