/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.uniquerows;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.uniquerows.UniqueRowsData;
import org.pentaho.di.trans.steps.uniquerows.UniqueRowsMeta;

public class UniqueRows
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = UniqueRowsMeta.class;
    private UniqueRowsMeta meta = (UniqueRowsMeta)this.getStepMeta().getStepMetaInterface();
    private UniqueRowsData data;

    public UniqueRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (UniqueRowsData)stepDataInterface;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (UniqueRowsMeta)smi;
        this.data = (UniqueRowsData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            if (this.data.previous != null) {
                Object[] outputRow = this.addCounter(this.data.outputRowMeta, this.data.previous, this.data.counter);
                this.putRow(this.data.outputRowMeta, outputRow);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.data.inputRowMeta = this.getInputRowMeta().clone();
            this.data.compareRowMeta = this.getInputRowMeta().clone();
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.previous = this.data.inputRowMeta.cloneRow(r);
            this.data.fieldnrs = new int[this.meta.getCompareFields().length];
            for (int i = 0; i < this.meta.getCompareFields().length; ++i) {
                this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getCompareFields()[i]);
                if (this.data.fieldnrs[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"UniqueRows.Log.CouldNotFindFieldInRow", (String[])new String[]{this.meta.getCompareFields()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.compareRowMeta.getValueMeta(this.data.fieldnrs[i]).setCaseInsensitive(this.meta.getCaseInsensitive()[i]);
                if (!this.data.sendDuplicateRows) continue;
                this.data.compareFields = this.data.compareFields == null ? this.meta.getCompareFields()[i] : this.data.compareFields + "," + this.meta.getCompareFields()[i];
            }
            if (this.data.sendDuplicateRows && !Const.isEmpty((String)this.meta.getErrorDescription())) {
                this.data.realErrorDescription = this.environmentSubstitute(this.meta.getErrorDescription());
            }
        }
        if (this.data.previous == null) {
            this.data.previous = this.data.inputRowMeta.cloneRow(r);
        }
        boolean isEqual = false;
        if (this.meta.getCompareFields() == null || this.meta.getCompareFields().length == 0) {
            isEqual = this.data.outputRowMeta.compare(r, this.data.previous) == 0;
        } else {
            boolean bl = isEqual = this.data.outputRowMeta.compare(r, this.data.previous, this.data.fieldnrs) == 0;
        }
        if (!isEqual) {
            Object[] outputRow = this.addCounter(this.data.outputRowMeta, this.data.previous, this.data.counter);
            this.putRow(this.data.outputRowMeta, outputRow);
            this.data.previous = this.data.inputRowMeta.cloneRow(r);
            this.data.counter = 1L;
        } else {
            ++this.data.counter;
            if (this.data.sendDuplicateRows && !this.first) {
                this.putError(this.getInputRowMeta(), r, 1L, this.data.realErrorDescription, this.data.compareFields == "" ? null : this.data.compareFields, "UNR001");
            }
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"UniqueRows.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        this.first = false;
        return true;
    }

    private Object[] addCounter(RowMetaInterface outputRowMeta, Object[] r, long count) {
        if (this.meta.isCountRows()) {
            Object[] outputRow = RowDataUtil.addValueData((Object[])r, (int)(outputRowMeta.size() - 1), (Object)new Long(count));
            return outputRow;
        }
        return r;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UniqueRowsMeta)smi;
        this.data = (UniqueRowsData)sdi;
        if (super.init(smi, sdi)) {
            this.data.sendDuplicateRows = this.getStepMeta().getStepErrorMeta() != null && this.meta.supportsErrorHandling();
            return true;
        }
        return false;
    }

    @Override
    public void batchComplete() throws KettleException {
        if (this.data.previous != null) {
            Object[] outputRow = this.addCounter(this.data.outputRowMeta, this.data.previous, this.data.counter);
            this.putRow(this.data.outputRowMeta, outputRow);
            this.data.previous = null;
        }
    }
}

