/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.uniquerowsbyhashset;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.RowKey;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.UniqueRowsByHashSetData;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.UniqueRowsByHashSetMeta;

public class UniqueRowsByHashSet
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = UniqueRowsByHashSetMeta.class;
    private UniqueRowsByHashSetMeta meta = (UniqueRowsByHashSetMeta)this.getStepMeta().getStepMetaInterface();
    private UniqueRowsByHashSetData data;

    public UniqueRowsByHashSet(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (UniqueRowsByHashSetData)stepDataInterface;
    }

    private boolean isUniqueRow(Object[] row) {
        return this.data.seen.add(new RowKey(row, this.data));
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (UniqueRowsByHashSetMeta)smi;
        this.data = (UniqueRowsByHashSetData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.data.clearHashSet();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.inputRowMeta = this.getInputRowMeta().clone();
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.storeValues = this.meta.getStoreValues();
            this.data.fieldnrs = new int[this.meta.getCompareFields().length];
            for (int i = 0; i < this.meta.getCompareFields().length; ++i) {
                this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getCompareFields()[i]);
                if (this.data.fieldnrs[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSet.Log.CouldNotFindFieldInRow", (String[])new String[]{this.meta.getCompareFields()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (!this.data.sendDuplicateRows) continue;
                this.data.compareFields = this.data.compareFields == null ? this.meta.getCompareFields()[i] : this.data.compareFields + "," + this.meta.getCompareFields()[i];
            }
            if (this.data.sendDuplicateRows && !Const.isEmpty((String)this.meta.getErrorDescription())) {
                this.data.realErrorDescription = this.environmentSubstitute(this.meta.getErrorDescription());
            }
        }
        if (this.isUniqueRow(r)) {
            this.putRow(this.data.outputRowMeta, r);
        } else {
            this.incrementLinesRejected();
            if (this.data.sendDuplicateRows) {
                this.putError(this.getInputRowMeta(), r, 1L, this.data.realErrorDescription, this.data.compareFields == "" ? null : this.data.compareFields, "UNRH001");
            }
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSet.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UniqueRowsByHashSetMeta)smi;
        this.data = (UniqueRowsByHashSetData)sdi;
        if (super.init(smi, sdi)) {
            this.data.sendDuplicateRows = this.getStepMeta().getStepErrorMeta() != null && this.meta.supportsErrorHandling();
            return true;
        }
        return false;
    }
}

