/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.validator.KettleValidatorException;
import org.pentaho.di.trans.steps.validator.Validation;
import org.pentaho.di.trans.steps.validator.ValidatorData;
import org.pentaho.di.trans.steps.validator.ValidatorMeta;

public class Validator
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ValidatorMeta.class;
    private ValidatorMeta meta;
    private ValidatorData data;

    public Validator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r;
        block20: {
            Iterator<KettleValidatorException> i$;
            boolean notFirst;
            StringBuffer codes;
            StringBuffer fields;
            StringBuffer messages;
            List<KettleValidatorException> exceptions;
            block19: {
                this.meta = (ValidatorMeta)smi;
                this.data = (ValidatorData)sdi;
                if (!this.first) {
                    r = this.getRow();
                    if (r == null) {
                        this.setOutputDone();
                        return false;
                    }
                } else {
                    this.first = false;
                    this.readSourceValuesFromInfoSteps();
                    r = this.getRow();
                    if (r == null) {
                        this.setOutputDone();
                        return false;
                    }
                    this.data.fieldIndexes = new int[this.meta.getValidations().size()];
                    for (int i = 0; i < this.meta.getValidations().size(); ++i) {
                        Validation field = this.meta.getValidations().get(i);
                        if (Const.isEmpty((String)field.getFieldName())) {
                            throw new KettleStepException("There is no name specified for validator field #" + (i + 1));
                        }
                        this.data.fieldIndexes[i] = this.getInputRowMeta().indexOfValue(field.getFieldName());
                        if (this.data.fieldIndexes[i] >= 0) continue;
                        throw new KettleStepException("Unable to find the specified fieldname '" + field.getFieldName() + "' for validation#" + (i + 1));
                    }
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel("Read row #" + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
                }
                try {
                    exceptions = this.validateFields(this.getInputRowMeta(), r);
                    if (exceptions.size() > 0) {
                        if (!this.getStepMeta().isDoingErrorHandling()) {
                            KettleValidatorException e = exceptions.get(0);
                            throw new KettleException(e.getMessage(), (Throwable)((Object)e));
                        }
                        if (this.meta.isConcatenatingErrors()) {
                            messages = new StringBuffer();
                            fields = new StringBuffer();
                            codes = new StringBuffer();
                            notFirst = false;
                            i$ = exceptions.iterator();
                            break block19;
                        }
                        for (KettleValidatorException e : exceptions) {
                            this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), e.getFieldname(), e.getCodeDesc());
                        }
                        break block20;
                    }
                    this.putRow(this.getInputRowMeta(), r);
                }
                catch (KettleValidatorException e) {
                    if (!this.getStepMeta().isDoingErrorHandling()) {
                        throw new KettleException(e.getMessage(), (Throwable)((Object)e));
                    }
                    this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), e.getFieldname(), e.getCodeDesc());
                }
                break block20;
            }
            while (i$.hasNext()) {
                KettleValidatorException e = i$.next();
                if (notFirst) {
                    messages.append(this.meta.getConcatenationSeparator());
                    fields.append(this.meta.getConcatenationSeparator());
                    codes.append(this.meta.getConcatenationSeparator());
                } else {
                    notFirst = true;
                }
                messages.append(e.getMessage());
                fields.append(e.getFieldname());
                codes.append(e.getCodeDesc());
            }
            this.putError(this.getInputRowMeta(), r, exceptions.size(), messages.toString(), fields.toString(), codes.toString());
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r));
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private void readSourceValuesFromInfoSteps() throws KettleStepException {
        for (int i = 0; i < this.meta.getValidations().size(); ++i) {
            Validation field = this.meta.getValidations().get(i);
            List<StreamInterface> streams = this.meta.getStepIOMeta().getInfoStreams();
            if (!field.isSourcingValues()) continue;
            if (streams.get(i).getStepMeta() == null) {
                throw new KettleStepException("There is no valid source step specified for the allowed values of validation [" + field.getName() + "]");
            }
            if (Const.isEmpty((String)field.getSourcingField())) {
                throw new KettleStepException("There is no valid source field specified for the allowed values of validation [" + field.getName() + "]");
            }
            RowSet allowedRowSet = this.findInputRowSet(streams.get(i).getStepname());
            int fieldIndex = -1;
            ArrayList<Object> allowedValues = new ArrayList<Object>();
            Object[] allowedRowData = this.getRowFrom(allowedRowSet);
            while (allowedRowData != null) {
                Object allowedValue;
                RowMetaInterface allowedRowMeta = allowedRowSet.getRowMeta();
                if (fieldIndex < 0) {
                    fieldIndex = allowedRowMeta.indexOfValue(field.getSourcingField());
                    if (fieldIndex < 0) {
                        throw new KettleStepException("Source field [" + field.getSourcingField() + "] is not found in the source row data");
                    }
                    this.data.constantsMeta[i] = allowedRowMeta.getValueMeta(fieldIndex);
                }
                if ((allowedValue = allowedRowData[fieldIndex]) != null) {
                    allowedValues.add(allowedValue);
                }
                allowedRowData = this.getRowFrom(allowedRowSet);
            }
            this.data.listValues[i] = allowedValues.toArray(new Object[allowedValues.size()]);
        }
    }

    private List<KettleValidatorException> validateFields(RowMetaInterface inputRowMeta, Object[] r) throws KettleValidatorException, KettleValueException {
        ArrayList<KettleValidatorException> exceptions = new ArrayList<KettleValidatorException>();
        for (int i = 0; i < this.meta.getValidations().size(); ++i) {
            Matcher matcher;
            KettleValidatorException exception;
            KettleValidatorException exception2;
            KettleValidatorException exception3;
            Validation field = this.meta.getValidations().get(i);
            int valueIndex = this.data.fieldIndexes[i];
            ValueMetaInterface validatorMeta = this.data.constantsMeta[i];
            ValueMetaInterface valueMeta = inputRowMeta.getValueMeta(valueIndex);
            Object valueData = r[valueIndex];
            boolean isNull = valueMeta.isNull(valueData);
            if (!field.isNullAllowed() && isNull) {
                exception3 = new KettleValidatorException(this, field, 1, BaseMessages.getString(PKG, (String)"Validator.Exception.NullNotAllowed", (String[])new String[]{field.getFieldName(), inputRowMeta.getString(r)}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception3);
                } else {
                    throw exception3;
                }
            }
            if (field.isOnlyNullAllowed() && !isNull) {
                exception3 = new KettleValidatorException(this, field, 15, BaseMessages.getString(PKG, (String)"Validator.Exception.OnlyNullAllowed", (String[])new String[]{field.getFieldName(), inputRowMeta.getString(r)}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception3);
                } else {
                    throw exception3;
                }
            }
            if (field.isDataTypeVerified() && field.getDataType() != 0 && field.getDataType() != valueMeta.getType()) {
                exception3 = new KettleValidatorException(this, field, 4, BaseMessages.getString(PKG, (String)"Validator.Exception.UnexpectedDataType", (String[])new String[]{field.getFieldName(), valueMeta.toStringMeta(), validatorMeta.toStringMeta()}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception3);
                } else {
                    throw exception3;
                }
            }
            if (isNull || this.data.fieldsMinimumLengthAsInt[i] < 0 && this.data.fieldsMaximumLengthAsInt[i] < 0 && this.data.minimumValue[i] == null && this.data.maximumValue[i] == null && this.data.listValues[i].length <= 0 && !field.isSourcingValues() && Const.isEmpty((String)this.data.startString[i]) && Const.isEmpty((String)this.data.endString[i]) && Const.isEmpty((String)this.data.startStringNotAllowed[i]) && Const.isEmpty((String)this.data.endStringNotAllowed[i]) && !field.isOnlyNumericAllowed() && this.data.patternExpected[i] == null && this.data.patternDisallowed[i] == null) continue;
            String stringValue = valueMeta.getString(valueData);
            int stringLength = stringValue.length();
            if (this.data.fieldsMinimumLengthAsInt[i] >= 0 && stringLength < this.data.fieldsMinimumLengthAsInt[i]) {
                exception2 = new KettleValidatorException(this, field, 3, BaseMessages.getString(PKG, (String)"Validator.Exception.ShorterThanMininumLength", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), Integer.toString(stringValue.length()), field.getMinimumLength()}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception2);
                } else {
                    throw exception2;
                }
            }
            if (this.data.fieldsMaximumLengthAsInt[i] >= 0 && stringLength > this.data.fieldsMaximumLengthAsInt[i]) {
                exception2 = new KettleValidatorException(this, field, 2, BaseMessages.getString(PKG, (String)"Validator.Exception.LongerThanMaximumLength", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), Integer.toString(stringValue.length()), field.getMaximumLength()}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception2);
                } else {
                    throw exception2;
                }
            }
            if (this.data.minimumValue[i] != null && valueMeta.compare(valueData, validatorMeta, this.data.minimumValue[i]) < 0) {
                exception2 = new KettleValidatorException(this, field, 5, BaseMessages.getString(PKG, (String)"Validator.Exception.LowerThanMinimumValue", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), this.data.constantsMeta[i].getString(this.data.minimumValue[i])}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception2);
                } else {
                    throw exception2;
                }
            }
            if (this.data.maximumValue[i] != null && valueMeta.compare(valueData, validatorMeta, this.data.maximumValue[i]) > 0) {
                exception2 = new KettleValidatorException(this, field, 6, BaseMessages.getString(PKG, (String)"Validator.Exception.HigherThanMaximumValue", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), this.data.constantsMeta[i].getString(this.data.maximumValue[i])}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception2);
                } else {
                    throw exception2;
                }
            }
            if (field.isSourcingValues() || this.data.listValues[i].length > 0) {
                boolean found = false;
                for (Object object : this.data.listValues[i]) {
                    if (object == null || this.data.listValues[i] == null || valueMeta.compare(valueData, validatorMeta, object) != 0) continue;
                    found = true;
                }
                if (!found) {
                    exception = new KettleValidatorException(this, field, 7, BaseMessages.getString(PKG, (String)"Validator.Exception.NotInList", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData)}), field.getFieldName());
                    if (this.meta.isValidatingAll()) {
                        exceptions.add(exception);
                    } else {
                        throw exception;
                    }
                }
            }
            if (field.isOnlyNumericAllowed() && (valueMeta.isNumeric() || !this.containsOnlyDigits(valueMeta.getString(valueData)))) {
                KettleValidatorException exception4 = new KettleValidatorException(this, field, 8, BaseMessages.getString(PKG, (String)"Validator.Exception.NonNumericDataNotAllowed", (String[])new String[]{field.getFieldName(), valueMeta.toStringMeta()}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception4);
                } else {
                    throw exception4;
                }
            }
            if (!Const.isEmpty((String)this.data.startString[i]) && !stringValue.startsWith(this.data.startString[i])) {
                KettleValidatorException exception5 = new KettleValidatorException(this, field, 9, BaseMessages.getString(PKG, (String)"Validator.Exception.DoesNotStartWithString", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getStartString()}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception5);
                } else {
                    throw exception5;
                }
            }
            if (!Const.isEmpty((String)this.data.endString[i]) && !stringValue.endsWith(this.data.endString[i])) {
                KettleValidatorException exception6 = new KettleValidatorException(this, field, 10, BaseMessages.getString(PKG, (String)"Validator.Exception.DoesNotStartWithString", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getEndString()}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception6);
                } else {
                    throw exception6;
                }
            }
            if (!Const.isEmpty((String)this.data.startStringNotAllowed[i]) && stringValue.startsWith(this.data.startStringNotAllowed[i])) {
                KettleValidatorException exception7 = new KettleValidatorException(this, field, 11, BaseMessages.getString(PKG, (String)"Validator.Exception.StartsWithString", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getStartStringNotAllowed()}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception7);
                } else {
                    throw exception7;
                }
            }
            if (!Const.isEmpty((String)this.data.endStringNotAllowed[i]) && stringValue.endsWith(this.data.endStringNotAllowed[i])) {
                KettleValidatorException exception8 = new KettleValidatorException(this, field, 12, BaseMessages.getString(PKG, (String)"Validator.Exception.EndsWithString", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getEndStringNotAllowed()}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception8);
                } else {
                    throw exception8;
                }
            }
            if (this.data.patternExpected[i] != null && !(matcher = this.data.patternExpected[i].matcher(stringValue)).matches()) {
                exception = new KettleValidatorException(this, field, 13, BaseMessages.getString(PKG, (String)"Validator.Exception.MatchingRegExpExpected", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getRegularExpression()}), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception);
                } else {
                    throw exception;
                }
            }
            if (this.data.patternDisallowed[i] == null || !(matcher = this.data.patternDisallowed[i].matcher(stringValue)).matches()) continue;
            exception = new KettleValidatorException(this, field, 14, BaseMessages.getString(PKG, (String)"Validator.Exception.MatchingRegExpNotAllowed", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getRegularExpressionNotAllowed()}), field.getFieldName());
            if (this.meta.isValidatingAll()) {
                exceptions.add(exception);
                continue;
            }
            throw exception;
        }
        return exceptions;
    }

    private boolean containsOnlyDigits(String string) {
        for (char c : string.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ValidatorMeta)smi;
        this.data = (ValidatorData)sdi;
        if (super.init(smi, sdi)) {
            this.data.constantsMeta = new ValueMetaInterface[this.meta.getValidations().size()];
            this.data.minimumValueAsString = new String[this.meta.getValidations().size()];
            this.data.maximumValueAsString = new String[this.meta.getValidations().size()];
            this.data.fieldsMinimumLengthAsInt = new int[this.meta.getValidations().size()];
            this.data.fieldsMaximumLengthAsInt = new int[this.meta.getValidations().size()];
            this.data.minimumValue = new Object[this.meta.getValidations().size()];
            this.data.maximumValue = new Object[this.meta.getValidations().size()];
            this.data.listValues = new Object[this.meta.getValidations().size()][];
            this.data.errorCode = new String[this.meta.getValidations().size()];
            this.data.errorDescription = new String[this.meta.getValidations().size()];
            this.data.conversionMask = new String[this.meta.getValidations().size()];
            this.data.decimalSymbol = new String[this.meta.getValidations().size()];
            this.data.groupingSymbol = new String[this.meta.getValidations().size()];
            this.data.maximumLength = new String[this.meta.getValidations().size()];
            this.data.minimumLength = new String[this.meta.getValidations().size()];
            this.data.startString = new String[this.meta.getValidations().size()];
            this.data.endString = new String[this.meta.getValidations().size()];
            this.data.startStringNotAllowed = new String[this.meta.getValidations().size()];
            this.data.endStringNotAllowed = new String[this.meta.getValidations().size()];
            this.data.regularExpression = new String[this.meta.getValidations().size()];
            this.data.regularExpressionNotAllowed = new String[this.meta.getValidations().size()];
            this.data.patternExpected = new Pattern[this.meta.getValidations().size()];
            this.data.patternDisallowed = new Pattern[this.meta.getValidations().size()];
            for (int i = 0; i < this.meta.getValidations().size(); ++i) {
                Validation field = this.meta.getValidations().get(i);
                try {
                    this.data.constantsMeta[i] = ValueMetaFactory.createValueMeta((String)field.getFieldName(), (int)field.getDataType());
                    this.data.constantsMeta[i].setConversionMask(field.getConversionMask());
                    this.data.constantsMeta[i].setDecimalSymbol(field.getDecimalSymbol());
                    this.data.constantsMeta[i].setGroupingSymbol(field.getGroupingSymbol());
                    this.data.errorCode[i] = this.environmentSubstitute(Const.NVL((String)field.getErrorCode(), (String)""));
                    this.data.errorDescription[i] = this.environmentSubstitute(Const.NVL((String)field.getErrorDescription(), (String)""));
                    this.data.conversionMask[i] = this.environmentSubstitute(Const.NVL((String)field.getConversionMask(), (String)""));
                    this.data.decimalSymbol[i] = this.environmentSubstitute(Const.NVL((String)field.getDecimalSymbol(), (String)""));
                    this.data.groupingSymbol[i] = this.environmentSubstitute(Const.NVL((String)field.getGroupingSymbol(), (String)""));
                    this.data.maximumLength[i] = this.environmentSubstitute(Const.NVL((String)field.getMaximumLength(), (String)""));
                    this.data.minimumLength[i] = this.environmentSubstitute(Const.NVL((String)field.getMinimumLength(), (String)""));
                    this.data.maximumValueAsString[i] = this.environmentSubstitute(Const.NVL((String)field.getMaximumValue(), (String)""));
                    this.data.minimumValueAsString[i] = this.environmentSubstitute(Const.NVL((String)field.getMinimumValue(), (String)""));
                    this.data.startString[i] = this.environmentSubstitute(Const.NVL((String)field.getStartString(), (String)""));
                    this.data.endString[i] = this.environmentSubstitute(Const.NVL((String)field.getEndString(), (String)""));
                    this.data.startStringNotAllowed[i] = this.environmentSubstitute(Const.NVL((String)field.getStartStringNotAllowed(), (String)""));
                    this.data.endStringNotAllowed[i] = this.environmentSubstitute(Const.NVL((String)field.getEndStringNotAllowed(), (String)""));
                    this.data.regularExpression[i] = this.environmentSubstitute(Const.NVL((String)field.getRegularExpression(), (String)""));
                    this.data.regularExpressionNotAllowed[i] = this.environmentSubstitute(Const.NVL((String)field.getRegularExpressionNotAllowed(), (String)""));
                    ValueMetaInterface stringMeta = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)this.data.constantsMeta[i], (int)2);
                    this.data.minimumValue[i] = Const.isEmpty((String)this.data.minimumValueAsString[i]) ? null : this.data.constantsMeta[i].convertData(stringMeta, (Object)this.data.minimumValueAsString[i]);
                    this.data.maximumValue[i] = Const.isEmpty((String)this.data.maximumValueAsString[i]) ? null : this.data.constantsMeta[i].convertData(stringMeta, (Object)this.data.maximumValueAsString[i]);
                    try {
                        this.data.fieldsMinimumLengthAsInt[i] = Integer.valueOf(Const.NVL((String)this.data.minimumLength[i], (String)"-1"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new KettleValueException("Caught a number format exception converting minimum length with value " + this.data.minimumLength[i] + " to an int.", (Throwable)nfe);
                    }
                    try {
                        this.data.fieldsMaximumLengthAsInt[i] = Integer.valueOf(Const.NVL((String)this.data.maximumLength[i], (String)"-1"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new KettleValueException("Caught a number format exception converting minimum length with value " + this.data.maximumLength[i] + " to an int.", (Throwable)nfe);
                    }
                    int listSize = field.getAllowedValues() != null ? field.getAllowedValues().length : 0;
                    this.data.listValues[i] = new Object[listSize];
                    for (int s = 0; s < listSize; ++s) {
                        this.data.listValues[i][s] = Const.isEmpty((String)field.getAllowedValues()[s]) ? null : this.data.constantsMeta[i].convertData(stringMeta, (Object)this.environmentSubstitute(field.getAllowedValues()[s]));
                    }
                }
                catch (KettleException e) {
                    if (field.getDataType() == 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"Validator.Exception.SpecifyDataType", (String[])new String[0]), e);
                    } else {
                        this.logError(BaseMessages.getString(PKG, (String)"Validator.Exception.DataConversionErrorEncountered", (String[])new String[0]), e);
                    }
                    return false;
                }
                if (!Const.isEmpty((String)this.data.regularExpression[i])) {
                    this.data.patternExpected[i] = Pattern.compile(field.getRegularExpression());
                }
                if (Const.isEmpty((String)this.data.regularExpressionNotAllowed[i])) continue;
                this.data.patternDisallowed[i] = Pattern.compile(field.getRegularExpressionNotAllowed());
            }
            return true;
        }
        return false;
    }

    public class FieldIndexes {
        public int indexName;
        public int indexA;
        public int indexB;
        public int indexC;
    }
}

